<?php


/**
 * Base class that represents a query for the 'medias_media' table.
 *
 * Archivo de medios
 *
 * @method MediaQuery orderById($order = Criteria::ASC) Order by the id column
 * @method MediaQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method MediaQuery orderByAddress($order = Criteria::ASC) Order by the address column
 * @method MediaQuery orderByPhone($order = Criteria::ASC) Order by the phone column
 * @method MediaQuery orderByUrl($order = Criteria::ASC) Order by the url column
 * @method MediaQuery orderByMediakiturl($order = Criteria::ASC) Order by the mediakitUrl column
 * @method MediaQuery orderByFax($order = Criteria::ASC) Order by the fax column
 * @method MediaQuery orderByEmail($order = Criteria::ASC) Order by the email column
 * @method MediaQuery orderByReceptionist($order = Criteria::ASC) Order by the receptionist column
 * @method MediaQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method MediaQuery orderByTypeid($order = Criteria::ASC) Order by the typeId column
 * @method MediaQuery orderByGroupid($order = Criteria::ASC) Order by the groupId column
 * @method MediaQuery orderByImportance($order = Criteria::ASC) Order by the importance column
 * @method MediaQuery orderByBias($order = Criteria::ASC) Order by the bias column
 * @method MediaQuery orderByAliasof($order = Criteria::ASC) Order by the aliasOf column
 * @method MediaQuery orderByCreatedAt($order = Criteria::ASC) Order by the created_at column
 * @method MediaQuery orderByUpdatedAt($order = Criteria::ASC) Order by the updated_at column
 *
 * @method MediaQuery groupById() Group by the id column
 * @method MediaQuery groupByName() Group by the name column
 * @method MediaQuery groupByAddress() Group by the address column
 * @method MediaQuery groupByPhone() Group by the phone column
 * @method MediaQuery groupByUrl() Group by the url column
 * @method MediaQuery groupByMediakiturl() Group by the mediakitUrl column
 * @method MediaQuery groupByFax() Group by the fax column
 * @method MediaQuery groupByEmail() Group by the email column
 * @method MediaQuery groupByReceptionist() Group by the receptionist column
 * @method MediaQuery groupByDescription() Group by the description column
 * @method MediaQuery groupByTypeid() Group by the typeId column
 * @method MediaQuery groupByGroupid() Group by the groupId column
 * @method MediaQuery groupByImportance() Group by the importance column
 * @method MediaQuery groupByBias() Group by the bias column
 * @method MediaQuery groupByAliasof() Group by the aliasOf column
 * @method MediaQuery groupByCreatedAt() Group by the created_at column
 * @method MediaQuery groupByUpdatedAt() Group by the updated_at column
 *
 * @method MediaQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method MediaQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method MediaQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method MediaQuery leftJoinMediaType($relationAlias = null) Adds a LEFT JOIN clause to the query using the MediaType relation
 * @method MediaQuery rightJoinMediaType($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MediaType relation
 * @method MediaQuery innerJoinMediaType($relationAlias = null) Adds a INNER JOIN clause to the query using the MediaType relation
 *
 * @method MediaQuery leftJoinMediaRelatedByGroupid($relationAlias = null) Adds a LEFT JOIN clause to the query using the MediaRelatedByGroupid relation
 * @method MediaQuery rightJoinMediaRelatedByGroupid($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MediaRelatedByGroupid relation
 * @method MediaQuery innerJoinMediaRelatedByGroupid($relationAlias = null) Adds a INNER JOIN clause to the query using the MediaRelatedByGroupid relation
 *
 * @method MediaQuery leftJoinMediaRelatedByAliasof($relationAlias = null) Adds a LEFT JOIN clause to the query using the MediaRelatedByAliasof relation
 * @method MediaQuery rightJoinMediaRelatedByAliasof($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MediaRelatedByAliasof relation
 * @method MediaQuery innerJoinMediaRelatedByAliasof($relationAlias = null) Adds a INNER JOIN clause to the query using the MediaRelatedByAliasof relation
 *
 * @method MediaQuery leftJoinHeadline($relationAlias = null) Adds a LEFT JOIN clause to the query using the Headline relation
 * @method MediaQuery rightJoinHeadline($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Headline relation
 * @method MediaQuery innerJoinHeadline($relationAlias = null) Adds a INNER JOIN clause to the query using the Headline relation
 *
 * @method MediaQuery leftJoinMediaRelatedById0($relationAlias = null) Adds a LEFT JOIN clause to the query using the MediaRelatedById0 relation
 * @method MediaQuery rightJoinMediaRelatedById0($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MediaRelatedById0 relation
 * @method MediaQuery innerJoinMediaRelatedById0($relationAlias = null) Adds a INNER JOIN clause to the query using the MediaRelatedById0 relation
 *
 * @method MediaQuery leftJoinMediaRelatedById1($relationAlias = null) Adds a LEFT JOIN clause to the query using the MediaRelatedById1 relation
 * @method MediaQuery rightJoinMediaRelatedById1($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MediaRelatedById1 relation
 * @method MediaQuery innerJoinMediaRelatedById1($relationAlias = null) Adds a INNER JOIN clause to the query using the MediaRelatedById1 relation
 *
 * @method MediaQuery leftJoinMediaMarketRelation($relationAlias = null) Adds a LEFT JOIN clause to the query using the MediaMarketRelation relation
 * @method MediaQuery rightJoinMediaMarketRelation($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MediaMarketRelation relation
 * @method MediaQuery innerJoinMediaMarketRelation($relationAlias = null) Adds a INNER JOIN clause to the query using the MediaMarketRelation relation
 *
 * @method MediaQuery leftJoinMediaAudienceRelation($relationAlias = null) Adds a LEFT JOIN clause to the query using the MediaAudienceRelation relation
 * @method MediaQuery rightJoinMediaAudienceRelation($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MediaAudienceRelation relation
 * @method MediaQuery innerJoinMediaAudienceRelation($relationAlias = null) Adds a INNER JOIN clause to the query using the MediaAudienceRelation relation
 *
 * @method Media findOne(PropelPDO $con = null) Return the first Media matching the query
 * @method Media findOneOrCreate(PropelPDO $con = null) Return the first Media matching the query, or a new Media object populated from the query conditions when no match is found
 *
 * @method Media findOneById(int $id) Return the first Media filtered by the id column
 * @method Media findOneByName(string $name) Return the first Media filtered by the name column
 * @method Media findOneByAddress(string $address) Return the first Media filtered by the address column
 * @method Media findOneByPhone(string $phone) Return the first Media filtered by the phone column
 * @method Media findOneByUrl(string $url) Return the first Media filtered by the url column
 * @method Media findOneByMediakiturl(string $mediakitUrl) Return the first Media filtered by the mediakitUrl column
 * @method Media findOneByFax(string $fax) Return the first Media filtered by the fax column
 * @method Media findOneByEmail(string $email) Return the first Media filtered by the email column
 * @method Media findOneByReceptionist(string $receptionist) Return the first Media filtered by the receptionist column
 * @method Media findOneByDescription(string $description) Return the first Media filtered by the description column
 * @method Media findOneByTypeid(int $typeId) Return the first Media filtered by the typeId column
 * @method Media findOneByGroupid(int $groupId) Return the first Media filtered by the groupId column
 * @method Media findOneByImportance(int $importance) Return the first Media filtered by the importance column
 * @method Media findOneByBias(int $bias) Return the first Media filtered by the bias column
 * @method Media findOneByAliasof(int $aliasOf) Return the first Media filtered by the aliasOf column
 * @method Media findOneByCreatedAt(string $created_at) Return the first Media filtered by the created_at column
 * @method Media findOneByUpdatedAt(string $updated_at) Return the first Media filtered by the updated_at column
 *
 * @method array findById(int $id) Return Media objects filtered by the id column
 * @method array findByName(string $name) Return Media objects filtered by the name column
 * @method array findByAddress(string $address) Return Media objects filtered by the address column
 * @method array findByPhone(string $phone) Return Media objects filtered by the phone column
 * @method array findByUrl(string $url) Return Media objects filtered by the url column
 * @method array findByMediakiturl(string $mediakitUrl) Return Media objects filtered by the mediakitUrl column
 * @method array findByFax(string $fax) Return Media objects filtered by the fax column
 * @method array findByEmail(string $email) Return Media objects filtered by the email column
 * @method array findByReceptionist(string $receptionist) Return Media objects filtered by the receptionist column
 * @method array findByDescription(string $description) Return Media objects filtered by the description column
 * @method array findByTypeid(int $typeId) Return Media objects filtered by the typeId column
 * @method array findByGroupid(int $groupId) Return Media objects filtered by the groupId column
 * @method array findByImportance(int $importance) Return Media objects filtered by the importance column
 * @method array findByBias(int $bias) Return Media objects filtered by the bias column
 * @method array findByAliasof(int $aliasOf) Return Media objects filtered by the aliasOf column
 * @method array findByCreatedAt(string $created_at) Return Media objects filtered by the created_at column
 * @method array findByUpdatedAt(string $updated_at) Return Media objects filtered by the updated_at column
 *
 * @package    propel.generator.medias.classes.om
 */
abstract class BaseMediaQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseMediaQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Media', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new MediaQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     MediaQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return MediaQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof MediaQuery) {
            return $criteria;
        }
        $query = new MediaQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Media|Media[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = MediaPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(MediaPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Media A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `ADDRESS`, `PHONE`, `URL`, `MEDIAKITURL`, `FAX`, `EMAIL`, `RECEPTIONIST`, `DESCRIPTION`, `TYPEID`, `GROUPID`, `IMPORTANCE`, `BIAS`, `ALIASOF`, `CREATED_AT`, `UPDATED_AT` FROM `medias_media` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new Media();
            $obj->hydrate($row);
            MediaPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Media|Media[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Media[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(MediaPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(MediaPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(MediaPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MediaPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the address column
     *
     * Example usage:
     * <code>
     * $query->filterByAddress('fooValue');   // WHERE address = 'fooValue'
     * $query->filterByAddress('%fooValue%'); // WHERE address LIKE '%fooValue%'
     * </code>
     *
     * @param     string $address The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByAddress($address = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($address)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $address)) {
                $address = str_replace('*', '%', $address);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MediaPeer::ADDRESS, $address, $comparison);
    }

    /**
     * Filter the query on the phone column
     *
     * Example usage:
     * <code>
     * $query->filterByPhone('fooValue');   // WHERE phone = 'fooValue'
     * $query->filterByPhone('%fooValue%'); // WHERE phone LIKE '%fooValue%'
     * </code>
     *
     * @param     string $phone The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByPhone($phone = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($phone)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $phone)) {
                $phone = str_replace('*', '%', $phone);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MediaPeer::PHONE, $phone, $comparison);
    }

    /**
     * Filter the query on the url column
     *
     * Example usage:
     * <code>
     * $query->filterByUrl('fooValue');   // WHERE url = 'fooValue'
     * $query->filterByUrl('%fooValue%'); // WHERE url LIKE '%fooValue%'
     * </code>
     *
     * @param     string $url The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByUrl($url = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($url)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $url)) {
                $url = str_replace('*', '%', $url);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MediaPeer::URL, $url, $comparison);
    }

    /**
     * Filter the query on the mediakitUrl column
     *
     * Example usage:
     * <code>
     * $query->filterByMediakiturl('fooValue');   // WHERE mediakitUrl = 'fooValue'
     * $query->filterByMediakiturl('%fooValue%'); // WHERE mediakitUrl LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mediakiturl The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByMediakiturl($mediakiturl = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mediakiturl)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $mediakiturl)) {
                $mediakiturl = str_replace('*', '%', $mediakiturl);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MediaPeer::MEDIAKITURL, $mediakiturl, $comparison);
    }

    /**
     * Filter the query on the fax column
     *
     * Example usage:
     * <code>
     * $query->filterByFax('fooValue');   // WHERE fax = 'fooValue'
     * $query->filterByFax('%fooValue%'); // WHERE fax LIKE '%fooValue%'
     * </code>
     *
     * @param     string $fax The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByFax($fax = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($fax)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $fax)) {
                $fax = str_replace('*', '%', $fax);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MediaPeer::FAX, $fax, $comparison);
    }

    /**
     * Filter the query on the email column
     *
     * Example usage:
     * <code>
     * $query->filterByEmail('fooValue');   // WHERE email = 'fooValue'
     * $query->filterByEmail('%fooValue%'); // WHERE email LIKE '%fooValue%'
     * </code>
     *
     * @param     string $email The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByEmail($email = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($email)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $email)) {
                $email = str_replace('*', '%', $email);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MediaPeer::EMAIL, $email, $comparison);
    }

    /**
     * Filter the query on the receptionist column
     *
     * Example usage:
     * <code>
     * $query->filterByReceptionist('fooValue');   // WHERE receptionist = 'fooValue'
     * $query->filterByReceptionist('%fooValue%'); // WHERE receptionist LIKE '%fooValue%'
     * </code>
     *
     * @param     string $receptionist The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByReceptionist($receptionist = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($receptionist)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $receptionist)) {
                $receptionist = str_replace('*', '%', $receptionist);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MediaPeer::RECEPTIONIST, $receptionist, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MediaPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the typeId column
     *
     * Example usage:
     * <code>
     * $query->filterByTypeid(1234); // WHERE typeId = 1234
     * $query->filterByTypeid(array(12, 34)); // WHERE typeId IN (12, 34)
     * $query->filterByTypeid(array('min' => 12)); // WHERE typeId > 12
     * </code>
     *
     * @see       filterByMediaType()
     *
     * @param     mixed $typeid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByTypeid($typeid = null, $comparison = null)
    {
        if (is_array($typeid)) {
            $useMinMax = false;
            if (isset($typeid['min'])) {
                $this->addUsingAlias(MediaPeer::TYPEID, $typeid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($typeid['max'])) {
                $this->addUsingAlias(MediaPeer::TYPEID, $typeid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MediaPeer::TYPEID, $typeid, $comparison);
    }

    /**
     * Filter the query on the groupId column
     *
     * Example usage:
     * <code>
     * $query->filterByGroupid(1234); // WHERE groupId = 1234
     * $query->filterByGroupid(array(12, 34)); // WHERE groupId IN (12, 34)
     * $query->filterByGroupid(array('min' => 12)); // WHERE groupId > 12
     * </code>
     *
     * @see       filterByMediaRelatedByGroupid()
     *
     * @param     mixed $groupid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByGroupid($groupid = null, $comparison = null)
    {
        if (is_array($groupid)) {
            $useMinMax = false;
            if (isset($groupid['min'])) {
                $this->addUsingAlias(MediaPeer::GROUPID, $groupid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($groupid['max'])) {
                $this->addUsingAlias(MediaPeer::GROUPID, $groupid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MediaPeer::GROUPID, $groupid, $comparison);
    }

    /**
     * Filter the query on the importance column
     *
     * Example usage:
     * <code>
     * $query->filterByImportance(1234); // WHERE importance = 1234
     * $query->filterByImportance(array(12, 34)); // WHERE importance IN (12, 34)
     * $query->filterByImportance(array('min' => 12)); // WHERE importance > 12
     * </code>
     *
     * @param     mixed $importance The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByImportance($importance = null, $comparison = null)
    {
        if (is_array($importance)) {
            $useMinMax = false;
            if (isset($importance['min'])) {
                $this->addUsingAlias(MediaPeer::IMPORTANCE, $importance['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($importance['max'])) {
                $this->addUsingAlias(MediaPeer::IMPORTANCE, $importance['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MediaPeer::IMPORTANCE, $importance, $comparison);
    }

    /**
     * Filter the query on the bias column
     *
     * Example usage:
     * <code>
     * $query->filterByBias(1234); // WHERE bias = 1234
     * $query->filterByBias(array(12, 34)); // WHERE bias IN (12, 34)
     * $query->filterByBias(array('min' => 12)); // WHERE bias > 12
     * </code>
     *
     * @param     mixed $bias The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByBias($bias = null, $comparison = null)
    {
        if (is_array($bias)) {
            $useMinMax = false;
            if (isset($bias['min'])) {
                $this->addUsingAlias(MediaPeer::BIAS, $bias['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($bias['max'])) {
                $this->addUsingAlias(MediaPeer::BIAS, $bias['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MediaPeer::BIAS, $bias, $comparison);
    }

    /**
     * Filter the query on the aliasOf column
     *
     * Example usage:
     * <code>
     * $query->filterByAliasof(1234); // WHERE aliasOf = 1234
     * $query->filterByAliasof(array(12, 34)); // WHERE aliasOf IN (12, 34)
     * $query->filterByAliasof(array('min' => 12)); // WHERE aliasOf > 12
     * </code>
     *
     * @see       filterByMediaRelatedByAliasof()
     *
     * @param     mixed $aliasof The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByAliasof($aliasof = null, $comparison = null)
    {
        if (is_array($aliasof)) {
            $useMinMax = false;
            if (isset($aliasof['min'])) {
                $this->addUsingAlias(MediaPeer::ALIASOF, $aliasof['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($aliasof['max'])) {
                $this->addUsingAlias(MediaPeer::ALIASOF, $aliasof['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MediaPeer::ALIASOF, $aliasof, $comparison);
    }

    /**
     * Filter the query on the created_at column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatedAt('2011-03-14'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt('now'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt(array('max' => 'yesterday')); // WHERE created_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $createdAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByCreatedAt($createdAt = null, $comparison = null)
    {
        if (is_array($createdAt)) {
            $useMinMax = false;
            if (isset($createdAt['min'])) {
                $this->addUsingAlias(MediaPeer::CREATED_AT, $createdAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($createdAt['max'])) {
                $this->addUsingAlias(MediaPeer::CREATED_AT, $createdAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MediaPeer::CREATED_AT, $createdAt, $comparison);
    }

    /**
     * Filter the query on the updated_at column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdatedAt('2011-03-14'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt('now'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt(array('max' => 'yesterday')); // WHERE updated_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $updatedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function filterByUpdatedAt($updatedAt = null, $comparison = null)
    {
        if (is_array($updatedAt)) {
            $useMinMax = false;
            if (isset($updatedAt['min'])) {
                $this->addUsingAlias(MediaPeer::UPDATED_AT, $updatedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updatedAt['max'])) {
                $this->addUsingAlias(MediaPeer::UPDATED_AT, $updatedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MediaPeer::UPDATED_AT, $updatedAt, $comparison);
    }

    /**
     * Filter the query by a related MediaType object
     *
     * @param   MediaType|PropelObjectCollection $mediaType The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MediaQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMediaType($mediaType, $comparison = null)
    {
        if ($mediaType instanceof MediaType) {
            return $this
                ->addUsingAlias(MediaPeer::TYPEID, $mediaType->getId(), $comparison);
        } elseif ($mediaType instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MediaPeer::TYPEID, $mediaType->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByMediaType() only accepts arguments of type MediaType or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MediaType relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function joinMediaType($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MediaType');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MediaType');
        }

        return $this;
    }

    /**
     * Use the MediaType relation MediaType object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MediaTypeQuery A secondary query class using the current class as primary query
     */
    public function useMediaTypeQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMediaType($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MediaType', 'MediaTypeQuery');
    }

    /**
     * Filter the query by a related Media object
     *
     * @param   Media|PropelObjectCollection $media The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MediaQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMediaRelatedByGroupid($media, $comparison = null)
    {
        if ($media instanceof Media) {
            return $this
                ->addUsingAlias(MediaPeer::GROUPID, $media->getId(), $comparison);
        } elseif ($media instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MediaPeer::GROUPID, $media->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByMediaRelatedByGroupid() only accepts arguments of type Media or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MediaRelatedByGroupid relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function joinMediaRelatedByGroupid($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MediaRelatedByGroupid');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MediaRelatedByGroupid');
        }

        return $this;
    }

    /**
     * Use the MediaRelatedByGroupid relation Media object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MediaQuery A secondary query class using the current class as primary query
     */
    public function useMediaRelatedByGroupidQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMediaRelatedByGroupid($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MediaRelatedByGroupid', 'MediaQuery');
    }

    /**
     * Filter the query by a related Media object
     *
     * @param   Media|PropelObjectCollection $media The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MediaQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMediaRelatedByAliasof($media, $comparison = null)
    {
        if ($media instanceof Media) {
            return $this
                ->addUsingAlias(MediaPeer::ALIASOF, $media->getId(), $comparison);
        } elseif ($media instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MediaPeer::ALIASOF, $media->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByMediaRelatedByAliasof() only accepts arguments of type Media or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MediaRelatedByAliasof relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function joinMediaRelatedByAliasof($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MediaRelatedByAliasof');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MediaRelatedByAliasof');
        }

        return $this;
    }

    /**
     * Use the MediaRelatedByAliasof relation Media object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MediaQuery A secondary query class using the current class as primary query
     */
    public function useMediaRelatedByAliasofQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMediaRelatedByAliasof($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MediaRelatedByAliasof', 'MediaQuery');
    }

    /**
     * Filter the query by a related Headline object
     *
     * @param   Headline|PropelObjectCollection $headline  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MediaQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByHeadline($headline, $comparison = null)
    {
        if ($headline instanceof Headline) {
            return $this
                ->addUsingAlias(MediaPeer::ID, $headline->getMediaid(), $comparison);
        } elseif ($headline instanceof PropelObjectCollection) {
            return $this
                ->useHeadlineQuery()
                ->filterByPrimaryKeys($headline->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByHeadline() only accepts arguments of type Headline or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Headline relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function joinHeadline($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Headline');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Headline');
        }

        return $this;
    }

    /**
     * Use the Headline relation Headline object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   HeadlineQuery A secondary query class using the current class as primary query
     */
    public function useHeadlineQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinHeadline($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Headline', 'HeadlineQuery');
    }

    /**
     * Filter the query by a related Media object
     *
     * @param   Media|PropelObjectCollection $media  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MediaQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMediaRelatedById0($media, $comparison = null)
    {
        if ($media instanceof Media) {
            return $this
                ->addUsingAlias(MediaPeer::ID, $media->getGroupid(), $comparison);
        } elseif ($media instanceof PropelObjectCollection) {
            return $this
                ->useMediaRelatedById0Query()
                ->filterByPrimaryKeys($media->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMediaRelatedById0() only accepts arguments of type Media or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MediaRelatedById0 relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function joinMediaRelatedById0($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MediaRelatedById0');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MediaRelatedById0');
        }

        return $this;
    }

    /**
     * Use the MediaRelatedById0 relation Media object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MediaQuery A secondary query class using the current class as primary query
     */
    public function useMediaRelatedById0Query($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMediaRelatedById0($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MediaRelatedById0', 'MediaQuery');
    }

    /**
     * Filter the query by a related Media object
     *
     * @param   Media|PropelObjectCollection $media  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MediaQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMediaRelatedById1($media, $comparison = null)
    {
        if ($media instanceof Media) {
            return $this
                ->addUsingAlias(MediaPeer::ID, $media->getAliasof(), $comparison);
        } elseif ($media instanceof PropelObjectCollection) {
            return $this
                ->useMediaRelatedById1Query()
                ->filterByPrimaryKeys($media->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMediaRelatedById1() only accepts arguments of type Media or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MediaRelatedById1 relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function joinMediaRelatedById1($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MediaRelatedById1');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MediaRelatedById1');
        }

        return $this;
    }

    /**
     * Use the MediaRelatedById1 relation Media object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MediaQuery A secondary query class using the current class as primary query
     */
    public function useMediaRelatedById1Query($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMediaRelatedById1($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MediaRelatedById1', 'MediaQuery');
    }

    /**
     * Filter the query by a related MediaMarketRelation object
     *
     * @param   MediaMarketRelation|PropelObjectCollection $mediaMarketRelation  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MediaQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMediaMarketRelation($mediaMarketRelation, $comparison = null)
    {
        if ($mediaMarketRelation instanceof MediaMarketRelation) {
            return $this
                ->addUsingAlias(MediaPeer::ID, $mediaMarketRelation->getMediaid(), $comparison);
        } elseif ($mediaMarketRelation instanceof PropelObjectCollection) {
            return $this
                ->useMediaMarketRelationQuery()
                ->filterByPrimaryKeys($mediaMarketRelation->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMediaMarketRelation() only accepts arguments of type MediaMarketRelation or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MediaMarketRelation relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function joinMediaMarketRelation($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MediaMarketRelation');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MediaMarketRelation');
        }

        return $this;
    }

    /**
     * Use the MediaMarketRelation relation MediaMarketRelation object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MediaMarketRelationQuery A secondary query class using the current class as primary query
     */
    public function useMediaMarketRelationQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMediaMarketRelation($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MediaMarketRelation', 'MediaMarketRelationQuery');
    }

    /**
     * Filter the query by a related MediaAudienceRelation object
     *
     * @param   MediaAudienceRelation|PropelObjectCollection $mediaAudienceRelation  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MediaQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMediaAudienceRelation($mediaAudienceRelation, $comparison = null)
    {
        if ($mediaAudienceRelation instanceof MediaAudienceRelation) {
            return $this
                ->addUsingAlias(MediaPeer::ID, $mediaAudienceRelation->getMediaid(), $comparison);
        } elseif ($mediaAudienceRelation instanceof PropelObjectCollection) {
            return $this
                ->useMediaAudienceRelationQuery()
                ->filterByPrimaryKeys($mediaAudienceRelation->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMediaAudienceRelation() only accepts arguments of type MediaAudienceRelation or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MediaAudienceRelation relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function joinMediaAudienceRelation($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MediaAudienceRelation');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MediaAudienceRelation');
        }

        return $this;
    }

    /**
     * Use the MediaAudienceRelation relation MediaAudienceRelation object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MediaAudienceRelationQuery A secondary query class using the current class as primary query
     */
    public function useMediaAudienceRelationQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMediaAudienceRelation($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MediaAudienceRelation', 'MediaAudienceRelationQuery');
    }

    /**
     * Filter the query by a related MediaMarket object
     * using the medias_marketRelation table as cross reference
     *
     * @param   MediaMarket $mediaMarket the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MediaQuery The current query, for fluid interface
     */
    public function filterByMediaMarket($mediaMarket, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useMediaMarketRelationQuery()
            ->filterByMediaMarket($mediaMarket, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related MediaAudience object
     * using the medias_audienceRelation table as cross reference
     *
     * @param   MediaAudience $mediaAudience the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MediaQuery The current query, for fluid interface
     */
    public function filterByMediaAudience($mediaAudience, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useMediaAudienceRelationQuery()
            ->filterByMediaAudience($mediaAudience, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Media $media Object to remove from the list of results
     *
     * @return MediaQuery The current query, for fluid interface
     */
    public function prune($media = null)
    {
        if ($media) {
            $this->addUsingAlias(MediaPeer::ID, $media->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    // timestampable behavior

    /**
     * Filter by the latest updated
     *
     * @param      int $nbDays Maximum age of the latest update in days
     *
     * @return     MediaQuery The current query, for fluid interface
     */
    public function recentlyUpdated($nbDays = 7)
    {
        return $this->addUsingAlias(MediaPeer::UPDATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by update date desc
     *
     * @return     MediaQuery The current query, for fluid interface
     */
    public function lastUpdatedFirst()
    {
        return $this->addDescendingOrderByColumn(MediaPeer::UPDATED_AT);
    }

    /**
     * Order by update date asc
     *
     * @return     MediaQuery The current query, for fluid interface
     */
    public function firstUpdatedFirst()
    {
        return $this->addAscendingOrderByColumn(MediaPeer::UPDATED_AT);
    }

    /**
     * Filter by the latest created
     *
     * @param      int $nbDays Maximum age of in days
     *
     * @return     MediaQuery The current query, for fluid interface
     */
    public function recentlyCreated($nbDays = 7)
    {
        return $this->addUsingAlias(MediaPeer::CREATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by create date desc
     *
     * @return     MediaQuery The current query, for fluid interface
     */
    public function lastCreatedFirst()
    {
        return $this->addDescendingOrderByColumn(MediaPeer::CREATED_AT);
    }

    /**
     * Order by create date asc
     *
     * @return     MediaQuery The current query, for fluid interface
     */
    public function firstCreatedFirst()
    {
        return $this->addAscendingOrderByColumn(MediaPeer::CREATED_AT);
    }
}
