<?php


/**
 * Base class that represents a row from the 'medias_market' table.
 *
 * Tipo de medios
 *
 * @package    propel.generator.medias.classes.om
 */
abstract class BaseMediaMarket extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'MediaMarketPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        MediaMarketPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * @var        PropelObjectCollection|MediaMarketRelation[] Collection to store aggregation of MediaMarketRelation objects.
     */
    protected $collMediaMarketRelations;
    protected $collMediaMarketRelationsPartial;

    /**
     * @var        PropelObjectCollection|Media[] Collection to store aggregation of Media objects.
     */
    protected $collMedias;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $mediasScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $mediaMarketRelationsScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     * Id mercado del medio
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Mercado del medio
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set the value of [id] column.
     * Id mercado del medio
     * @param int $v new value
     * @return MediaMarket The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = MediaMarketPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Mercado del medio
     * @param string $v new value
     * @return MediaMarket The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = MediaMarketPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 2; // 2 = MediaMarketPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating MediaMarket object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(MediaMarketPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = MediaMarketPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->collMediaMarketRelations = null;

            $this->collMedias = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(MediaMarketPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = MediaMarketQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(MediaMarketPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                MediaMarketPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->mediasScheduledForDeletion !== null) {
                if (!$this->mediasScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->mediasScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    MediaMarketRelationQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->mediasScheduledForDeletion = null;
                }

                foreach ($this->getMedias() as $media) {
                    if ($media->isModified()) {
                        $media->save($con);
                    }
                }
            }

            if ($this->mediaMarketRelationsScheduledForDeletion !== null) {
                if (!$this->mediaMarketRelationsScheduledForDeletion->isEmpty()) {
                    MediaMarketRelationQuery::create()
                        ->filterByPrimaryKeys($this->mediaMarketRelationsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->mediaMarketRelationsScheduledForDeletion = null;
                }
            }

            if ($this->collMediaMarketRelations !== null) {
                foreach ($this->collMediaMarketRelations as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = MediaMarketPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . MediaMarketPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(MediaMarketPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(MediaMarketPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }

        $sql = sprintf(
            'INSERT INTO `medias_market` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            if (($retval = MediaMarketPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collMediaMarketRelations !== null) {
                    foreach ($this->collMediaMarketRelations as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = MediaMarketPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['MediaMarket'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['MediaMarket'][$this->getPrimaryKey()] = true;
        $keys = MediaMarketPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->collMediaMarketRelations) {
                $result['MediaMarketRelations'] = $this->collMediaMarketRelations->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = MediaMarketPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = MediaMarketPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(MediaMarketPeer::DATABASE_NAME);

        if ($this->isColumnModified(MediaMarketPeer::ID)) $criteria->add(MediaMarketPeer::ID, $this->id);
        if ($this->isColumnModified(MediaMarketPeer::NAME)) $criteria->add(MediaMarketPeer::NAME, $this->name);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(MediaMarketPeer::DATABASE_NAME);
        $criteria->add(MediaMarketPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of MediaMarket (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getMediaMarketRelations() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addMediaMarketRelation($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return MediaMarket Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return MediaMarketPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new MediaMarketPeer();
        }

        return self::$peer;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('MediaMarketRelation' == $relationName) {
            $this->initMediaMarketRelations();
        }
    }

    /**
     * Clears out the collMediaMarketRelations collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addMediaMarketRelations()
     */
    public function clearMediaMarketRelations()
    {
        $this->collMediaMarketRelations = null; // important to set this to null since that means it is uninitialized
        $this->collMediaMarketRelationsPartial = null;
    }

    /**
     * reset is the collMediaMarketRelations collection loaded partially
     *
     * @return void
     */
    public function resetPartialMediaMarketRelations($v = true)
    {
        $this->collMediaMarketRelationsPartial = $v;
    }

    /**
     * Initializes the collMediaMarketRelations collection.
     *
     * By default this just sets the collMediaMarketRelations collection to an empty array (like clearcollMediaMarketRelations());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initMediaMarketRelations($overrideExisting = true)
    {
        if (null !== $this->collMediaMarketRelations && !$overrideExisting) {
            return;
        }
        $this->collMediaMarketRelations = new PropelObjectCollection();
        $this->collMediaMarketRelations->setModel('MediaMarketRelation');
    }

    /**
     * Gets an array of MediaMarketRelation objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this MediaMarket is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|MediaMarketRelation[] List of MediaMarketRelation objects
     * @throws PropelException
     */
    public function getMediaMarketRelations($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collMediaMarketRelationsPartial && !$this->isNew();
        if (null === $this->collMediaMarketRelations || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collMediaMarketRelations) {
                // return empty collection
                $this->initMediaMarketRelations();
            } else {
                $collMediaMarketRelations = MediaMarketRelationQuery::create(null, $criteria)
                    ->filterByMediaMarket($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collMediaMarketRelationsPartial && count($collMediaMarketRelations)) {
                      $this->initMediaMarketRelations(false);

                      foreach($collMediaMarketRelations as $obj) {
                        if (false == $this->collMediaMarketRelations->contains($obj)) {
                          $this->collMediaMarketRelations->append($obj);
                        }
                      }

                      $this->collMediaMarketRelationsPartial = true;
                    }

                    return $collMediaMarketRelations;
                }

                if($partial && $this->collMediaMarketRelations) {
                    foreach($this->collMediaMarketRelations as $obj) {
                        if($obj->isNew()) {
                            $collMediaMarketRelations[] = $obj;
                        }
                    }
                }

                $this->collMediaMarketRelations = $collMediaMarketRelations;
                $this->collMediaMarketRelationsPartial = false;
            }
        }

        return $this->collMediaMarketRelations;
    }

    /**
     * Sets a collection of MediaMarketRelation objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $mediaMarketRelations A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setMediaMarketRelations(PropelCollection $mediaMarketRelations, PropelPDO $con = null)
    {
        $this->mediaMarketRelationsScheduledForDeletion = $this->getMediaMarketRelations(new Criteria(), $con)->diff($mediaMarketRelations);

        foreach ($this->mediaMarketRelationsScheduledForDeletion as $mediaMarketRelationRemoved) {
            $mediaMarketRelationRemoved->setMediaMarket(null);
        }

        $this->collMediaMarketRelations = null;
        foreach ($mediaMarketRelations as $mediaMarketRelation) {
            $this->addMediaMarketRelation($mediaMarketRelation);
        }

        $this->collMediaMarketRelations = $mediaMarketRelations;
        $this->collMediaMarketRelationsPartial = false;
    }

    /**
     * Returns the number of related MediaMarketRelation objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related MediaMarketRelation objects.
     * @throws PropelException
     */
    public function countMediaMarketRelations(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collMediaMarketRelationsPartial && !$this->isNew();
        if (null === $this->collMediaMarketRelations || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collMediaMarketRelations) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getMediaMarketRelations());
                }
                $query = MediaMarketRelationQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByMediaMarket($this)
                    ->count($con);
            }
        } else {
            return count($this->collMediaMarketRelations);
        }
    }

    /**
     * Method called to associate a MediaMarketRelation object to this object
     * through the MediaMarketRelation foreign key attribute.
     *
     * @param    MediaMarketRelation $l MediaMarketRelation
     * @return MediaMarket The current object (for fluent API support)
     */
    public function addMediaMarketRelation(MediaMarketRelation $l)
    {
        if ($this->collMediaMarketRelations === null) {
            $this->initMediaMarketRelations();
            $this->collMediaMarketRelationsPartial = true;
        }
        if (!$this->collMediaMarketRelations->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddMediaMarketRelation($l);
        }

        return $this;
    }

    /**
     * @param	MediaMarketRelation $mediaMarketRelation The mediaMarketRelation object to add.
     */
    protected function doAddMediaMarketRelation($mediaMarketRelation)
    {
        $this->collMediaMarketRelations[]= $mediaMarketRelation;
        $mediaMarketRelation->setMediaMarket($this);
    }

    /**
     * @param	MediaMarketRelation $mediaMarketRelation The mediaMarketRelation object to remove.
     */
    public function removeMediaMarketRelation($mediaMarketRelation)
    {
        if ($this->getMediaMarketRelations()->contains($mediaMarketRelation)) {
            $this->collMediaMarketRelations->remove($this->collMediaMarketRelations->search($mediaMarketRelation));
            if (null === $this->mediaMarketRelationsScheduledForDeletion) {
                $this->mediaMarketRelationsScheduledForDeletion = clone $this->collMediaMarketRelations;
                $this->mediaMarketRelationsScheduledForDeletion->clear();
            }
            $this->mediaMarketRelationsScheduledForDeletion[]= $mediaMarketRelation;
            $mediaMarketRelation->setMediaMarket(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this MediaMarket is new, it will return
     * an empty collection; or if this MediaMarket has previously
     * been saved, it will retrieve related MediaMarketRelations from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in MediaMarket.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|MediaMarketRelation[] List of MediaMarketRelation objects
     */
    public function getMediaMarketRelationsJoinMedia($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = MediaMarketRelationQuery::create(null, $criteria);
        $query->joinWith('Media', $join_behavior);

        return $this->getMediaMarketRelations($query, $con);
    }

    /**
     * Clears out the collMedias collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addMedias()
     */
    public function clearMedias()
    {
        $this->collMedias = null; // important to set this to null since that means it is uninitialized
        $this->collMediasPartial = null;
    }

    /**
     * Initializes the collMedias collection.
     *
     * By default this just sets the collMedias collection to an empty collection (like clearMedias());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initMedias()
    {
        $this->collMedias = new PropelObjectCollection();
        $this->collMedias->setModel('Media');
    }

    /**
     * Gets a collection of Media objects related by a many-to-many relationship
     * to the current object by way of the medias_marketRelation cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this MediaMarket is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Media[] List of Media objects
     */
    public function getMedias($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collMedias || null !== $criteria) {
            if ($this->isNew() && null === $this->collMedias) {
                // return empty collection
                $this->initMedias();
            } else {
                $collMedias = MediaQuery::create(null, $criteria)
                    ->filterByMediaMarket($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collMedias;
                }
                $this->collMedias = $collMedias;
            }
        }

        return $this->collMedias;
    }

    /**
     * Sets a collection of Media objects related by a many-to-many relationship
     * to the current object by way of the medias_marketRelation cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $medias A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setMedias(PropelCollection $medias, PropelPDO $con = null)
    {
        $this->clearMedias();
        $currentMedias = $this->getMedias();

        $this->mediasScheduledForDeletion = $currentMedias->diff($medias);

        foreach ($medias as $media) {
            if (!$currentMedias->contains($media)) {
                $this->doAddMedia($media);
            }
        }

        $this->collMedias = $medias;
    }

    /**
     * Gets the number of Media objects related by a many-to-many relationship
     * to the current object by way of the medias_marketRelation cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Media objects
     */
    public function countMedias($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collMedias || null !== $criteria) {
            if ($this->isNew() && null === $this->collMedias) {
                return 0;
            } else {
                $query = MediaQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByMediaMarket($this)
                    ->count($con);
            }
        } else {
            return count($this->collMedias);
        }
    }

    /**
     * Associate a Media object to this object
     * through the medias_marketRelation cross reference table.
     *
     * @param  Media $media The MediaMarketRelation object to relate
     * @return void
     */
    public function addMedia(Media $media)
    {
        if ($this->collMedias === null) {
            $this->initMedias();
        }
        if (!$this->collMedias->contains($media)) { // only add it if the **same** object is not already associated
            $this->doAddMedia($media);

            $this->collMedias[]= $media;
        }
    }

    /**
     * @param	Media $media The media object to add.
     */
    protected function doAddMedia($media)
    {
        $mediaMarketRelation = new MediaMarketRelation();
        $mediaMarketRelation->setMedia($media);
        $this->addMediaMarketRelation($mediaMarketRelation);
    }

    /**
     * Remove a Media object to this object
     * through the medias_marketRelation cross reference table.
     *
     * @param Media $media The MediaMarketRelation object to relate
     * @return void
     */
    public function removeMedia(Media $media)
    {
        if ($this->getMedias()->contains($media)) {
            $this->collMedias->remove($this->collMedias->search($media));
            if (null === $this->mediasScheduledForDeletion) {
                $this->mediasScheduledForDeletion = clone $this->collMedias;
                $this->mediasScheduledForDeletion->clear();
            }
            $this->mediasScheduledForDeletion[]= $media;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collMediaMarketRelations) {
                foreach ($this->collMediaMarketRelations as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collMedias) {
                foreach ($this->collMedias as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collMediaMarketRelations instanceof PropelCollection) {
            $this->collMediaMarketRelations->clearIterator();
        }
        $this->collMediaMarketRelations = null;
        if ($this->collMedias instanceof PropelCollection) {
            $this->collMedias->clearIterator();
        }
        $this->collMedias = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
