<?php


/**
 * Base class that represents a row from the 'issues_issue' table.
 *
 * Asuntos
 *
 * @package    propel.generator.issues.classes.om
 */
abstract class BaseIssue extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'IssuePeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        IssuePeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the parentid field.
     * @var        int
     */
    protected $parentid;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the impact field.
     * @var        int
     */
    protected $impact;

    /**
     * The value for the valoration field.
     * @var        int
     */
    protected $valoration;

    /**
     * The value for the evolution field.
     * @var        int
     */
    protected $evolution;

    /**
     * The value for the objecttype field.
     * @var        string
     */
    protected $objecttype;

    /**
     * The value for the objectid field.
     * @var        int
     */
    protected $objectid;

    /**
     * The value for the created_at field.
     * @var        string
     */
    protected $created_at;

    /**
     * The value for the updated_at field.
     * @var        string
     */
    protected $updated_at;

    /**
     * The value for the deleted_at field.
     * @var        string
     */
    protected $deleted_at;

    /**
     * The value for the version field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $version;

    /**
     * The value for the version_created_by field.
     * @var        string
     */
    protected $version_created_by;

    /**
     * @var        PropelObjectCollection|HeadlineIssue[] Collection to store aggregation of HeadlineIssue objects.
     */
    protected $collHeadlineIssues;
    protected $collHeadlineIssuesPartial;

    /**
     * @var        PropelObjectCollection|IssueCategoryRelation[] Collection to store aggregation of IssueCategoryRelation objects.
     */
    protected $collIssueCategoryRelations;
    protected $collIssueCategoryRelationsPartial;

    /**
     * @var        PropelObjectCollection|IssueActor[] Collection to store aggregation of IssueActor objects.
     */
    protected $collIssueActors;
    protected $collIssueActorsPartial;

    /**
     * @var        PropelObjectCollection|IssueVersion[] Collection to store aggregation of IssueVersion objects.
     */
    protected $collIssueVersions;
    protected $collIssueVersionsPartial;

    /**
     * @var        PropelObjectCollection|Headline[] Collection to store aggregation of Headline objects.
     */
    protected $collHeadlines;

    /**
     * @var        PropelObjectCollection|IssueCategory[] Collection to store aggregation of IssueCategory objects.
     */
    protected $collIssueCategorys;

    /**
     * @var        PropelObjectCollection|Actor[] Collection to store aggregation of Actor objects.
     */
    protected $collActors;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    // versionable behavior


    /**
     * @var bool
     */
    protected $enforceVersion = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $headlinesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $issueCategorysScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $actorsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $headlineIssuesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $issueCategoryRelationsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $issueActorsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $issueVersionsScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see        __construct()
     */
    public function applyDefaultValues()
    {
        $this->version = 0;
    }

    /**
     * Initializes internal state of BaseIssue object.
     * @see        applyDefaults()
     */
    public function __construct()
    {
        parent::__construct();
        $this->applyDefaultValues();
    }

    /**
     * Get the [id] column value.
     * Id log
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Nombre del issue
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [parentid] column value.
     * Id del parent issue
     * @return int
     */
    public function getParentid()
    {
        return $this->parentid;
    }

    /**
     * Get the [description] column value.
     * Descripcion del issue
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [impact] column value.
     * Impacto del issue
     * @return int
     */
    public function getImpact()
    {
        return $this->impact;
    }

    /**
     * Get the [valoration] column value.
     * Valoracion del issue
     * @return int
     */
    public function getValoration()
    {
        return $this->valoration;
    }

    /**
     * Get the [evolution] column value.
     * Evolucion del issue
     * @return int
     */
    public function getEvolution()
    {
        return $this->evolution;
    }

    /**
     * Get the [objecttype] column value.
     * Tipo de objeto de usuario
     * @return string
     */
    public function getObjecttype()
    {
        return $this->objecttype;
    }

    /**
     * Get the [objectid] column value.
     * Id de objeto de usuario
     * @return int
     */
    public function getObjectid()
    {
        return $this->objectid;
    }

    /**
     * Get the [optionally formatted] temporal [created_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getCreatedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->created_at === null) {
            return null;
        }

        if ($this->created_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->created_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->created_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [updated_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUpdatedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->updated_at === null) {
            return null;
        }

        if ($this->updated_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->updated_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->updated_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [deleted_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDeletedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->deleted_at === null) {
            return null;
        }

        if ($this->deleted_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->deleted_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->deleted_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [version] column value.
     *
     * @return int
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * Get the [version_created_by] column value.
     *
     * @return string
     */
    public function getVersionCreatedBy()
    {
        return $this->version_created_by;
    }

    /**
     * Set the value of [id] column.
     * Id log
     * @param int $v new value
     * @return Issue The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = IssuePeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Nombre del issue
     * @param string $v new value
     * @return Issue The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = IssuePeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [parentid] column.
     * Id del parent issue
     * @param int $v new value
     * @return Issue The current object (for fluent API support)
     */
    public function setParentid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->parentid !== $v) {
            $this->parentid = $v;
            $this->modifiedColumns[] = IssuePeer::PARENTID;
        }


        return $this;
    } // setParentid()

    /**
     * Set the value of [description] column.
     * Descripcion del issue
     * @param string $v new value
     * @return Issue The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = IssuePeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Set the value of [impact] column.
     * Impacto del issue
     * @param int $v new value
     * @return Issue The current object (for fluent API support)
     */
    public function setImpact($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->impact !== $v) {
            $this->impact = $v;
            $this->modifiedColumns[] = IssuePeer::IMPACT;
        }


        return $this;
    } // setImpact()

    /**
     * Set the value of [valoration] column.
     * Valoracion del issue
     * @param int $v new value
     * @return Issue The current object (for fluent API support)
     */
    public function setValoration($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->valoration !== $v) {
            $this->valoration = $v;
            $this->modifiedColumns[] = IssuePeer::VALORATION;
        }


        return $this;
    } // setValoration()

    /**
     * Set the value of [evolution] column.
     * Evolucion del issue
     * @param int $v new value
     * @return Issue The current object (for fluent API support)
     */
    public function setEvolution($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->evolution !== $v) {
            $this->evolution = $v;
            $this->modifiedColumns[] = IssuePeer::EVOLUTION;
        }


        return $this;
    } // setEvolution()

    /**
     * Set the value of [objecttype] column.
     * Tipo de objeto de usuario
     * @param string $v new value
     * @return Issue The current object (for fluent API support)
     */
    public function setObjecttype($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->objecttype !== $v) {
            $this->objecttype = $v;
            $this->modifiedColumns[] = IssuePeer::OBJECTTYPE;
        }


        return $this;
    } // setObjecttype()

    /**
     * Set the value of [objectid] column.
     * Id de objeto de usuario
     * @param int $v new value
     * @return Issue The current object (for fluent API support)
     */
    public function setObjectid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->objectid !== $v) {
            $this->objectid = $v;
            $this->modifiedColumns[] = IssuePeer::OBJECTID;
        }


        return $this;
    } // setObjectid()

    /**
     * Sets the value of [created_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Issue The current object (for fluent API support)
     */
    public function setCreatedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->created_at !== null || $dt !== null) {
            $currentDateAsString = ($this->created_at !== null && $tmpDt = new DateTime($this->created_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->created_at = $newDateAsString;
                $this->modifiedColumns[] = IssuePeer::CREATED_AT;
            }
        } // if either are not null


        return $this;
    } // setCreatedAt()

    /**
     * Sets the value of [updated_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Issue The current object (for fluent API support)
     */
    public function setUpdatedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->updated_at !== null || $dt !== null) {
            $currentDateAsString = ($this->updated_at !== null && $tmpDt = new DateTime($this->updated_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->updated_at = $newDateAsString;
                $this->modifiedColumns[] = IssuePeer::UPDATED_AT;
            }
        } // if either are not null


        return $this;
    } // setUpdatedAt()

    /**
     * Sets the value of [deleted_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Issue The current object (for fluent API support)
     */
    public function setDeletedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->deleted_at !== null || $dt !== null) {
            $currentDateAsString = ($this->deleted_at !== null && $tmpDt = new DateTime($this->deleted_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->deleted_at = $newDateAsString;
                $this->modifiedColumns[] = IssuePeer::DELETED_AT;
            }
        } // if either are not null


        return $this;
    } // setDeletedAt()

    /**
     * Set the value of [version] column.
     *
     * @param int $v new value
     * @return Issue The current object (for fluent API support)
     */
    public function setVersion($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->version !== $v) {
            $this->version = $v;
            $this->modifiedColumns[] = IssuePeer::VERSION;
        }


        return $this;
    } // setVersion()

    /**
     * Set the value of [version_created_by] column.
     *
     * @param string $v new value
     * @return Issue The current object (for fluent API support)
     */
    public function setVersionCreatedBy($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->version_created_by !== $v) {
            $this->version_created_by = $v;
            $this->modifiedColumns[] = IssuePeer::VERSION_CREATED_BY;
        }


        return $this;
    } // setVersionCreatedBy()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->version !== 0) {
                return false;
            }

        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->parentid = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->description = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->impact = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
            $this->valoration = ($row[$startcol + 5] !== null) ? (int) $row[$startcol + 5] : null;
            $this->evolution = ($row[$startcol + 6] !== null) ? (int) $row[$startcol + 6] : null;
            $this->objecttype = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->objectid = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
            $this->created_at = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
            $this->updated_at = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
            $this->deleted_at = ($row[$startcol + 11] !== null) ? (string) $row[$startcol + 11] : null;
            $this->version = ($row[$startcol + 12] !== null) ? (int) $row[$startcol + 12] : null;
            $this->version_created_by = ($row[$startcol + 13] !== null) ? (string) $row[$startcol + 13] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 14; // 14 = IssuePeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Issue object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(IssuePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = IssuePeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->collHeadlineIssues = null;

            $this->collIssueCategoryRelations = null;

            $this->collIssueActors = null;

            $this->collIssueVersions = null;

            $this->collHeadlines = null;
            $this->collIssueCategorys = null;
            $this->collActors = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(IssuePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = IssueQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // soft_delete behavior
            if (!empty($ret) && IssueQuery::isSoftDeleteEnabled()) {
                $this->keepUpdateDateUnchanged();
                $this->setDeletedAt(time());
                $this->save($con);
                $this->postDelete($con);
                $con->commit();
                IssuePeer::removeInstanceFromPool($this);

                return;
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                // versionable behavior
                // emulate delete cascade
                IssueVersionQuery::create()
                    ->filterByIssue($this)
                    ->delete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(IssuePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            // versionable behavior
            if ($this->isVersioningNecessary()) {
                $this->setVersion($this->isNew() ? 1 : $this->getLastVersionNumber($con) + 1);
                $createVersion = true; // for postSave hook
            }
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
                // timestampable behavior
                if (!$this->isColumnModified(IssuePeer::CREATED_AT)) {
                    $this->setCreatedAt(time());
                }
                if (!$this->isColumnModified(IssuePeer::UPDATED_AT)) {
                    $this->setUpdatedAt(time());
                }
            } else {
                $ret = $ret && $this->preUpdate($con);
                // timestampable behavior
                if ($this->isModified() && !$this->isColumnModified(IssuePeer::UPDATED_AT)) {
                    $this->setUpdatedAt(time());
                }
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                // versionable behavior
                if (isset($createVersion)) {
                    $this->addVersion($con);
                }
                IssuePeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->headlinesScheduledForDeletion !== null) {
                if (!$this->headlinesScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->headlinesScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    HeadlineIssueQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->headlinesScheduledForDeletion = null;
                }

                foreach ($this->getHeadlines() as $headline) {
                    if ($headline->isModified()) {
                        $headline->save($con);
                    }
                }
            }

            if ($this->issueCategorysScheduledForDeletion !== null) {
                if (!$this->issueCategorysScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->issueCategorysScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    IssueCategoryRelationQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->issueCategorysScheduledForDeletion = null;
                }

                foreach ($this->getIssueCategorys() as $issueCategory) {
                    if ($issueCategory->isModified()) {
                        $issueCategory->save($con);
                    }
                }
            }

            if ($this->actorsScheduledForDeletion !== null) {
                if (!$this->actorsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->actorsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    IssueActorQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->actorsScheduledForDeletion = null;
                }

                foreach ($this->getActors() as $actor) {
                    if ($actor->isModified()) {
                        $actor->save($con);
                    }
                }
            }

            if ($this->headlineIssuesScheduledForDeletion !== null) {
                if (!$this->headlineIssuesScheduledForDeletion->isEmpty()) {
                    HeadlineIssueQuery::create()
                        ->filterByPrimaryKeys($this->headlineIssuesScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->headlineIssuesScheduledForDeletion = null;
                }
            }

            if ($this->collHeadlineIssues !== null) {
                foreach ($this->collHeadlineIssues as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->issueCategoryRelationsScheduledForDeletion !== null) {
                if (!$this->issueCategoryRelationsScheduledForDeletion->isEmpty()) {
                    IssueCategoryRelationQuery::create()
                        ->filterByPrimaryKeys($this->issueCategoryRelationsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->issueCategoryRelationsScheduledForDeletion = null;
                }
            }

            if ($this->collIssueCategoryRelations !== null) {
                foreach ($this->collIssueCategoryRelations as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->issueActorsScheduledForDeletion !== null) {
                if (!$this->issueActorsScheduledForDeletion->isEmpty()) {
                    IssueActorQuery::create()
                        ->filterByPrimaryKeys($this->issueActorsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->issueActorsScheduledForDeletion = null;
                }
            }

            if ($this->collIssueActors !== null) {
                foreach ($this->collIssueActors as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->issueVersionsScheduledForDeletion !== null) {
                if (!$this->issueVersionsScheduledForDeletion->isEmpty()) {
                    IssueVersionQuery::create()
                        ->filterByPrimaryKeys($this->issueVersionsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->issueVersionsScheduledForDeletion = null;
                }
            }

            if ($this->collIssueVersions !== null) {
                foreach ($this->collIssueVersions as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = IssuePeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . IssuePeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(IssuePeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(IssuePeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(IssuePeer::PARENTID)) {
            $modifiedColumns[':p' . $index++]  = '`PARENTID`';
        }
        if ($this->isColumnModified(IssuePeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(IssuePeer::IMPACT)) {
            $modifiedColumns[':p' . $index++]  = '`IMPACT`';
        }
        if ($this->isColumnModified(IssuePeer::VALORATION)) {
            $modifiedColumns[':p' . $index++]  = '`VALORATION`';
        }
        if ($this->isColumnModified(IssuePeer::EVOLUTION)) {
            $modifiedColumns[':p' . $index++]  = '`EVOLUTION`';
        }
        if ($this->isColumnModified(IssuePeer::OBJECTTYPE)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECTTYPE`';
        }
        if ($this->isColumnModified(IssuePeer::OBJECTID)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECTID`';
        }
        if ($this->isColumnModified(IssuePeer::CREATED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`CREATED_AT`';
        }
        if ($this->isColumnModified(IssuePeer::UPDATED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`UPDATED_AT`';
        }
        if ($this->isColumnModified(IssuePeer::DELETED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`DELETED_AT`';
        }
        if ($this->isColumnModified(IssuePeer::VERSION)) {
            $modifiedColumns[':p' . $index++]  = '`VERSION`';
        }
        if ($this->isColumnModified(IssuePeer::VERSION_CREATED_BY)) {
            $modifiedColumns[':p' . $index++]  = '`VERSION_CREATED_BY`';
        }

        $sql = sprintf(
            'INSERT INTO `issues_issue` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`PARENTID`':
                        $stmt->bindValue($identifier, $this->parentid, PDO::PARAM_INT);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`IMPACT`':
                        $stmt->bindValue($identifier, $this->impact, PDO::PARAM_INT);
                        break;
                    case '`VALORATION`':
                        $stmt->bindValue($identifier, $this->valoration, PDO::PARAM_INT);
                        break;
                    case '`EVOLUTION`':
                        $stmt->bindValue($identifier, $this->evolution, PDO::PARAM_INT);
                        break;
                    case '`OBJECTTYPE`':
                        $stmt->bindValue($identifier, $this->objecttype, PDO::PARAM_STR);
                        break;
                    case '`OBJECTID`':
                        $stmt->bindValue($identifier, $this->objectid, PDO::PARAM_INT);
                        break;
                    case '`CREATED_AT`':
                        $stmt->bindValue($identifier, $this->created_at, PDO::PARAM_STR);
                        break;
                    case '`UPDATED_AT`':
                        $stmt->bindValue($identifier, $this->updated_at, PDO::PARAM_STR);
                        break;
                    case '`DELETED_AT`':
                        $stmt->bindValue($identifier, $this->deleted_at, PDO::PARAM_STR);
                        break;
                    case '`VERSION`':
                        $stmt->bindValue($identifier, $this->version, PDO::PARAM_INT);
                        break;
                    case '`VERSION_CREATED_BY`':
                        $stmt->bindValue($identifier, $this->version_created_by, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            if (($retval = IssuePeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collHeadlineIssues !== null) {
                    foreach ($this->collHeadlineIssues as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collIssueCategoryRelations !== null) {
                    foreach ($this->collIssueCategoryRelations as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collIssueActors !== null) {
                    foreach ($this->collIssueActors as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collIssueVersions !== null) {
                    foreach ($this->collIssueVersions as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = IssuePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getParentid();
                break;
            case 3:
                return $this->getDescription();
                break;
            case 4:
                return $this->getImpact();
                break;
            case 5:
                return $this->getValoration();
                break;
            case 6:
                return $this->getEvolution();
                break;
            case 7:
                return $this->getObjecttype();
                break;
            case 8:
                return $this->getObjectid();
                break;
            case 9:
                return $this->getCreatedAt();
                break;
            case 10:
                return $this->getUpdatedAt();
                break;
            case 11:
                return $this->getDeletedAt();
                break;
            case 12:
                return $this->getVersion();
                break;
            case 13:
                return $this->getVersionCreatedBy();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Issue'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Issue'][$this->getPrimaryKey()] = true;
        $keys = IssuePeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getParentid(),
            $keys[3] => $this->getDescription(),
            $keys[4] => $this->getImpact(),
            $keys[5] => $this->getValoration(),
            $keys[6] => $this->getEvolution(),
            $keys[7] => $this->getObjecttype(),
            $keys[8] => $this->getObjectid(),
            $keys[9] => $this->getCreatedAt(),
            $keys[10] => $this->getUpdatedAt(),
            $keys[11] => $this->getDeletedAt(),
            $keys[12] => $this->getVersion(),
            $keys[13] => $this->getVersionCreatedBy(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->collHeadlineIssues) {
                $result['HeadlineIssues'] = $this->collHeadlineIssues->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collIssueCategoryRelations) {
                $result['IssueCategoryRelations'] = $this->collIssueCategoryRelations->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collIssueActors) {
                $result['IssueActors'] = $this->collIssueActors->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collIssueVersions) {
                $result['IssueVersions'] = $this->collIssueVersions->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = IssuePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setParentid($value);
                break;
            case 3:
                $this->setDescription($value);
                break;
            case 4:
                $this->setImpact($value);
                break;
            case 5:
                $this->setValoration($value);
                break;
            case 6:
                $this->setEvolution($value);
                break;
            case 7:
                $this->setObjecttype($value);
                break;
            case 8:
                $this->setObjectid($value);
                break;
            case 9:
                $this->setCreatedAt($value);
                break;
            case 10:
                $this->setUpdatedAt($value);
                break;
            case 11:
                $this->setDeletedAt($value);
                break;
            case 12:
                $this->setVersion($value);
                break;
            case 13:
                $this->setVersionCreatedBy($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = IssuePeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setParentid($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setDescription($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setImpact($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setValoration($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setEvolution($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setObjecttype($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setObjectid($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setCreatedAt($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setUpdatedAt($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setDeletedAt($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setVersion($arr[$keys[12]]);
        if (array_key_exists($keys[13], $arr)) $this->setVersionCreatedBy($arr[$keys[13]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(IssuePeer::DATABASE_NAME);

        if ($this->isColumnModified(IssuePeer::ID)) $criteria->add(IssuePeer::ID, $this->id);
        if ($this->isColumnModified(IssuePeer::NAME)) $criteria->add(IssuePeer::NAME, $this->name);
        if ($this->isColumnModified(IssuePeer::PARENTID)) $criteria->add(IssuePeer::PARENTID, $this->parentid);
        if ($this->isColumnModified(IssuePeer::DESCRIPTION)) $criteria->add(IssuePeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(IssuePeer::IMPACT)) $criteria->add(IssuePeer::IMPACT, $this->impact);
        if ($this->isColumnModified(IssuePeer::VALORATION)) $criteria->add(IssuePeer::VALORATION, $this->valoration);
        if ($this->isColumnModified(IssuePeer::EVOLUTION)) $criteria->add(IssuePeer::EVOLUTION, $this->evolution);
        if ($this->isColumnModified(IssuePeer::OBJECTTYPE)) $criteria->add(IssuePeer::OBJECTTYPE, $this->objecttype);
        if ($this->isColumnModified(IssuePeer::OBJECTID)) $criteria->add(IssuePeer::OBJECTID, $this->objectid);
        if ($this->isColumnModified(IssuePeer::CREATED_AT)) $criteria->add(IssuePeer::CREATED_AT, $this->created_at);
        if ($this->isColumnModified(IssuePeer::UPDATED_AT)) $criteria->add(IssuePeer::UPDATED_AT, $this->updated_at);
        if ($this->isColumnModified(IssuePeer::DELETED_AT)) $criteria->add(IssuePeer::DELETED_AT, $this->deleted_at);
        if ($this->isColumnModified(IssuePeer::VERSION)) $criteria->add(IssuePeer::VERSION, $this->version);
        if ($this->isColumnModified(IssuePeer::VERSION_CREATED_BY)) $criteria->add(IssuePeer::VERSION_CREATED_BY, $this->version_created_by);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(IssuePeer::DATABASE_NAME);
        $criteria->add(IssuePeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Issue (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setParentid($this->getParentid());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setImpact($this->getImpact());
        $copyObj->setValoration($this->getValoration());
        $copyObj->setEvolution($this->getEvolution());
        $copyObj->setObjecttype($this->getObjecttype());
        $copyObj->setObjectid($this->getObjectid());
        $copyObj->setCreatedAt($this->getCreatedAt());
        $copyObj->setUpdatedAt($this->getUpdatedAt());
        $copyObj->setDeletedAt($this->getDeletedAt());
        $copyObj->setVersion($this->getVersion());
        $copyObj->setVersionCreatedBy($this->getVersionCreatedBy());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getHeadlineIssues() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addHeadlineIssue($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getIssueCategoryRelations() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addIssueCategoryRelation($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getIssueActors() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addIssueActor($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getIssueVersions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addIssueVersion($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Issue Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return IssuePeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new IssuePeer();
        }

        return self::$peer;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('HeadlineIssue' == $relationName) {
            $this->initHeadlineIssues();
        }
        if ('IssueCategoryRelation' == $relationName) {
            $this->initIssueCategoryRelations();
        }
        if ('IssueActor' == $relationName) {
            $this->initIssueActors();
        }
        if ('IssueVersion' == $relationName) {
            $this->initIssueVersions();
        }
    }

    /**
     * Clears out the collHeadlineIssues collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addHeadlineIssues()
     */
    public function clearHeadlineIssues()
    {
        $this->collHeadlineIssues = null; // important to set this to null since that means it is uninitialized
        $this->collHeadlineIssuesPartial = null;
    }

    /**
     * reset is the collHeadlineIssues collection loaded partially
     *
     * @return void
     */
    public function resetPartialHeadlineIssues($v = true)
    {
        $this->collHeadlineIssuesPartial = $v;
    }

    /**
     * Initializes the collHeadlineIssues collection.
     *
     * By default this just sets the collHeadlineIssues collection to an empty array (like clearcollHeadlineIssues());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initHeadlineIssues($overrideExisting = true)
    {
        if (null !== $this->collHeadlineIssues && !$overrideExisting) {
            return;
        }
        $this->collHeadlineIssues = new PropelObjectCollection();
        $this->collHeadlineIssues->setModel('HeadlineIssue');
    }

    /**
     * Gets an array of HeadlineIssue objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Issue is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|HeadlineIssue[] List of HeadlineIssue objects
     * @throws PropelException
     */
    public function getHeadlineIssues($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineIssuesPartial && !$this->isNew();
        if (null === $this->collHeadlineIssues || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collHeadlineIssues) {
                // return empty collection
                $this->initHeadlineIssues();
            } else {
                $collHeadlineIssues = HeadlineIssueQuery::create(null, $criteria)
                    ->filterByIssue($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collHeadlineIssuesPartial && count($collHeadlineIssues)) {
                      $this->initHeadlineIssues(false);

                      foreach($collHeadlineIssues as $obj) {
                        if (false == $this->collHeadlineIssues->contains($obj)) {
                          $this->collHeadlineIssues->append($obj);
                        }
                      }

                      $this->collHeadlineIssuesPartial = true;
                    }

                    return $collHeadlineIssues;
                }

                if($partial && $this->collHeadlineIssues) {
                    foreach($this->collHeadlineIssues as $obj) {
                        if($obj->isNew()) {
                            $collHeadlineIssues[] = $obj;
                        }
                    }
                }

                $this->collHeadlineIssues = $collHeadlineIssues;
                $this->collHeadlineIssuesPartial = false;
            }
        }

        return $this->collHeadlineIssues;
    }

    /**
     * Sets a collection of HeadlineIssue objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $headlineIssues A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setHeadlineIssues(PropelCollection $headlineIssues, PropelPDO $con = null)
    {
        $this->headlineIssuesScheduledForDeletion = $this->getHeadlineIssues(new Criteria(), $con)->diff($headlineIssues);

        foreach ($this->headlineIssuesScheduledForDeletion as $headlineIssueRemoved) {
            $headlineIssueRemoved->setIssue(null);
        }

        $this->collHeadlineIssues = null;
        foreach ($headlineIssues as $headlineIssue) {
            $this->addHeadlineIssue($headlineIssue);
        }

        $this->collHeadlineIssues = $headlineIssues;
        $this->collHeadlineIssuesPartial = false;
    }

    /**
     * Returns the number of related HeadlineIssue objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related HeadlineIssue objects.
     * @throws PropelException
     */
    public function countHeadlineIssues(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineIssuesPartial && !$this->isNew();
        if (null === $this->collHeadlineIssues || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collHeadlineIssues) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getHeadlineIssues());
                }
                $query = HeadlineIssueQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIssue($this)
                    ->count($con);
            }
        } else {
            return count($this->collHeadlineIssues);
        }
    }

    /**
     * Method called to associate a HeadlineIssue object to this object
     * through the HeadlineIssue foreign key attribute.
     *
     * @param    HeadlineIssue $l HeadlineIssue
     * @return Issue The current object (for fluent API support)
     */
    public function addHeadlineIssue(HeadlineIssue $l)
    {
        if ($this->collHeadlineIssues === null) {
            $this->initHeadlineIssues();
            $this->collHeadlineIssuesPartial = true;
        }
        if (!$this->collHeadlineIssues->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddHeadlineIssue($l);
        }

        return $this;
    }

    /**
     * @param	HeadlineIssue $headlineIssue The headlineIssue object to add.
     */
    protected function doAddHeadlineIssue($headlineIssue)
    {
        $this->collHeadlineIssues[]= $headlineIssue;
        $headlineIssue->setIssue($this);
    }

    /**
     * @param	HeadlineIssue $headlineIssue The headlineIssue object to remove.
     */
    public function removeHeadlineIssue($headlineIssue)
    {
        if ($this->getHeadlineIssues()->contains($headlineIssue)) {
            $this->collHeadlineIssues->remove($this->collHeadlineIssues->search($headlineIssue));
            if (null === $this->headlineIssuesScheduledForDeletion) {
                $this->headlineIssuesScheduledForDeletion = clone $this->collHeadlineIssues;
                $this->headlineIssuesScheduledForDeletion->clear();
            }
            $this->headlineIssuesScheduledForDeletion[]= $headlineIssue;
            $headlineIssue->setIssue(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Issue is new, it will return
     * an empty collection; or if this Issue has previously
     * been saved, it will retrieve related HeadlineIssues from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Issue.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|HeadlineIssue[] List of HeadlineIssue objects
     */
    public function getHeadlineIssuesJoinHeadline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = HeadlineIssueQuery::create(null, $criteria);
        $query->joinWith('Headline', $join_behavior);

        return $this->getHeadlineIssues($query, $con);
    }

    /**
     * Clears out the collIssueCategoryRelations collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIssueCategoryRelations()
     */
    public function clearIssueCategoryRelations()
    {
        $this->collIssueCategoryRelations = null; // important to set this to null since that means it is uninitialized
        $this->collIssueCategoryRelationsPartial = null;
    }

    /**
     * reset is the collIssueCategoryRelations collection loaded partially
     *
     * @return void
     */
    public function resetPartialIssueCategoryRelations($v = true)
    {
        $this->collIssueCategoryRelationsPartial = $v;
    }

    /**
     * Initializes the collIssueCategoryRelations collection.
     *
     * By default this just sets the collIssueCategoryRelations collection to an empty array (like clearcollIssueCategoryRelations());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initIssueCategoryRelations($overrideExisting = true)
    {
        if (null !== $this->collIssueCategoryRelations && !$overrideExisting) {
            return;
        }
        $this->collIssueCategoryRelations = new PropelObjectCollection();
        $this->collIssueCategoryRelations->setModel('IssueCategoryRelation');
    }

    /**
     * Gets an array of IssueCategoryRelation objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Issue is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|IssueCategoryRelation[] List of IssueCategoryRelation objects
     * @throws PropelException
     */
    public function getIssueCategoryRelations($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collIssueCategoryRelationsPartial && !$this->isNew();
        if (null === $this->collIssueCategoryRelations || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collIssueCategoryRelations) {
                // return empty collection
                $this->initIssueCategoryRelations();
            } else {
                $collIssueCategoryRelations = IssueCategoryRelationQuery::create(null, $criteria)
                    ->filterByIssue($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collIssueCategoryRelationsPartial && count($collIssueCategoryRelations)) {
                      $this->initIssueCategoryRelations(false);

                      foreach($collIssueCategoryRelations as $obj) {
                        if (false == $this->collIssueCategoryRelations->contains($obj)) {
                          $this->collIssueCategoryRelations->append($obj);
                        }
                      }

                      $this->collIssueCategoryRelationsPartial = true;
                    }

                    return $collIssueCategoryRelations;
                }

                if($partial && $this->collIssueCategoryRelations) {
                    foreach($this->collIssueCategoryRelations as $obj) {
                        if($obj->isNew()) {
                            $collIssueCategoryRelations[] = $obj;
                        }
                    }
                }

                $this->collIssueCategoryRelations = $collIssueCategoryRelations;
                $this->collIssueCategoryRelationsPartial = false;
            }
        }

        return $this->collIssueCategoryRelations;
    }

    /**
     * Sets a collection of IssueCategoryRelation objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $issueCategoryRelations A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIssueCategoryRelations(PropelCollection $issueCategoryRelations, PropelPDO $con = null)
    {
        $this->issueCategoryRelationsScheduledForDeletion = $this->getIssueCategoryRelations(new Criteria(), $con)->diff($issueCategoryRelations);

        foreach ($this->issueCategoryRelationsScheduledForDeletion as $issueCategoryRelationRemoved) {
            $issueCategoryRelationRemoved->setIssue(null);
        }

        $this->collIssueCategoryRelations = null;
        foreach ($issueCategoryRelations as $issueCategoryRelation) {
            $this->addIssueCategoryRelation($issueCategoryRelation);
        }

        $this->collIssueCategoryRelations = $issueCategoryRelations;
        $this->collIssueCategoryRelationsPartial = false;
    }

    /**
     * Returns the number of related IssueCategoryRelation objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related IssueCategoryRelation objects.
     * @throws PropelException
     */
    public function countIssueCategoryRelations(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collIssueCategoryRelationsPartial && !$this->isNew();
        if (null === $this->collIssueCategoryRelations || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collIssueCategoryRelations) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getIssueCategoryRelations());
                }
                $query = IssueCategoryRelationQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIssue($this)
                    ->count($con);
            }
        } else {
            return count($this->collIssueCategoryRelations);
        }
    }

    /**
     * Method called to associate a IssueCategoryRelation object to this object
     * through the IssueCategoryRelation foreign key attribute.
     *
     * @param    IssueCategoryRelation $l IssueCategoryRelation
     * @return Issue The current object (for fluent API support)
     */
    public function addIssueCategoryRelation(IssueCategoryRelation $l)
    {
        if ($this->collIssueCategoryRelations === null) {
            $this->initIssueCategoryRelations();
            $this->collIssueCategoryRelationsPartial = true;
        }
        if (!$this->collIssueCategoryRelations->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddIssueCategoryRelation($l);
        }

        return $this;
    }

    /**
     * @param	IssueCategoryRelation $issueCategoryRelation The issueCategoryRelation object to add.
     */
    protected function doAddIssueCategoryRelation($issueCategoryRelation)
    {
        $this->collIssueCategoryRelations[]= $issueCategoryRelation;
        $issueCategoryRelation->setIssue($this);
    }

    /**
     * @param	IssueCategoryRelation $issueCategoryRelation The issueCategoryRelation object to remove.
     */
    public function removeIssueCategoryRelation($issueCategoryRelation)
    {
        if ($this->getIssueCategoryRelations()->contains($issueCategoryRelation)) {
            $this->collIssueCategoryRelations->remove($this->collIssueCategoryRelations->search($issueCategoryRelation));
            if (null === $this->issueCategoryRelationsScheduledForDeletion) {
                $this->issueCategoryRelationsScheduledForDeletion = clone $this->collIssueCategoryRelations;
                $this->issueCategoryRelationsScheduledForDeletion->clear();
            }
            $this->issueCategoryRelationsScheduledForDeletion[]= $issueCategoryRelation;
            $issueCategoryRelation->setIssue(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Issue is new, it will return
     * an empty collection; or if this Issue has previously
     * been saved, it will retrieve related IssueCategoryRelations from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Issue.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|IssueCategoryRelation[] List of IssueCategoryRelation objects
     */
    public function getIssueCategoryRelationsJoinIssueCategory($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = IssueCategoryRelationQuery::create(null, $criteria);
        $query->joinWith('IssueCategory', $join_behavior);

        return $this->getIssueCategoryRelations($query, $con);
    }

    /**
     * Clears out the collIssueActors collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIssueActors()
     */
    public function clearIssueActors()
    {
        $this->collIssueActors = null; // important to set this to null since that means it is uninitialized
        $this->collIssueActorsPartial = null;
    }

    /**
     * reset is the collIssueActors collection loaded partially
     *
     * @return void
     */
    public function resetPartialIssueActors($v = true)
    {
        $this->collIssueActorsPartial = $v;
    }

    /**
     * Initializes the collIssueActors collection.
     *
     * By default this just sets the collIssueActors collection to an empty array (like clearcollIssueActors());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initIssueActors($overrideExisting = true)
    {
        if (null !== $this->collIssueActors && !$overrideExisting) {
            return;
        }
        $this->collIssueActors = new PropelObjectCollection();
        $this->collIssueActors->setModel('IssueActor');
    }

    /**
     * Gets an array of IssueActor objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Issue is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|IssueActor[] List of IssueActor objects
     * @throws PropelException
     */
    public function getIssueActors($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collIssueActorsPartial && !$this->isNew();
        if (null === $this->collIssueActors || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collIssueActors) {
                // return empty collection
                $this->initIssueActors();
            } else {
                $collIssueActors = IssueActorQuery::create(null, $criteria)
                    ->filterByIssue($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collIssueActorsPartial && count($collIssueActors)) {
                      $this->initIssueActors(false);

                      foreach($collIssueActors as $obj) {
                        if (false == $this->collIssueActors->contains($obj)) {
                          $this->collIssueActors->append($obj);
                        }
                      }

                      $this->collIssueActorsPartial = true;
                    }

                    return $collIssueActors;
                }

                if($partial && $this->collIssueActors) {
                    foreach($this->collIssueActors as $obj) {
                        if($obj->isNew()) {
                            $collIssueActors[] = $obj;
                        }
                    }
                }

                $this->collIssueActors = $collIssueActors;
                $this->collIssueActorsPartial = false;
            }
        }

        return $this->collIssueActors;
    }

    /**
     * Sets a collection of IssueActor objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $issueActors A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIssueActors(PropelCollection $issueActors, PropelPDO $con = null)
    {
        $this->issueActorsScheduledForDeletion = $this->getIssueActors(new Criteria(), $con)->diff($issueActors);

        foreach ($this->issueActorsScheduledForDeletion as $issueActorRemoved) {
            $issueActorRemoved->setIssue(null);
        }

        $this->collIssueActors = null;
        foreach ($issueActors as $issueActor) {
            $this->addIssueActor($issueActor);
        }

        $this->collIssueActors = $issueActors;
        $this->collIssueActorsPartial = false;
    }

    /**
     * Returns the number of related IssueActor objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related IssueActor objects.
     * @throws PropelException
     */
    public function countIssueActors(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collIssueActorsPartial && !$this->isNew();
        if (null === $this->collIssueActors || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collIssueActors) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getIssueActors());
                }
                $query = IssueActorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIssue($this)
                    ->count($con);
            }
        } else {
            return count($this->collIssueActors);
        }
    }

    /**
     * Method called to associate a IssueActor object to this object
     * through the IssueActor foreign key attribute.
     *
     * @param    IssueActor $l IssueActor
     * @return Issue The current object (for fluent API support)
     */
    public function addIssueActor(IssueActor $l)
    {
        if ($this->collIssueActors === null) {
            $this->initIssueActors();
            $this->collIssueActorsPartial = true;
        }
        if (!$this->collIssueActors->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddIssueActor($l);
        }

        return $this;
    }

    /**
     * @param	IssueActor $issueActor The issueActor object to add.
     */
    protected function doAddIssueActor($issueActor)
    {
        $this->collIssueActors[]= $issueActor;
        $issueActor->setIssue($this);
    }

    /**
     * @param	IssueActor $issueActor The issueActor object to remove.
     */
    public function removeIssueActor($issueActor)
    {
        if ($this->getIssueActors()->contains($issueActor)) {
            $this->collIssueActors->remove($this->collIssueActors->search($issueActor));
            if (null === $this->issueActorsScheduledForDeletion) {
                $this->issueActorsScheduledForDeletion = clone $this->collIssueActors;
                $this->issueActorsScheduledForDeletion->clear();
            }
            $this->issueActorsScheduledForDeletion[]= $issueActor;
            $issueActor->setIssue(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Issue is new, it will return
     * an empty collection; or if this Issue has previously
     * been saved, it will retrieve related IssueActors from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Issue.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|IssueActor[] List of IssueActor objects
     */
    public function getIssueActorsJoinActor($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = IssueActorQuery::create(null, $criteria);
        $query->joinWith('Actor', $join_behavior);

        return $this->getIssueActors($query, $con);
    }

    /**
     * Clears out the collIssueVersions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIssueVersions()
     */
    public function clearIssueVersions()
    {
        $this->collIssueVersions = null; // important to set this to null since that means it is uninitialized
        $this->collIssueVersionsPartial = null;
    }

    /**
     * reset is the collIssueVersions collection loaded partially
     *
     * @return void
     */
    public function resetPartialIssueVersions($v = true)
    {
        $this->collIssueVersionsPartial = $v;
    }

    /**
     * Initializes the collIssueVersions collection.
     *
     * By default this just sets the collIssueVersions collection to an empty array (like clearcollIssueVersions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initIssueVersions($overrideExisting = true)
    {
        if (null !== $this->collIssueVersions && !$overrideExisting) {
            return;
        }
        $this->collIssueVersions = new PropelObjectCollection();
        $this->collIssueVersions->setModel('IssueVersion');
    }

    /**
     * Gets an array of IssueVersion objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Issue is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|IssueVersion[] List of IssueVersion objects
     * @throws PropelException
     */
    public function getIssueVersions($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collIssueVersionsPartial && !$this->isNew();
        if (null === $this->collIssueVersions || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collIssueVersions) {
                // return empty collection
                $this->initIssueVersions();
            } else {
                $collIssueVersions = IssueVersionQuery::create(null, $criteria)
                    ->filterByIssue($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collIssueVersionsPartial && count($collIssueVersions)) {
                      $this->initIssueVersions(false);

                      foreach($collIssueVersions as $obj) {
                        if (false == $this->collIssueVersions->contains($obj)) {
                          $this->collIssueVersions->append($obj);
                        }
                      }

                      $this->collIssueVersionsPartial = true;
                    }

                    return $collIssueVersions;
                }

                if($partial && $this->collIssueVersions) {
                    foreach($this->collIssueVersions as $obj) {
                        if($obj->isNew()) {
                            $collIssueVersions[] = $obj;
                        }
                    }
                }

                $this->collIssueVersions = $collIssueVersions;
                $this->collIssueVersionsPartial = false;
            }
        }

        return $this->collIssueVersions;
    }

    /**
     * Sets a collection of IssueVersion objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $issueVersions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIssueVersions(PropelCollection $issueVersions, PropelPDO $con = null)
    {
        $this->issueVersionsScheduledForDeletion = $this->getIssueVersions(new Criteria(), $con)->diff($issueVersions);

        foreach ($this->issueVersionsScheduledForDeletion as $issueVersionRemoved) {
            $issueVersionRemoved->setIssue(null);
        }

        $this->collIssueVersions = null;
        foreach ($issueVersions as $issueVersion) {
            $this->addIssueVersion($issueVersion);
        }

        $this->collIssueVersions = $issueVersions;
        $this->collIssueVersionsPartial = false;
    }

    /**
     * Returns the number of related IssueVersion objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related IssueVersion objects.
     * @throws PropelException
     */
    public function countIssueVersions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collIssueVersionsPartial && !$this->isNew();
        if (null === $this->collIssueVersions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collIssueVersions) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getIssueVersions());
                }
                $query = IssueVersionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIssue($this)
                    ->count($con);
            }
        } else {
            return count($this->collIssueVersions);
        }
    }

    /**
     * Method called to associate a IssueVersion object to this object
     * through the IssueVersion foreign key attribute.
     *
     * @param    IssueVersion $l IssueVersion
     * @return Issue The current object (for fluent API support)
     */
    public function addIssueVersion(IssueVersion $l)
    {
        if ($this->collIssueVersions === null) {
            $this->initIssueVersions();
            $this->collIssueVersionsPartial = true;
        }
        if (!$this->collIssueVersions->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddIssueVersion($l);
        }

        return $this;
    }

    /**
     * @param	IssueVersion $issueVersion The issueVersion object to add.
     */
    protected function doAddIssueVersion($issueVersion)
    {
        $this->collIssueVersions[]= $issueVersion;
        $issueVersion->setIssue($this);
    }

    /**
     * @param	IssueVersion $issueVersion The issueVersion object to remove.
     */
    public function removeIssueVersion($issueVersion)
    {
        if ($this->getIssueVersions()->contains($issueVersion)) {
            $this->collIssueVersions->remove($this->collIssueVersions->search($issueVersion));
            if (null === $this->issueVersionsScheduledForDeletion) {
                $this->issueVersionsScheduledForDeletion = clone $this->collIssueVersions;
                $this->issueVersionsScheduledForDeletion->clear();
            }
            $this->issueVersionsScheduledForDeletion[]= $issueVersion;
            $issueVersion->setIssue(null);
        }
    }

    /**
     * Clears out the collHeadlines collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addHeadlines()
     */
    public function clearHeadlines()
    {
        $this->collHeadlines = null; // important to set this to null since that means it is uninitialized
        $this->collHeadlinesPartial = null;
    }

    /**
     * Initializes the collHeadlines collection.
     *
     * By default this just sets the collHeadlines collection to an empty collection (like clearHeadlines());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initHeadlines()
    {
        $this->collHeadlines = new PropelObjectCollection();
        $this->collHeadlines->setModel('Headline');
    }

    /**
     * Gets a collection of Headline objects related by a many-to-many relationship
     * to the current object by way of the headlines_issue cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Issue is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Headline[] List of Headline objects
     */
    public function getHeadlines($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collHeadlines || null !== $criteria) {
            if ($this->isNew() && null === $this->collHeadlines) {
                // return empty collection
                $this->initHeadlines();
            } else {
                $collHeadlines = HeadlineQuery::create(null, $criteria)
                    ->filterByIssue($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collHeadlines;
                }
                $this->collHeadlines = $collHeadlines;
            }
        }

        return $this->collHeadlines;
    }

    /**
     * Sets a collection of Headline objects related by a many-to-many relationship
     * to the current object by way of the headlines_issue cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $headlines A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setHeadlines(PropelCollection $headlines, PropelPDO $con = null)
    {
        $this->clearHeadlines();
        $currentHeadlines = $this->getHeadlines();

        $this->headlinesScheduledForDeletion = $currentHeadlines->diff($headlines);

        foreach ($headlines as $headline) {
            if (!$currentHeadlines->contains($headline)) {
                $this->doAddHeadline($headline);
            }
        }

        $this->collHeadlines = $headlines;
    }

    /**
     * Gets the number of Headline objects related by a many-to-many relationship
     * to the current object by way of the headlines_issue cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Headline objects
     */
    public function countHeadlines($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collHeadlines || null !== $criteria) {
            if ($this->isNew() && null === $this->collHeadlines) {
                return 0;
            } else {
                $query = HeadlineQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIssue($this)
                    ->count($con);
            }
        } else {
            return count($this->collHeadlines);
        }
    }

    /**
     * Associate a Headline object to this object
     * through the headlines_issue cross reference table.
     *
     * @param  Headline $headline The HeadlineIssue object to relate
     * @return void
     */
    public function addHeadline(Headline $headline)
    {
        if ($this->collHeadlines === null) {
            $this->initHeadlines();
        }
        if (!$this->collHeadlines->contains($headline)) { // only add it if the **same** object is not already associated
            $this->doAddHeadline($headline);

            $this->collHeadlines[]= $headline;
        }
    }

    /**
     * @param	Headline $headline The headline object to add.
     */
    protected function doAddHeadline($headline)
    {
        $headlineIssue = new HeadlineIssue();
        $headlineIssue->setHeadline($headline);
        $this->addHeadlineIssue($headlineIssue);
    }

    /**
     * Remove a Headline object to this object
     * through the headlines_issue cross reference table.
     *
     * @param Headline $headline The HeadlineIssue object to relate
     * @return void
     */
    public function removeHeadline(Headline $headline)
    {
        if ($this->getHeadlines()->contains($headline)) {
            $this->collHeadlines->remove($this->collHeadlines->search($headline));
            if (null === $this->headlinesScheduledForDeletion) {
                $this->headlinesScheduledForDeletion = clone $this->collHeadlines;
                $this->headlinesScheduledForDeletion->clear();
            }
            $this->headlinesScheduledForDeletion[]= $headline;
        }
    }

    /**
     * Clears out the collIssueCategorys collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIssueCategorys()
     */
    public function clearIssueCategorys()
    {
        $this->collIssueCategorys = null; // important to set this to null since that means it is uninitialized
        $this->collIssueCategorysPartial = null;
    }

    /**
     * Initializes the collIssueCategorys collection.
     *
     * By default this just sets the collIssueCategorys collection to an empty collection (like clearIssueCategorys());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initIssueCategorys()
    {
        $this->collIssueCategorys = new PropelObjectCollection();
        $this->collIssueCategorys->setModel('IssueCategory');
    }

    /**
     * Gets a collection of IssueCategory objects related by a many-to-many relationship
     * to the current object by way of the issues_issuesCategory cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Issue is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|IssueCategory[] List of IssueCategory objects
     */
    public function getIssueCategorys($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collIssueCategorys || null !== $criteria) {
            if ($this->isNew() && null === $this->collIssueCategorys) {
                // return empty collection
                $this->initIssueCategorys();
            } else {
                $collIssueCategorys = IssueCategoryQuery::create(null, $criteria)
                    ->filterByIssue($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collIssueCategorys;
                }
                $this->collIssueCategorys = $collIssueCategorys;
            }
        }

        return $this->collIssueCategorys;
    }

    /**
     * Sets a collection of IssueCategory objects related by a many-to-many relationship
     * to the current object by way of the issues_issuesCategory cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $issueCategorys A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIssueCategorys(PropelCollection $issueCategorys, PropelPDO $con = null)
    {
        $this->clearIssueCategorys();
        $currentIssueCategorys = $this->getIssueCategorys();

        $this->issueCategorysScheduledForDeletion = $currentIssueCategorys->diff($issueCategorys);

        foreach ($issueCategorys as $issueCategory) {
            if (!$currentIssueCategorys->contains($issueCategory)) {
                $this->doAddIssueCategory($issueCategory);
            }
        }

        $this->collIssueCategorys = $issueCategorys;
    }

    /**
     * Gets the number of IssueCategory objects related by a many-to-many relationship
     * to the current object by way of the issues_issuesCategory cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related IssueCategory objects
     */
    public function countIssueCategorys($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collIssueCategorys || null !== $criteria) {
            if ($this->isNew() && null === $this->collIssueCategorys) {
                return 0;
            } else {
                $query = IssueCategoryQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIssue($this)
                    ->count($con);
            }
        } else {
            return count($this->collIssueCategorys);
        }
    }

    /**
     * Associate a IssueCategory object to this object
     * through the issues_issuesCategory cross reference table.
     *
     * @param  IssueCategory $issueCategory The IssueCategoryRelation object to relate
     * @return void
     */
    public function addIssueCategory(IssueCategory $issueCategory)
    {
        if ($this->collIssueCategorys === null) {
            $this->initIssueCategorys();
        }
        if (!$this->collIssueCategorys->contains($issueCategory)) { // only add it if the **same** object is not already associated
            $this->doAddIssueCategory($issueCategory);

            $this->collIssueCategorys[]= $issueCategory;
        }
    }

    /**
     * @param	IssueCategory $issueCategory The issueCategory object to add.
     */
    protected function doAddIssueCategory($issueCategory)
    {
        $issueCategoryRelation = new IssueCategoryRelation();
        $issueCategoryRelation->setIssueCategory($issueCategory);
        $this->addIssueCategoryRelation($issueCategoryRelation);
    }

    /**
     * Remove a IssueCategory object to this object
     * through the issues_issuesCategory cross reference table.
     *
     * @param IssueCategory $issueCategory The IssueCategoryRelation object to relate
     * @return void
     */
    public function removeIssueCategory(IssueCategory $issueCategory)
    {
        if ($this->getIssueCategorys()->contains($issueCategory)) {
            $this->collIssueCategorys->remove($this->collIssueCategorys->search($issueCategory));
            if (null === $this->issueCategorysScheduledForDeletion) {
                $this->issueCategorysScheduledForDeletion = clone $this->collIssueCategorys;
                $this->issueCategorysScheduledForDeletion->clear();
            }
            $this->issueCategorysScheduledForDeletion[]= $issueCategory;
        }
    }

    /**
     * Clears out the collActors collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addActors()
     */
    public function clearActors()
    {
        $this->collActors = null; // important to set this to null since that means it is uninitialized
        $this->collActorsPartial = null;
    }

    /**
     * Initializes the collActors collection.
     *
     * By default this just sets the collActors collection to an empty collection (like clearActors());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initActors()
    {
        $this->collActors = new PropelObjectCollection();
        $this->collActors->setModel('Actor');
    }

    /**
     * Gets a collection of Actor objects related by a many-to-many relationship
     * to the current object by way of the issues_actors cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Issue is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Actor[] List of Actor objects
     */
    public function getActors($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collActors || null !== $criteria) {
            if ($this->isNew() && null === $this->collActors) {
                // return empty collection
                $this->initActors();
            } else {
                $collActors = ActorQuery::create(null, $criteria)
                    ->filterByIssue($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collActors;
                }
                $this->collActors = $collActors;
            }
        }

        return $this->collActors;
    }

    /**
     * Sets a collection of Actor objects related by a many-to-many relationship
     * to the current object by way of the issues_actors cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $actors A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setActors(PropelCollection $actors, PropelPDO $con = null)
    {
        $this->clearActors();
        $currentActors = $this->getActors();

        $this->actorsScheduledForDeletion = $currentActors->diff($actors);

        foreach ($actors as $actor) {
            if (!$currentActors->contains($actor)) {
                $this->doAddActor($actor);
            }
        }

        $this->collActors = $actors;
    }

    /**
     * Gets the number of Actor objects related by a many-to-many relationship
     * to the current object by way of the issues_actors cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Actor objects
     */
    public function countActors($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collActors || null !== $criteria) {
            if ($this->isNew() && null === $this->collActors) {
                return 0;
            } else {
                $query = ActorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIssue($this)
                    ->count($con);
            }
        } else {
            return count($this->collActors);
        }
    }

    /**
     * Associate a Actor object to this object
     * through the issues_actors cross reference table.
     *
     * @param  Actor $actor The IssueActor object to relate
     * @return void
     */
    public function addActor(Actor $actor)
    {
        if ($this->collActors === null) {
            $this->initActors();
        }
        if (!$this->collActors->contains($actor)) { // only add it if the **same** object is not already associated
            $this->doAddActor($actor);

            $this->collActors[]= $actor;
        }
    }

    /**
     * @param	Actor $actor The actor object to add.
     */
    protected function doAddActor($actor)
    {
        $issueActor = new IssueActor();
        $issueActor->setActor($actor);
        $this->addIssueActor($issueActor);
    }

    /**
     * Remove a Actor object to this object
     * through the issues_actors cross reference table.
     *
     * @param Actor $actor The IssueActor object to relate
     * @return void
     */
    public function removeActor(Actor $actor)
    {
        if ($this->getActors()->contains($actor)) {
            $this->collActors->remove($this->collActors->search($actor));
            if (null === $this->actorsScheduledForDeletion) {
                $this->actorsScheduledForDeletion = clone $this->collActors;
                $this->actorsScheduledForDeletion->clear();
            }
            $this->actorsScheduledForDeletion[]= $actor;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->parentid = null;
        $this->description = null;
        $this->impact = null;
        $this->valoration = null;
        $this->evolution = null;
        $this->objecttype = null;
        $this->objectid = null;
        $this->created_at = null;
        $this->updated_at = null;
        $this->deleted_at = null;
        $this->version = null;
        $this->version_created_by = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collHeadlineIssues) {
                foreach ($this->collHeadlineIssues as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collIssueCategoryRelations) {
                foreach ($this->collIssueCategoryRelations as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collIssueActors) {
                foreach ($this->collIssueActors as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collIssueVersions) {
                foreach ($this->collIssueVersions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collHeadlines) {
                foreach ($this->collHeadlines as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collIssueCategorys) {
                foreach ($this->collIssueCategorys as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collActors) {
                foreach ($this->collActors as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collHeadlineIssues instanceof PropelCollection) {
            $this->collHeadlineIssues->clearIterator();
        }
        $this->collHeadlineIssues = null;
        if ($this->collIssueCategoryRelations instanceof PropelCollection) {
            $this->collIssueCategoryRelations->clearIterator();
        }
        $this->collIssueCategoryRelations = null;
        if ($this->collIssueActors instanceof PropelCollection) {
            $this->collIssueActors->clearIterator();
        }
        $this->collIssueActors = null;
        if ($this->collIssueVersions instanceof PropelCollection) {
            $this->collIssueVersions->clearIterator();
        }
        $this->collIssueVersions = null;
        if ($this->collHeadlines instanceof PropelCollection) {
            $this->collHeadlines->clearIterator();
        }
        $this->collHeadlines = null;
        if ($this->collIssueCategorys instanceof PropelCollection) {
            $this->collIssueCategorys->clearIterator();
        }
        $this->collIssueCategorys = null;
        if ($this->collActors instanceof PropelCollection) {
            $this->collActors->clearIterator();
        }
        $this->collActors = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // versionable behavior

    /**
     * Enforce a new Version of this object upon next save.
     *
     * @return Issue
     */
    public function enforceVersioning()
    {
        $this->enforceVersion = true;

        return $this;
    }

    /**
     * Checks whether the current state must be recorded as a version
     *
     * @param PropelPDO $con An optional PropelPDO connection to use.
     *
     * @return  boolean
     */
    public function isVersioningNecessary($con = null)
    {
        if ($this->alreadyInSave) {
            return false;
        }

        if ($this->enforceVersion) {
            return true;
        }

        if (IssuePeer::isVersioningEnabled() && ($this->isNew() || $this->isModified() || $this->isDeleted())) {
            return true;
        }

        return false;
    }

    /**
     * Creates a version of the current object and saves it.
     *
     * @param   PropelPDO $con the connection to use
     *
     * @return  IssueVersion A version object
     */
    public function addVersion($con = null)
    {
        $this->enforceVersion = false;

        $version = new IssueVersion();
        $version->setId($this->getId());
        $version->setName($this->getName());
        $version->setParentid($this->getParentid());
        $version->setDescription($this->getDescription());
        $version->setImpact($this->getImpact());
        $version->setValoration($this->getValoration());
        $version->setEvolution($this->getEvolution());
        $version->setObjecttype($this->getObjecttype());
        $version->setObjectid($this->getObjectid());
        $version->setCreatedAt($this->getCreatedAt());
        $version->setUpdatedAt($this->getUpdatedAt());
        $version->setDeletedAt($this->getDeletedAt());
        $version->setVersion($this->getVersion());
        $version->setVersionCreatedBy($this->getVersionCreatedBy());
        $version->setIssue($this);
        $version->save($con);

        return $version;
    }

    /**
     * Sets the properties of the curent object to the value they had at a specific version
     *
     * @param   integer $versionNumber The version number to read
     * @param   PropelPDO $con the connection to use
     *
     * @return  Issue The current object (for fluent API support)
     * @throws  PropelException - if no object with the given version can be found.
     */
    public function toVersion($versionNumber, $con = null)
    {
        $version = $this->getOneVersion($versionNumber, $con);
        if (!$version) {
            throw new PropelException(sprintf('No Issue object found with version %d', $version));
        }
        $this->populateFromVersion($version, $con);

        return $this;
    }

    /**
     * Sets the properties of the curent object to the value they had at a specific version
     *
     * @param   IssueVersion $version The version object to use
     * @param   PropelPDO $con the connection to use
     * @param   array $loadedObjects objects thats been loaded in a chain of populateFromVersion calls on referrer or fk objects.
     *
     * @return  Issue The current object (for fluent API support)
     */
    public function populateFromVersion($version, $con = null, &$loadedObjects = array())
    {

        $loadedObjects['Issue'][$version->getId()][$version->getVersion()] = $this;
        $this->setId($version->getId());
        $this->setName($version->getName());
        $this->setParentid($version->getParentid());
        $this->setDescription($version->getDescription());
        $this->setImpact($version->getImpact());
        $this->setValoration($version->getValoration());
        $this->setEvolution($version->getEvolution());
        $this->setObjecttype($version->getObjecttype());
        $this->setObjectid($version->getObjectid());
        $this->setCreatedAt($version->getCreatedAt());
        $this->setUpdatedAt($version->getUpdatedAt());
        $this->setDeletedAt($version->getDeletedAt());
        $this->setVersion($version->getVersion());
        $this->setVersionCreatedBy($version->getVersionCreatedBy());

        return $this;
    }

    /**
     * Gets the latest persisted version number for the current object
     *
     * @param   PropelPDO $con the connection to use
     *
     * @return  integer
     */
    public function getLastVersionNumber($con = null)
    {
        $v = IssueVersionQuery::create()
            ->filterByIssue($this)
            ->orderByVersion('desc')
            ->findOne($con);
        if (!$v) {
            return 0;
        }

        return $v->getVersion();
    }

    /**
     * Checks whether the current object is the latest one
     *
     * @param   PropelPDO $con the connection to use
     *
     * @return  boolean
     */
    public function isLastVersion($con = null)
    {
        return $this->getLastVersionNumber($con) == $this->getVersion();
    }

    /**
     * Retrieves a version object for this entity and a version number
     *
     * @param   integer $versionNumber The version number to read
     * @param   PropelPDO $con the connection to use
     *
     * @return  IssueVersion A version object
     */
    public function getOneVersion($versionNumber, $con = null)
    {
        return IssueVersionQuery::create()
            ->filterByIssue($this)
            ->filterByVersion($versionNumber)
            ->findOne($con);
    }

    /**
     * Gets all the versions of this object, in incremental order
     *
     * @param   PropelPDO $con the connection to use
     *
     * @return  PropelObjectCollection A list of IssueVersion objects
     */
    public function getAllVersions($con = null)
    {
        $criteria = new Criteria();
        $criteria->addAscendingOrderByColumn(IssueVersionPeer::VERSION);

        return $this->getIssueVersions($criteria, $con);
    }

    /**
     * Compares the current object with another of its version.
     * <code>
     * print_r($book->compareVersion(1));
     * => array(
     *   '1' => array('Title' => 'Book title at version 1'),
     *   '2' => array('Title' => 'Book title at version 2')
     * );
     * </code>
     *
     * @param   integer   $versionNumber
     * @param   string    $keys Main key used for the result diff (versions|columns)
     * @param   PropelPDO $con the connection to use
     * @param   array     $ignoredColumns  The columns to exclude from the diff.
     *
     * @return  array A list of differences
     */
    public function compareVersion($versionNumber, $keys = 'columns', $con = null, $ignoredColumns = array())
    {
        $fromVersion = $this->toArray();
        $toVersion = $this->getOneVersion($versionNumber, $con)->toArray();

        return $this->computeDiff($fromVersion, $toVersion, $keys, $ignoredColumns);
    }

    /**
     * Compares two versions of the current object.
     * <code>
     * print_r($book->compareVersions(1, 2));
     * => array(
     *   '1' => array('Title' => 'Book title at version 1'),
     *   '2' => array('Title' => 'Book title at version 2')
     * );
     * </code>
     *
     * @param   integer   $fromVersionNumber
     * @param   integer   $toVersionNumber
     * @param   string    $keys Main key used for the result diff (versions|columns)
     * @param   PropelPDO $con the connection to use
     * @param   array     $ignoredColumns  The columns to exclude from the diff.
     *
     * @return  array A list of differences
     */
    public function compareVersions($fromVersionNumber, $toVersionNumber, $keys = 'columns', $con = null, $ignoredColumns = array())
    {
        $fromVersion = $this->getOneVersion($fromVersionNumber, $con)->toArray();
        $toVersion = $this->getOneVersion($toVersionNumber, $con)->toArray();

        return $this->computeDiff($fromVersion, $toVersion, $keys, $ignoredColumns);
    }

    /**
     * Computes the diff between two versions.
     * <code>
     * print_r($this->computeDiff(1, 2));
     * => array(
     *   '1' => array('Title' => 'Book title at version 1'),
     *   '2' => array('Title' => 'Book title at version 2')
     * );
     * </code>
     *
     * @param   array     $fromVersion     An array representing the original version.
     * @param   array     $toVersion       An array representing the destination version.
     * @param   string    $keys            Main key used for the result diff (versions|columns).
     * @param   array     $ignoredColumns  The columns to exclude from the diff.
     *
     * @return  array A list of differences
     */
    protected function computeDiff($fromVersion, $toVersion, $keys = 'columns', $ignoredColumns = array())
    {
        $fromVersionNumber = $fromVersion['Version'];
        $toVersionNumber = $toVersion['Version'];
        $ignoredColumns = array_merge(array(
            'Version',
            'VersionCreatedBy',
        ), $ignoredColumns);
        $diff = array();
        foreach ($fromVersion as $key => $value) {
            if (in_array($key, $ignoredColumns)) {
                continue;
            }
            if ($toVersion[$key] != $value) {
                switch ($keys) {
                    case 'versions':
                        $diff[$fromVersionNumber][$key] = $value;
                        $diff[$toVersionNumber][$key] = $toVersion[$key];
                        break;
                    default:
                        $diff[$key] = array(
                            $fromVersionNumber => $value,
                            $toVersionNumber => $toVersion[$key],
                        );
                        break;
                }
            }
        }

        return $diff;
    }
    /**
     * retrieve the last $number versions.
     *
     * @param integer $number the number of record to return.
     * @param IssueVersionQuery|Criteria $criteria Additional criteria to filter.
     * @param PropelPDO $con An optional connection to use.
     *
     * @return PropelCollection|IssueVersion[] List of IssueVersion objects
     */
    public function getLastVersions($number = 10, $criteria = null, PropelPDO $con = null)
    {
        $criteria = IssueVersionQuery::create(null, $criteria);
        $criteria->addDescendingOrderByColumn(IssueVersionPeer::VERSION);
        $criteria->limit($number);

        return $this->getIssueVersions($criteria, $con);
    }
    // timestampable behavior

    /**
     * Mark the current object so that the update date doesn't get updated during next save
     *
     * @return     Issue The current object (for fluent API support)
     */
    public function keepUpdateDateUnchanged()
    {
        $this->modifiedColumns[] = IssuePeer::UPDATED_AT;

        return $this;
    }

    // soft_delete behavior

    /**
     * Bypass the soft_delete behavior and force a hard delete of the current object
     */
    public function forceDelete(PropelPDO $con = null)
    {
        if ($isSoftDeleteEnabled = IssuePeer::isSoftDeleteEnabled()) {
            IssuePeer::disableSoftDelete();
        }
        $this->delete($con);
        if ($isSoftDeleteEnabled) {
            IssuePeer::enableSoftDelete();
        }
    }

    /**
     * Undelete a row that was soft_deleted
     *
     * @return		 int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        $this->setDeletedAt(null);

        return $this->save($con);
    }

}
