<?php


/**
 * Base class that represents a query for the 'indicators_value' table.
 *
 * Indicators values
 *
 * @method IndicatorValueQuery orderById($order = Criteria::ASC) Order by the id column
 * @method IndicatorValueQuery orderByValue($order = Criteria::ASC) Order by the value column
 * @method IndicatorValueQuery orderByDate($order = Criteria::ASC) Order by the date column
 * @method IndicatorValueQuery orderByClasskey($order = Criteria::ASC) Order by the classKey column
 * @method IndicatorValueQuery orderByNumericindicatorid($order = Criteria::ASC) Order by the numericIndicatorId column
 *
 * @method IndicatorValueQuery groupById() Group by the id column
 * @method IndicatorValueQuery groupByValue() Group by the value column
 * @method IndicatorValueQuery groupByDate() Group by the date column
 * @method IndicatorValueQuery groupByClasskey() Group by the classKey column
 * @method IndicatorValueQuery groupByNumericindicatorid() Group by the numericIndicatorId column
 *
 * @method IndicatorValueQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method IndicatorValueQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method IndicatorValueQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method IndicatorValueQuery leftJoinIndicator($relationAlias = null) Adds a LEFT JOIN clause to the query using the Indicator relation
 * @method IndicatorValueQuery rightJoinIndicator($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Indicator relation
 * @method IndicatorValueQuery innerJoinIndicator($relationAlias = null) Adds a INNER JOIN clause to the query using the Indicator relation
 *
 * @method IndicatorValue findOne(PropelPDO $con = null) Return the first IndicatorValue matching the query
 * @method IndicatorValue findOneOrCreate(PropelPDO $con = null) Return the first IndicatorValue matching the query, or a new IndicatorValue object populated from the query conditions when no match is found
 *
 * @method IndicatorValue findOneById(int $id) Return the first IndicatorValue filtered by the id column
 * @method IndicatorValue findOneByValue(double $value) Return the first IndicatorValue filtered by the value column
 * @method IndicatorValue findOneByDate(string $date) Return the first IndicatorValue filtered by the date column
 * @method IndicatorValue findOneByClasskey(int $classKey) Return the first IndicatorValue filtered by the classKey column
 * @method IndicatorValue findOneByNumericindicatorid(int $numericIndicatorId) Return the first IndicatorValue filtered by the numericIndicatorId column
 *
 * @method array findById(int $id) Return IndicatorValue objects filtered by the id column
 * @method array findByValue(double $value) Return IndicatorValue objects filtered by the value column
 * @method array findByDate(string $date) Return IndicatorValue objects filtered by the date column
 * @method array findByClasskey(int $classKey) Return IndicatorValue objects filtered by the classKey column
 * @method array findByNumericindicatorid(int $numericIndicatorId) Return IndicatorValue objects filtered by the numericIndicatorId column
 *
 * @package    propel.generator.indicators.classes.om
 */
abstract class BaseIndicatorValueQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseIndicatorValueQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'IndicatorValue', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new IndicatorValueQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     IndicatorValueQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return IndicatorValueQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof IndicatorValueQuery) {
            return $criteria;
        }
        $query = new IndicatorValueQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   IndicatorValue|IndicatorValue[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = IndicatorValuePeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(IndicatorValuePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   IndicatorValue A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `VALUE`, `DATE`, `CLASSKEY`, `NUMERICINDICATORID` FROM `indicators_value` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $cls = IndicatorValuePeer::getOMClass($row, 0);
            $obj = new $cls();
            $obj->hydrate($row);
            IndicatorValuePeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return IndicatorValue|IndicatorValue[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|IndicatorValue[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return IndicatorValueQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(IndicatorValuePeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return IndicatorValueQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(IndicatorValuePeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorValueQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(IndicatorValuePeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the value column
     *
     * Example usage:
     * <code>
     * $query->filterByValue(1234); // WHERE value = 1234
     * $query->filterByValue(array(12, 34)); // WHERE value IN (12, 34)
     * $query->filterByValue(array('min' => 12)); // WHERE value > 12
     * </code>
     *
     * @param     mixed $value The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorValueQuery The current query, for fluid interface
     */
    public function filterByValue($value = null, $comparison = null)
    {
        if (is_array($value)) {
            $useMinMax = false;
            if (isset($value['min'])) {
                $this->addUsingAlias(IndicatorValuePeer::VALUE, $value['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($value['max'])) {
                $this->addUsingAlias(IndicatorValuePeer::VALUE, $value['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorValuePeer::VALUE, $value, $comparison);
    }

    /**
     * Filter the query on the date column
     *
     * Example usage:
     * <code>
     * $query->filterByDate('2011-03-14'); // WHERE date = '2011-03-14'
     * $query->filterByDate('now'); // WHERE date = '2011-03-14'
     * $query->filterByDate(array('max' => 'yesterday')); // WHERE date > '2011-03-13'
     * </code>
     *
     * @param     mixed $date The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorValueQuery The current query, for fluid interface
     */
    public function filterByDate($date = null, $comparison = null)
    {
        if (is_array($date)) {
            $useMinMax = false;
            if (isset($date['min'])) {
                $this->addUsingAlias(IndicatorValuePeer::DATE, $date['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($date['max'])) {
                $this->addUsingAlias(IndicatorValuePeer::DATE, $date['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorValuePeer::DATE, $date, $comparison);
    }

    /**
     * Filter the query on the classKey column
     *
     * Example usage:
     * <code>
     * $query->filterByClasskey(1234); // WHERE classKey = 1234
     * $query->filterByClasskey(array(12, 34)); // WHERE classKey IN (12, 34)
     * $query->filterByClasskey(array('min' => 12)); // WHERE classKey > 12
     * </code>
     *
     * @param     mixed $classkey The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorValueQuery The current query, for fluid interface
     */
    public function filterByClasskey($classkey = null, $comparison = null)
    {
        if (is_array($classkey)) {
            $useMinMax = false;
            if (isset($classkey['min'])) {
                $this->addUsingAlias(IndicatorValuePeer::CLASSKEY, $classkey['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($classkey['max'])) {
                $this->addUsingAlias(IndicatorValuePeer::CLASSKEY, $classkey['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorValuePeer::CLASSKEY, $classkey, $comparison);
    }

    /**
     * Filter the query on the numericIndicatorId column
     *
     * Example usage:
     * <code>
     * $query->filterByNumericindicatorid(1234); // WHERE numericIndicatorId = 1234
     * $query->filterByNumericindicatorid(array(12, 34)); // WHERE numericIndicatorId IN (12, 34)
     * $query->filterByNumericindicatorid(array('min' => 12)); // WHERE numericIndicatorId > 12
     * </code>
     *
     * @see       filterByIndicator()
     *
     * @param     mixed $numericindicatorid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorValueQuery The current query, for fluid interface
     */
    public function filterByNumericindicatorid($numericindicatorid = null, $comparison = null)
    {
        if (is_array($numericindicatorid)) {
            $useMinMax = false;
            if (isset($numericindicatorid['min'])) {
                $this->addUsingAlias(IndicatorValuePeer::NUMERICINDICATORID, $numericindicatorid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($numericindicatorid['max'])) {
                $this->addUsingAlias(IndicatorValuePeer::NUMERICINDICATORID, $numericindicatorid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorValuePeer::NUMERICINDICATORID, $numericindicatorid, $comparison);
    }

    /**
     * Filter the query by a related Indicator object
     *
     * @param   Indicator|PropelObjectCollection $indicator The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IndicatorValueQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIndicator($indicator, $comparison = null)
    {
        if ($indicator instanceof Indicator) {
            return $this
                ->addUsingAlias(IndicatorValuePeer::NUMERICINDICATORID, $indicator->getId(), $comparison);
        } elseif ($indicator instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(IndicatorValuePeer::NUMERICINDICATORID, $indicator->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByIndicator() only accepts arguments of type Indicator or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Indicator relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IndicatorValueQuery The current query, for fluid interface
     */
    public function joinIndicator($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Indicator');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Indicator');
        }

        return $this;
    }

    /**
     * Use the Indicator relation Indicator object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IndicatorQuery A secondary query class using the current class as primary query
     */
    public function useIndicatorQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinIndicator($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Indicator', 'IndicatorQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   IndicatorValue $indicatorValue Object to remove from the list of results
     *
     * @return IndicatorValueQuery The current query, for fluid interface
     */
    public function prune($indicatorValue = null)
    {
        if ($indicatorValue) {
            $this->addUsingAlias(IndicatorValuePeer::ID, $indicatorValue->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
