<?php


/**
 * Base class that represents a row from the 'indicators_indicator' table.
 *
 * Indicators
 *
 * @package    propel.generator.indicators.classes.om
 */
abstract class BaseIndicator extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'IndicatorPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        IndicatorPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the archived field.
     * Note: this column has a database default value of: false
     * @var        boolean
     */
    protected $archived;

    /**
     * The value for the methodology field.
     * @var        string
     */
    protected $methodology;

    /**
     * The value for the decimals field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $decimals;

    /**
     * The value for the goal field.
     * @var        double
     */
    protected $goal;

    /**
     * The value for the goaldate field.
     * @var        string
     */
    protected $goaldate;

    /**
     * The value for the idealbehavior field.
     * @var        int
     */
    protected $idealbehavior;

    /**
     * The value for the positionid field.
     * @var        int
     */
    protected $positionid;

    /**
     * The value for the objectiveid field.
     * @var        int
     */
    protected $objectiveid;

    /**
     * The value for the duedate field.
     * @var        string
     */
    protected $duedate;

    /**
     * The value for the finisheddate field.
     * @var        string
     */
    protected $finisheddate;

    /**
     * The value for the classkey field.
     * @var        int
     */
    protected $classkey;

    /**
     * @var        Position
     */
    protected $aPosition;

    /**
     * @var        Objective
     */
    protected $aObjective;

    /**
     * @var        PropelObjectCollection|IndicatorValue[] Collection to store aggregation of IndicatorValue objects.
     */
    protected $collIndicatorValues;
    protected $collIndicatorValuesPartial;

    /**
     * @var        PropelObjectCollection|IndicatorGraphSerie[] Collection to store aggregation of IndicatorGraphSerie objects.
     */
    protected $collIndicatorGraphSeries;
    protected $collIndicatorGraphSeriesPartial;

    /**
     * @var        PropelObjectCollection|PolicyGuidelineIndicators[] Collection to store aggregation of PolicyGuidelineIndicators objects.
     */
    protected $collPolicyGuidelineIndicatorss;
    protected $collPolicyGuidelineIndicatorssPartial;

    /**
     * @var        PropelObjectCollection|Project[] Collection to store aggregation of Project objects.
     */
    protected $collProjects;
    protected $collProjectsPartial;

    /**
     * @var        PropelObjectCollection|IndicatorGraph[] Collection to store aggregation of IndicatorGraph objects.
     */
    protected $collIndicatorGraphs;

    /**
     * @var        PropelObjectCollection|PolicyGuideline[] Collection to store aggregation of PolicyGuideline objects.
     */
    protected $collPolicyGuidelines;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $indicatorGraphsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $policyGuidelinesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $indicatorValuesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $indicatorGraphSeriesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $policyGuidelineIndicatorssScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectsScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see        __construct()
     */
    public function applyDefaultValues()
    {
        $this->archived = false;
        $this->decimals = 0;
    }

    /**
     * Initializes internal state of BaseIndicator object.
     * @see        applyDefaults()
     */
    public function __construct()
    {
        parent::__construct();
        $this->applyDefaultValues();
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [description] column value.
     * Description
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [archived] column value.
     * Archivado
     * @return boolean
     */
    public function getArchived()
    {
        return $this->archived;
    }

    /**
     * Get the [methodology] column value.
     * Metodologia de medicion
     * @return string
     */
    public function getMethodology()
    {
        return $this->methodology;
    }

    /**
     * Get the [decimals] column value.
     * Cantidad de decimales
     * @return int
     */
    public function getDecimals()
    {
        return $this->decimals;
    }

    /**
     * Get the [goal] column value.
     * Value
     * @return double
     */
    public function getGoal()
    {
        return $this->goal;
    }

    /**
     * Get the [optionally formatted] temporal [goaldate] column value.
     * Fecha de publicacion
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getGoaldate($format = 'Y-m-d H:i:s')
    {
        if ($this->goaldate === null) {
            return null;
        }

        if ($this->goaldate === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->goaldate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->goaldate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [idealbehavior] column value.
     * Comportamiento ideal
     * @return int
     */
    public function getIdealbehavior()
    {
        return $this->idealbehavior;
    }

    /**
     * Get the [positionid] column value.
     * Encargado de medicion
     * @return int
     */
    public function getPositionid()
    {
        return $this->positionid;
    }

    /**
     * Get the [objectiveid] column value.
     * Objetivo relacionado
     * @return int
     */
    public function getObjectiveid()
    {
        return $this->objectiveid;
    }

    /**
     * Get the [optionally formatted] temporal [duedate] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDuedate($format = '%Y/%m/%d')
    {
        if ($this->duedate === null) {
            return null;
        }

        if ($this->duedate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->duedate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->duedate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [finisheddate] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getFinisheddate($format = '%Y/%m/%d')
    {
        if ($this->finisheddate === null) {
            return null;
        }

        if ($this->finisheddate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->finisheddate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->finisheddate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [classkey] column value.
     *
     * @return int
     */
    public function getClasskey()
    {
        return $this->classkey;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return Indicator The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = IndicatorPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Name
     * @param string $v new value
     * @return Indicator The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = IndicatorPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [description] column.
     * Description
     * @param string $v new value
     * @return Indicator The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = IndicatorPeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Sets the value of the [archived] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Archivado
     * @param boolean|integer|string $v The new value
     * @return Indicator The current object (for fluent API support)
     */
    public function setArchived($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->archived !== $v) {
            $this->archived = $v;
            $this->modifiedColumns[] = IndicatorPeer::ARCHIVED;
        }


        return $this;
    } // setArchived()

    /**
     * Set the value of [methodology] column.
     * Metodologia de medicion
     * @param string $v new value
     * @return Indicator The current object (for fluent API support)
     */
    public function setMethodology($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->methodology !== $v) {
            $this->methodology = $v;
            $this->modifiedColumns[] = IndicatorPeer::METHODOLOGY;
        }


        return $this;
    } // setMethodology()

    /**
     * Set the value of [decimals] column.
     * Cantidad de decimales
     * @param int $v new value
     * @return Indicator The current object (for fluent API support)
     */
    public function setDecimals($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->decimals !== $v) {
            $this->decimals = $v;
            $this->modifiedColumns[] = IndicatorPeer::DECIMALS;
        }


        return $this;
    } // setDecimals()

    /**
     * Set the value of [goal] column.
     * Value
     * @param double $v new value
     * @return Indicator The current object (for fluent API support)
     */
    public function setGoal($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->goal !== $v) {
            $this->goal = $v;
            $this->modifiedColumns[] = IndicatorPeer::GOAL;
        }


        return $this;
    } // setGoal()

    /**
     * Sets the value of [goaldate] column to a normalized version of the date/time value specified.
     * Fecha de publicacion
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Indicator The current object (for fluent API support)
     */
    public function setGoaldate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->goaldate !== null || $dt !== null) {
            $currentDateAsString = ($this->goaldate !== null && $tmpDt = new DateTime($this->goaldate)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->goaldate = $newDateAsString;
                $this->modifiedColumns[] = IndicatorPeer::GOALDATE;
            }
        } // if either are not null


        return $this;
    } // setGoaldate()

    /**
     * Set the value of [idealbehavior] column.
     * Comportamiento ideal
     * @param int $v new value
     * @return Indicator The current object (for fluent API support)
     */
    public function setIdealbehavior($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->idealbehavior !== $v) {
            $this->idealbehavior = $v;
            $this->modifiedColumns[] = IndicatorPeer::IDEALBEHAVIOR;
        }


        return $this;
    } // setIdealbehavior()

    /**
     * Set the value of [positionid] column.
     * Encargado de medicion
     * @param int $v new value
     * @return Indicator The current object (for fluent API support)
     */
    public function setPositionid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->positionid !== $v) {
            $this->positionid = $v;
            $this->modifiedColumns[] = IndicatorPeer::POSITIONID;
        }

        if ($this->aPosition !== null && $this->aPosition->getId() !== $v) {
            $this->aPosition = null;
        }


        return $this;
    } // setPositionid()

    /**
     * Set the value of [objectiveid] column.
     * Objetivo relacionado
     * @param int $v new value
     * @return Indicator The current object (for fluent API support)
     */
    public function setObjectiveid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->objectiveid !== $v) {
            $this->objectiveid = $v;
            $this->modifiedColumns[] = IndicatorPeer::OBJECTIVEID;
        }

        if ($this->aObjective !== null && $this->aObjective->getId() !== $v) {
            $this->aObjective = null;
        }


        return $this;
    } // setObjectiveid()

    /**
     * Sets the value of [duedate] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Indicator The current object (for fluent API support)
     */
    public function setDuedate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->duedate !== null || $dt !== null) {
            $currentDateAsString = ($this->duedate !== null && $tmpDt = new DateTime($this->duedate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->duedate = $newDateAsString;
                $this->modifiedColumns[] = IndicatorPeer::DUEDATE;
            }
        } // if either are not null


        return $this;
    } // setDuedate()

    /**
     * Sets the value of [finisheddate] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Indicator The current object (for fluent API support)
     */
    public function setFinisheddate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->finisheddate !== null || $dt !== null) {
            $currentDateAsString = ($this->finisheddate !== null && $tmpDt = new DateTime($this->finisheddate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->finisheddate = $newDateAsString;
                $this->modifiedColumns[] = IndicatorPeer::FINISHEDDATE;
            }
        } // if either are not null


        return $this;
    } // setFinisheddate()

    /**
     * Set the value of [classkey] column.
     *
     * @param int $v new value
     * @return Indicator The current object (for fluent API support)
     */
    public function setClasskey($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->classkey !== $v) {
            $this->classkey = $v;
            $this->modifiedColumns[] = IndicatorPeer::CLASSKEY;
        }


        return $this;
    } // setClasskey()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->archived !== false) {
                return false;
            }

            if ($this->decimals !== 0) {
                return false;
            }

        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->description = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->archived = ($row[$startcol + 3] !== null) ? (boolean) $row[$startcol + 3] : null;
            $this->methodology = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->decimals = ($row[$startcol + 5] !== null) ? (int) $row[$startcol + 5] : null;
            $this->goal = ($row[$startcol + 6] !== null) ? (double) $row[$startcol + 6] : null;
            $this->goaldate = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->idealbehavior = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
            $this->positionid = ($row[$startcol + 9] !== null) ? (int) $row[$startcol + 9] : null;
            $this->objectiveid = ($row[$startcol + 10] !== null) ? (int) $row[$startcol + 10] : null;
            $this->duedate = ($row[$startcol + 11] !== null) ? (string) $row[$startcol + 11] : null;
            $this->finisheddate = ($row[$startcol + 12] !== null) ? (string) $row[$startcol + 12] : null;
            $this->classkey = ($row[$startcol + 13] !== null) ? (int) $row[$startcol + 13] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 14; // 14 = IndicatorPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Indicator object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aPosition !== null && $this->positionid !== $this->aPosition->getId()) {
            $this->aPosition = null;
        }
        if ($this->aObjective !== null && $this->objectiveid !== $this->aObjective->getId()) {
            $this->aObjective = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = IndicatorPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aPosition = null;
            $this->aObjective = null;
            $this->collIndicatorValues = null;

            $this->collIndicatorGraphSeries = null;

            $this->collPolicyGuidelineIndicatorss = null;

            $this->collProjects = null;

            $this->collIndicatorGraphs = null;
            $this->collPolicyGuidelines = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = IndicatorQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                IndicatorPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aPosition !== null) {
                if ($this->aPosition->isModified() || $this->aPosition->isNew()) {
                    $affectedRows += $this->aPosition->save($con);
                }
                $this->setPosition($this->aPosition);
            }

            if ($this->aObjective !== null) {
                if ($this->aObjective->isModified() || $this->aObjective->isNew()) {
                    $affectedRows += $this->aObjective->save($con);
                }
                $this->setObjective($this->aObjective);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->indicatorGraphsScheduledForDeletion !== null) {
                if (!$this->indicatorGraphsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->indicatorGraphsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    IndicatorGraphSerieQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->indicatorGraphsScheduledForDeletion = null;
                }

                foreach ($this->getIndicatorGraphs() as $indicatorGraph) {
                    if ($indicatorGraph->isModified()) {
                        $indicatorGraph->save($con);
                    }
                }
            }

            if ($this->policyGuidelinesScheduledForDeletion !== null) {
                if (!$this->policyGuidelinesScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->policyGuidelinesScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    PolicyGuidelineIndicatorsQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->policyGuidelinesScheduledForDeletion = null;
                }

                foreach ($this->getPolicyGuidelines() as $policyGuideline) {
                    if ($policyGuideline->isModified()) {
                        $policyGuideline->save($con);
                    }
                }
            }

            if ($this->indicatorValuesScheduledForDeletion !== null) {
                if (!$this->indicatorValuesScheduledForDeletion->isEmpty()) {
                    foreach ($this->indicatorValuesScheduledForDeletion as $indicatorValue) {
                        // need to save related object because we set the relation to null
                        $indicatorValue->save($con);
                    }
                    $this->indicatorValuesScheduledForDeletion = null;
                }
            }

            if ($this->collIndicatorValues !== null) {
                foreach ($this->collIndicatorValues as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->indicatorGraphSeriesScheduledForDeletion !== null) {
                if (!$this->indicatorGraphSeriesScheduledForDeletion->isEmpty()) {
                    IndicatorGraphSerieQuery::create()
                        ->filterByPrimaryKeys($this->indicatorGraphSeriesScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->indicatorGraphSeriesScheduledForDeletion = null;
                }
            }

            if ($this->collIndicatorGraphSeries !== null) {
                foreach ($this->collIndicatorGraphSeries as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->policyGuidelineIndicatorssScheduledForDeletion !== null) {
                if (!$this->policyGuidelineIndicatorssScheduledForDeletion->isEmpty()) {
                    PolicyGuidelineIndicatorsQuery::create()
                        ->filterByPrimaryKeys($this->policyGuidelineIndicatorssScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->policyGuidelineIndicatorssScheduledForDeletion = null;
                }
            }

            if ($this->collPolicyGuidelineIndicatorss !== null) {
                foreach ($this->collPolicyGuidelineIndicatorss as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectsScheduledForDeletion !== null) {
                if (!$this->projectsScheduledForDeletion->isEmpty()) {
                    foreach ($this->projectsScheduledForDeletion as $project) {
                        // need to save related object because we set the relation to null
                        $project->save($con);
                    }
                    $this->projectsScheduledForDeletion = null;
                }
            }

            if ($this->collProjects !== null) {
                foreach ($this->collProjects as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = IndicatorPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . IndicatorPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(IndicatorPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(IndicatorPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(IndicatorPeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(IndicatorPeer::ARCHIVED)) {
            $modifiedColumns[':p' . $index++]  = '`ARCHIVED`';
        }
        if ($this->isColumnModified(IndicatorPeer::METHODOLOGY)) {
            $modifiedColumns[':p' . $index++]  = '`METHODOLOGY`';
        }
        if ($this->isColumnModified(IndicatorPeer::DECIMALS)) {
            $modifiedColumns[':p' . $index++]  = '`DECIMALS`';
        }
        if ($this->isColumnModified(IndicatorPeer::GOAL)) {
            $modifiedColumns[':p' . $index++]  = '`GOAL`';
        }
        if ($this->isColumnModified(IndicatorPeer::GOALDATE)) {
            $modifiedColumns[':p' . $index++]  = '`GOALDATE`';
        }
        if ($this->isColumnModified(IndicatorPeer::IDEALBEHAVIOR)) {
            $modifiedColumns[':p' . $index++]  = '`IDEALBEHAVIOR`';
        }
        if ($this->isColumnModified(IndicatorPeer::POSITIONID)) {
            $modifiedColumns[':p' . $index++]  = '`POSITIONID`';
        }
        if ($this->isColumnModified(IndicatorPeer::OBJECTIVEID)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECTIVEID`';
        }
        if ($this->isColumnModified(IndicatorPeer::DUEDATE)) {
            $modifiedColumns[':p' . $index++]  = '`DUEDATE`';
        }
        if ($this->isColumnModified(IndicatorPeer::FINISHEDDATE)) {
            $modifiedColumns[':p' . $index++]  = '`FINISHEDDATE`';
        }
        if ($this->isColumnModified(IndicatorPeer::CLASSKEY)) {
            $modifiedColumns[':p' . $index++]  = '`CLASSKEY`';
        }

        $sql = sprintf(
            'INSERT INTO `indicators_indicator` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`ARCHIVED`':
                        $stmt->bindValue($identifier, (int) $this->archived, PDO::PARAM_INT);
                        break;
                    case '`METHODOLOGY`':
                        $stmt->bindValue($identifier, $this->methodology, PDO::PARAM_STR);
                        break;
                    case '`DECIMALS`':
                        $stmt->bindValue($identifier, $this->decimals, PDO::PARAM_INT);
                        break;
                    case '`GOAL`':
                        $stmt->bindValue($identifier, $this->goal, PDO::PARAM_STR);
                        break;
                    case '`GOALDATE`':
                        $stmt->bindValue($identifier, $this->goaldate, PDO::PARAM_STR);
                        break;
                    case '`IDEALBEHAVIOR`':
                        $stmt->bindValue($identifier, $this->idealbehavior, PDO::PARAM_INT);
                        break;
                    case '`POSITIONID`':
                        $stmt->bindValue($identifier, $this->positionid, PDO::PARAM_INT);
                        break;
                    case '`OBJECTIVEID`':
                        $stmt->bindValue($identifier, $this->objectiveid, PDO::PARAM_INT);
                        break;
                    case '`DUEDATE`':
                        $stmt->bindValue($identifier, $this->duedate, PDO::PARAM_STR);
                        break;
                    case '`FINISHEDDATE`':
                        $stmt->bindValue($identifier, $this->finisheddate, PDO::PARAM_STR);
                        break;
                    case '`CLASSKEY`':
                        $stmt->bindValue($identifier, $this->classkey, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aPosition !== null) {
                if (!$this->aPosition->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aPosition->getValidationFailures());
                }
            }

            if ($this->aObjective !== null) {
                if (!$this->aObjective->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aObjective->getValidationFailures());
                }
            }


            if (($retval = IndicatorPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collIndicatorValues !== null) {
                    foreach ($this->collIndicatorValues as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collIndicatorGraphSeries !== null) {
                    foreach ($this->collIndicatorGraphSeries as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collPolicyGuidelineIndicatorss !== null) {
                    foreach ($this->collPolicyGuidelineIndicatorss as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjects !== null) {
                    foreach ($this->collProjects as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = IndicatorPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getDescription();
                break;
            case 3:
                return $this->getArchived();
                break;
            case 4:
                return $this->getMethodology();
                break;
            case 5:
                return $this->getDecimals();
                break;
            case 6:
                return $this->getGoal();
                break;
            case 7:
                return $this->getGoaldate();
                break;
            case 8:
                return $this->getIdealbehavior();
                break;
            case 9:
                return $this->getPositionid();
                break;
            case 10:
                return $this->getObjectiveid();
                break;
            case 11:
                return $this->getDuedate();
                break;
            case 12:
                return $this->getFinisheddate();
                break;
            case 13:
                return $this->getClasskey();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Indicator'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Indicator'][$this->getPrimaryKey()] = true;
        $keys = IndicatorPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getDescription(),
            $keys[3] => $this->getArchived(),
            $keys[4] => $this->getMethodology(),
            $keys[5] => $this->getDecimals(),
            $keys[6] => $this->getGoal(),
            $keys[7] => $this->getGoaldate(),
            $keys[8] => $this->getIdealbehavior(),
            $keys[9] => $this->getPositionid(),
            $keys[10] => $this->getObjectiveid(),
            $keys[11] => $this->getDuedate(),
            $keys[12] => $this->getFinisheddate(),
            $keys[13] => $this->getClasskey(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aPosition) {
                $result['Position'] = $this->aPosition->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aObjective) {
                $result['Objective'] = $this->aObjective->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collIndicatorValues) {
                $result['IndicatorValues'] = $this->collIndicatorValues->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collIndicatorGraphSeries) {
                $result['IndicatorGraphSeries'] = $this->collIndicatorGraphSeries->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collPolicyGuidelineIndicatorss) {
                $result['PolicyGuidelineIndicatorss'] = $this->collPolicyGuidelineIndicatorss->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjects) {
                $result['Projects'] = $this->collProjects->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = IndicatorPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setDescription($value);
                break;
            case 3:
                $this->setArchived($value);
                break;
            case 4:
                $this->setMethodology($value);
                break;
            case 5:
                $this->setDecimals($value);
                break;
            case 6:
                $this->setGoal($value);
                break;
            case 7:
                $this->setGoaldate($value);
                break;
            case 8:
                $this->setIdealbehavior($value);
                break;
            case 9:
                $this->setPositionid($value);
                break;
            case 10:
                $this->setObjectiveid($value);
                break;
            case 11:
                $this->setDuedate($value);
                break;
            case 12:
                $this->setFinisheddate($value);
                break;
            case 13:
                $this->setClasskey($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = IndicatorPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setDescription($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setArchived($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setMethodology($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setDecimals($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setGoal($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setGoaldate($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setIdealbehavior($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setPositionid($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setObjectiveid($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setDuedate($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setFinisheddate($arr[$keys[12]]);
        if (array_key_exists($keys[13], $arr)) $this->setClasskey($arr[$keys[13]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(IndicatorPeer::DATABASE_NAME);

        if ($this->isColumnModified(IndicatorPeer::ID)) $criteria->add(IndicatorPeer::ID, $this->id);
        if ($this->isColumnModified(IndicatorPeer::NAME)) $criteria->add(IndicatorPeer::NAME, $this->name);
        if ($this->isColumnModified(IndicatorPeer::DESCRIPTION)) $criteria->add(IndicatorPeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(IndicatorPeer::ARCHIVED)) $criteria->add(IndicatorPeer::ARCHIVED, $this->archived);
        if ($this->isColumnModified(IndicatorPeer::METHODOLOGY)) $criteria->add(IndicatorPeer::METHODOLOGY, $this->methodology);
        if ($this->isColumnModified(IndicatorPeer::DECIMALS)) $criteria->add(IndicatorPeer::DECIMALS, $this->decimals);
        if ($this->isColumnModified(IndicatorPeer::GOAL)) $criteria->add(IndicatorPeer::GOAL, $this->goal);
        if ($this->isColumnModified(IndicatorPeer::GOALDATE)) $criteria->add(IndicatorPeer::GOALDATE, $this->goaldate);
        if ($this->isColumnModified(IndicatorPeer::IDEALBEHAVIOR)) $criteria->add(IndicatorPeer::IDEALBEHAVIOR, $this->idealbehavior);
        if ($this->isColumnModified(IndicatorPeer::POSITIONID)) $criteria->add(IndicatorPeer::POSITIONID, $this->positionid);
        if ($this->isColumnModified(IndicatorPeer::OBJECTIVEID)) $criteria->add(IndicatorPeer::OBJECTIVEID, $this->objectiveid);
        if ($this->isColumnModified(IndicatorPeer::DUEDATE)) $criteria->add(IndicatorPeer::DUEDATE, $this->duedate);
        if ($this->isColumnModified(IndicatorPeer::FINISHEDDATE)) $criteria->add(IndicatorPeer::FINISHEDDATE, $this->finisheddate);
        if ($this->isColumnModified(IndicatorPeer::CLASSKEY)) $criteria->add(IndicatorPeer::CLASSKEY, $this->classkey);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(IndicatorPeer::DATABASE_NAME);
        $criteria->add(IndicatorPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Indicator (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setArchived($this->getArchived());
        $copyObj->setMethodology($this->getMethodology());
        $copyObj->setDecimals($this->getDecimals());
        $copyObj->setGoal($this->getGoal());
        $copyObj->setGoaldate($this->getGoaldate());
        $copyObj->setIdealbehavior($this->getIdealbehavior());
        $copyObj->setPositionid($this->getPositionid());
        $copyObj->setObjectiveid($this->getObjectiveid());
        $copyObj->setDuedate($this->getDuedate());
        $copyObj->setFinisheddate($this->getFinisheddate());
        $copyObj->setClasskey($this->getClasskey());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getIndicatorValues() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addIndicatorValue($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getIndicatorGraphSeries() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addIndicatorGraphSerie($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getPolicyGuidelineIndicatorss() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addPolicyGuidelineIndicators($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjects() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProject($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Indicator Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return IndicatorPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new IndicatorPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Position object.
     *
     * @param             Position $v
     * @return Indicator The current object (for fluent API support)
     * @throws PropelException
     */
    public function setPosition(Position $v = null)
    {
        if ($v === null) {
            $this->setPositionid(NULL);
        } else {
            $this->setPositionid($v->getId());
        }

        $this->aPosition = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Position object, it will not be re-added.
        if ($v !== null) {
            $v->addIndicator($this);
        }


        return $this;
    }


    /**
     * Get the associated Position object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Position The associated Position object.
     * @throws PropelException
     */
    public function getPosition(PropelPDO $con = null)
    {
        if ($this->aPosition === null && ($this->positionid !== null)) {
            $this->aPosition = PositionQuery::create()->findPk($this->positionid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aPosition->addIndicators($this);
             */
        }

        return $this->aPosition;
    }

    /**
     * Declares an association between this object and a Objective object.
     *
     * @param             Objective $v
     * @return Indicator The current object (for fluent API support)
     * @throws PropelException
     */
    public function setObjective(Objective $v = null)
    {
        if ($v === null) {
            $this->setObjectiveid(NULL);
        } else {
            $this->setObjectiveid($v->getId());
        }

        $this->aObjective = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Objective object, it will not be re-added.
        if ($v !== null) {
            $v->addIndicator($this);
        }


        return $this;
    }


    /**
     * Get the associated Objective object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Objective The associated Objective object.
     * @throws PropelException
     */
    public function getObjective(PropelPDO $con = null)
    {
        if ($this->aObjective === null && ($this->objectiveid !== null)) {
            $this->aObjective = ObjectiveQuery::create()->findPk($this->objectiveid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aObjective->addIndicators($this);
             */
        }

        return $this->aObjective;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('IndicatorValue' == $relationName) {
            $this->initIndicatorValues();
        }
        if ('IndicatorGraphSerie' == $relationName) {
            $this->initIndicatorGraphSeries();
        }
        if ('PolicyGuidelineIndicators' == $relationName) {
            $this->initPolicyGuidelineIndicatorss();
        }
        if ('Project' == $relationName) {
            $this->initProjects();
        }
    }

    /**
     * Clears out the collIndicatorValues collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIndicatorValues()
     */
    public function clearIndicatorValues()
    {
        $this->collIndicatorValues = null; // important to set this to null since that means it is uninitialized
        $this->collIndicatorValuesPartial = null;
    }

    /**
     * reset is the collIndicatorValues collection loaded partially
     *
     * @return void
     */
    public function resetPartialIndicatorValues($v = true)
    {
        $this->collIndicatorValuesPartial = $v;
    }

    /**
     * Initializes the collIndicatorValues collection.
     *
     * By default this just sets the collIndicatorValues collection to an empty array (like clearcollIndicatorValues());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initIndicatorValues($overrideExisting = true)
    {
        if (null !== $this->collIndicatorValues && !$overrideExisting) {
            return;
        }
        $this->collIndicatorValues = new PropelObjectCollection();
        $this->collIndicatorValues->setModel('IndicatorValue');
    }

    /**
     * Gets an array of IndicatorValue objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Indicator is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|IndicatorValue[] List of IndicatorValue objects
     * @throws PropelException
     */
    public function getIndicatorValues($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collIndicatorValuesPartial && !$this->isNew();
        if (null === $this->collIndicatorValues || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collIndicatorValues) {
                // return empty collection
                $this->initIndicatorValues();
            } else {
                $collIndicatorValues = IndicatorValueQuery::create(null, $criteria)
                    ->filterByIndicator($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collIndicatorValuesPartial && count($collIndicatorValues)) {
                      $this->initIndicatorValues(false);

                      foreach($collIndicatorValues as $obj) {
                        if (false == $this->collIndicatorValues->contains($obj)) {
                          $this->collIndicatorValues->append($obj);
                        }
                      }

                      $this->collIndicatorValuesPartial = true;
                    }

                    return $collIndicatorValues;
                }

                if($partial && $this->collIndicatorValues) {
                    foreach($this->collIndicatorValues as $obj) {
                        if($obj->isNew()) {
                            $collIndicatorValues[] = $obj;
                        }
                    }
                }

                $this->collIndicatorValues = $collIndicatorValues;
                $this->collIndicatorValuesPartial = false;
            }
        }

        return $this->collIndicatorValues;
    }

    /**
     * Sets a collection of IndicatorValue objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $indicatorValues A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIndicatorValues(PropelCollection $indicatorValues, PropelPDO $con = null)
    {
        $this->indicatorValuesScheduledForDeletion = $this->getIndicatorValues(new Criteria(), $con)->diff($indicatorValues);

        foreach ($this->indicatorValuesScheduledForDeletion as $indicatorValueRemoved) {
            $indicatorValueRemoved->setIndicator(null);
        }

        $this->collIndicatorValues = null;
        foreach ($indicatorValues as $indicatorValue) {
            $this->addIndicatorValue($indicatorValue);
        }

        $this->collIndicatorValues = $indicatorValues;
        $this->collIndicatorValuesPartial = false;
    }

    /**
     * Returns the number of related IndicatorValue objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related IndicatorValue objects.
     * @throws PropelException
     */
    public function countIndicatorValues(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collIndicatorValuesPartial && !$this->isNew();
        if (null === $this->collIndicatorValues || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collIndicatorValues) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getIndicatorValues());
                }
                $query = IndicatorValueQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIndicator($this)
                    ->count($con);
            }
        } else {
            return count($this->collIndicatorValues);
        }
    }

    /**
     * Method called to associate a BaseIndicatorValue object to this object
     * through the BaseIndicatorValue foreign key attribute.
     *
     * @param    BaseIndicatorValue $l BaseIndicatorValue
     * @return Indicator The current object (for fluent API support)
     */
    public function addIndicatorValue(BaseIndicatorValue $l)
    {
        if ($this->collIndicatorValues === null) {
            $this->initIndicatorValues();
            $this->collIndicatorValuesPartial = true;
        }
        if (!$this->collIndicatorValues->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddIndicatorValue($l);
        }

        return $this;
    }

    /**
     * @param	IndicatorValue $indicatorValue The indicatorValue object to add.
     */
    protected function doAddIndicatorValue($indicatorValue)
    {
        $this->collIndicatorValues[]= $indicatorValue;
        $indicatorValue->setIndicator($this);
    }

    /**
     * @param	IndicatorValue $indicatorValue The indicatorValue object to remove.
     */
    public function removeIndicatorValue($indicatorValue)
    {
        if ($this->getIndicatorValues()->contains($indicatorValue)) {
            $this->collIndicatorValues->remove($this->collIndicatorValues->search($indicatorValue));
            if (null === $this->indicatorValuesScheduledForDeletion) {
                $this->indicatorValuesScheduledForDeletion = clone $this->collIndicatorValues;
                $this->indicatorValuesScheduledForDeletion->clear();
            }
            $this->indicatorValuesScheduledForDeletion[]= $indicatorValue;
            $indicatorValue->setIndicator(null);
        }
    }

    /**
     * Clears out the collIndicatorGraphSeries collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIndicatorGraphSeries()
     */
    public function clearIndicatorGraphSeries()
    {
        $this->collIndicatorGraphSeries = null; // important to set this to null since that means it is uninitialized
        $this->collIndicatorGraphSeriesPartial = null;
    }

    /**
     * reset is the collIndicatorGraphSeries collection loaded partially
     *
     * @return void
     */
    public function resetPartialIndicatorGraphSeries($v = true)
    {
        $this->collIndicatorGraphSeriesPartial = $v;
    }

    /**
     * Initializes the collIndicatorGraphSeries collection.
     *
     * By default this just sets the collIndicatorGraphSeries collection to an empty array (like clearcollIndicatorGraphSeries());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initIndicatorGraphSeries($overrideExisting = true)
    {
        if (null !== $this->collIndicatorGraphSeries && !$overrideExisting) {
            return;
        }
        $this->collIndicatorGraphSeries = new PropelObjectCollection();
        $this->collIndicatorGraphSeries->setModel('IndicatorGraphSerie');
    }

    /**
     * Gets an array of IndicatorGraphSerie objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Indicator is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|IndicatorGraphSerie[] List of IndicatorGraphSerie objects
     * @throws PropelException
     */
    public function getIndicatorGraphSeries($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collIndicatorGraphSeriesPartial && !$this->isNew();
        if (null === $this->collIndicatorGraphSeries || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collIndicatorGraphSeries) {
                // return empty collection
                $this->initIndicatorGraphSeries();
            } else {
                $collIndicatorGraphSeries = IndicatorGraphSerieQuery::create(null, $criteria)
                    ->filterByIndicator($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collIndicatorGraphSeriesPartial && count($collIndicatorGraphSeries)) {
                      $this->initIndicatorGraphSeries(false);

                      foreach($collIndicatorGraphSeries as $obj) {
                        if (false == $this->collIndicatorGraphSeries->contains($obj)) {
                          $this->collIndicatorGraphSeries->append($obj);
                        }
                      }

                      $this->collIndicatorGraphSeriesPartial = true;
                    }

                    return $collIndicatorGraphSeries;
                }

                if($partial && $this->collIndicatorGraphSeries) {
                    foreach($this->collIndicatorGraphSeries as $obj) {
                        if($obj->isNew()) {
                            $collIndicatorGraphSeries[] = $obj;
                        }
                    }
                }

                $this->collIndicatorGraphSeries = $collIndicatorGraphSeries;
                $this->collIndicatorGraphSeriesPartial = false;
            }
        }

        return $this->collIndicatorGraphSeries;
    }

    /**
     * Sets a collection of IndicatorGraphSerie objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $indicatorGraphSeries A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIndicatorGraphSeries(PropelCollection $indicatorGraphSeries, PropelPDO $con = null)
    {
        $this->indicatorGraphSeriesScheduledForDeletion = $this->getIndicatorGraphSeries(new Criteria(), $con)->diff($indicatorGraphSeries);

        foreach ($this->indicatorGraphSeriesScheduledForDeletion as $indicatorGraphSerieRemoved) {
            $indicatorGraphSerieRemoved->setIndicator(null);
        }

        $this->collIndicatorGraphSeries = null;
        foreach ($indicatorGraphSeries as $indicatorGraphSerie) {
            $this->addIndicatorGraphSerie($indicatorGraphSerie);
        }

        $this->collIndicatorGraphSeries = $indicatorGraphSeries;
        $this->collIndicatorGraphSeriesPartial = false;
    }

    /**
     * Returns the number of related IndicatorGraphSerie objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related IndicatorGraphSerie objects.
     * @throws PropelException
     */
    public function countIndicatorGraphSeries(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collIndicatorGraphSeriesPartial && !$this->isNew();
        if (null === $this->collIndicatorGraphSeries || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collIndicatorGraphSeries) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getIndicatorGraphSeries());
                }
                $query = IndicatorGraphSerieQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIndicator($this)
                    ->count($con);
            }
        } else {
            return count($this->collIndicatorGraphSeries);
        }
    }

    /**
     * Method called to associate a IndicatorGraphSerie object to this object
     * through the IndicatorGraphSerie foreign key attribute.
     *
     * @param    IndicatorGraphSerie $l IndicatorGraphSerie
     * @return Indicator The current object (for fluent API support)
     */
    public function addIndicatorGraphSerie(IndicatorGraphSerie $l)
    {
        if ($this->collIndicatorGraphSeries === null) {
            $this->initIndicatorGraphSeries();
            $this->collIndicatorGraphSeriesPartial = true;
        }
        if (!$this->collIndicatorGraphSeries->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddIndicatorGraphSerie($l);
        }

        return $this;
    }

    /**
     * @param	IndicatorGraphSerie $indicatorGraphSerie The indicatorGraphSerie object to add.
     */
    protected function doAddIndicatorGraphSerie($indicatorGraphSerie)
    {
        $this->collIndicatorGraphSeries[]= $indicatorGraphSerie;
        $indicatorGraphSerie->setIndicator($this);
    }

    /**
     * @param	IndicatorGraphSerie $indicatorGraphSerie The indicatorGraphSerie object to remove.
     */
    public function removeIndicatorGraphSerie($indicatorGraphSerie)
    {
        if ($this->getIndicatorGraphSeries()->contains($indicatorGraphSerie)) {
            $this->collIndicatorGraphSeries->remove($this->collIndicatorGraphSeries->search($indicatorGraphSerie));
            if (null === $this->indicatorGraphSeriesScheduledForDeletion) {
                $this->indicatorGraphSeriesScheduledForDeletion = clone $this->collIndicatorGraphSeries;
                $this->indicatorGraphSeriesScheduledForDeletion->clear();
            }
            $this->indicatorGraphSeriesScheduledForDeletion[]= $indicatorGraphSerie;
            $indicatorGraphSerie->setIndicator(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Indicator is new, it will return
     * an empty collection; or if this Indicator has previously
     * been saved, it will retrieve related IndicatorGraphSeries from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Indicator.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|IndicatorGraphSerie[] List of IndicatorGraphSerie objects
     */
    public function getIndicatorGraphSeriesJoinIndicatorGraph($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = IndicatorGraphSerieQuery::create(null, $criteria);
        $query->joinWith('IndicatorGraph', $join_behavior);

        return $this->getIndicatorGraphSeries($query, $con);
    }

    /**
     * Clears out the collPolicyGuidelineIndicatorss collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addPolicyGuidelineIndicatorss()
     */
    public function clearPolicyGuidelineIndicatorss()
    {
        $this->collPolicyGuidelineIndicatorss = null; // important to set this to null since that means it is uninitialized
        $this->collPolicyGuidelineIndicatorssPartial = null;
    }

    /**
     * reset is the collPolicyGuidelineIndicatorss collection loaded partially
     *
     * @return void
     */
    public function resetPartialPolicyGuidelineIndicatorss($v = true)
    {
        $this->collPolicyGuidelineIndicatorssPartial = $v;
    }

    /**
     * Initializes the collPolicyGuidelineIndicatorss collection.
     *
     * By default this just sets the collPolicyGuidelineIndicatorss collection to an empty array (like clearcollPolicyGuidelineIndicatorss());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initPolicyGuidelineIndicatorss($overrideExisting = true)
    {
        if (null !== $this->collPolicyGuidelineIndicatorss && !$overrideExisting) {
            return;
        }
        $this->collPolicyGuidelineIndicatorss = new PropelObjectCollection();
        $this->collPolicyGuidelineIndicatorss->setModel('PolicyGuidelineIndicators');
    }

    /**
     * Gets an array of PolicyGuidelineIndicators objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Indicator is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|PolicyGuidelineIndicators[] List of PolicyGuidelineIndicators objects
     * @throws PropelException
     */
    public function getPolicyGuidelineIndicatorss($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collPolicyGuidelineIndicatorssPartial && !$this->isNew();
        if (null === $this->collPolicyGuidelineIndicatorss || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collPolicyGuidelineIndicatorss) {
                // return empty collection
                $this->initPolicyGuidelineIndicatorss();
            } else {
                $collPolicyGuidelineIndicatorss = PolicyGuidelineIndicatorsQuery::create(null, $criteria)
                    ->filterByIndicator($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collPolicyGuidelineIndicatorssPartial && count($collPolicyGuidelineIndicatorss)) {
                      $this->initPolicyGuidelineIndicatorss(false);

                      foreach($collPolicyGuidelineIndicatorss as $obj) {
                        if (false == $this->collPolicyGuidelineIndicatorss->contains($obj)) {
                          $this->collPolicyGuidelineIndicatorss->append($obj);
                        }
                      }

                      $this->collPolicyGuidelineIndicatorssPartial = true;
                    }

                    return $collPolicyGuidelineIndicatorss;
                }

                if($partial && $this->collPolicyGuidelineIndicatorss) {
                    foreach($this->collPolicyGuidelineIndicatorss as $obj) {
                        if($obj->isNew()) {
                            $collPolicyGuidelineIndicatorss[] = $obj;
                        }
                    }
                }

                $this->collPolicyGuidelineIndicatorss = $collPolicyGuidelineIndicatorss;
                $this->collPolicyGuidelineIndicatorssPartial = false;
            }
        }

        return $this->collPolicyGuidelineIndicatorss;
    }

    /**
     * Sets a collection of PolicyGuidelineIndicators objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $policyGuidelineIndicatorss A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setPolicyGuidelineIndicatorss(PropelCollection $policyGuidelineIndicatorss, PropelPDO $con = null)
    {
        $this->policyGuidelineIndicatorssScheduledForDeletion = $this->getPolicyGuidelineIndicatorss(new Criteria(), $con)->diff($policyGuidelineIndicatorss);

        foreach ($this->policyGuidelineIndicatorssScheduledForDeletion as $policyGuidelineIndicatorsRemoved) {
            $policyGuidelineIndicatorsRemoved->setIndicator(null);
        }

        $this->collPolicyGuidelineIndicatorss = null;
        foreach ($policyGuidelineIndicatorss as $policyGuidelineIndicators) {
            $this->addPolicyGuidelineIndicators($policyGuidelineIndicators);
        }

        $this->collPolicyGuidelineIndicatorss = $policyGuidelineIndicatorss;
        $this->collPolicyGuidelineIndicatorssPartial = false;
    }

    /**
     * Returns the number of related PolicyGuidelineIndicators objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related PolicyGuidelineIndicators objects.
     * @throws PropelException
     */
    public function countPolicyGuidelineIndicatorss(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collPolicyGuidelineIndicatorssPartial && !$this->isNew();
        if (null === $this->collPolicyGuidelineIndicatorss || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collPolicyGuidelineIndicatorss) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getPolicyGuidelineIndicatorss());
                }
                $query = PolicyGuidelineIndicatorsQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIndicator($this)
                    ->count($con);
            }
        } else {
            return count($this->collPolicyGuidelineIndicatorss);
        }
    }

    /**
     * Method called to associate a PolicyGuidelineIndicators object to this object
     * through the PolicyGuidelineIndicators foreign key attribute.
     *
     * @param    PolicyGuidelineIndicators $l PolicyGuidelineIndicators
     * @return Indicator The current object (for fluent API support)
     */
    public function addPolicyGuidelineIndicators(PolicyGuidelineIndicators $l)
    {
        if ($this->collPolicyGuidelineIndicatorss === null) {
            $this->initPolicyGuidelineIndicatorss();
            $this->collPolicyGuidelineIndicatorssPartial = true;
        }
        if (!$this->collPolicyGuidelineIndicatorss->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddPolicyGuidelineIndicators($l);
        }

        return $this;
    }

    /**
     * @param	PolicyGuidelineIndicators $policyGuidelineIndicators The policyGuidelineIndicators object to add.
     */
    protected function doAddPolicyGuidelineIndicators($policyGuidelineIndicators)
    {
        $this->collPolicyGuidelineIndicatorss[]= $policyGuidelineIndicators;
        $policyGuidelineIndicators->setIndicator($this);
    }

    /**
     * @param	PolicyGuidelineIndicators $policyGuidelineIndicators The policyGuidelineIndicators object to remove.
     */
    public function removePolicyGuidelineIndicators($policyGuidelineIndicators)
    {
        if ($this->getPolicyGuidelineIndicatorss()->contains($policyGuidelineIndicators)) {
            $this->collPolicyGuidelineIndicatorss->remove($this->collPolicyGuidelineIndicatorss->search($policyGuidelineIndicators));
            if (null === $this->policyGuidelineIndicatorssScheduledForDeletion) {
                $this->policyGuidelineIndicatorssScheduledForDeletion = clone $this->collPolicyGuidelineIndicatorss;
                $this->policyGuidelineIndicatorssScheduledForDeletion->clear();
            }
            $this->policyGuidelineIndicatorssScheduledForDeletion[]= $policyGuidelineIndicators;
            $policyGuidelineIndicators->setIndicator(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Indicator is new, it will return
     * an empty collection; or if this Indicator has previously
     * been saved, it will retrieve related PolicyGuidelineIndicatorss from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Indicator.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|PolicyGuidelineIndicators[] List of PolicyGuidelineIndicators objects
     */
    public function getPolicyGuidelineIndicatorssJoinPolicyGuideline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = PolicyGuidelineIndicatorsQuery::create(null, $criteria);
        $query->joinWith('PolicyGuideline', $join_behavior);

        return $this->getPolicyGuidelineIndicatorss($query, $con);
    }

    /**
     * Clears out the collProjects collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjects()
     */
    public function clearProjects()
    {
        $this->collProjects = null; // important to set this to null since that means it is uninitialized
        $this->collProjectsPartial = null;
    }

    /**
     * reset is the collProjects collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjects($v = true)
    {
        $this->collProjectsPartial = $v;
    }

    /**
     * Initializes the collProjects collection.
     *
     * By default this just sets the collProjects collection to an empty array (like clearcollProjects());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjects($overrideExisting = true)
    {
        if (null !== $this->collProjects && !$overrideExisting) {
            return;
        }
        $this->collProjects = new PropelObjectCollection();
        $this->collProjects->setModel('Project');
    }

    /**
     * Gets an array of Project objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Indicator is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Project[] List of Project objects
     * @throws PropelException
     */
    public function getProjects($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectsPartial && !$this->isNew();
        if (null === $this->collProjects || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjects) {
                // return empty collection
                $this->initProjects();
            } else {
                $collProjects = ProjectQuery::create(null, $criteria)
                    ->filterByIndicator($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectsPartial && count($collProjects)) {
                      $this->initProjects(false);

                      foreach($collProjects as $obj) {
                        if (false == $this->collProjects->contains($obj)) {
                          $this->collProjects->append($obj);
                        }
                      }

                      $this->collProjectsPartial = true;
                    }

                    return $collProjects;
                }

                if($partial && $this->collProjects) {
                    foreach($this->collProjects as $obj) {
                        if($obj->isNew()) {
                            $collProjects[] = $obj;
                        }
                    }
                }

                $this->collProjects = $collProjects;
                $this->collProjectsPartial = false;
            }
        }

        return $this->collProjects;
    }

    /**
     * Sets a collection of Project objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projects A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjects(PropelCollection $projects, PropelPDO $con = null)
    {
        $this->projectsScheduledForDeletion = $this->getProjects(new Criteria(), $con)->diff($projects);

        foreach ($this->projectsScheduledForDeletion as $projectRemoved) {
            $projectRemoved->setIndicator(null);
        }

        $this->collProjects = null;
        foreach ($projects as $project) {
            $this->addProject($project);
        }

        $this->collProjects = $projects;
        $this->collProjectsPartial = false;
    }

    /**
     * Returns the number of related Project objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Project objects.
     * @throws PropelException
     */
    public function countProjects(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectsPartial && !$this->isNew();
        if (null === $this->collProjects || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjects) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjects());
                }
                $query = ProjectQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIndicator($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjects);
        }
    }

    /**
     * Method called to associate a Project object to this object
     * through the Project foreign key attribute.
     *
     * @param    Project $l Project
     * @return Indicator The current object (for fluent API support)
     */
    public function addProject(Project $l)
    {
        if ($this->collProjects === null) {
            $this->initProjects();
            $this->collProjectsPartial = true;
        }
        if (!$this->collProjects->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProject($l);
        }

        return $this;
    }

    /**
     * @param	Project $project The project object to add.
     */
    protected function doAddProject($project)
    {
        $this->collProjects[]= $project;
        $project->setIndicator($this);
    }

    /**
     * @param	Project $project The project object to remove.
     */
    public function removeProject($project)
    {
        if ($this->getProjects()->contains($project)) {
            $this->collProjects->remove($this->collProjects->search($project));
            if (null === $this->projectsScheduledForDeletion) {
                $this->projectsScheduledForDeletion = clone $this->collProjects;
                $this->projectsScheduledForDeletion->clear();
            }
            $this->projectsScheduledForDeletion[]= $project;
            $project->setIndicator(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Indicator is new, it will return
     * an empty collection; or if this Indicator has previously
     * been saved, it will retrieve related Projects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Indicator.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Project[] List of Project objects
     */
    public function getProjectsJoinObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectQuery::create(null, $criteria);
        $query->joinWith('Objective', $join_behavior);

        return $this->getProjects($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Indicator is new, it will return
     * an empty collection; or if this Indicator has previously
     * been saved, it will retrieve related Projects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Indicator.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Project[] List of Project objects
     */
    public function getProjectsJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getProjects($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Indicator is new, it will return
     * an empty collection; or if this Indicator has previously
     * been saved, it will retrieve related Projects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Indicator.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Project[] List of Project objects
     */
    public function getProjectsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getProjects($query, $con);
    }

    /**
     * Clears out the collIndicatorGraphs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIndicatorGraphs()
     */
    public function clearIndicatorGraphs()
    {
        $this->collIndicatorGraphs = null; // important to set this to null since that means it is uninitialized
        $this->collIndicatorGraphsPartial = null;
    }

    /**
     * Initializes the collIndicatorGraphs collection.
     *
     * By default this just sets the collIndicatorGraphs collection to an empty collection (like clearIndicatorGraphs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initIndicatorGraphs()
    {
        $this->collIndicatorGraphs = new PropelObjectCollection();
        $this->collIndicatorGraphs->setModel('IndicatorGraph');
    }

    /**
     * Gets a collection of IndicatorGraph objects related by a many-to-many relationship
     * to the current object by way of the indicators_graphSerie cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Indicator is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|IndicatorGraph[] List of IndicatorGraph objects
     */
    public function getIndicatorGraphs($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collIndicatorGraphs || null !== $criteria) {
            if ($this->isNew() && null === $this->collIndicatorGraphs) {
                // return empty collection
                $this->initIndicatorGraphs();
            } else {
                $collIndicatorGraphs = IndicatorGraphQuery::create(null, $criteria)
                    ->filterByIndicator($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collIndicatorGraphs;
                }
                $this->collIndicatorGraphs = $collIndicatorGraphs;
            }
        }

        return $this->collIndicatorGraphs;
    }

    /**
     * Sets a collection of IndicatorGraph objects related by a many-to-many relationship
     * to the current object by way of the indicators_graphSerie cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $indicatorGraphs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIndicatorGraphs(PropelCollection $indicatorGraphs, PropelPDO $con = null)
    {
        $this->clearIndicatorGraphs();
        $currentIndicatorGraphs = $this->getIndicatorGraphs();

        $this->indicatorGraphsScheduledForDeletion = $currentIndicatorGraphs->diff($indicatorGraphs);

        foreach ($indicatorGraphs as $indicatorGraph) {
            if (!$currentIndicatorGraphs->contains($indicatorGraph)) {
                $this->doAddIndicatorGraph($indicatorGraph);
            }
        }

        $this->collIndicatorGraphs = $indicatorGraphs;
    }

    /**
     * Gets the number of IndicatorGraph objects related by a many-to-many relationship
     * to the current object by way of the indicators_graphSerie cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related IndicatorGraph objects
     */
    public function countIndicatorGraphs($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collIndicatorGraphs || null !== $criteria) {
            if ($this->isNew() && null === $this->collIndicatorGraphs) {
                return 0;
            } else {
                $query = IndicatorGraphQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIndicator($this)
                    ->count($con);
            }
        } else {
            return count($this->collIndicatorGraphs);
        }
    }

    /**
     * Associate a IndicatorGraph object to this object
     * through the indicators_graphSerie cross reference table.
     *
     * @param  IndicatorGraph $indicatorGraph The IndicatorGraphSerie object to relate
     * @return void
     */
    public function addIndicatorGraph(IndicatorGraph $indicatorGraph)
    {
        if ($this->collIndicatorGraphs === null) {
            $this->initIndicatorGraphs();
        }
        if (!$this->collIndicatorGraphs->contains($indicatorGraph)) { // only add it if the **same** object is not already associated
            $this->doAddIndicatorGraph($indicatorGraph);

            $this->collIndicatorGraphs[]= $indicatorGraph;
        }
    }

    /**
     * @param	IndicatorGraph $indicatorGraph The indicatorGraph object to add.
     */
    protected function doAddIndicatorGraph($indicatorGraph)
    {
        $indicatorGraphSerie = new IndicatorGraphSerie();
        $indicatorGraphSerie->setIndicatorGraph($indicatorGraph);
        $this->addIndicatorGraphSerie($indicatorGraphSerie);
    }

    /**
     * Remove a IndicatorGraph object to this object
     * through the indicators_graphSerie cross reference table.
     *
     * @param IndicatorGraph $indicatorGraph The IndicatorGraphSerie object to relate
     * @return void
     */
    public function removeIndicatorGraph(IndicatorGraph $indicatorGraph)
    {
        if ($this->getIndicatorGraphs()->contains($indicatorGraph)) {
            $this->collIndicatorGraphs->remove($this->collIndicatorGraphs->search($indicatorGraph));
            if (null === $this->indicatorGraphsScheduledForDeletion) {
                $this->indicatorGraphsScheduledForDeletion = clone $this->collIndicatorGraphs;
                $this->indicatorGraphsScheduledForDeletion->clear();
            }
            $this->indicatorGraphsScheduledForDeletion[]= $indicatorGraph;
        }
    }

    /**
     * Clears out the collPolicyGuidelines collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addPolicyGuidelines()
     */
    public function clearPolicyGuidelines()
    {
        $this->collPolicyGuidelines = null; // important to set this to null since that means it is uninitialized
        $this->collPolicyGuidelinesPartial = null;
    }

    /**
     * Initializes the collPolicyGuidelines collection.
     *
     * By default this just sets the collPolicyGuidelines collection to an empty collection (like clearPolicyGuidelines());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initPolicyGuidelines()
    {
        $this->collPolicyGuidelines = new PropelObjectCollection();
        $this->collPolicyGuidelines->setModel('PolicyGuideline');
    }

    /**
     * Gets a collection of PolicyGuideline objects related by a many-to-many relationship
     * to the current object by way of the objectives_policyGuidelineIndicators cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Indicator is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|PolicyGuideline[] List of PolicyGuideline objects
     */
    public function getPolicyGuidelines($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collPolicyGuidelines || null !== $criteria) {
            if ($this->isNew() && null === $this->collPolicyGuidelines) {
                // return empty collection
                $this->initPolicyGuidelines();
            } else {
                $collPolicyGuidelines = PolicyGuidelineQuery::create(null, $criteria)
                    ->filterByIndicator($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collPolicyGuidelines;
                }
                $this->collPolicyGuidelines = $collPolicyGuidelines;
            }
        }

        return $this->collPolicyGuidelines;
    }

    /**
     * Sets a collection of PolicyGuideline objects related by a many-to-many relationship
     * to the current object by way of the objectives_policyGuidelineIndicators cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $policyGuidelines A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setPolicyGuidelines(PropelCollection $policyGuidelines, PropelPDO $con = null)
    {
        $this->clearPolicyGuidelines();
        $currentPolicyGuidelines = $this->getPolicyGuidelines();

        $this->policyGuidelinesScheduledForDeletion = $currentPolicyGuidelines->diff($policyGuidelines);

        foreach ($policyGuidelines as $policyGuideline) {
            if (!$currentPolicyGuidelines->contains($policyGuideline)) {
                $this->doAddPolicyGuideline($policyGuideline);
            }
        }

        $this->collPolicyGuidelines = $policyGuidelines;
    }

    /**
     * Gets the number of PolicyGuideline objects related by a many-to-many relationship
     * to the current object by way of the objectives_policyGuidelineIndicators cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related PolicyGuideline objects
     */
    public function countPolicyGuidelines($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collPolicyGuidelines || null !== $criteria) {
            if ($this->isNew() && null === $this->collPolicyGuidelines) {
                return 0;
            } else {
                $query = PolicyGuidelineQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByIndicator($this)
                    ->count($con);
            }
        } else {
            return count($this->collPolicyGuidelines);
        }
    }

    /**
     * Associate a PolicyGuideline object to this object
     * through the objectives_policyGuidelineIndicators cross reference table.
     *
     * @param  PolicyGuideline $policyGuideline The PolicyGuidelineIndicators object to relate
     * @return void
     */
    public function addPolicyGuideline(PolicyGuideline $policyGuideline)
    {
        if ($this->collPolicyGuidelines === null) {
            $this->initPolicyGuidelines();
        }
        if (!$this->collPolicyGuidelines->contains($policyGuideline)) { // only add it if the **same** object is not already associated
            $this->doAddPolicyGuideline($policyGuideline);

            $this->collPolicyGuidelines[]= $policyGuideline;
        }
    }

    /**
     * @param	PolicyGuideline $policyGuideline The policyGuideline object to add.
     */
    protected function doAddPolicyGuideline($policyGuideline)
    {
        $policyGuidelineIndicators = new PolicyGuidelineIndicators();
        $policyGuidelineIndicators->setPolicyGuideline($policyGuideline);
        $this->addPolicyGuidelineIndicators($policyGuidelineIndicators);
    }

    /**
     * Remove a PolicyGuideline object to this object
     * through the objectives_policyGuidelineIndicators cross reference table.
     *
     * @param PolicyGuideline $policyGuideline The PolicyGuidelineIndicators object to relate
     * @return void
     */
    public function removePolicyGuideline(PolicyGuideline $policyGuideline)
    {
        if ($this->getPolicyGuidelines()->contains($policyGuideline)) {
            $this->collPolicyGuidelines->remove($this->collPolicyGuidelines->search($policyGuideline));
            if (null === $this->policyGuidelinesScheduledForDeletion) {
                $this->policyGuidelinesScheduledForDeletion = clone $this->collPolicyGuidelines;
                $this->policyGuidelinesScheduledForDeletion->clear();
            }
            $this->policyGuidelinesScheduledForDeletion[]= $policyGuideline;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->description = null;
        $this->archived = null;
        $this->methodology = null;
        $this->decimals = null;
        $this->goal = null;
        $this->goaldate = null;
        $this->idealbehavior = null;
        $this->positionid = null;
        $this->objectiveid = null;
        $this->duedate = null;
        $this->finisheddate = null;
        $this->classkey = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collIndicatorValues) {
                foreach ($this->collIndicatorValues as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collIndicatorGraphSeries) {
                foreach ($this->collIndicatorGraphSeries as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collPolicyGuidelineIndicatorss) {
                foreach ($this->collPolicyGuidelineIndicatorss as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjects) {
                foreach ($this->collProjects as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collIndicatorGraphs) {
                foreach ($this->collIndicatorGraphs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collPolicyGuidelines) {
                foreach ($this->collPolicyGuidelines as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collIndicatorValues instanceof PropelCollection) {
            $this->collIndicatorValues->clearIterator();
        }
        $this->collIndicatorValues = null;
        if ($this->collIndicatorGraphSeries instanceof PropelCollection) {
            $this->collIndicatorGraphSeries->clearIterator();
        }
        $this->collIndicatorGraphSeries = null;
        if ($this->collPolicyGuidelineIndicatorss instanceof PropelCollection) {
            $this->collPolicyGuidelineIndicatorss->clearIterator();
        }
        $this->collPolicyGuidelineIndicatorss = null;
        if ($this->collProjects instanceof PropelCollection) {
            $this->collProjects->clearIterator();
        }
        $this->collProjects = null;
        if ($this->collIndicatorGraphs instanceof PropelCollection) {
            $this->collIndicatorGraphs->clearIterator();
        }
        $this->collIndicatorGraphs = null;
        if ($this->collPolicyGuidelines instanceof PropelCollection) {
            $this->collPolicyGuidelines->clearIterator();
        }
        $this->collPolicyGuidelines = null;
        $this->aPosition = null;
        $this->aObjective = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
