|-if !is_object($campaign)-|
<span class="resultFailure">No se encontró la campaña</span>
|-else-|
<link type="text/css" rel="stylesheet" href="css/twitterMenu.css" />
<link href="scripts/nvd3/nv.d3.css" rel="stylesheet" type="text/css">

<script src="scripts/d3.v3.min.js" charset="utf-8"></script>
<!--Para timeline-->
<script src="scripts/nvd3/nv.d3.js"></script>
<script src="scripts/nvd3/src/tooltip.js"></script>
<script src="scripts/nvd3/src/utils.js"></script>
<script src="scripts/nvd3/src/models/legend.js"></script>
<script src="scripts/nvd3/src/models/axis.js"></script>
<script src="scripts/nvd3/src/models/scatter.js"></script>
<script src="scripts/nvd3/src/models/line.js"></script>
<script src="scripts/nvd3/src/models/lineWithFocusChart.js"></script>
<script src="scripts/nvd3/examples/stream_layers.js"></script>
<script src="scripts/venn.js" charset="utf-8"></script>

<script src="scripts/widgets.js" charset="utf-8"></script>
<script src="Main.php?do=js&name=campaignsChartsJs&module=headlines&code=|-$currentLanguageCode-|" type="text/javascript"></script>

<h2>Reportes</h2>
<h1>Reportes de Campaña</h1>
<p>Análisis de la Campaña "|-$campaign->getName()-|"</p>
<div id="reportContainer">
	<div id='panelDiv'>
	<ul>
	   <li class='active' id='removeFilters'><button onclick='removeFilters(); return false;'><span>Eliminar Filtros</span></button></li>
	   <li class='active' id='exportData'><button onclick='generateReport(); return false;'><span>Exportar</span></button></li>
	   <li class='has-sub'>
	     <button><span>Tiempo</span></button>
		  <ul>
			 <li><button onclick="$('.timeSelected').not(this).removeClass('timeSelected');$(this).toggleClass('timeSelected'); $('#customDate').hide(); setValueX(); return false;" value="- 12 hours"><span>Ultimas 12 horas</span></button></li>
			 <li><button onclick="$('.timeSelected').not(this).removeClass('timeSelected');$(this).toggleClass('timeSelected'); $('#customDate').hide(); setValueX(); return false;" value="- 24 hours"><span>Ultimas 24 horas</span></button></li>
			 <li><button onclick="$('.timeSelected').not(this).removeClass('timeSelected');$(this).toggleClass('timeSelected'); $('#customDate').hide(); setValueX(); return false;" value="- 7 days"><span>Ultimos 7 días</span></button></li>
			 <li><button onclick="$('.timeSelected').not(this).removeClass('timeSelected');$(this).toggleClass('timeSelected'); $('#customDate').hide(); setValueX(); return false;" value="- 15 days"><span>Ultimos 15 días</span></button></li>
			 <li><button onclick="$('.timeSelected').not(this).removeClass('timeSelected');$(this).toggleClass('timeSelected'); $('#customDate').toggle(); return false;" value="custom"><span>Personalizar</span></button>
			 <div id="customDate" style="display: none;">
				<input type="text" name="from" id="dateFrom" value="">
				<input type="text" name="to" id="dateTo" value="">
			 </div>
			 </li>
			 <li class='last'><button id="time" class="timeSelected" onclick="$('.timeSelected').not(this).removeClass('timeSelected');$(this).addClass('timeSelected'); $('#customDate').hide();setValueX(); return false;" value=""><span>Toda la campaña</span></button></li>
		  </ul>
	   </li>
	   <li class='has-sub last'><button><span>Tipos</span></button>
		  <ul>
			 <li><button onclick="$('.typeSelected').not(this).removeClass('typeSelected');$(this).toggleClass('typeSelected');setValueX(); return false;" value="1"><span>Originales</span></button></li>
			 <li><button onclick="$('.typeSelected').not(this).removeClass('typeSelected');$(this).toggleClass('typeSelected');setValueX(); return false;" value="2"><span>Retweets</span></button></li>
			 <li><button onclick="$('.typeSelected').not(this).removeClass('typeSelected');$(this).toggleClass('typeSelected');setValueX(); return false;" value="3"><span>Respuestas</span></button></li>
			 <li class='last'><button id="type" class="typeSelected" onclick="$('.typeSelected').not(this).removeClass('typeSelected');$(this).addClass('typeSelected');setValueX(); return false;" value=""><span>Todos</span></button></li>
		  </ul>
	   </li>
	   <li class='has-sub last'><button><span>Valoración</span></button>
		  <ul id="valueFilters">
			|-foreach from=$tweetValues key=key item=val-|
			 <li><button onclick="$('.valueSelected').not(this).removeClass('valueSelected');$(this).toggleClass('valueSelected');setValueX(); return false;" value="|-$key-|"><span>|-$val-|</span></button></li>
			 |-/foreach-|
			 <li class='last'><button id="value" class="valueSelected" onclick="$('.valueSelected').not(this).removeClass('valueSelected');$(this).addClass('valueSelected');setValueX(); return false;" value=""><span>Todos</span></button></li>
		  </ul>
	   </li>
	   <li class='has-sub last'><button><span>Relevancia</span></button>
		  <ul>
			 |-foreach from=$tweetRelevances key=key item=rel-|
			 <li><button onclick="$('.relevanceSelected').not(this).removeClass('relevanceSelected');$(this).toggleClass('relevanceSelected');setValueX(); return false;" value="|-$key-|"><span>|-$rel-|</span></button></li>
			 |-/foreach-|
			 <li class='last'><button id="relevance" class="relevanceSelected" onclick="$('.relevanceSelected').not(this).removeClass('relevanceSelected');$(this).addClass('relevanceSelected');setValueX(); return false;" value=""><span>Todos</span></button></li>
		  </ul>
	   </li>
		  <ul id="photoFilters">
			 <li><button onclick="$('.photoSelected').not(this).removeClass('photoSelected');$(this).toggleClass('photoSelected');setValueX(); return false;" value="male"><span>No</span></button></li>
			 <li><button onclick="$('.photoSelected').not(this).removeClass('photoSelected');$(this).toggleClass('photoSelected');setValueX(); return false;" value="female"><span>Si</span></button></li>
			 <li class='last'><button id="value" class="photoSelected" onclick="$('.photoSelected').not(this).removeClass('photoSelected');$(this).addClass('photoSelected');setValueX(); return false;" value=""><span>Todos</span></button></li>
		  </ul>
	   </li>	</ul>
	</div>
	<div id="content">
	  |-include file="HeadlinesCampaignsReportInclude.tpl"-|
	</div>

<script type="text/javascript">
	var startDateTextBox = $('#dateFrom');
	var endDateTextBox = $('#dateTo');
	
	startDateTextBox.datetimepicker({ 
		dateFormat: 'dd-mm-yy',
		timeFormat: 'HH:mm',
		onClose: function(dateText, inst) {
			if (endDateTextBox.val() != '') {
				var testStartDate = startDateTextBox.datetimepicker('getDate');
				var testEndDate = endDateTextBox.datetimepicker('getDate');
				if (testStartDate > testEndDate)
					endDateTextBox.datetimepicker('setDate', testStartDate);
			}
			else {
				endDateTextBox.val(dateText);
			}
		},
		onSelect: function (selectedDateTime){
			endDateTextBox.datetimepicker('option', 'minDate', startDateTextBox.datetimepicker('getDate') );
		}
	}).attr('readonly', 'readonly').css('backgroundColor', '#FFF');
	endDateTextBox.datetimepicker({
		dateFormat: 'dd-mm-yy', 
		timeFormat: 'HH:mm',
		onClose: function(dateText, inst) {
			if (startDateTextBox.val() != '') {
				var testStartDate = startDateTextBox.datetimepicker('getDate');
				var testEndDate = endDateTextBox.datetimepicker('getDate');
				if (testStartDate > testEndDate)
					startDateTextBox.datetimepicker('setDate', testEndDate);
			}
			else {
				startDateTextBox.val(dateText);
			}
			setValueX();
		},
		onSelect: function (selectedDateTime){
			startDateTextBox.datetimepicker('option', 'maxDate', endDateTextBox.datetimepicker('getDate') );
		}
	}).attr('readonly', 'readonly').css('backgroundColor', '#FFF');

	function setValueX() {
		var val = $('.valueSelected').val();
		var rel = $('.relevanceSelected').val();
		var type = $('.typeSelected').val();
		var time = $('.timeSelected').val();
		var gender = $('.genderSelected').val();
		if(time == 'custom'){
			var from = $('#dateFrom').val();
			var to = $('#dateTo').val();
		}
		var personal = $('.personalizedSelected').text();
		var personalFilter = $('.ttFilterSelected').text();
		
		$.ajax({
			url: 'Main.php?do=headlinesCampaignsReportFilterX',
			data: {id: '|-$campaign->getId()-|', value: val, relevance: rel, type: type, time: time, from: from, to: to, tt: personal, ttFilter: personalFilter, gender: gender},
			type: 'post',
			success: function(data){
				$('#content').html(data);
			}	
		});
		$('#reportMessage').html('<span class="inProgress">... Actualizando Datos ...</span>');
	}
	
	function removeFilters() {
		$('.valueSelected, .relevanceSelected, .typeSelected, .timeSelected').removeClass();
		$('#time, #value, #relevance, #type').addClass(function(){ return $(this).attr('id') + 'Selected'; })
		
		$('#customDate').hide();
		$.ajax({
			url: 'Main.php?do=headlinesCampaignsReportFilterX',
			data: {id: '|-$campaign->getId()-|'},
			type: 'post',
			success: function(data){
				$('#content').html(data);
			}	
		});
		$('#reportMessage').html('<span class="inProgress">... Actualizando Datos ...</span>');
	}
	
	function generateReport(){
		$('#toReport').remove();
		
		var newForm = $('<form>', {
			'action': 'Main.php',
			'target': '_blank',
			'method': 'post',
			'id': 'toReport'
		});
		
		if($('.timeSelected').val() == 'custom'){
			newForm.append($('<input>', {'name': 'from','value': $('#dateFrom').val(),'type': 'hidden'}))
			.append($('<input>', {'name': 'to','value': $('#dateTo').val(),'type': 'hidden'}));
		}
		
		newForm.append($('<input>', {'name': 'do','value': 'twitterReportView','type': 'hidden'}))
		.append($('<input>', {'name': 'value','value': $('.valueSelected').val(),'type': 'hidden'}))
		.append($('<input>', {'name': 'relevance','value': $('.relevanceSelected').val(),'type': 'hidden'}))
		.append($('<input>', {'name': 'time','value': $('.timeSelected').val(),'type': 'hidden'}))
		.append($('<input>', {'name': 'type','value': $('.typeSelected').val(),'type': 'hidden'}))
		.append($('<input>', {'name': 'filters[campaignid]','value': '|-$campaign->getId()-|','type': 'hidden'}))
		.append($('<input>', {'name': 'tt','value': $('.personalizedSelected').text(),'type': 'hidden'}));
		$('body').append(newForm);
		
		newForm.submit();
	}

</script>
|-/if-|
</div>
