<?php


/**
 * Base class that represents a query for the 'headlines_relation' table.
 *
 * Tabla de relaciones de titulares
 *
 * @method HeadlineRelationQuery orderByHeadline1($order = Criteria::ASC) Order by the headline_1 column
 * @method HeadlineRelationQuery orderByHeadline2($order = Criteria::ASC) Order by the headline_2 column
 *
 * @method HeadlineRelationQuery groupByHeadline1() Group by the headline_1 column
 * @method HeadlineRelationQuery groupByHeadline2() Group by the headline_2 column
 *
 * @method HeadlineRelationQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method HeadlineRelationQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method HeadlineRelationQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method HeadlineRelationQuery leftJoinHeadlineRelatedByHeadline1($relationAlias = null) Adds a LEFT JOIN clause to the query using the HeadlineRelatedByHeadline1 relation
 * @method HeadlineRelationQuery rightJoinHeadlineRelatedByHeadline1($relationAlias = null) Adds a RIGHT JOIN clause to the query using the HeadlineRelatedByHeadline1 relation
 * @method HeadlineRelationQuery innerJoinHeadlineRelatedByHeadline1($relationAlias = null) Adds a INNER JOIN clause to the query using the HeadlineRelatedByHeadline1 relation
 *
 * @method HeadlineRelationQuery leftJoinHeadlineRelatedByHeadline2($relationAlias = null) Adds a LEFT JOIN clause to the query using the HeadlineRelatedByHeadline2 relation
 * @method HeadlineRelationQuery rightJoinHeadlineRelatedByHeadline2($relationAlias = null) Adds a RIGHT JOIN clause to the query using the HeadlineRelatedByHeadline2 relation
 * @method HeadlineRelationQuery innerJoinHeadlineRelatedByHeadline2($relationAlias = null) Adds a INNER JOIN clause to the query using the HeadlineRelatedByHeadline2 relation
 *
 * @method HeadlineRelation findOne(PropelPDO $con = null) Return the first HeadlineRelation matching the query
 * @method HeadlineRelation findOneOrCreate(PropelPDO $con = null) Return the first HeadlineRelation matching the query, or a new HeadlineRelation object populated from the query conditions when no match is found
 *
 * @method HeadlineRelation findOneByHeadline1(int $headline_1) Return the first HeadlineRelation filtered by the headline_1 column
 * @method HeadlineRelation findOneByHeadline2(int $headline_2) Return the first HeadlineRelation filtered by the headline_2 column
 *
 * @method array findByHeadline1(int $headline_1) Return HeadlineRelation objects filtered by the headline_1 column
 * @method array findByHeadline2(int $headline_2) Return HeadlineRelation objects filtered by the headline_2 column
 *
 * @package    propel.generator.headlines.classes.om
 */
abstract class BaseHeadlineRelationQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseHeadlineRelationQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'HeadlineRelation', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new HeadlineRelationQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param   HeadlineRelationQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return HeadlineRelationQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof HeadlineRelationQuery) {
            return $criteria;
        }
        $query = new HeadlineRelationQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$headline_1, $headline_2]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   HeadlineRelation|HeadlineRelation[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = HeadlineRelationPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(HeadlineRelationPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return                 HeadlineRelation A model object, or null if the key is not found
     * @throws PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `headline_1`, `headline_2` FROM `headlines_relation` WHERE `headline_1` = :p0 AND `headline_2` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new HeadlineRelation();
            $obj->hydrate($row);
            HeadlineRelationPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return HeadlineRelation|HeadlineRelation[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|HeadlineRelation[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return HeadlineRelationQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(HeadlineRelationPeer::HEADLINE_1, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(HeadlineRelationPeer::HEADLINE_2, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return HeadlineRelationQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(HeadlineRelationPeer::HEADLINE_1, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(HeadlineRelationPeer::HEADLINE_2, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the headline_1 column
     *
     * Example usage:
     * <code>
     * $query->filterByHeadline1(1234); // WHERE headline_1 = 1234
     * $query->filterByHeadline1(array(12, 34)); // WHERE headline_1 IN (12, 34)
     * $query->filterByHeadline1(array('min' => 12)); // WHERE headline_1 >= 12
     * $query->filterByHeadline1(array('max' => 12)); // WHERE headline_1 <= 12
     * </code>
     *
     * @see       filterByHeadlineRelatedByHeadline1()
     *
     * @param     mixed $headline1 The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineRelationQuery The current query, for fluid interface
     */
    public function filterByHeadline1($headline1 = null, $comparison = null)
    {
        if (is_array($headline1)) {
            $useMinMax = false;
            if (isset($headline1['min'])) {
                $this->addUsingAlias(HeadlineRelationPeer::HEADLINE_1, $headline1['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($headline1['max'])) {
                $this->addUsingAlias(HeadlineRelationPeer::HEADLINE_1, $headline1['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlineRelationPeer::HEADLINE_1, $headline1, $comparison);
    }

    /**
     * Filter the query on the headline_2 column
     *
     * Example usage:
     * <code>
     * $query->filterByHeadline2(1234); // WHERE headline_2 = 1234
     * $query->filterByHeadline2(array(12, 34)); // WHERE headline_2 IN (12, 34)
     * $query->filterByHeadline2(array('min' => 12)); // WHERE headline_2 >= 12
     * $query->filterByHeadline2(array('max' => 12)); // WHERE headline_2 <= 12
     * </code>
     *
     * @see       filterByHeadlineRelatedByHeadline2()
     *
     * @param     mixed $headline2 The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineRelationQuery The current query, for fluid interface
     */
    public function filterByHeadline2($headline2 = null, $comparison = null)
    {
        if (is_array($headline2)) {
            $useMinMax = false;
            if (isset($headline2['min'])) {
                $this->addUsingAlias(HeadlineRelationPeer::HEADLINE_2, $headline2['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($headline2['max'])) {
                $this->addUsingAlias(HeadlineRelationPeer::HEADLINE_2, $headline2['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlineRelationPeer::HEADLINE_2, $headline2, $comparison);
    }

    /**
     * Filter the query by a related Headline object
     *
     * @param   Headline|PropelObjectCollection $headline The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return                 HeadlineRelationQuery The current query, for fluid interface
     * @throws PropelException - if the provided filter is invalid.
     */
    public function filterByHeadlineRelatedByHeadline1($headline, $comparison = null)
    {
        if ($headline instanceof Headline) {
            return $this
                ->addUsingAlias(HeadlineRelationPeer::HEADLINE_1, $headline->getId(), $comparison);
        } elseif ($headline instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(HeadlineRelationPeer::HEADLINE_1, $headline->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByHeadlineRelatedByHeadline1() only accepts arguments of type Headline or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the HeadlineRelatedByHeadline1 relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return HeadlineRelationQuery The current query, for fluid interface
     */
    public function joinHeadlineRelatedByHeadline1($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('HeadlineRelatedByHeadline1');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'HeadlineRelatedByHeadline1');
        }

        return $this;
    }

    /**
     * Use the HeadlineRelatedByHeadline1 relation Headline object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   HeadlineQuery A secondary query class using the current class as primary query
     */
    public function useHeadlineRelatedByHeadline1Query($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinHeadlineRelatedByHeadline1($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'HeadlineRelatedByHeadline1', 'HeadlineQuery');
    }

    /**
     * Filter the query by a related Headline object
     *
     * @param   Headline|PropelObjectCollection $headline The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return                 HeadlineRelationQuery The current query, for fluid interface
     * @throws PropelException - if the provided filter is invalid.
     */
    public function filterByHeadlineRelatedByHeadline2($headline, $comparison = null)
    {
        if ($headline instanceof Headline) {
            return $this
                ->addUsingAlias(HeadlineRelationPeer::HEADLINE_2, $headline->getId(), $comparison);
        } elseif ($headline instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(HeadlineRelationPeer::HEADLINE_2, $headline->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByHeadlineRelatedByHeadline2() only accepts arguments of type Headline or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the HeadlineRelatedByHeadline2 relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return HeadlineRelationQuery The current query, for fluid interface
     */
    public function joinHeadlineRelatedByHeadline2($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('HeadlineRelatedByHeadline2');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'HeadlineRelatedByHeadline2');
        }

        return $this;
    }

    /**
     * Use the HeadlineRelatedByHeadline2 relation Headline object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   HeadlineQuery A secondary query class using the current class as primary query
     */
    public function useHeadlineRelatedByHeadline2Query($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinHeadlineRelatedByHeadline2($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'HeadlineRelatedByHeadline2', 'HeadlineQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   HeadlineRelation $headlineRelation Object to remove from the list of results
     *
     * @return HeadlineRelationQuery The current query, for fluid interface
     */
    public function prune($headlineRelation = null)
    {
        if ($headlineRelation) {
            $this->addCond('pruneCond0', $this->getAliasedColName(HeadlineRelationPeer::HEADLINE_1), $headlineRelation->getHeadline1(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(HeadlineRelationPeer::HEADLINE_2), $headlineRelation->getHeadline2(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

    // equal_nest behavior

    /**
     * Filter the query by 2 Headline objects for a Equal Nest HeadlineRelation relation
     *
     * @param      Headline|integer $object1
     * @param      Headline|integer $object2
     * @return     HeadlineRelationQuery Fluent API
     */
    public function filterByHeadlines($object1, $object2)
    {
        return $this
            ->condition('first-one', 'HeadlineRelation.Headline1 = ?', is_object($object1) ? $object1->getPrimaryKey() : $object1)
            ->condition('first-two', 'HeadlineRelation.Headline2 = ?', is_object($object2) ? $object2->getPrimaryKey() : $object2)
            ->condition('second-one', 'HeadlineRelation.Headline2 = ?', is_object($object1) ? $object1->getPrimaryKey() : $object1)
            ->condition('second-two', 'HeadlineRelation.Headline1 = ?', is_object($object2) ? $object2->getPrimaryKey() : $object2)
            ->combine(array('first-one',  'first-two'),  'AND', 'first')
            ->combine(array('second-one', 'second-two'), 'AND', 'second')
            ->where(array('first', 'second'), 'OR');
    }

}
