<?php

class HeadlinesCampaignsReportFilterXAction extends BaseSelectAction {
	
	function __construct() {
		parent::__construct('Campaign');
	}
	
	protected function postSelect() {
		parent::postSelect();

		if(is_object($this->entity)){
			
			// armo el arreglo de filtros
			$headlinesFilters = array();
			
			$headlinesFilters['campaignId'] = $this->entity->getId();

			// obtengo el total de tweets para avisale al usuario en caso de que con los filtros no se obtengan datos
			$campaignHeadlinesCount = TwitterTweetQuery::create()->filterByCampaignId($headlinesFilters['campaignId'])->count();

			// si en la campaign hay tweets opero normalmente
			if($campaignHeadlinesCount > 0){
				// obtengo los graficos con los filtros indicados
//				$headlinesFilters['type'] = $_POST['type'];
				$headlinesFilters['value'] = $_POST['value'];
				$headlinesFilters['relevance'] = $_POST['relevance'];
				$headlinesFilters['personalized'] = $_POST['tt'];
//				$headlinesFilters['gender'] = $_POST['gender'];
				
				$this->smarty->assign('personalSelected', $_POST['tt']);
				$this->smarty->assign('selectedTTFilter', $_POST['ttFilter']);
				
				// si no es un rango de fechas custom
				if($_POST['time'] == 'custom' && isset($_POST['from']) && isset($_POST['to'])){
					$headlinesFilters['from'] = Common::getDatetimeOnGMT(date('Y-m-d H:i:s',strtotime($_POST['from']. ':00')));
					$headlinesFilters['to'] = Common::getDatetimeOnGMT(date('Y-m-d H:i:s',strtotime($_POST['to']. ':00')));
				}
				else{
					if(!empty($_POST['time']))
						$headlinesFilters['from'] = Common::getDatetimeOnGMT(date('Y-m-d H:i:s',strtotime($_POST['time'])));
					else
						$headlinesFilters['from'] = Common::getDatetimeOnGMT(date('Y-m-d H:i:s',strtotime($this->entity->getStartdate())));
					$headlinesFilters['to'] = Common::getDatetimeOnGMT(date('Y-m-d H:i:s'));
				}

				$this->smarty->assign('from',$headlinesFilters['from']);
				$this->smarty->assign('to',$headlinesFilters['to']);
				// FIN DATE FILTER SET

				// obtengo titulares por valor y relevancia
				$byValue = Headline::getAllByValue($headlinesFilters);
				foreach($byValue as $date) {
					unset($date['date']);
					$byValueTotal += array_sum($date);
				}
				$byRelevance = Headline::getAllByRelevance($headlinesFilters);
				foreach($byRelevance as $date) {
					unset($date['date']);
					$byRelevanceTotal += array_sum($date);
				}

				$this->smarty->assign('byValue', $byValue);
				$this->smarty->assign('byValueTotal', $byValueTotal);
				$this->smarty->assign('byRelevance', $byRelevance);
				$this->smarty->assign('byRelevanceTotal', $byRelevanceTotal);
				
				if($byValueTotal > 0 || $byRelevanceTotal > 0){

					$byGender = TwitterTweetQuery::getAllByGender($headlinesFilters);
					$this->smarty->assign('byGender', $byGender);
					
					// obtengo los usuarios que mas tweets crearon
					$topUsers = TwitterUserQuery::getTopUsers($headlinesFilters, 5);
					$influentialUsers = TwitterUserQuery::getInfluentialUsers($headlinesFilters);
					$vennData = TwitterTweetQuery::getVennData($headlinesFilters);
					$tweetsAmount = TwitterTweetQuery::getCombinations($headlinesFilters);
					/*echo"<pre>"; print_r($relevantUsers); echo"</pre>";
					die();*/
					$this->smarty->assign('topUsers', $topUsers);
					$this->smarty->assign('influentialUsers', $influentialUsers);
					$this->smarty->assign('vennData', $vennData);
					$this->smarty->assign('tweetsAmount', $tweetsAmount);
					
					/* Tendencias personalizadas */
				
					$treemapInfo = array();
					$personalTrends = TwitterTweet::getPersonalTrends($headlinesFilters, $treemapInfo);
					$this->smarty->assign("personalTrends", $personalTrends);
					$this->smarty->assign("treemapPersonalTrends", json_encode($treemapInfo));
					$dailyPersonalTrends = TwitterTweet::dailyPersonalTrends($headlinesFilters, $personalTrends);
					$this->smarty->assign('dailyPersonalTrends',json_encode($dailyPersonalTrends));
					$dailyTweets = TwitterTweet::dailyTweets($headlinesFilters);
					$this->smarty->assign('dailyTweets',json_encode($dailyTweets));
					
					$this->smarty->assign('headlinesCount',$campaignHeadlinesCount);
				}// FIN HAY VAL O REL
				else{
					$this->smarty->assign('availableTweets',true);
					$this->smarty->assign('totalTweets',$campaignHeadlinesCount);
				}
			}//FIN HAY T
			else{
				$this->smarty->assign('availableTweets',false);
			}
			
		}
		
	}

}
