<?php



/**
 * Skeleton subclass for representing a row from the 'construction_progress' table.
 *
 * Ejecucion fisico/financiera
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.constructions.classes
 */
class ConstructionProgress extends BaseConstructionProgress
{

	public function preSave() {
		if (!parent::preDelete()) return false;
		if ($this->isNew()) {
			$lastCertificateNumber = $this->getLastSiblingQuery()
				->select('CertificateNumber')
				->findOne();
			$this->setCertificateNumber($lastCertificateNumber + 1);
		}
		return true;
	}

	public function preDelete() {
		if (!parent::preDelete()) return false;
		if (!$this->isDeletable()) return false;
		return true;
	}

	/**
	 * Devuelve el acumulado para un campo.
	 * Se calcula como la suma de los valores de ese campo en cada 
	 * ConstructionProgress de la Construction asociada hasta $this
	 * 
	 * @param string $field
	 * @return number
	 */
	public function getAcummulated($field) {
		
		$acummulated = 0;
		$refYear = $this->getYear();
		$refMonth = $this->getMonth();
		$constructionId = $this->getConstructionid();
		
		$dateLessEqual = "(Year < $refYear OR (Year = $refYear AND Month <= $refMonth))";
		$constructionProgresses = ConstructionProgressQuery::create()
			->where("Constructionid = $constructionId AND $dateLessEqual")
			->find();

		foreach ($constructionProgresses as $constructionProgress) {
			$acummulated += $constructionProgress->getByName($field);
		}
		return $acummulated;
	}
	
	/**
	 * Devuelve el RealFinancialProgress acumulado.
	 * Se calcula como la suma de los valores de ese campo en cada 
	 * ConstructionProgress de la Construction asociada hasta $this
	 * 
	 * @return number
	 */
	public function getAcummulatedRealFinancialProgress() {
		return $this->getAcummulated('Realfinancialprogress');
	}
	
	/**
	 * Devuelve el RealPhysicalProgress acumulado.
	 * Se calcula como la suma de los valores de ese campo en cada 
	 * ConstructionProgress de la Construction asociada hasta $this
	 * 
	 * @return number
	 */
	public function getAcummulatedRealPhysicalProgress() {
		return $this->getAcummulated('Realphysicalprogress');
	}
	
	/**
	 * Devuelve el AcummulatedFinancialProgress acumulado.
	 * Se calcula como la suma de los valores de ese campo en cada 
	 * ConstructionProgress de la Construction asociada hasta $this
	 * 
	 * @return number
	 */
	public function getAcummulatedFinancialProgress() {
		return $this->getAcummulated('Financialprogress');
	}
	
	/**
	 * Devuelve el AcummulatedPhysicalProgress acumulado.
	 * Se calcula como la suma de los valores de ese campo en cada 
	 * ConstructionProgress de la Construction asociada hasta $this
	 * 
	 * @return number
	 */
	public function getAcummulatedPhysicalProgress() {
		return $this->getAcummulated('Physicalprogress');
	}

	/**
	 * Obtiene la diferencia de avance fisico del planificado vs real
	 */
	public function getFinancialDelta() {
		$delta = $this->getRealFinancialProgress() - $this->getFinancialProgress();
		return $delta;
	}

	/**
	 * Obtiene la diferencia de avance finaciero del planificado vs real
	 */
	public function getPhysicalDelta() {
		$delta = $this->getRealPhysicalProgress() - $this->getPhysicalProgress();
		return $delta;
	}

	protected function getLastSiblingQuery() {
		return ConstructionProgressQuery::create()
			->filterByConstructionId($this->getConstructionId())
			->order(Criteria::DESC);
	}

	public function isLastSibling() {
		$lastId = $this->getLastSiblingQuery()
			->select('Id')
			->findOne();
		return $this->getId() == $lastId;
	}

	public function isDeletable() {
		return $this->isLastSibling();
	}
}
