<?php



/**
 * Skeleton subclass for performing query and update operations on the 'campaign_campaign' table.
 *
 * Base de Campaigns
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.campaign.classes
 */
class CampaignPeer extends BaseCampaignPeer {

 /**
	* Crea un campaign nuevo.
	*
	* @param array $params con los datos del proyecto
	* @return boolean true si se creo el campaign correctamente, false sino
	*/
	function create($params,$con = null) {
		$campaign = new Campaign();
		$campaign = Common::setObjectFromParams($campaign,$params);
		try {
			$campaign->save($con);
			return $campaign->getId();
		}
		catch (PropelException $exp) {
			if (ConfigModule::get("global","showPropelExceptions"))
				print_r($exp->getMessage());
			return false;
		}
	}

	/**
	* Actualiza la informacion de un campaign.
	*
	* @param int $id id del campaign
	* @param array $params datos del campaign
	* @return boolean true si se actualizo la informacion correctamente, false sino
	*/
	function update($id,$params){
		$campaign = CampaignQuery::create()->findPk($id);
		$campaign = Common::setObjectFromParams($campaign,$params);
		try {
			$campaign->save($con);
			return true;
		}
		catch (PropelException $exp) {
			if (ConfigModule::get("global","showPropelExceptions"))
				print_r($exp->getMessage());
			return false;
		}
	}

 /**
	* Obtiene todos los campaign desactivados.
	*
	*	@return array Informacion sobre los campaign
	*/
	function getSoftDeleted() {
		$criteria = new Criteria();
		$criteria->add(CampaignPeer::DELETED_AT, null, Criteria::ISNOTNULL);
		CampaignPeer::disableSoftDelete();
		$campaigns = CampaignPeer::doSelect($criteria);
		return $campaigns;
  }

	/**
	* Recupera del softdelete un campaign
	*
	* @param int $id Id del campaign
	* @return boolean true
	*/
  function recoverDeleted($id) {
		CampaignPeer::disableSoftDelete();
		$campaign = CampaignPeer::retrieveByPk($id);
		try {
			$campaign->unDelete();
			return true;
		}
		catch (PropelException $exp) {
			if (ConfigModule::get("global","showPropelExceptions"))
				print_r($exp->getMessage());
			return false;
		}
	}
	
} // CampaignPeer
