<?php



/**
 * Skeleton subclass for representing a row from the 'campaign_campaign' table.
 *
 * Base de Campaigns
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.campaign.classes
 */
class Campaign extends BaseCampaign {

	/** the default item name for this class */
	const ITEM_NAME = 'Campaign';

	const RELEASE            = 1;
	const PUBLIC_APPEREANCE  = 2;
	const INTERVIEW          = 3;
	const SPONSOR            = 4; 
	const JUDGE              = 5;
	const EARNED             = 6;

	// Nota: el id de tipo debe ser potencia de dos
	const HEADLINES			 = 1;
	const TWITTER			 = 2;

	//nombre de los tipos de garantia
	protected static $campaignTypes = array(
						Campaign::RELEASE            => 'Release',
						Campaign::PUBLIC_APPEREANCE  => 'Public Appereance',
						Campaign::INTERVIEW          => 'Interview',
						Campaign::SPONSOR            => 'Sponsor',
						Campaign::JUDGE              => 'Judge',
						Campaign::EARNED             => 'Earned'
					);

	//nombre de los tipos de fuentes de informacion de la campaign
	protected static $campaignSourceTypes = array(
						Campaign::HEADLINES          => 'Titulares',
						Campaign::TWITTER 			 => 'Twitter',
					);

	/**
	 * Devuelve los tipos de campaign
	 */
	public static function getCampaignTypes() {
		return Campaign::$campaignTypes;
	}

	/**
	* Obtiene el nombre traducido del tipo de rol.
	*
	* @return array tipos de rol traducido
	*/
	function getCampaignTypesTranslated() {
		$types = Campaign::getCampaignTypes();
		foreach ($types as $type)
			$type[1] = Common::getTranslatedArray($type[1],'campaigns');
		return $types;
	}

	/**
	 * Devuelve los tipos de fuentes de informacion
	 */
	public static function getCampaignSourceTypes() {
		return Campaign::$campaignSourceTypes;
	}

	/**
	* Obtiene el nombre traducido del tipo de campaign.
	*
	* @return string nombre del tipo
	*/
	function getTypeTranslated() {
		$types = Campaign::getCampaignTypes();
		return Common::getTranslation($types[$this->getType()],'campaigns');
	}

	/**
	* Obtiene el id de todas las categoras asignadas.
	*
	*	@return array Id de todos los actor category asignados
	*/
	function getAssignedActorsArray(){
		return CampaignParticipantQuery::create()->filterByCampaign($this)->filterByObjecttype('actor')->select('Objectid')->find()->toArray();
	}

	/**
	* Obtiene el id de todas las categoras asignadas.
	*
	*	@return array Id de todos los actor category asignados
	*/
	function getAssignedUsersArray(){
		return CampaignParticipantQuery::create()->filterByCampaign($this)->filterByObjecttype('user')->select('Objectid')->find()->toArray();
	}

	/**
	* Obtiene el id de todas las categoras asignadas.
	*
	*	@return array Id de todos los actor category asignados
	*/
	function getAssignedClientsArray(){
		return CampaignParticipantQuery::create()->filterByCampaign($this)->filterByObjecttype('client')->select('Objectid')->find()->toArray();
	}

	/**
	* Obtiene el cliente
	*
	* @return objeto cliente
	*/
	function getClient() {
		if (class_exists("ClientQuery")) {
			$client = ClientQuery::create()->findOneById($this->getClientId());
			return $client;
		}
		else
			return;
	}

	/**
	* Crea el identificador de fuentes de informacion
	*	@param $sources: arreglo de fuentes (cada una es potencia de dos)
	*	@return identificador de fuentes
	*/
	public static function createSource($sources){
		$sum = 0;
		foreach ($sources as $sourceKey => $isSource) {
			$sum += $sourceKey;	
		}

		return $sum;
	}

	/**
	* Obtiene las fuentes de informacion de la campaign
	*
	*	@return arreglo de fuentes
	*/
	public function getSourcesArray(){
		$sourcesSum = $this->getSources();

		$campaignSources = array();
		$types = Campaign::$campaignSourceTypes;
		// bitwise and entre cada tipo de fuente y el binario correspondiente a la campaign
		foreach ($types as $source => $value) {
			if(($source & $sourcesSum))
				$campaignSources[] = $source;
		}

		return $campaignSources;
	}

	/**
	* Indica si una fuente es fuente de la campaign
	*	@param $source: tipo de fuente
	*	@return bool
	*/
	public function hasSource($source){
		return $this->getSources() & $source;
	}

	/**
	* Elimina definitivamente un campaign a partir del id.
	*
	* @param int $id Id del campaign
	* @return boolean true
	*/
  	function hardDelete($id) {
		CampaignPeer::disableSoftDelete();
		$campaign = CampaignQuery::create()->findOneById($id);
		try {
			$campaign->forceDelete();
			return true;
		}
		catch (PropelException $exp) {
			if (ConfigModule::get("global","showPropelExceptions"))
				print_r($exp->getMessage());
			return false;
		}
	}

} // Campaign
