<?php

namespace Egytca;

use BadMethodCallException;

trait VirtualColumns {

	private $_virtualColumns_virtualColumns = [];

	function addVirtualColumn($name, $getter) {
		if (!$name)
			throw new BadMethodCallException('parameter $name is missing');
		if (!$getter)
			throw new BadMethodCallException('parameter $getter is missing');
		$this->_virtualColumns_virtualColumns[] = ['name' => $name, 'getter' => $getter];
	}

	function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true,
					$alreadyDumpedObjects = [], $includeForeignObjects = false) {

		$array = parent::toArray($keyType, $includeLazyLoadColumns, $alreadyDumpedObjects, $includeForeignObjects);

		if ($array === '*RECURSION*')
			return $array;

		foreach ($this->_virtualColumns_virtualColumns as $virtualColumn) {
			$normalizedName = ucfirst(strtolower($virtualColumn['name']));
			$getter = $virtualColumn['getter'];
			$array[$normalizedName] = $this->$getter();
		}
		return $array;
	}
}