<?php

namespace Egytca\Status;

use Egytca\PropelRelationsConfig;

trait DescendantFilters {

	private function configDescendantFilters(PropelRelationsConfig $propelRelationsConfig) {
		$this->propelRelationsConfig = $propelRelationsConfig;
	}

	function filterByUnmetDueDate($value, $comparison = null) {
		$first = true;
		$useDescendantQueryFns = $this->propelRelationsConfig->getUseDescendantQueryFns();
		foreach ($useDescendantQueryFns as $useDescendantQueryFn) {

			if (!$first)
				$this->_or();

			$this->$useDescendantQueryFn()
					->filterByUnmetDueDate($value, $comparison)
				->endUse();

			$first = false;
		}
		$this->_and(); // TODO parece que queda seteado el _or sino... averiguar
		return $this->distinct();
	}
}
