<?php

namespace Egytca\Statements;

use Exception;

abstract class Statement {

	private $operator;
	private $operatorMap;

	function __construct($operator, $operatorMap) {
		if (!is_array($operatorMap))
			throw new Exception('operator map must be defined');
		if (!array_key_exists($operator, $operatorMap))
			throw new Exception("operator is not defined: '$operator'");
		$this->operator = $operator;
		$this->operatorMap = $operatorMap;
	}

	abstract function toString();

	abstract function invert();

	protected function getOperator() {
		return $this->operator;
	}

	protected function invertOperator() {
		if (!array_key_exists($this->operator, $this->operatorMap))
			throw new Exception("inverse operation is not defined for '$operator'");
		$this->operator = $this->operatorMap[$this->operator];
	}


	// TODO eliminar acoplamiento?
	function andWith(Statement $other) {
		return Factory::create($this, 'AND', $other);
	}

	// TODO eliminar acoplamiento?
	function orWith(Statement $other) {
		return Factory::create($this, 'OR', $other);
	}
}
