<?php

//namespace Egytca;

/**
 * Propel error parser used by Robo task manager.
 *
 * @package Egytca
 */
class PropelErrorParser {
	
	// list of possible propel errors
	protected $errorTypes = [
		'Unknown database' => 'Database doesnt exist.',
		'Access denied' => 'Database User / Password incorrect',
		'DOMDocument::schemaValidate' => 'Verify the schema file',
		'sql-template' => 'Invalid schema syntax',
	];

	/**
	 * Parse propel error log and return a human redable error.
	 * @param  string $errorMsg Error log
	 * @return string           Human redable error.
	 */
	function parse($errorMsg) {

		foreach (array_keys($this->errorTypes) as $error) {
			if (strrpos($errorMsg, $error)) {
				return $this->errorTypes[$error];
				break;
			}
		}
		return 'No error found';
	}

}