<?php

namespace Egytca\ParamChecker\Conditions;

use Exception;

class IndividualOrArrayCondition extends Condition {

	private $tester;

	function __construct($tester, $failureMessage) {
		$this->tester = $tester;
		if ($failureMessage)
			$this->failureMessage = $failureMessage;
	}

	function test($value) {
		if (is_array($value)) {
			foreach ($value as $item) {
				if (!$this->individualTest($item))
					return false;
			}
			return true;
		} else {
			return $this->individualTest($value);
		}
	}

	function individualTest($value) {
		if ($this->tester instanceof Condition) {
			return $this->tester->test($value);
		} else if (is_callable($this->tester)) {
			$tester = $this->tester;
			return $tester($value);
		} else {
			throw new Exception('invalid tester');
		}
	}

	function getFailureMessage($paramDescriptor) {
		if ($this->tester instanceof Condition) {
			return 'parameter must be a single value or an array passing the condition: '
				.$this->tester->getFailureMessage($paramDescriptor);
		} else {
			return parent::getFailureMessage($paramDescriptor);
		}
	}
}