<?php

namespace Egytca;

class HTTPError {

	const BAD_REQUEST           = '400';
	const UNAUTHORIZED          = '401';
	const FORBIDDEN             = '403';
	const NOT_FOUND             = '404';
	const CONFLICT              = '409';
	const INTERNAL_SERVER_ERROR = '500';
	const UNAVAILABLE           = '503';

	private static $errorMessages = [
		self::BAD_REQUEST => 'Bad Request',
		self::UNAUTHORIZED => 'Unauthorized',
		self::FORBIDDEN => 'Forbidden',
		self::NOT_FOUND => 'Not Found',
		self::CONFLICT => 'Conflict',
		self::INTERNAL_SERVER_ERROR => 'Internal Server Error',
		self::UNAVAILABLE => 'Unavailable'
	];

	static function errorMessage($errorCode) {
		return self::$errorMessages[$errorCode];
	}

	static function sendErrorHeader($errorCode = INTERNAL_SERVER_ERROR) {
		header('HTTP/1.1 ' . $errorCode . ' ' . self::$errorMessages[$errorCode]);
	}
}
