
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

-- ---------------------------------------------------------------------
-- regions_region
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `regions_region`;

CREATE TABLE `regions_region`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(100) NOT NULL COMMENT 'Name',
    `type` INTEGER(2) NOT NULL COMMENT 'Tipo de Region',
    `postalCode` INTEGER(6) COMMENT 'Postal Code',
    `latitude` DECIMAL(12,9) COMMENT 'latitud',
    `longitude` DECIMAL(12,9) COMMENT 'longitud',
    `population` DOUBLE COMMENT 'Habitantes',
    `populationYear` INTEGER COMMENT 'Fecha censo',
    `area` DOUBLE COMMENT 'Superficie',
    `capital` VARCHAR(100) COMMENT 'Capital (si aplica)',
    `tree_left` INTEGER,
    `tree_right` INTEGER,
    `tree_level` INTEGER,
    `scope` INTEGER,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `regions_region_U_1` (`name`, `type`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Regiones';

-- ---------------------------------------------------------------------
-- regions_timezone
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `regions_timezone`;

CREATE TABLE `regions_timezone`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(100) NOT NULL COMMENT 'Name',
    `label` VARCHAR(100) NOT NULL COMMENT 'Label',
    `tree_left` INTEGER,
    `tree_right` INTEGER,
    `tree_level` INTEGER,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `regions_timezone_U_1` (`name`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Regiones y Zonas';

-- ---------------------------------------------------------------------
-- regions_point
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `regions_point`;

CREATE TABLE `regions_point`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Id del punto',
    `regionId` INTEGER NOT NULL,
    `latitude` DECIMAL(12,9) COMMENT 'latitud',
    `longitude` DECIMAL(12,9) COMMENT 'longitud',
    PRIMARY KEY (`id`),
    INDEX `regions_point_FI_1` (`regionId`),
    CONSTRAINT `regions_point_FK_1`
        FOREIGN KEY (`regionId`)
        REFERENCES `regions_region` (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Puntos que conforman el perimetro de las regiones';

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
