
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

-- ---------------------------------------------------------------------
-- issues_issue
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `issues_issue`;

CREATE TABLE `issues_issue`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Id log',
    `name` VARCHAR(100) NOT NULL COMMENT 'Nombre del issue',
    `parentId` INTEGER COMMENT 'Id del parent issue',
    `description` MEDIUMTEXT COMMENT 'Descripcion del issue',
    `impact` INTEGER(5) COMMENT 'Impacto del issue',
    `valoration` INTEGER(5) COMMENT 'Valoracion del issue',
    `evolution` INTEGER(5) COMMENT 'Evolucion del issue',
    `objectType` VARCHAR(20) COMMENT 'Tipo de objeto de usuario',
    `objectId` INTEGER(5) COMMENT 'Id de objeto de usuario',
    `created_at` DATETIME,
    `updated_at` DATETIME,
    `deleted_at` DATETIME,
    `version` INTEGER DEFAULT 0,
    `version_created_by` VARCHAR(100),
    PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Asuntos';

-- ---------------------------------------------------------------------
-- issues_category
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `issues_category`;

CREATE TABLE `issues_category`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Category Id',
    `name` VARCHAR(100) NOT NULL COMMENT 'Category Name',
    `tree_left` INTEGER,
    `tree_right` INTEGER,
    `tree_level` INTEGER,
    `scope` INTEGER,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Categorias de Issues';

-- ---------------------------------------------------------------------
-- issues_issuesCategory
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `issues_issuesCategory`;

CREATE TABLE `issues_issuesCategory`
(
    `issueId` INTEGER(5) NOT NULL COMMENT 'Issue Id',
    `categoryId` INTEGER(5) NOT NULL COMMENT 'Category Id',
    PRIMARY KEY (`issueId`,`categoryId`),
    INDEX `issues_issuesCategory_FI_2` (`categoryId`),
    CONSTRAINT `issues_issuesCategory_FK_1`
        FOREIGN KEY (`issueId`)
        REFERENCES `issues_issue` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `issues_issuesCategory_FK_2`
        FOREIGN KEY (`categoryId`)
        REFERENCES `issues_category` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Relacion Issuees y Categorias';

-- ---------------------------------------------------------------------
-- issues_actors
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `issues_actors`;

CREATE TABLE `issues_actors`
(
    `issueId` INTEGER(5) NOT NULL COMMENT 'Issue Id',
    `actorId` INTEGER(5) NOT NULL COMMENT 'Category Id',
    PRIMARY KEY (`issueId`,`actorId`),
    INDEX `issues_actors_FI_2` (`actorId`),
    CONSTRAINT `issues_actors_FK_1`
        FOREIGN KEY (`issueId`)
        REFERENCES `issues_issue` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `issues_actors_FK_2`
        FOREIGN KEY (`actorId`)
        REFERENCES `actors_actor` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Relacion Issuees y Actores';

-- ---------------------------------------------------------------------
-- issues_issueLog
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `issues_issueLog`;

CREATE TABLE `issues_issueLog`
(
    `id` INTEGER NOT NULL COMMENT 'Id log',
    `name` VARCHAR(100) NOT NULL COMMENT 'Nombre del issue',
    `parentId` INTEGER COMMENT 'Id del parent issue',
    `description` MEDIUMTEXT COMMENT 'Descripcion del issue',
    `impact` INTEGER(5) COMMENT 'Impacto del issue',
    `valoration` INTEGER(5) COMMENT 'Valoracion del issue',
    `evolution` INTEGER(5) COMMENT 'Evolucion del issue',
    `objectType` VARCHAR(20) COMMENT 'Tipo de objeto de usuario',
    `objectId` INTEGER(5) COMMENT 'Id de objeto de usuario',
    `created_at` DATETIME,
    `updated_at` DATETIME,
    `deleted_at` DATETIME,
    `version` INTEGER DEFAULT 0 NOT NULL,
    `version_created_by` VARCHAR(100),
    PRIMARY KEY (`id`,`version`),
    CONSTRAINT `issues_issueLog_FK_1`
        FOREIGN KEY (`id`)
        REFERENCES `issues_issue` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
