<?php

/**
 * RegionsEditAction
 *
 * Edicion de regiones extendiendo BaseSelectAction
 *
 * @package regions
 */

class RegionsEditAction extends BaseSelectAction {

	function __construct($entityClassName = 'Region') {
		parent::__construct($entityClassName);
	}

	/**
	 * Acciones a ejecutar despues de obtener el objeto
	 */
	protected function postSelect() {
		parent::postSelect();

		//Campos activos del formulario
		$this->smarty->assign('activeFields', ConfigModule::get('regions', 'activeFields'));

		//Tipos de region
		$this->smarty->assign('regionTypes', Region::getRegionTypesTranslated());

		//Potenciales padres de la region
		$this->smarty->assign('possibleParents', $this->entity->getAllPossibleParents());

	}

}
