<?php


/**
 * Base class that represents a row from the 'projects_indicator' table.
 *
 * Indicator
 *
 * @package    propel.generator.projects.classes.om
 */
abstract class BaseProjectIndicator extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'ProjectIndicatorPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        ProjectIndicatorPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the projectid field.
     * @var        int
     */
    protected $projectid;

    /**
     * The value for the communeid field.
     * @var        int
     */
    protected $communeid;

    /**
     * The value for the regionid field.
     * @var        int
     */
    protected $regionid;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the expirationdate field.
     * @var        string
     */
    protected $expirationdate;

    /**
     * The value for the measureunitid field.
     * @var        int
     */
    protected $measureunitid;

    /**
     * The value for the notes field.
     * @var        string
     */
    protected $notes;

    /**
     * The value for the started field.
     * @var        boolean
     */
    protected $started;

    /**
     * The value for the startdate field.
     * @var        string
     */
    protected $startdate;

    /**
     * The value for the enddate field.
     * @var        string
     */
    protected $enddate;

    /**
     * The value for the actualprogress field.
     * @var        int
     */
    protected $actualprogress;

    /**
     * @var        Project
     */
    protected $aProject;

    /**
     * @var        Region
     */
    protected $aRegion;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * Get the [id] column value.
     * Indicator Id
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [projectid] column value.
     * Project Id
     * @return int
     */
    public function getProjectid()
    {
        return $this->projectid;
    }

    /**
     * Get the [communeid] column value.
     * Project Id
     * @return int
     */
    public function getCommuneid()
    {
        return $this->communeid;
    }

    /**
     * Get the [regionid] column value.
     * Project Id
     * @return int
     */
    public function getRegionid()
    {
        return $this->regionid;
    }

    /**
     * Get the [name] column value.
     * Indicator Name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [optionally formatted] temporal [expirationdate] column value.
     * Indicator Expiration Date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getExpirationdate($format = '%Y/%m/%d')
    {
        if ($this->expirationdate === null) {
            return null;
        }

        if ($this->expirationdate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->expirationdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->expirationdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [measureunitid] column value.
     * Measure Unit
     * @return int
     */
    public function getMeasureunitid()
    {
        return $this->measureunitid;
    }

    /**
     * Get the [notes] column value.
     * Project Notes
     * @return string
     */
    public function getNotes()
    {
        return $this->notes;
    }

    /**
     * Get the [started] column value.
     * is Indicator Started?
     * @return boolean
     */
    public function getStarted()
    {
        return $this->started;
    }

    /**
     * Get the [optionally formatted] temporal [startdate] column value.
     * Indicator Start Date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getStartdate($format = '%Y/%m/%d')
    {
        if ($this->startdate === null) {
            return null;
        }

        if ($this->startdate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->startdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->startdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [enddate] column value.
     * Indicator End Date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getEnddate($format = '%Y/%m/%d')
    {
        if ($this->enddate === null) {
            return null;
        }

        if ($this->enddate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->enddate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->enddate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [actualprogress] column value.
     * Indicator Actual Progress
     * @return int
     */
    public function getActualprogress()
    {
        return $this->actualprogress;
    }

    /**
     * Set the value of [id] column.
     * Indicator Id
     * @param int $v new value
     * @return ProjectIndicator The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = ProjectIndicatorPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [projectid] column.
     * Project Id
     * @param int $v new value
     * @return ProjectIndicator The current object (for fluent API support)
     */
    public function setProjectid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->projectid !== $v) {
            $this->projectid = $v;
            $this->modifiedColumns[] = ProjectIndicatorPeer::PROJECTID;
        }

        if ($this->aProject !== null && $this->aProject->getId() !== $v) {
            $this->aProject = null;
        }


        return $this;
    } // setProjectid()

    /**
     * Set the value of [communeid] column.
     * Project Id
     * @param int $v new value
     * @return ProjectIndicator The current object (for fluent API support)
     */
    public function setCommuneid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->communeid !== $v) {
            $this->communeid = $v;
            $this->modifiedColumns[] = ProjectIndicatorPeer::COMMUNEID;
        }


        return $this;
    } // setCommuneid()

    /**
     * Set the value of [regionid] column.
     * Project Id
     * @param int $v new value
     * @return ProjectIndicator The current object (for fluent API support)
     */
    public function setRegionid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->regionid !== $v) {
            $this->regionid = $v;
            $this->modifiedColumns[] = ProjectIndicatorPeer::REGIONID;
        }

        if ($this->aRegion !== null && $this->aRegion->getId() !== $v) {
            $this->aRegion = null;
        }


        return $this;
    } // setRegionid()

    /**
     * Set the value of [name] column.
     * Indicator Name
     * @param string $v new value
     * @return ProjectIndicator The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = ProjectIndicatorPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Sets the value of [expirationdate] column to a normalized version of the date/time value specified.
     * Indicator Expiration Date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectIndicator The current object (for fluent API support)
     */
    public function setExpirationdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->expirationdate !== null || $dt !== null) {
            $currentDateAsString = ($this->expirationdate !== null && $tmpDt = new DateTime($this->expirationdate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->expirationdate = $newDateAsString;
                $this->modifiedColumns[] = ProjectIndicatorPeer::EXPIRATIONDATE;
            }
        } // if either are not null


        return $this;
    } // setExpirationdate()

    /**
     * Set the value of [measureunitid] column.
     * Measure Unit
     * @param int $v new value
     * @return ProjectIndicator The current object (for fluent API support)
     */
    public function setMeasureunitid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->measureunitid !== $v) {
            $this->measureunitid = $v;
            $this->modifiedColumns[] = ProjectIndicatorPeer::MEASUREUNITID;
        }


        return $this;
    } // setMeasureunitid()

    /**
     * Set the value of [notes] column.
     * Project Notes
     * @param string $v new value
     * @return ProjectIndicator The current object (for fluent API support)
     */
    public function setNotes($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->notes !== $v) {
            $this->notes = $v;
            $this->modifiedColumns[] = ProjectIndicatorPeer::NOTES;
        }


        return $this;
    } // setNotes()

    /**
     * Sets the value of the [started] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * is Indicator Started?
     * @param boolean|integer|string $v The new value
     * @return ProjectIndicator The current object (for fluent API support)
     */
    public function setStarted($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->started !== $v) {
            $this->started = $v;
            $this->modifiedColumns[] = ProjectIndicatorPeer::STARTED;
        }


        return $this;
    } // setStarted()

    /**
     * Sets the value of [startdate] column to a normalized version of the date/time value specified.
     * Indicator Start Date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectIndicator The current object (for fluent API support)
     */
    public function setStartdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->startdate !== null || $dt !== null) {
            $currentDateAsString = ($this->startdate !== null && $tmpDt = new DateTime($this->startdate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->startdate = $newDateAsString;
                $this->modifiedColumns[] = ProjectIndicatorPeer::STARTDATE;
            }
        } // if either are not null


        return $this;
    } // setStartdate()

    /**
     * Sets the value of [enddate] column to a normalized version of the date/time value specified.
     * Indicator End Date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectIndicator The current object (for fluent API support)
     */
    public function setEnddate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->enddate !== null || $dt !== null) {
            $currentDateAsString = ($this->enddate !== null && $tmpDt = new DateTime($this->enddate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->enddate = $newDateAsString;
                $this->modifiedColumns[] = ProjectIndicatorPeer::ENDDATE;
            }
        } // if either are not null


        return $this;
    } // setEnddate()

    /**
     * Set the value of [actualprogress] column.
     * Indicator Actual Progress
     * @param int $v new value
     * @return ProjectIndicator The current object (for fluent API support)
     */
    public function setActualprogress($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->actualprogress !== $v) {
            $this->actualprogress = $v;
            $this->modifiedColumns[] = ProjectIndicatorPeer::ACTUALPROGRESS;
        }


        return $this;
    } // setActualprogress()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->projectid = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->communeid = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->regionid = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
            $this->name = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->expirationdate = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->measureunitid = ($row[$startcol + 6] !== null) ? (int) $row[$startcol + 6] : null;
            $this->notes = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->started = ($row[$startcol + 8] !== null) ? (boolean) $row[$startcol + 8] : null;
            $this->startdate = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
            $this->enddate = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
            $this->actualprogress = ($row[$startcol + 11] !== null) ? (int) $row[$startcol + 11] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 12; // 12 = ProjectIndicatorPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating ProjectIndicator object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aProject !== null && $this->projectid !== $this->aProject->getId()) {
            $this->aProject = null;
        }
        if ($this->aRegion !== null && $this->regionid !== $this->aRegion->getId()) {
            $this->aRegion = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = ProjectIndicatorPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aProject = null;
            $this->aRegion = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = ProjectIndicatorQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ProjectIndicatorPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aProject !== null) {
                if ($this->aProject->isModified() || $this->aProject->isNew()) {
                    $affectedRows += $this->aProject->save($con);
                }
                $this->setProject($this->aProject);
            }

            if ($this->aRegion !== null) {
                if ($this->aRegion->isModified() || $this->aRegion->isNew()) {
                    $affectedRows += $this->aRegion->save($con);
                }
                $this->setRegion($this->aRegion);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = ProjectIndicatorPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . ProjectIndicatorPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ProjectIndicatorPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(ProjectIndicatorPeer::PROJECTID)) {
            $modifiedColumns[':p' . $index++]  = '`PROJECTID`';
        }
        if ($this->isColumnModified(ProjectIndicatorPeer::COMMUNEID)) {
            $modifiedColumns[':p' . $index++]  = '`COMMUNEID`';
        }
        if ($this->isColumnModified(ProjectIndicatorPeer::REGIONID)) {
            $modifiedColumns[':p' . $index++]  = '`REGIONID`';
        }
        if ($this->isColumnModified(ProjectIndicatorPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(ProjectIndicatorPeer::EXPIRATIONDATE)) {
            $modifiedColumns[':p' . $index++]  = '`EXPIRATIONDATE`';
        }
        if ($this->isColumnModified(ProjectIndicatorPeer::MEASUREUNITID)) {
            $modifiedColumns[':p' . $index++]  = '`MEASUREUNITID`';
        }
        if ($this->isColumnModified(ProjectIndicatorPeer::NOTES)) {
            $modifiedColumns[':p' . $index++]  = '`NOTES`';
        }
        if ($this->isColumnModified(ProjectIndicatorPeer::STARTED)) {
            $modifiedColumns[':p' . $index++]  = '`STARTED`';
        }
        if ($this->isColumnModified(ProjectIndicatorPeer::STARTDATE)) {
            $modifiedColumns[':p' . $index++]  = '`STARTDATE`';
        }
        if ($this->isColumnModified(ProjectIndicatorPeer::ENDDATE)) {
            $modifiedColumns[':p' . $index++]  = '`ENDDATE`';
        }
        if ($this->isColumnModified(ProjectIndicatorPeer::ACTUALPROGRESS)) {
            $modifiedColumns[':p' . $index++]  = '`ACTUALPROGRESS`';
        }

        $sql = sprintf(
            'INSERT INTO `projects_indicator` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`PROJECTID`':
                        $stmt->bindValue($identifier, $this->projectid, PDO::PARAM_INT);
                        break;
                    case '`COMMUNEID`':
                        $stmt->bindValue($identifier, $this->communeid, PDO::PARAM_INT);
                        break;
                    case '`REGIONID`':
                        $stmt->bindValue($identifier, $this->regionid, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`EXPIRATIONDATE`':
                        $stmt->bindValue($identifier, $this->expirationdate, PDO::PARAM_STR);
                        break;
                    case '`MEASUREUNITID`':
                        $stmt->bindValue($identifier, $this->measureunitid, PDO::PARAM_INT);
                        break;
                    case '`NOTES`':
                        $stmt->bindValue($identifier, $this->notes, PDO::PARAM_STR);
                        break;
                    case '`STARTED`':
                        $stmt->bindValue($identifier, (int) $this->started, PDO::PARAM_INT);
                        break;
                    case '`STARTDATE`':
                        $stmt->bindValue($identifier, $this->startdate, PDO::PARAM_STR);
                        break;
                    case '`ENDDATE`':
                        $stmt->bindValue($identifier, $this->enddate, PDO::PARAM_STR);
                        break;
                    case '`ACTUALPROGRESS`':
                        $stmt->bindValue($identifier, $this->actualprogress, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aProject !== null) {
                if (!$this->aProject->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aProject->getValidationFailures());
                }
            }

            if ($this->aRegion !== null) {
                if (!$this->aRegion->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aRegion->getValidationFailures());
                }
            }


            if (($retval = ProjectIndicatorPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }



            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ProjectIndicatorPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getProjectid();
                break;
            case 2:
                return $this->getCommuneid();
                break;
            case 3:
                return $this->getRegionid();
                break;
            case 4:
                return $this->getName();
                break;
            case 5:
                return $this->getExpirationdate();
                break;
            case 6:
                return $this->getMeasureunitid();
                break;
            case 7:
                return $this->getNotes();
                break;
            case 8:
                return $this->getStarted();
                break;
            case 9:
                return $this->getStartdate();
                break;
            case 10:
                return $this->getEnddate();
                break;
            case 11:
                return $this->getActualprogress();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['ProjectIndicator'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['ProjectIndicator'][$this->getPrimaryKey()] = true;
        $keys = ProjectIndicatorPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getProjectid(),
            $keys[2] => $this->getCommuneid(),
            $keys[3] => $this->getRegionid(),
            $keys[4] => $this->getName(),
            $keys[5] => $this->getExpirationdate(),
            $keys[6] => $this->getMeasureunitid(),
            $keys[7] => $this->getNotes(),
            $keys[8] => $this->getStarted(),
            $keys[9] => $this->getStartdate(),
            $keys[10] => $this->getEnddate(),
            $keys[11] => $this->getActualprogress(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aProject) {
                $result['Project'] = $this->aProject->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aRegion) {
                $result['Region'] = $this->aRegion->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ProjectIndicatorPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setProjectid($value);
                break;
            case 2:
                $this->setCommuneid($value);
                break;
            case 3:
                $this->setRegionid($value);
                break;
            case 4:
                $this->setName($value);
                break;
            case 5:
                $this->setExpirationdate($value);
                break;
            case 6:
                $this->setMeasureunitid($value);
                break;
            case 7:
                $this->setNotes($value);
                break;
            case 8:
                $this->setStarted($value);
                break;
            case 9:
                $this->setStartdate($value);
                break;
            case 10:
                $this->setEnddate($value);
                break;
            case 11:
                $this->setActualprogress($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = ProjectIndicatorPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setProjectid($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setCommuneid($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setRegionid($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setName($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setExpirationdate($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setMeasureunitid($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setNotes($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setStarted($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setStartdate($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setEnddate($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setActualprogress($arr[$keys[11]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(ProjectIndicatorPeer::DATABASE_NAME);

        if ($this->isColumnModified(ProjectIndicatorPeer::ID)) $criteria->add(ProjectIndicatorPeer::ID, $this->id);
        if ($this->isColumnModified(ProjectIndicatorPeer::PROJECTID)) $criteria->add(ProjectIndicatorPeer::PROJECTID, $this->projectid);
        if ($this->isColumnModified(ProjectIndicatorPeer::COMMUNEID)) $criteria->add(ProjectIndicatorPeer::COMMUNEID, $this->communeid);
        if ($this->isColumnModified(ProjectIndicatorPeer::REGIONID)) $criteria->add(ProjectIndicatorPeer::REGIONID, $this->regionid);
        if ($this->isColumnModified(ProjectIndicatorPeer::NAME)) $criteria->add(ProjectIndicatorPeer::NAME, $this->name);
        if ($this->isColumnModified(ProjectIndicatorPeer::EXPIRATIONDATE)) $criteria->add(ProjectIndicatorPeer::EXPIRATIONDATE, $this->expirationdate);
        if ($this->isColumnModified(ProjectIndicatorPeer::MEASUREUNITID)) $criteria->add(ProjectIndicatorPeer::MEASUREUNITID, $this->measureunitid);
        if ($this->isColumnModified(ProjectIndicatorPeer::NOTES)) $criteria->add(ProjectIndicatorPeer::NOTES, $this->notes);
        if ($this->isColumnModified(ProjectIndicatorPeer::STARTED)) $criteria->add(ProjectIndicatorPeer::STARTED, $this->started);
        if ($this->isColumnModified(ProjectIndicatorPeer::STARTDATE)) $criteria->add(ProjectIndicatorPeer::STARTDATE, $this->startdate);
        if ($this->isColumnModified(ProjectIndicatorPeer::ENDDATE)) $criteria->add(ProjectIndicatorPeer::ENDDATE, $this->enddate);
        if ($this->isColumnModified(ProjectIndicatorPeer::ACTUALPROGRESS)) $criteria->add(ProjectIndicatorPeer::ACTUALPROGRESS, $this->actualprogress);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(ProjectIndicatorPeer::DATABASE_NAME);
        $criteria->add(ProjectIndicatorPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of ProjectIndicator (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setProjectid($this->getProjectid());
        $copyObj->setCommuneid($this->getCommuneid());
        $copyObj->setRegionid($this->getRegionid());
        $copyObj->setName($this->getName());
        $copyObj->setExpirationdate($this->getExpirationdate());
        $copyObj->setMeasureunitid($this->getMeasureunitid());
        $copyObj->setNotes($this->getNotes());
        $copyObj->setStarted($this->getStarted());
        $copyObj->setStartdate($this->getStartdate());
        $copyObj->setEnddate($this->getEnddate());
        $copyObj->setActualprogress($this->getActualprogress());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return ProjectIndicator Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return ProjectIndicatorPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new ProjectIndicatorPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Project object.
     *
     * @param             Project $v
     * @return ProjectIndicator The current object (for fluent API support)
     * @throws PropelException
     */
    public function setProject(Project $v = null)
    {
        if ($v === null) {
            $this->setProjectid(NULL);
        } else {
            $this->setProjectid($v->getId());
        }

        $this->aProject = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Project object, it will not be re-added.
        if ($v !== null) {
            $v->addProjectIndicator($this);
        }


        return $this;
    }


    /**
     * Get the associated Project object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Project The associated Project object.
     * @throws PropelException
     */
    public function getProject(PropelPDO $con = null)
    {
        if ($this->aProject === null && ($this->projectid !== null)) {
            $this->aProject = ProjectQuery::create()->findPk($this->projectid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aProject->addProjectIndicators($this);
             */
        }

        return $this->aProject;
    }

    /**
     * Declares an association between this object and a Region object.
     *
     * @param             Region $v
     * @return ProjectIndicator The current object (for fluent API support)
     * @throws PropelException
     */
    public function setRegion(Region $v = null)
    {
        if ($v === null) {
            $this->setRegionid(NULL);
        } else {
            $this->setRegionid($v->getId());
        }

        $this->aRegion = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Region object, it will not be re-added.
        if ($v !== null) {
            $v->addProjectIndicator($this);
        }


        return $this;
    }


    /**
     * Get the associated Region object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Region The associated Region object.
     * @throws PropelException
     */
    public function getRegion(PropelPDO $con = null)
    {
        if ($this->aRegion === null && ($this->regionid !== null)) {
            $this->aRegion = RegionQuery::create()->findPk($this->regionid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aRegion->addProjectIndicators($this);
             */
        }

        return $this->aRegion;
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->projectid = null;
        $this->communeid = null;
        $this->regionid = null;
        $this->name = null;
        $this->expirationdate = null;
        $this->measureunitid = null;
        $this->notes = null;
        $this->started = null;
        $this->startdate = null;
        $this->enddate = null;
        $this->actualprogress = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
        } // if ($deep)

        $this->aProject = null;
        $this->aRegion = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
