<?php


/**
 * Skeleton subclass for representing a row from the 'projects_projectLog' table.
 *
 * ProjectLog
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.projects.classes
 */
class ProjectLog extends BaseProjectLog {

	/**
	 * En el project log dice quien realizo el cambio. Se crea aca por razones de compatibilidad.
	 */
	public function changedBy() {
		return UserQuery::create()->filterById($this->getUserId())->findOne();												 		
	}

	/*
	* Obtiene la primera fecha de todas las activities asociadas a la instancia.
	*
	* @return date $date
	*/
	public function getAllActivitiesPlannedStart() {
		return ProjectActivityQuery::create()->select('Plannedstart')->filterByProjectid($this->getProjectid())->filterByPlannedstart(array('min' => 0))->orderByPlannedstart()->findOne();
	}

	/*
	* Obtiene la primera fecha de todas las activities asociadas a la instancia.
	*
	* @return date $date
	*/
	public function getAllActivitiesPlannedend() {
		return ProjectActivityQuery::create()->select('Plannedend')->filterByProjectid($this->getProjectid())->orderByPlannedend(Criteria::DESC)->findOne();
	}

	/*
	* Obtiene la primera fecha de todas las activities asociadas a la instancia.
	*
	* @return date $date
	*/
	public function getAllActivitiesRealStart() {
		return ProjectActivityQuery::create()->select('Realstart')->filterByProjectid($this->getProjectid())->filterByRealstart(array('min' => 0))->orderByRealstart()->findOne();
	}

	/*
	* Obtiene la primera fecha de todas las activities asociadas a la instancia.
	*
	* @return date $date
	*/
	public function getAllActivitiesRealEnd() {
		return ProjectActivityQuery::create()->select('Realend')->filterByProjectid($this->getProjectid())->orderByRealend(Criteria::DESC)->findOne();
	}

} // ProjectLog
