<?php



/**
 * Skeleton subclass for performing query and update operations on the 'projects_activity' table.
 *
 * Activity
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.projects.classes
 */
class ProjectActivityPeer extends BaseProjectActivityPeer {

 /** the default item name for this class */
	const ITEM_NAME = 'Activities';

	private $searchString;
	private $searchPositionId;
	private $searchRegionId;
	private $searchDelayed;
	private $searchEnded;
	private $searchWorking;
	private $searchProjectId;
	private $responsibleCode;
	private $searchPositionCode;

	//mapea las condiciones del filtro
	var $filterConditions = array(
					"searchString"=>"setSearchString",
					"position"=>"setSearchPosition",
					"region"=>"setSearchRegion",
					"delayed"=>"setSearchDelayed",
					"ended"=>"setSearchEnded",
					"working"=>"setSearchWorking",
					"projectId"=>"setSearchProjectId",
					"dateFrom"=>"setSearchDateFrom",
					"dateTo"=>"setSearchDateTo",
					"responsibleCode"=>"setResponsibleCode",
					"includeDependents"=>"setIncludeDependents",
					"positionCode"=>"setSearchPositionCode"
					);

 /**
	 * Especifica una cadena de busqueda.
	 * @param searchString cadena de busqueda.
	 */
	function setSearchString($searchString){
		$this->searchString = $searchString;
	}

 /**
	 * Especifica un objetivo para la busqueda
	 * @param $objectiveId id de objetivo
	 */
	function setSearchProjectId($projectId){
		$this->searchProjectId = $projectId;
	}

 /**
	 * Indica una dependencia para la que se deberan buscar resultados.
	 * @param $dependecyId id de dependencia
	 */
	function setSearchPosition($positionId){
		$this->searchPosition = $positionId;
	}

 /**
	 * Indica una region para la cual se deberan buscar resultados.
	 * @param $regionId id de region
	 */
	function setSearchRegion($regionId){
		$this->searchRegionId = $regionId;
	}

 /**
	 * Indica que se deberan buscar aquellas actividades que se encuentran retrasados.
	 *
	 */
	function setSearchDelayed(){
		$this->searchDelayed = true;
	}

 /**
	 * Indica que se deberan buscar aquellas actividades que se encuentran finalizados.
	 *
	 */
	function setSearchEnded(){
		$this->searchEnded = true;
	}

 /**
	 * Indica que se deberan buscar aquellas actividades que se encuentran en ejecucion.
	 *
	 */
	function setSearchWorking(){
		$this->searchWorking = true;
	}

 /**
	 * Indica como se ordenan los resultados por orden
	 *
	 */
	function setOrderByPlannedStart(){
		$this->plannedStart = true;
	}

 /**
	 * Indica que se deberan buscar aquellas actividades que cuyo inicio planificado es superios a la fecha ingresada.
  	 * @param date $dateFrom fecha de inicio de busqueda
	 */
	function setSearchDateFrom($dateFrom) {
		$this->searchDateFrom = $dateFrom;
	}

 /**
	 * Indica que se deberan buscar aquellas actividades que cuyo inicio planificado es superios a la fecha ingresada.
  	 * @param date $dateTo fecha de fin de busqueda
	 */
	function setSearchDateTo($dateTo) {
		$this->searchDateTo = $dateTo;
	}

 /**
	 * Indica que se deberan buscar aquellos proyectos que cuyo responsable se ha ingresado
	 * @param integer $responsibleCode Codigo de responsable
	 */
	function setResponsibleCode($responsibleCode) {
		$this->searchResponsibleCode = $responsibleCode;
	}

 /**
	 * Indica que se deberan buscar aquellos proyectos que cuyo responsable se ha ingresado
	 * @param integer $responsibleCode Codigo de responsable
	 */
	function setIncludeDependents($includeDependents) {
		$this->searchIncludeDependents = $includeDependents;
	}

	/**
	 * Especifica el Id del position.
	 * @param int Id del position.
	 */
	public function setSearchPositionCode($positionCode) {
		if ($positionCode > 0)
			$this->searchPositionCode = $positionCode;
	}

 /**
	* Obtiene la informacion de un project.
	*
	* @param int $id id del project
	* @return Project Informacion del project
	*/
	function get($id){
		$obj = self::retrieveByPK($id);
			return $obj;
	}

 /**
	* Crea un activity nuevo.
	*
	* @param array $paramsProject con los datos del proyecto
	* @return boolean true si se creo el project correctamente, false sino
	*/
	function create($objParams,$con = null) {
		$newObj = new ProjectActivity();
		foreach ($objParams as $key => $value) {
			$setMethod = "set".$key;
			if ( method_exists($newObj,$setMethod) ) {
				if (!empty($value) || $value == "0")
					$newObj->$setMethod($value);
				else
					$newObj->$setMethod(null);
			}
		}
		try {
			$newObj->save($con);
			return true;
		}
		catch (PropelException $exp) {
			if (ConfigModule::get("global","showPropelExceptions"))
				print_r($exp->getMessage());
			return false;
		}
	}
 /**
	* Actualiza la informacion de un activity.
	*
	* @param int $id id del activity
	* @param array $paramsObj con los datos del actividad
	* @return boolean true si se actualizo la informacion correctamente, false sino
	*/
	function update($id,$params){
		$object = ProjectActivityPeer::retrieveByPK($id);
		if ((ConfigModule::get("projects","useLogs")) &&
			 (((ConfigModule::get("projects","useMinorChanges")) && (empty($params["minorChange"]))) ||
			 (!ConfigModule::get("projects","useMinorChanges")))) {
			$objectLog = new ProjectActivityLog();
			$objectLog = Common::morphObjectValues($object,$objectLog);
			$objectLog->setId(NULL);
			$objectLog->setActivityId($id);
			$objectLog->setUpdated(time());
			try {
				$objectLog->save();
			}
			catch (PropelException $exp) {
				if (ConfigModule::get("global","showPropelExceptions"))
					print_r($exp->getMessage());
			}
		}
		foreach ($params as $key => $value) {
			$setMethod = "set".$key;
			if ( method_exists($object,$setMethod) ) {
				if (!empty($value) || $value == "0")
					$object->$setMethod($value);
				else
					$object->$setMethod(null);
			}
		}
		$object->setUpdated(time());
		$object->setLastModification(time());
		if (method_exists($object,"getChanges")) {
			$changes = $object->getChanges() + 1;
			$object->setChanges($changes);
		}
		try {
			$object->save();
			return true;
		}
		catch (PropelException $exp) {
			if (ConfigModule::get("global","showPropelExceptions"))
				print_r($exp->getMessage());
			return false;
		}
	}

	function setCriteria($criteria) {
		$this->criteria = $criteria;
	}

 /**
	 * Retorna el criteria generado a partir de los parametros de busqueda
	 *
	 * @return criteria $criteria Criteria con parametros de busqueda
	 */
	private function getSearchCriteria(){

		$criteria = $this->criteria === null ? ProjectActivityQuery::create() : $this->criteria;

		$criteria->setIgnoreCase(true);

//		if ($this->plannedStart)
			$criteria->addAscendingOrderByColumn(ProjectActivityPeer::PLANNEDSTART);

		$criteria->addDescendingOrderByColumn(ProjectActivityPeer::ID);


		if ($this->searchString)
			$criteria->add(ProjectActivityPeer::NAME,"%" . $this->searchString . "%",Criteria::LIKE);

    	if ( !empty($this->searchDateFrom) || !empty($this->searchDateTo) ) {
    		if ( !empty($this->searchDateFrom) )
				$criterion = $criteria->getNewCriterion(ProjectActivityPeer::PLANNEDSTART, $this->searchDateFrom, Criteria::GREATER_EQUAL);
    		if ( !empty($this->searchDateTo) ) {
      			if (!empty($criterion))
      				$criterion->addAnd($criteria->getNewCriterion(ProjectActivityPeer::PLANNEDSTART, $this->searchDateTo, Criteria::LESS_EQUAL));
        		else
        			$criterion = $criteria->getNewCriterion(ProjectActivityPeer::PLANNEDSTART, $this->searchDateTo, Criteria::LESS_EQUAL);
     		}
			$criteria->add($criterion);
    	}

		if (!empty($this->searchObjectiveId))
			$criteria->add(ProjectActivityPeer::OBJECTIVEID,$this->searchObjectiveId);

		if (!empty($this->searchProjectId))
			$criteria->add(ProjectActivityPeer::PROJECTID,$this->searchProjectId);

		if (!empty($this->searchResponsibleCode)) {
			if(!empty($this->searchIncludeDependents)) {
				$position = PositionQuery::create()->findOneByCode($this->searchResponsibleCode);
				$this->searchResponsibleCode = $position->getCodeWithDescendants();
			}
			$criteria->useProjectQuery()
									->filterByResponsibleCode($this->searchResponsibleCode, Criteria::IN)
								->endUse();
		}

		if (!empty($this->searchDelayed)) {
			//no finalizado y su fecha de de finalizacion es anterior a la actual.
			$criterionDelayedFinished = $criteria->getNewCriterion(ProjectActivityPeer::PLANNEDEND, date('Y-m-d') . " 00:00:00", Criteria::LESS_EQUAL);
			$criterionDelayedFinished->addAnd($criteria->getNewCriterion(ProjectActivityPeer::COMPLETED,0,Criteria::EQUAL));

			$criterionDelayedStarted = $criteria->getNewCriterion(ProjectActivityPeer::PLANNEDSTART, date('Y-m-d') . " 00:00:00", Criteria::LESS_EQUAL);
			$criterionDelayedStarted->addAnd($criteria->getNewCriterion(ProjectActivityPeer::REALSTART, null, Criteria::ISNULL));
			
			$criterionDelayedFinished->addOr($criterionDelayedStarted);
			
			$criterionFinished = $criterionDelayedFinished;

		}
		
		if (!empty($this->searchEnded)) {
			if (empty($criterionFinished))
				$criterionFinished = $criteria->getNewCriterion(ProjectActivityPeer::COMPLETED,1,Criteria::EQUAL);
			else
				$criterionFinished->addOr($criteria->getNewCriterion(ProjectActivityPeer::COMPLETED,1,Criteria::EQUAL));
		}
		
		if (!empty($this->searchWorking)) {
			$criterionWorkingFinished = $criteria->getNewCriterion(ProjectActivityPeer::COMPLETED,0,Criteria::EQUAL);
			
			$criterionWorking = $criteria->getNewCriterion(ProjectActivityPeer::REALSTART, null, Criteria::ISNOTNULL);
			$criterionWorkingFinished->addAnd($criterionWorking);
			
			if (empty($criterionFinished))
				$criterionFinished = $criterionWorkingFinished;
			else
				$criterionFinished->addOr($criterionWorkingFinished);
		}	
		
		
		if (!empty($criterionFinished))
			$criteria->addAnd($criterionFinished);
			
		if (ConfigModule::get('users', 'useFilterByUserGroup')) {
			$criteria = ProjectActivityQuery::create(null, $criteria)
				->filterByLoggedUserGroup();
		}

		if ($this->searchPositionCode) {
			$criteria->useProjectQuery()
				->useObjectiveQuery()
					->useStrategicObjectiveQuery()
						->filterByPositionCode($this->searchPositionCode)
					->endUse()
				->endUse()
			->endUse();
		}

		return $criteria;

	}
 /**
	* Obtiene todos los projects paginados segun la condicion de busqueda ingresada.
	*
	* @param int $page [optional] Numero de pagina actual
	* @param int $perPage [optional] Cantidad de filas por pagina
	* @return array Informacion sobre todos los projects
	*/
	function getAllPaginatedFiltered($page=1,$perPage=-1){
		if ($perPage == -1)
			$perPage = 	Common::getRowsPerPage();
		if (empty($page))
			$page = 1;
		$criteria = $this->getSearchCriteria();
		$pager = new PropelPager($criteria,"ProjectActivityPeer", "doSelect",$page,$perPage);
		return $pager;
	}
	
	/**
	 * Devuelve la criteria para filtrar por fecha de finalización planificada a fin de armar un reporte de alertas de actividades.
	 */
	public static function getAlertCriteriaForPlannedEnd() {
		
		$min = new DateTime('today');
		$max = new DateTime('today');
		$panelConfig = Common::getConfiguration('Panel');
		$alertPeriodType = $panelConfig['alert']['timePeriod']['type']['value'];
		$alertPeriodCount = $panelConfig['alert']['timePeriod']['count'];
		if ($alertPeriodType == 'DAYS_COUNT')
			$max->modify("+$alertPeriodCount days");
		else if ($alertPeriodType == 'WEEKS_COUNT')
			$max->modify("+$alertPeriodCount weeks");
		else
			$max->modify("+7 days");
		
		return ProjectActivityQuery::create()->filterByCompleted(false)
			->filterByPlannedend(array('min' => $min, 'max' => $max))
			->filterByRealend(null, Criteria::ISNULL);
	}
	
	/**
	 * Devuelve la criteria para filtrar por fecha de finalización planificada a fin de armar un reporte de alertas de actividades.
	 */
	public static function getAlertCriteriaForDelayed() {
		
		$min = new DateTime('today');
		$max = new DateTime('today');
		$panelConfig = Common::getConfiguration('Panel');
		$alertPeriodType = $panelConfig['alert']['timePeriod']['type']['value'];
		$alertPeriodCount = $panelConfig['alert']['timePeriod']['count'];
		if ($alertPeriodType == 'DAYS_COUNT')
			$min->modify("-$alertPeriodCount days");
		else if ($alertPeriodType == 'WEEKS_COUNT')
			$min->modify("-$alertPeriodCount weeks");
		else
			$min->modify("-7 days");
		
		return ProjectActivityQuery::create()->filterByCompleted(false)
			->filterByPlannedEnd(array('min' => $min, 'max' => $max))
			->filterByRealend(null, Criteria::ISNULL);
	}

} // ProjectActivityPeer
