<?php

class PositionsBubbleChartAction extends BaseAction {
	
	public function execute($mapping, $form, &$request, &$response) {
		
		parent::execute($mapping, $form, $request, $response);
		
		$plugInKey = 'SMARTY_PLUGIN';
		$smarty =& $this->actionServer->getPlugIn($plugInKey);
		if($smarty == NULL) {
			echo 'No PlugIn found matching key: '.$plugInKey."<br>\n";
		}
		
		if (empty($_GET['id'])) {
			$smarty->assign('invalidId', true);
			return $mapping->findForwardConfig('success');
		}
		
		$position = PositionQuery::create()
			->filterByDoPlanning()
			->filterById($_GET['id'])
			->findOne();
		
		if (!$position) {
			$smarty->assign('invalidId', true);
			return $mapping->findForwardConfig('success');
		}
		
		$colors = array('red', 'green', 'yellow', 'blue');
		$priorities = array(
			ProjectPeer::LOW,
			ProjectPeer::MEDIUM,
	//		ProjectPeer::MEDIUM_HIGH,
			ProjectPeer::HIGH
		//	ProjectPeer::CRITICAL
		);
		$visibilities = array(1,2,3,4,5,6,7,8,9,10);
		
		$projects = array();
		foreach ($colors as $color) {
			foreach ($priorities as $priority) {
				foreach ($visibilities as $visibility) {
					$projects[$color][$priority][$visibility] = 0;
				}
			}
			
			foreach ($position->getProjectsByStatusColor($color) as $project) {
				if (($priority = $project->getPriority()) && ($visibility = $project->getVisibility()))
					$projects[$color][$priority][$visibility]++;
			}
		}
		
		$chartProjects = array();
		foreach ($projects as $color => $next) {
			foreach ($next as $priority => $next) {
				foreach ($next as $visibility => $count) {
					$chartProjects[] = array(
						'color' => $color,
						'priority' => $this->mapPriority($priority),
						'visibility' => $visibility,
						'count' => $count
					);
				}
			}
		}
		
		$smarty->assign('projects', json_encode($chartProjects));
		$smarty->assign('position', $position);
		
		$this->prepareOutput();
		
		return $mapping->findForwardConfig('success');
	}
	
	function mapPriority($value) {
		switch ($value) {
			case ProjectPeer::LOW: return -1;
			case ProjectPeer::MEDIUM: return 1;
			case ProjectPeer::MEDIUM_HIGH: return 2;
			case ProjectPeer::HIGH: return 3;
			case ProjectPeer::CRITICAL: return 4;
			default: throw new Exception("unknown priority: $value");
		}
	}
	
	function prepareOutput() {

		$this->template->template = 'TemplatePlain.tpl';
	}
}