<?php


/**
 * Base class that represents a query for the 'panel_reportVersion' table.
 *
 * Versiones de reportes
 *
 * @method ReportVersionQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ReportVersionQuery orderByDatefrom($order = Criteria::ASC) Order by the dateFrom column
 * @method ReportVersionQuery orderByDateto($order = Criteria::ASC) Order by the dateTo column
 * @method ReportVersionQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method ReportVersionQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method ReportVersionQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method ReportVersionQuery groupById() Group by the id column
 * @method ReportVersionQuery groupByDatefrom() Group by the dateFrom column
 * @method ReportVersionQuery groupByDateto() Group by the dateTo column
 * @method ReportVersionQuery groupByName() Group by the name column
 * @method ReportVersionQuery groupByDescription() Group by the description column
 * @method ReportVersionQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method ReportVersionQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ReportVersionQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ReportVersionQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ReportVersionQuery leftJoinReportSection($relationAlias = null) Adds a LEFT JOIN clause to the query using the ReportSection relation
 * @method ReportVersionQuery rightJoinReportSection($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ReportSection relation
 * @method ReportVersionQuery innerJoinReportSection($relationAlias = null) Adds a INNER JOIN clause to the query using the ReportSection relation
 *
 * @method ReportVersion findOne(PropelPDO $con = null) Return the first ReportVersion matching the query
 * @method ReportVersion findOneOrCreate(PropelPDO $con = null) Return the first ReportVersion matching the query, or a new ReportVersion object populated from the query conditions when no match is found
 *
 * @method ReportVersion findOneById(int $id) Return the first ReportVersion filtered by the id column
 * @method ReportVersion findOneByDatefrom(string $dateFrom) Return the first ReportVersion filtered by the dateFrom column
 * @method ReportVersion findOneByDateto(string $dateTo) Return the first ReportVersion filtered by the dateTo column
 * @method ReportVersion findOneByName(string $name) Return the first ReportVersion filtered by the name column
 * @method ReportVersion findOneByDescription(string $description) Return the first ReportVersion filtered by the description column
 * @method ReportVersion findOneByDeletedAt(string $deleted_at) Return the first ReportVersion filtered by the deleted_at column
 *
 * @method array findById(int $id) Return ReportVersion objects filtered by the id column
 * @method array findByDatefrom(string $dateFrom) Return ReportVersion objects filtered by the dateFrom column
 * @method array findByDateto(string $dateTo) Return ReportVersion objects filtered by the dateTo column
 * @method array findByName(string $name) Return ReportVersion objects filtered by the name column
 * @method array findByDescription(string $description) Return ReportVersion objects filtered by the description column
 * @method array findByDeletedAt(string $deleted_at) Return ReportVersion objects filtered by the deleted_at column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseReportVersionQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseReportVersionQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ReportVersion', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ReportVersionQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ReportVersionQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ReportVersionQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ReportVersionQuery) {
            return $criteria;
        }
        $query = new ReportVersionQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ReportVersion|ReportVersion[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ReportVersionPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ReportVersionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ReportVersion A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `DATEFROM`, `DATETO`, `NAME`, `DESCRIPTION`, `DELETED_AT` FROM `panel_reportVersion` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ReportVersion();
            $obj->hydrate($row);
            ReportVersionPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ReportVersion|ReportVersion[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ReportVersion[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ReportVersionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ReportVersionPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ReportVersionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ReportVersionPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportVersionQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ReportVersionPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the dateFrom column
     *
     * Example usage:
     * <code>
     * $query->filterByDatefrom('2011-03-14'); // WHERE dateFrom = '2011-03-14'
     * $query->filterByDatefrom('now'); // WHERE dateFrom = '2011-03-14'
     * $query->filterByDatefrom(array('max' => 'yesterday')); // WHERE dateFrom > '2011-03-13'
     * </code>
     *
     * @param     mixed $datefrom The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportVersionQuery The current query, for fluid interface
     */
    public function filterByDatefrom($datefrom = null, $comparison = null)
    {
        if (is_array($datefrom)) {
            $useMinMax = false;
            if (isset($datefrom['min'])) {
                $this->addUsingAlias(ReportVersionPeer::DATEFROM, $datefrom['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($datefrom['max'])) {
                $this->addUsingAlias(ReportVersionPeer::DATEFROM, $datefrom['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ReportVersionPeer::DATEFROM, $datefrom, $comparison);
    }

    /**
     * Filter the query on the dateTo column
     *
     * Example usage:
     * <code>
     * $query->filterByDateto('2011-03-14'); // WHERE dateTo = '2011-03-14'
     * $query->filterByDateto('now'); // WHERE dateTo = '2011-03-14'
     * $query->filterByDateto(array('max' => 'yesterday')); // WHERE dateTo > '2011-03-13'
     * </code>
     *
     * @param     mixed $dateto The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportVersionQuery The current query, for fluid interface
     */
    public function filterByDateto($dateto = null, $comparison = null)
    {
        if (is_array($dateto)) {
            $useMinMax = false;
            if (isset($dateto['min'])) {
                $this->addUsingAlias(ReportVersionPeer::DATETO, $dateto['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($dateto['max'])) {
                $this->addUsingAlias(ReportVersionPeer::DATETO, $dateto['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ReportVersionPeer::DATETO, $dateto, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportVersionQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ReportVersionPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportVersionQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ReportVersionPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportVersionQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(ReportVersionPeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(ReportVersionPeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ReportVersionPeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related ReportSection object
     *
     * @param   ReportSection|PropelObjectCollection $reportSection  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ReportVersionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByReportSection($reportSection, $comparison = null)
    {
        if ($reportSection instanceof ReportSection) {
            return $this
                ->addUsingAlias(ReportVersionPeer::ID, $reportSection->getVersionid(), $comparison);
        } elseif ($reportSection instanceof PropelObjectCollection) {
            return $this
                ->useReportSectionQuery()
                ->filterByPrimaryKeys($reportSection->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByReportSection() only accepts arguments of type ReportSection or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ReportSection relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ReportVersionQuery The current query, for fluid interface
     */
    public function joinReportSection($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ReportSection');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ReportSection');
        }

        return $this;
    }

    /**
     * Use the ReportSection relation ReportSection object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ReportSectionQuery A secondary query class using the current class as primary query
     */
    public function useReportSectionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinReportSection($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ReportSection', 'ReportSectionQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ReportVersion $reportVersion Object to remove from the list of results
     *
     * @return ReportVersionQuery The current query, for fluid interface
     */
    public function prune($reportVersion = null)
    {
        if ($reportVersion) {
            $this->addUsingAlias(ReportVersionPeer::ID, $reportVersion->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (ReportVersionQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(ReportVersionPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ReportVersionPeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (ReportVersionQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see ReportVersionQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return ReportVersionQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return ReportVersionPeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return ReportVersionPeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
