<?php


/**
 * Base class that represents a query for the 'panel_mission' table.
 *
 * Base de Misiones
 *
 * @method MissionQuery orderById($order = Criteria::ASC) Order by the id column
 * @method MissionQuery orderByType($order = Criteria::ASC) Order by the type column
 * @method MissionQuery orderByStartdate($order = Criteria::ASC) Order by the startDate column
 * @method MissionQuery orderByFinishdate($order = Criteria::ASC) Order by the finishDate column
 * @method MissionQuery orderByProjectid($order = Criteria::ASC) Order by the projectId column
 * @method MissionQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method MissionQuery orderByResponsible($order = Criteria::ASC) Order by the responsible column
 * @method MissionQuery orderByUserid($order = Criteria::ASC) Order by the userId column
 * @method MissionQuery orderByUpdateruserid($order = Criteria::ASC) Order by the updaterUserId column
 * @method MissionQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 * @method MissionQuery orderByCreatedAt($order = Criteria::ASC) Order by the created_at column
 * @method MissionQuery orderByUpdatedAt($order = Criteria::ASC) Order by the updated_at column
 *
 * @method MissionQuery groupById() Group by the id column
 * @method MissionQuery groupByType() Group by the type column
 * @method MissionQuery groupByStartdate() Group by the startDate column
 * @method MissionQuery groupByFinishdate() Group by the finishDate column
 * @method MissionQuery groupByProjectid() Group by the projectId column
 * @method MissionQuery groupByDescription() Group by the description column
 * @method MissionQuery groupByResponsible() Group by the responsible column
 * @method MissionQuery groupByUserid() Group by the userId column
 * @method MissionQuery groupByUpdateruserid() Group by the updaterUserId column
 * @method MissionQuery groupByDeletedAt() Group by the deleted_at column
 * @method MissionQuery groupByCreatedAt() Group by the created_at column
 * @method MissionQuery groupByUpdatedAt() Group by the updated_at column
 *
 * @method MissionQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method MissionQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method MissionQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method MissionQuery leftJoinProject($relationAlias = null) Adds a LEFT JOIN clause to the query using the Project relation
 * @method MissionQuery rightJoinProject($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Project relation
 * @method MissionQuery innerJoinProject($relationAlias = null) Adds a INNER JOIN clause to the query using the Project relation
 *
 * @method MissionQuery leftJoinUserRelatedByUserid($relationAlias = null) Adds a LEFT JOIN clause to the query using the UserRelatedByUserid relation
 * @method MissionQuery rightJoinUserRelatedByUserid($relationAlias = null) Adds a RIGHT JOIN clause to the query using the UserRelatedByUserid relation
 * @method MissionQuery innerJoinUserRelatedByUserid($relationAlias = null) Adds a INNER JOIN clause to the query using the UserRelatedByUserid relation
 *
 * @method MissionQuery leftJoinUserRelatedByUpdateruserid($relationAlias = null) Adds a LEFT JOIN clause to the query using the UserRelatedByUpdateruserid relation
 * @method MissionQuery rightJoinUserRelatedByUpdateruserid($relationAlias = null) Adds a RIGHT JOIN clause to the query using the UserRelatedByUpdateruserid relation
 * @method MissionQuery innerJoinUserRelatedByUpdateruserid($relationAlias = null) Adds a INNER JOIN clause to the query using the UserRelatedByUpdateruserid relation
 *
 * @method MissionQuery leftJoinMissionParticipant($relationAlias = null) Adds a LEFT JOIN clause to the query using the MissionParticipant relation
 * @method MissionQuery rightJoinMissionParticipant($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MissionParticipant relation
 * @method MissionQuery innerJoinMissionParticipant($relationAlias = null) Adds a INNER JOIN clause to the query using the MissionParticipant relation
 *
 * @method MissionQuery leftJoinMissionCommitment($relationAlias = null) Adds a LEFT JOIN clause to the query using the MissionCommitment relation
 * @method MissionQuery rightJoinMissionCommitment($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MissionCommitment relation
 * @method MissionQuery innerJoinMissionCommitment($relationAlias = null) Adds a INNER JOIN clause to the query using the MissionCommitment relation
 *
 * @method MissionQuery leftJoinMissionDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the MissionDocument relation
 * @method MissionQuery rightJoinMissionDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MissionDocument relation
 * @method MissionQuery innerJoinMissionDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the MissionDocument relation
 *
 * @method MissionQuery leftJoinMissionUpdate($relationAlias = null) Adds a LEFT JOIN clause to the query using the MissionUpdate relation
 * @method MissionQuery rightJoinMissionUpdate($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MissionUpdate relation
 * @method MissionQuery innerJoinMissionUpdate($relationAlias = null) Adds a INNER JOIN clause to the query using the MissionUpdate relation
 *
 * @method Mission findOne(PropelPDO $con = null) Return the first Mission matching the query
 * @method Mission findOneOrCreate(PropelPDO $con = null) Return the first Mission matching the query, or a new Mission object populated from the query conditions when no match is found
 *
 * @method Mission findOneById(int $id) Return the first Mission filtered by the id column
 * @method Mission findOneByType(int $type) Return the first Mission filtered by the type column
 * @method Mission findOneByStartdate(string $startDate) Return the first Mission filtered by the startDate column
 * @method Mission findOneByFinishdate(string $finishDate) Return the first Mission filtered by the finishDate column
 * @method Mission findOneByProjectid(int $projectId) Return the first Mission filtered by the projectId column
 * @method Mission findOneByDescription(string $description) Return the first Mission filtered by the description column
 * @method Mission findOneByResponsible(string $responsible) Return the first Mission filtered by the responsible column
 * @method Mission findOneByUserid(int $userId) Return the first Mission filtered by the userId column
 * @method Mission findOneByUpdateruserid(int $updaterUserId) Return the first Mission filtered by the updaterUserId column
 * @method Mission findOneByDeletedAt(string $deleted_at) Return the first Mission filtered by the deleted_at column
 * @method Mission findOneByCreatedAt(string $created_at) Return the first Mission filtered by the created_at column
 * @method Mission findOneByUpdatedAt(string $updated_at) Return the first Mission filtered by the updated_at column
 *
 * @method array findById(int $id) Return Mission objects filtered by the id column
 * @method array findByType(int $type) Return Mission objects filtered by the type column
 * @method array findByStartdate(string $startDate) Return Mission objects filtered by the startDate column
 * @method array findByFinishdate(string $finishDate) Return Mission objects filtered by the finishDate column
 * @method array findByProjectid(int $projectId) Return Mission objects filtered by the projectId column
 * @method array findByDescription(string $description) Return Mission objects filtered by the description column
 * @method array findByResponsible(string $responsible) Return Mission objects filtered by the responsible column
 * @method array findByUserid(int $userId) Return Mission objects filtered by the userId column
 * @method array findByUpdateruserid(int $updaterUserId) Return Mission objects filtered by the updaterUserId column
 * @method array findByDeletedAt(string $deleted_at) Return Mission objects filtered by the deleted_at column
 * @method array findByCreatedAt(string $created_at) Return Mission objects filtered by the created_at column
 * @method array findByUpdatedAt(string $updated_at) Return Mission objects filtered by the updated_at column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseMissionQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseMissionQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Mission', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new MissionQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     MissionQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return MissionQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof MissionQuery) {
            return $criteria;
        }
        $query = new MissionQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Mission|Mission[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = MissionPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(MissionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Mission A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `TYPE`, `STARTDATE`, `FINISHDATE`, `PROJECTID`, `DESCRIPTION`, `RESPONSIBLE`, `USERID`, `UPDATERUSERID`, `DELETED_AT`, `CREATED_AT`, `UPDATED_AT` FROM `panel_mission` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new Mission();
            $obj->hydrate($row);
            MissionPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Mission|Mission[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Mission[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(MissionPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(MissionPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(MissionPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the type column
     *
     * Example usage:
     * <code>
     * $query->filterByType(1234); // WHERE type = 1234
     * $query->filterByType(array(12, 34)); // WHERE type IN (12, 34)
     * $query->filterByType(array('min' => 12)); // WHERE type > 12
     * </code>
     *
     * @param     mixed $type The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByType($type = null, $comparison = null)
    {
        if (is_array($type)) {
            $useMinMax = false;
            if (isset($type['min'])) {
                $this->addUsingAlias(MissionPeer::TYPE, $type['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($type['max'])) {
                $this->addUsingAlias(MissionPeer::TYPE, $type['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionPeer::TYPE, $type, $comparison);
    }

    /**
     * Filter the query on the startDate column
     *
     * Example usage:
     * <code>
     * $query->filterByStartdate('2011-03-14'); // WHERE startDate = '2011-03-14'
     * $query->filterByStartdate('now'); // WHERE startDate = '2011-03-14'
     * $query->filterByStartdate(array('max' => 'yesterday')); // WHERE startDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $startdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByStartdate($startdate = null, $comparison = null)
    {
        if (is_array($startdate)) {
            $useMinMax = false;
            if (isset($startdate['min'])) {
                $this->addUsingAlias(MissionPeer::STARTDATE, $startdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($startdate['max'])) {
                $this->addUsingAlias(MissionPeer::STARTDATE, $startdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionPeer::STARTDATE, $startdate, $comparison);
    }

    /**
     * Filter the query on the finishDate column
     *
     * Example usage:
     * <code>
     * $query->filterByFinishdate('2011-03-14'); // WHERE finishDate = '2011-03-14'
     * $query->filterByFinishdate('now'); // WHERE finishDate = '2011-03-14'
     * $query->filterByFinishdate(array('max' => 'yesterday')); // WHERE finishDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $finishdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByFinishdate($finishdate = null, $comparison = null)
    {
        if (is_array($finishdate)) {
            $useMinMax = false;
            if (isset($finishdate['min'])) {
                $this->addUsingAlias(MissionPeer::FINISHDATE, $finishdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($finishdate['max'])) {
                $this->addUsingAlias(MissionPeer::FINISHDATE, $finishdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionPeer::FINISHDATE, $finishdate, $comparison);
    }

    /**
     * Filter the query on the projectId column
     *
     * Example usage:
     * <code>
     * $query->filterByProjectid(1234); // WHERE projectId = 1234
     * $query->filterByProjectid(array(12, 34)); // WHERE projectId IN (12, 34)
     * $query->filterByProjectid(array('min' => 12)); // WHERE projectId > 12
     * </code>
     *
     * @see       filterByProject()
     *
     * @param     mixed $projectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByProjectid($projectid = null, $comparison = null)
    {
        if (is_array($projectid)) {
            $useMinMax = false;
            if (isset($projectid['min'])) {
                $this->addUsingAlias(MissionPeer::PROJECTID, $projectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($projectid['max'])) {
                $this->addUsingAlias(MissionPeer::PROJECTID, $projectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionPeer::PROJECTID, $projectid, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MissionPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the responsible column
     *
     * Example usage:
     * <code>
     * $query->filterByResponsible('fooValue');   // WHERE responsible = 'fooValue'
     * $query->filterByResponsible('%fooValue%'); // WHERE responsible LIKE '%fooValue%'
     * </code>
     *
     * @param     string $responsible The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByResponsible($responsible = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($responsible)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $responsible)) {
                $responsible = str_replace('*', '%', $responsible);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MissionPeer::RESPONSIBLE, $responsible, $comparison);
    }

    /**
     * Filter the query on the userId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserid(1234); // WHERE userId = 1234
     * $query->filterByUserid(array(12, 34)); // WHERE userId IN (12, 34)
     * $query->filterByUserid(array('min' => 12)); // WHERE userId > 12
     * </code>
     *
     * @see       filterByUserRelatedByUserid()
     *
     * @param     mixed $userid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByUserid($userid = null, $comparison = null)
    {
        if (is_array($userid)) {
            $useMinMax = false;
            if (isset($userid['min'])) {
                $this->addUsingAlias(MissionPeer::USERID, $userid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userid['max'])) {
                $this->addUsingAlias(MissionPeer::USERID, $userid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionPeer::USERID, $userid, $comparison);
    }

    /**
     * Filter the query on the updaterUserId column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdateruserid(1234); // WHERE updaterUserId = 1234
     * $query->filterByUpdateruserid(array(12, 34)); // WHERE updaterUserId IN (12, 34)
     * $query->filterByUpdateruserid(array('min' => 12)); // WHERE updaterUserId > 12
     * </code>
     *
     * @see       filterByUserRelatedByUpdateruserid()
     *
     * @param     mixed $updateruserid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByUpdateruserid($updateruserid = null, $comparison = null)
    {
        if (is_array($updateruserid)) {
            $useMinMax = false;
            if (isset($updateruserid['min'])) {
                $this->addUsingAlias(MissionPeer::UPDATERUSERID, $updateruserid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updateruserid['max'])) {
                $this->addUsingAlias(MissionPeer::UPDATERUSERID, $updateruserid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionPeer::UPDATERUSERID, $updateruserid, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(MissionPeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(MissionPeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionPeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query on the created_at column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatedAt('2011-03-14'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt('now'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt(array('max' => 'yesterday')); // WHERE created_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $createdAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByCreatedAt($createdAt = null, $comparison = null)
    {
        if (is_array($createdAt)) {
            $useMinMax = false;
            if (isset($createdAt['min'])) {
                $this->addUsingAlias(MissionPeer::CREATED_AT, $createdAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($createdAt['max'])) {
                $this->addUsingAlias(MissionPeer::CREATED_AT, $createdAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionPeer::CREATED_AT, $createdAt, $comparison);
    }

    /**
     * Filter the query on the updated_at column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdatedAt('2011-03-14'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt('now'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt(array('max' => 'yesterday')); // WHERE updated_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $updatedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByUpdatedAt($updatedAt = null, $comparison = null)
    {
        if (is_array($updatedAt)) {
            $useMinMax = false;
            if (isset($updatedAt['min'])) {
                $this->addUsingAlias(MissionPeer::UPDATED_AT, $updatedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updatedAt['max'])) {
                $this->addUsingAlias(MissionPeer::UPDATED_AT, $updatedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionPeer::UPDATED_AT, $updatedAt, $comparison);
    }

    /**
     * Filter the query by a related Project object
     *
     * @param   Project|PropelObjectCollection $project The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProject($project, $comparison = null)
    {
        if ($project instanceof Project) {
            return $this
                ->addUsingAlias(MissionPeer::PROJECTID, $project->getId(), $comparison);
        } elseif ($project instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MissionPeer::PROJECTID, $project->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProject() only accepts arguments of type Project or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Project relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function joinProject($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Project');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Project');
        }

        return $this;
    }

    /**
     * Use the Project relation Project object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectQuery A secondary query class using the current class as primary query
     */
    public function useProjectQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinProject($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Project', 'ProjectQuery');
    }

    /**
     * Filter the query by a related User object
     *
     * @param   User|PropelObjectCollection $user The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByUserRelatedByUserid($user, $comparison = null)
    {
        if ($user instanceof User) {
            return $this
                ->addUsingAlias(MissionPeer::USERID, $user->getId(), $comparison);
        } elseif ($user instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MissionPeer::USERID, $user->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByUserRelatedByUserid() only accepts arguments of type User or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the UserRelatedByUserid relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function joinUserRelatedByUserid($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('UserRelatedByUserid');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'UserRelatedByUserid');
        }

        return $this;
    }

    /**
     * Use the UserRelatedByUserid relation User object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   UserQuery A secondary query class using the current class as primary query
     */
    public function useUserRelatedByUseridQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinUserRelatedByUserid($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'UserRelatedByUserid', 'UserQuery');
    }

    /**
     * Filter the query by a related User object
     *
     * @param   User|PropelObjectCollection $user The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByUserRelatedByUpdateruserid($user, $comparison = null)
    {
        if ($user instanceof User) {
            return $this
                ->addUsingAlias(MissionPeer::UPDATERUSERID, $user->getId(), $comparison);
        } elseif ($user instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MissionPeer::UPDATERUSERID, $user->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByUserRelatedByUpdateruserid() only accepts arguments of type User or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the UserRelatedByUpdateruserid relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function joinUserRelatedByUpdateruserid($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('UserRelatedByUpdateruserid');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'UserRelatedByUpdateruserid');
        }

        return $this;
    }

    /**
     * Use the UserRelatedByUpdateruserid relation User object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   UserQuery A secondary query class using the current class as primary query
     */
    public function useUserRelatedByUpdateruseridQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinUserRelatedByUpdateruserid($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'UserRelatedByUpdateruserid', 'UserQuery');
    }

    /**
     * Filter the query by a related MissionParticipant object
     *
     * @param   MissionParticipant|PropelObjectCollection $missionParticipant  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMissionParticipant($missionParticipant, $comparison = null)
    {
        if ($missionParticipant instanceof MissionParticipant) {
            return $this
                ->addUsingAlias(MissionPeer::ID, $missionParticipant->getMissionid(), $comparison);
        } elseif ($missionParticipant instanceof PropelObjectCollection) {
            return $this
                ->useMissionParticipantQuery()
                ->filterByPrimaryKeys($missionParticipant->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMissionParticipant() only accepts arguments of type MissionParticipant or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MissionParticipant relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function joinMissionParticipant($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MissionParticipant');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MissionParticipant');
        }

        return $this;
    }

    /**
     * Use the MissionParticipant relation MissionParticipant object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionParticipantQuery A secondary query class using the current class as primary query
     */
    public function useMissionParticipantQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMissionParticipant($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MissionParticipant', 'MissionParticipantQuery');
    }

    /**
     * Filter the query by a related MissionCommitment object
     *
     * @param   MissionCommitment|PropelObjectCollection $missionCommitment  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMissionCommitment($missionCommitment, $comparison = null)
    {
        if ($missionCommitment instanceof MissionCommitment) {
            return $this
                ->addUsingAlias(MissionPeer::ID, $missionCommitment->getMissionid(), $comparison);
        } elseif ($missionCommitment instanceof PropelObjectCollection) {
            return $this
                ->useMissionCommitmentQuery()
                ->filterByPrimaryKeys($missionCommitment->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMissionCommitment() only accepts arguments of type MissionCommitment or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MissionCommitment relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function joinMissionCommitment($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MissionCommitment');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MissionCommitment');
        }

        return $this;
    }

    /**
     * Use the MissionCommitment relation MissionCommitment object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionCommitmentQuery A secondary query class using the current class as primary query
     */
    public function useMissionCommitmentQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMissionCommitment($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MissionCommitment', 'MissionCommitmentQuery');
    }

    /**
     * Filter the query by a related MissionDocument object
     *
     * @param   MissionDocument|PropelObjectCollection $missionDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMissionDocument($missionDocument, $comparison = null)
    {
        if ($missionDocument instanceof MissionDocument) {
            return $this
                ->addUsingAlias(MissionPeer::ID, $missionDocument->getMissionid(), $comparison);
        } elseif ($missionDocument instanceof PropelObjectCollection) {
            return $this
                ->useMissionDocumentQuery()
                ->filterByPrimaryKeys($missionDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMissionDocument() only accepts arguments of type MissionDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MissionDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function joinMissionDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MissionDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MissionDocument');
        }

        return $this;
    }

    /**
     * Use the MissionDocument relation MissionDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionDocumentQuery A secondary query class using the current class as primary query
     */
    public function useMissionDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMissionDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MissionDocument', 'MissionDocumentQuery');
    }

    /**
     * Filter the query by a related MissionUpdate object
     *
     * @param   MissionUpdate|PropelObjectCollection $missionUpdate  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMissionUpdate($missionUpdate, $comparison = null)
    {
        if ($missionUpdate instanceof MissionUpdate) {
            return $this
                ->addUsingAlias(MissionPeer::ID, $missionUpdate->getMissionid(), $comparison);
        } elseif ($missionUpdate instanceof PropelObjectCollection) {
            return $this
                ->useMissionUpdateQuery()
                ->filterByPrimaryKeys($missionUpdate->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMissionUpdate() only accepts arguments of type MissionUpdate or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MissionUpdate relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function joinMissionUpdate($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MissionUpdate');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MissionUpdate');
        }

        return $this;
    }

    /**
     * Use the MissionUpdate relation MissionUpdate object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionUpdateQuery A secondary query class using the current class as primary query
     */
    public function useMissionUpdateQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMissionUpdate($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MissionUpdate', 'MissionUpdateQuery');
    }

    /**
     * Filter the query by a related Document object
     * using the panel_missionDocument table as cross reference
     *
     * @param   Document $document the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionQuery The current query, for fluid interface
     */
    public function filterByDocument($document, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useMissionDocumentQuery()
            ->filterByDocument($document, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Mission $mission Object to remove from the list of results
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function prune($mission = null)
    {
        if ($mission) {
            $this->addUsingAlias(MissionPeer::ID, $mission->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (MissionQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(MissionPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            MissionPeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (MissionQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see MissionQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return MissionPeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return MissionPeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

    // timestampable behavior

    /**
     * Filter by the latest updated
     *
     * @param      int $nbDays Maximum age of the latest update in days
     *
     * @return     MissionQuery The current query, for fluid interface
     */
    public function recentlyUpdated($nbDays = 7)
    {
        return $this->addUsingAlias(MissionPeer::UPDATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by update date desc
     *
     * @return     MissionQuery The current query, for fluid interface
     */
    public function lastUpdatedFirst()
    {
        return $this->addDescendingOrderByColumn(MissionPeer::UPDATED_AT);
    }

    /**
     * Order by update date asc
     *
     * @return     MissionQuery The current query, for fluid interface
     */
    public function firstUpdatedFirst()
    {
        return $this->addAscendingOrderByColumn(MissionPeer::UPDATED_AT);
    }

    /**
     * Filter by the latest created
     *
     * @param      int $nbDays Maximum age of in days
     *
     * @return     MissionQuery The current query, for fluid interface
     */
    public function recentlyCreated($nbDays = 7)
    {
        return $this->addUsingAlias(MissionPeer::CREATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by create date desc
     *
     * @return     MissionQuery The current query, for fluid interface
     */
    public function lastCreatedFirst()
    {
        return $this->addDescendingOrderByColumn(MissionPeer::CREATED_AT);
    }

    /**
     * Order by create date asc
     *
     * @return     MissionQuery The current query, for fluid interface
     */
    public function firstCreatedFirst()
    {
        return $this->addAscendingOrderByColumn(MissionPeer::CREATED_AT);
    }
}
