<?php


/**
 * Base class that represents a query for the 'panel_missionDocument' table.
 *
 *
 *
 * @method MissionDocumentQuery orderByMissionid($order = Criteria::ASC) Order by the missionId column
 * @method MissionDocumentQuery orderByDocumentid($order = Criteria::ASC) Order by the documentId column
 *
 * @method MissionDocumentQuery groupByMissionid() Group by the missionId column
 * @method MissionDocumentQuery groupByDocumentid() Group by the documentId column
 *
 * @method MissionDocumentQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method MissionDocumentQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method MissionDocumentQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method MissionDocumentQuery leftJoinMission($relationAlias = null) Adds a LEFT JOIN clause to the query using the Mission relation
 * @method MissionDocumentQuery rightJoinMission($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Mission relation
 * @method MissionDocumentQuery innerJoinMission($relationAlias = null) Adds a INNER JOIN clause to the query using the Mission relation
 *
 * @method MissionDocumentQuery leftJoinDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the Document relation
 * @method MissionDocumentQuery rightJoinDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Document relation
 * @method MissionDocumentQuery innerJoinDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the Document relation
 *
 * @method MissionDocument findOne(PropelPDO $con = null) Return the first MissionDocument matching the query
 * @method MissionDocument findOneOrCreate(PropelPDO $con = null) Return the first MissionDocument matching the query, or a new MissionDocument object populated from the query conditions when no match is found
 *
 * @method MissionDocument findOneByMissionid(int $missionId) Return the first MissionDocument filtered by the missionId column
 * @method MissionDocument findOneByDocumentid(int $documentId) Return the first MissionDocument filtered by the documentId column
 *
 * @method array findByMissionid(int $missionId) Return MissionDocument objects filtered by the missionId column
 * @method array findByDocumentid(int $documentId) Return MissionDocument objects filtered by the documentId column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseMissionDocumentQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseMissionDocumentQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'MissionDocument', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new MissionDocumentQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     MissionDocumentQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return MissionDocumentQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof MissionDocumentQuery) {
            return $criteria;
        }
        $query = new MissionDocumentQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$missionId, $documentId]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   MissionDocument|MissionDocument[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = MissionDocumentPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(MissionDocumentPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   MissionDocument A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `MISSIONID`, `DOCUMENTID` FROM `panel_missionDocument` WHERE `MISSIONID` = :p0 AND `DOCUMENTID` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new MissionDocument();
            $obj->hydrate($row);
            MissionDocumentPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return MissionDocument|MissionDocument[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|MissionDocument[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return MissionDocumentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(MissionDocumentPeer::MISSIONID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(MissionDocumentPeer::DOCUMENTID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return MissionDocumentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(MissionDocumentPeer::MISSIONID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(MissionDocumentPeer::DOCUMENTID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the missionId column
     *
     * Example usage:
     * <code>
     * $query->filterByMissionid(1234); // WHERE missionId = 1234
     * $query->filterByMissionid(array(12, 34)); // WHERE missionId IN (12, 34)
     * $query->filterByMissionid(array('min' => 12)); // WHERE missionId > 12
     * </code>
     *
     * @see       filterByMission()
     *
     * @param     mixed $missionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionDocumentQuery The current query, for fluid interface
     */
    public function filterByMissionid($missionid = null, $comparison = null)
    {
        if (is_array($missionid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(MissionDocumentPeer::MISSIONID, $missionid, $comparison);
    }

    /**
     * Filter the query on the documentId column
     *
     * Example usage:
     * <code>
     * $query->filterByDocumentid(1234); // WHERE documentId = 1234
     * $query->filterByDocumentid(array(12, 34)); // WHERE documentId IN (12, 34)
     * $query->filterByDocumentid(array('min' => 12)); // WHERE documentId > 12
     * </code>
     *
     * @see       filterByDocument()
     *
     * @param     mixed $documentid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionDocumentQuery The current query, for fluid interface
     */
    public function filterByDocumentid($documentid = null, $comparison = null)
    {
        if (is_array($documentid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(MissionDocumentPeer::DOCUMENTID, $documentid, $comparison);
    }

    /**
     * Filter the query by a related Mission object
     *
     * @param   Mission|PropelObjectCollection $mission The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionDocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMission($mission, $comparison = null)
    {
        if ($mission instanceof Mission) {
            return $this
                ->addUsingAlias(MissionDocumentPeer::MISSIONID, $mission->getId(), $comparison);
        } elseif ($mission instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MissionDocumentPeer::MISSIONID, $mission->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByMission() only accepts arguments of type Mission or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Mission relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionDocumentQuery The current query, for fluid interface
     */
    public function joinMission($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Mission');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Mission');
        }

        return $this;
    }

    /**
     * Use the Mission relation Mission object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionQuery A secondary query class using the current class as primary query
     */
    public function useMissionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMission($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Mission', 'MissionQuery');
    }

    /**
     * Filter the query by a related Document object
     *
     * @param   Document|PropelObjectCollection $document The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionDocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByDocument($document, $comparison = null)
    {
        if ($document instanceof Document) {
            return $this
                ->addUsingAlias(MissionDocumentPeer::DOCUMENTID, $document->getId(), $comparison);
        } elseif ($document instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MissionDocumentPeer::DOCUMENTID, $document->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByDocument() only accepts arguments of type Document or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Document relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionDocumentQuery The current query, for fluid interface
     */
    public function joinDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Document');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Document');
        }

        return $this;
    }

    /**
     * Use the Document relation Document object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   DocumentQuery A secondary query class using the current class as primary query
     */
    public function useDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Document', 'DocumentQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   MissionDocument $missionDocument Object to remove from the list of results
     *
     * @return MissionDocumentQuery The current query, for fluid interface
     */
    public function prune($missionDocument = null)
    {
        if ($missionDocument) {
            $this->addCond('pruneCond0', $this->getAliasedColName(MissionDocumentPeer::MISSIONID), $missionDocument->getMissionid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(MissionDocumentPeer::DOCUMENTID), $missionDocument->getDocumentid(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
