<?php


/**
 * Base static class for performing query and update operations on the 'panel_guarantee' table.
 *
 * Base de Garantias
 *
 * @package propel.generator.panel.classes.om
 */
abstract class BaseGuaranteePeer
{

    /** the default database name for this class */
    const DATABASE_NAME = 'application';

    /** the table name for this class */
    const TABLE_NAME = 'panel_guarantee';

    /** the related Propel class for this table */
    const OM_CLASS = 'Guarantee';

    /** the related TableMap class for this table */
    const TM_CLASS = 'GuaranteeTableMap';

    /** The total number of columns. */
    const NUM_COLUMNS = 14;

    /** The number of lazy-loaded columns. */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /** The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS) */
    const NUM_HYDRATE_COLUMNS = 14;

    /** the column name for the ID field */
    const ID = 'panel_guarantee.ID';

    /** the column name for the CODE field */
    const CODE = 'panel_guarantee.CODE';

    /** the column name for the TYPE field */
    const TYPE = 'panel_guarantee.TYPE';

    /** the column name for the PROJECTID field */
    const PROJECTID = 'panel_guarantee.PROJECTID';

    /** the column name for the CONTRACTORID field */
    const CONTRACTORID = 'panel_guarantee.CONTRACTORID';

    /** the column name for the ISSUER field */
    const ISSUER = 'panel_guarantee.ISSUER';

    /** the column name for the CURRENCY field */
    const CURRENCY = 'panel_guarantee.CURRENCY';

    /** the column name for the AMMOUNT field */
    const AMMOUNT = 'panel_guarantee.AMMOUNT';

    /** the column name for the ISSUEDATE field */
    const ISSUEDATE = 'panel_guarantee.ISSUEDATE';

    /** the column name for the EXPIRATIONTYPE field */
    const EXPIRATIONTYPE = 'panel_guarantee.EXPIRATIONTYPE';

    /** the column name for the EXPIRATIONDATE field */
    const EXPIRATIONDATE = 'panel_guarantee.EXPIRATIONDATE';

    /** the column name for the EXPIRATIONTERMS field */
    const EXPIRATIONTERMS = 'panel_guarantee.EXPIRATIONTERMS';

    /** the column name for the RETURNED field */
    const RETURNED = 'panel_guarantee.RETURNED';

    /** the column name for the DELETED_AT field */
    const DELETED_AT = 'panel_guarantee.DELETED_AT';

    /** The default string format for model objects of the related table **/
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * An identiy map to hold any loaded instances of Guarantee objects.
     * This must be public so that other peer classes can access this when hydrating from JOIN
     * queries.
     * @var        array Guarantee[]
     */
    public static $instances = array();


    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. GuaranteePeer::$fieldNames[GuaranteePeer::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        BasePeer::TYPE_PHPNAME => array ('Id', 'Code', 'Type', 'Projectid', 'Contractorid', 'Issuer', 'Currency', 'Ammount', 'Issuedate', 'Expirationtype', 'Expirationdate', 'Expirationterms', 'Returned', 'DeletedAt', ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id', 'code', 'type', 'projectid', 'contractorid', 'issuer', 'currency', 'ammount', 'issuedate', 'expirationtype', 'expirationdate', 'expirationterms', 'returned', 'deletedAt', ),
        BasePeer::TYPE_COLNAME => array (GuaranteePeer::ID, GuaranteePeer::CODE, GuaranteePeer::TYPE, GuaranteePeer::PROJECTID, GuaranteePeer::CONTRACTORID, GuaranteePeer::ISSUER, GuaranteePeer::CURRENCY, GuaranteePeer::AMMOUNT, GuaranteePeer::ISSUEDATE, GuaranteePeer::EXPIRATIONTYPE, GuaranteePeer::EXPIRATIONDATE, GuaranteePeer::EXPIRATIONTERMS, GuaranteePeer::RETURNED, GuaranteePeer::DELETED_AT, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID', 'CODE', 'TYPE', 'PROJECTID', 'CONTRACTORID', 'ISSUER', 'CURRENCY', 'AMMOUNT', 'ISSUEDATE', 'EXPIRATIONTYPE', 'EXPIRATIONDATE', 'EXPIRATIONTERMS', 'RETURNED', 'DELETED_AT', ),
        BasePeer::TYPE_FIELDNAME => array ('id', 'code', 'type', 'projectId', 'contractorId', 'issuer', 'currency', 'ammount', 'issueDate', 'expirationType', 'expirationDate', 'expirationTerms', 'returned', 'deleted_at', ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. GuaranteePeer::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Code' => 1, 'Type' => 2, 'Projectid' => 3, 'Contractorid' => 4, 'Issuer' => 5, 'Currency' => 6, 'Ammount' => 7, 'Issuedate' => 8, 'Expirationtype' => 9, 'Expirationdate' => 10, 'Expirationterms' => 11, 'Returned' => 12, 'DeletedAt' => 13, ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id' => 0, 'code' => 1, 'type' => 2, 'projectid' => 3, 'contractorid' => 4, 'issuer' => 5, 'currency' => 6, 'ammount' => 7, 'issuedate' => 8, 'expirationtype' => 9, 'expirationdate' => 10, 'expirationterms' => 11, 'returned' => 12, 'deletedAt' => 13, ),
        BasePeer::TYPE_COLNAME => array (GuaranteePeer::ID => 0, GuaranteePeer::CODE => 1, GuaranteePeer::TYPE => 2, GuaranteePeer::PROJECTID => 3, GuaranteePeer::CONTRACTORID => 4, GuaranteePeer::ISSUER => 5, GuaranteePeer::CURRENCY => 6, GuaranteePeer::AMMOUNT => 7, GuaranteePeer::ISSUEDATE => 8, GuaranteePeer::EXPIRATIONTYPE => 9, GuaranteePeer::EXPIRATIONDATE => 10, GuaranteePeer::EXPIRATIONTERMS => 11, GuaranteePeer::RETURNED => 12, GuaranteePeer::DELETED_AT => 13, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID' => 0, 'CODE' => 1, 'TYPE' => 2, 'PROJECTID' => 3, 'CONTRACTORID' => 4, 'ISSUER' => 5, 'CURRENCY' => 6, 'AMMOUNT' => 7, 'ISSUEDATE' => 8, 'EXPIRATIONTYPE' => 9, 'EXPIRATIONDATE' => 10, 'EXPIRATIONTERMS' => 11, 'RETURNED' => 12, 'DELETED_AT' => 13, ),
        BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'code' => 1, 'type' => 2, 'projectId' => 3, 'contractorId' => 4, 'issuer' => 5, 'currency' => 6, 'ammount' => 7, 'issueDate' => 8, 'expirationType' => 9, 'expirationDate' => 10, 'expirationTerms' => 11, 'returned' => 12, 'deleted_at' => 13, ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, )
    );

    /**
     * Translates a fieldname to another type
     *
     * @param      string $name field name
     * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @param      string $toType   One of the class type constants
     * @return string          translated name of the field.
     * @throws PropelException - if the specified name could not be found in the fieldname mappings.
     */
    public static function translateFieldName($name, $fromType, $toType)
    {
        $toNames = GuaranteePeer::getFieldNames($toType);
        $key = isset(GuaranteePeer::$fieldKeys[$fromType][$name]) ? GuaranteePeer::$fieldKeys[$fromType][$name] : null;
        if ($key === null) {
            throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(GuaranteePeer::$fieldKeys[$fromType], true));
        }

        return $toNames[$key];
    }

    /**
     * Returns an array of field names.
     *
     * @param      string $type The type of fieldnames to return:
     *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @return array           A list of field names
     * @throws PropelException - if the type is not valid.
     */
    public static function getFieldNames($type = BasePeer::TYPE_PHPNAME)
    {
        if (!array_key_exists($type, GuaranteePeer::$fieldNames)) {
            throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
        }

        return GuaranteePeer::$fieldNames[$type];
    }

    /**
     * Convenience method which changes table.column to alias.column.
     *
     * Using this method you can maintain SQL abstraction while using column aliases.
     * <code>
     *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
     *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
     * </code>
     * @param      string $alias The alias for the current table.
     * @param      string $column The column name for current table. (i.e. GuaranteePeer::COLUMN_NAME).
     * @return string
     */
    public static function alias($alias, $column)
    {
        return str_replace(GuaranteePeer::TABLE_NAME.'.', $alias.'.', $column);
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param      Criteria $criteria object containing the columns to add.
     * @param      string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(GuaranteePeer::ID);
            $criteria->addSelectColumn(GuaranteePeer::CODE);
            $criteria->addSelectColumn(GuaranteePeer::TYPE);
            $criteria->addSelectColumn(GuaranteePeer::PROJECTID);
            $criteria->addSelectColumn(GuaranteePeer::CONTRACTORID);
            $criteria->addSelectColumn(GuaranteePeer::ISSUER);
            $criteria->addSelectColumn(GuaranteePeer::CURRENCY);
            $criteria->addSelectColumn(GuaranteePeer::AMMOUNT);
            $criteria->addSelectColumn(GuaranteePeer::ISSUEDATE);
            $criteria->addSelectColumn(GuaranteePeer::EXPIRATIONTYPE);
            $criteria->addSelectColumn(GuaranteePeer::EXPIRATIONDATE);
            $criteria->addSelectColumn(GuaranteePeer::EXPIRATIONTERMS);
            $criteria->addSelectColumn(GuaranteePeer::RETURNED);
            $criteria->addSelectColumn(GuaranteePeer::DELETED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.ID');
            $criteria->addSelectColumn($alias . '.CODE');
            $criteria->addSelectColumn($alias . '.TYPE');
            $criteria->addSelectColumn($alias . '.PROJECTID');
            $criteria->addSelectColumn($alias . '.CONTRACTORID');
            $criteria->addSelectColumn($alias . '.ISSUER');
            $criteria->addSelectColumn($alias . '.CURRENCY');
            $criteria->addSelectColumn($alias . '.AMMOUNT');
            $criteria->addSelectColumn($alias . '.ISSUEDATE');
            $criteria->addSelectColumn($alias . '.EXPIRATIONTYPE');
            $criteria->addSelectColumn($alias . '.EXPIRATIONDATE');
            $criteria->addSelectColumn($alias . '.EXPIRATIONTERMS');
            $criteria->addSelectColumn($alias . '.RETURNED');
            $criteria->addSelectColumn($alias . '.DELETED_AT');
        }
    }

    /**
     * Returns the number of rows matching criteria.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @return int Number of matching rows.
     */
    public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
    {
        // we may modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(GuaranteePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            GuaranteePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
        $criteria->setDbName(GuaranteePeer::DATABASE_NAME); // Set the correct dbName

        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        // soft_delete behavior
        if (GuaranteeQuery::isSoftDeleteEnabled()) {
            $criteria->add(GuaranteePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            GuaranteePeer::enableSoftDelete();
        }
        // BasePeer returns a PDOStatement
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }
    /**
     * Selects one object from the DB.
     *
     * @param      Criteria $criteria object used to create the SELECT statement.
     * @param      PropelPDO $con
     * @return                 Guarantee
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
    {
        $critcopy = clone $criteria;
        $critcopy->setLimit(1);
        $objects = GuaranteePeer::doSelect($critcopy, $con);
        if ($objects) {
            return $objects[0];
        }

        return null;
    }
    /**
     * Selects several row from the DB.
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con
     * @return array           Array of selected Objects
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        return GuaranteePeer::populateObjects(GuaranteePeer::doSelectStmt($criteria, $con));
    }
    /**
     * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
     *
     * Use this method directly if you want to work with an executed statement durirectly (for example
     * to perform your own object hydration).
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con The connection to use
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return PDOStatement The executed PDOStatement object.
     * @see        BasePeer::doSelect()
     */
    public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        if (!$criteria->hasSelectClause()) {
            $criteria = clone $criteria;
            GuaranteePeer::addSelectColumns($criteria);
        }

        // Set the correct dbName
        $criteria->setDbName(GuaranteePeer::DATABASE_NAME);
        // soft_delete behavior
        if (GuaranteeQuery::isSoftDeleteEnabled()) {
            $criteria->add(GuaranteePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            GuaranteePeer::enableSoftDelete();
        }

        // BasePeer returns a PDOStatement
        return BasePeer::doSelect($criteria, $con);
    }
    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doSelect*()
     * methods in your stub classes -- you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by doSelect*()
     * and retrieveByPK*() calls.
     *
     * @param      Guarantee $obj A Guarantee object.
     * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if ($key === null) {
                $key = (string) $obj->getId();
            } // if key === null
            GuaranteePeer::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param      mixed $value A Guarantee object or a primary key value.
     *
     * @return void
     * @throws PropelException - if the value is invalid.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && $value !== null) {
            if (is_object($value) && $value instanceof Guarantee) {
                $key = (string) $value->getId();
            } elseif (is_scalar($value)) {
                // assume we've been passed a primary key
                $key = (string) $value;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or Guarantee object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
                throw $e;
            }

            unset(GuaranteePeer::$instances[$key]);
        }
    } // removeInstanceFromPool()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
     * @return   Guarantee Found object or null if 1) no instance exists for specified key or 2) instance pooling has been disabled.
     * @see        getPrimaryKeyHash()
     */
    public static function getInstanceFromPool($key)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (isset(GuaranteePeer::$instances[$key])) {
                return GuaranteePeer::$instances[$key];
            }
        }

        return null; // just to be explicit
    }

    /**
     * Clear the instance pool.
     *
     * @return void
     */
    public static function clearInstancePool()
    {
        GuaranteePeer::$instances = array();
    }

    /**
     * Method to invalidate the instance pool of all tables related to panel_guarantee
     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
        // Invalidate objects in GuaranteeDocumentPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        GuaranteeDocumentPeer::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return string A string version of PK or null if the components of primary key in result array are all null.
     */
    public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
    {
        // If the PK cannot be derived from the row, return null.
        if ($row[$startcol] === null) {
            return null;
        }

        return (string) $row[$startcol];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $startcol = 0)
    {

        return (int) $row[$startcol];
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function populateObjects(PDOStatement $stmt)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = GuaranteePeer::getOMClass();
        // populate the object(s)
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key = GuaranteePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj = GuaranteePeer::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                GuaranteePeer::addInstanceToPool($obj, $key);
            } // if key exists
        }
        $stmt->closeCursor();

        return $results;
    }
    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return array (Guarantee object, last column rank)
     */
    public static function populateObject($row, $startcol = 0)
    {
        $key = GuaranteePeer::getPrimaryKeyHashFromRow($row, $startcol);
        if (null !== ($obj = GuaranteePeer::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $startcol, true); // rehydrate
            $col = $startcol + GuaranteePeer::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = GuaranteePeer::OM_CLASS;
            $obj = new $cls();
            $col = $obj->hydrate($row, $startcol);
            GuaranteePeer::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }


    /**
     * Returns the number of rows matching criteria, joining the related Project table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinProject(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(GuaranteePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            GuaranteePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(GuaranteePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(GuaranteePeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        // soft_delete behavior
        if (GuaranteeQuery::isSoftDeleteEnabled()) {
            $criteria->add(GuaranteePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            GuaranteePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Contractor table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinContractor(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(GuaranteePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            GuaranteePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(GuaranteePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(GuaranteePeer::CONTRACTORID, ContractorPeer::ID, $join_behavior);

        // soft_delete behavior
        if (GuaranteeQuery::isSoftDeleteEnabled()) {
            $criteria->add(GuaranteePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            GuaranteePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of Guarantee objects pre-filled with their Project objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Guarantee objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinProject(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(GuaranteePeer::DATABASE_NAME);
        }

        GuaranteePeer::addSelectColumns($criteria);
        $startcol = GuaranteePeer::NUM_HYDRATE_COLUMNS;
        ProjectPeer::addSelectColumns($criteria);

        $criteria->addJoin(GuaranteePeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        // soft_delete behavior
        if (GuaranteeQuery::isSoftDeleteEnabled()) {
            $criteria->add(GuaranteePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            GuaranteePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = GuaranteePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = GuaranteePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = GuaranteePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                GuaranteePeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = ProjectPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = ProjectPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ProjectPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    ProjectPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (Guarantee) to $obj2 (Project)
                $obj2->addGuarantee($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of Guarantee objects pre-filled with their Contractor objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Guarantee objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinContractor(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(GuaranteePeer::DATABASE_NAME);
        }

        GuaranteePeer::addSelectColumns($criteria);
        $startcol = GuaranteePeer::NUM_HYDRATE_COLUMNS;
        ContractorPeer::addSelectColumns($criteria);

        $criteria->addJoin(GuaranteePeer::CONTRACTORID, ContractorPeer::ID, $join_behavior);

        // soft_delete behavior
        if (GuaranteeQuery::isSoftDeleteEnabled()) {
            $criteria->add(GuaranteePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            GuaranteePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = GuaranteePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = GuaranteePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = GuaranteePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                GuaranteePeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = ContractorPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = ContractorPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ContractorPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    ContractorPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (Guarantee) to $obj2 (Contractor)
                $obj2->addGuarantee($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining all related tables
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAll(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(GuaranteePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            GuaranteePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(GuaranteePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(GuaranteePeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(GuaranteePeer::CONTRACTORID, ContractorPeer::ID, $join_behavior);

        // soft_delete behavior
        if (GuaranteeQuery::isSoftDeleteEnabled()) {
            $criteria->add(GuaranteePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            GuaranteePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }

    /**
     * Selects a collection of Guarantee objects pre-filled with all related objects.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Guarantee objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAll(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(GuaranteePeer::DATABASE_NAME);
        }

        GuaranteePeer::addSelectColumns($criteria);
        $startcol2 = GuaranteePeer::NUM_HYDRATE_COLUMNS;

        ProjectPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ProjectPeer::NUM_HYDRATE_COLUMNS;

        ContractorPeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + ContractorPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(GuaranteePeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(GuaranteePeer::CONTRACTORID, ContractorPeer::ID, $join_behavior);

        // soft_delete behavior
        if (GuaranteeQuery::isSoftDeleteEnabled()) {
            $criteria->add(GuaranteePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            GuaranteePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = GuaranteePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = GuaranteePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = GuaranteePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                GuaranteePeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

            // Add objects for joined Project rows

            $key2 = ProjectPeer::getPrimaryKeyHashFromRow($row, $startcol2);
            if ($key2 !== null) {
                $obj2 = ProjectPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ProjectPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ProjectPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 loaded

                // Add the $obj1 (Guarantee) to the collection in $obj2 (Project)
                $obj2->addGuarantee($obj1);
            } // if joined row not null

            // Add objects for joined Contractor rows

            $key3 = ContractorPeer::getPrimaryKeyHashFromRow($row, $startcol3);
            if ($key3 !== null) {
                $obj3 = ContractorPeer::getInstanceFromPool($key3);
                if (!$obj3) {

                    $cls = ContractorPeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    ContractorPeer::addInstanceToPool($obj3, $key3);
                } // if obj3 loaded

                // Add the $obj1 (Guarantee) to the collection in $obj3 (Contractor)
                $obj3->addGuarantee($obj1);
            } // if joined row not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Project table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptProject(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(GuaranteePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            GuaranteePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(GuaranteePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(GuaranteePeer::CONTRACTORID, ContractorPeer::ID, $join_behavior);

        // soft_delete behavior
        if (GuaranteeQuery::isSoftDeleteEnabled()) {
            $criteria->add(GuaranteePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            GuaranteePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Contractor table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptContractor(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(GuaranteePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            GuaranteePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(GuaranteePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(GuaranteePeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        // soft_delete behavior
        if (GuaranteeQuery::isSoftDeleteEnabled()) {
            $criteria->add(GuaranteePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            GuaranteePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of Guarantee objects pre-filled with all related objects except Project.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Guarantee objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptProject(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(GuaranteePeer::DATABASE_NAME);
        }

        GuaranteePeer::addSelectColumns($criteria);
        $startcol2 = GuaranteePeer::NUM_HYDRATE_COLUMNS;

        ContractorPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ContractorPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(GuaranteePeer::CONTRACTORID, ContractorPeer::ID, $join_behavior);

        // soft_delete behavior
        if (GuaranteeQuery::isSoftDeleteEnabled()) {
            $criteria->add(GuaranteePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            GuaranteePeer::enableSoftDelete();
        }

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = GuaranteePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = GuaranteePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = GuaranteePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                GuaranteePeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined Contractor rows

                $key2 = ContractorPeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = ContractorPeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = ContractorPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ContractorPeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (Guarantee) to the collection in $obj2 (Contractor)
                $obj2->addGuarantee($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of Guarantee objects pre-filled with all related objects except Contractor.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Guarantee objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptContractor(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(GuaranteePeer::DATABASE_NAME);
        }

        GuaranteePeer::addSelectColumns($criteria);
        $startcol2 = GuaranteePeer::NUM_HYDRATE_COLUMNS;

        ProjectPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ProjectPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(GuaranteePeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        // soft_delete behavior
        if (GuaranteeQuery::isSoftDeleteEnabled()) {
            $criteria->add(GuaranteePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            GuaranteePeer::enableSoftDelete();
        }

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = GuaranteePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = GuaranteePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = GuaranteePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                GuaranteePeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined Project rows

                $key2 = ProjectPeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = ProjectPeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = ProjectPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ProjectPeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (Guarantee) to the collection in $obj2 (Project)
                $obj2->addGuarantee($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }

    /**
     * Returns the TableMap related to this peer.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getDatabaseMap(GuaranteePeer::DATABASE_NAME)->getTable(GuaranteePeer::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this peer class.
     */
    public static function buildTableMap()
    {
      $dbMap = Propel::getDatabaseMap(BaseGuaranteePeer::DATABASE_NAME);
      if (!$dbMap->hasTable(BaseGuaranteePeer::TABLE_NAME)) {
        $dbMap->addTableObject(new GuaranteeTableMap());
      }
    }

    /**
     * The class that the Peer will make instances of.
     *
     *
     * @return string ClassName
     */
    public static function getOMClass()
    {
        return GuaranteePeer::OM_CLASS;
    }

    /**
     * Performs an INSERT on the database, given a Guarantee or Criteria object.
     *
     * @param      mixed $values Criteria or Guarantee object containing data that is used to create the INSERT statement.
     * @param      PropelPDO $con the PropelPDO connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doInsert($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity
        } else {
            $criteria = $values->buildCriteria(); // build Criteria from Guarantee object
        }

        if ($criteria->containsKey(GuaranteePeer::ID) && $criteria->keyContainsValue(GuaranteePeer::ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.GuaranteePeer::ID.')');
        }


        // Set the correct dbName
        $criteria->setDbName(GuaranteePeer::DATABASE_NAME);

        try {
            // use transaction because $criteria could contain info
            // for more than one table (I guess, conceivably)
            $con->beginTransaction();
            $pk = BasePeer::doInsert($criteria, $con);
            $con->commit();
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }

        return $pk;
    }

    /**
     * Performs an UPDATE on the database, given a Guarantee or Criteria object.
     *
     * @param      mixed $values Criteria or Guarantee object containing data that is used to create the UPDATE statement.
     * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doUpdate($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $selectCriteria = new Criteria(GuaranteePeer::DATABASE_NAME);

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity

            $comparison = $criteria->getComparison(GuaranteePeer::ID);
            $value = $criteria->remove(GuaranteePeer::ID);
            if ($value) {
                $selectCriteria->add(GuaranteePeer::ID, $value, $comparison);
            } else {
                $selectCriteria->setPrimaryTableName(GuaranteePeer::TABLE_NAME);
            }

        } else { // $values is Guarantee object
            $criteria = $values->buildCriteria(); // gets full criteria
            $selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
        }

        // set the correct dbName
        $criteria->setDbName(GuaranteePeer::DATABASE_NAME);

        return BasePeer::doUpdate($selectCriteria, $criteria, $con);
    }

    /**
     * Deletes all rows from the panel_guarantee table.
     *
     * @param      PropelPDO $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException
     */
    public static function doForceDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $affectedRows = 0; // initialize var to track total num of affected rows
        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();
            $affectedRows += GuaranteePeer::doOnDeleteCascade(new Criteria(GuaranteePeer::DATABASE_NAME), $con);
            $affectedRows += BasePeer::doDeleteAll(GuaranteePeer::TABLE_NAME, $con, GuaranteePeer::DATABASE_NAME);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            GuaranteePeer::clearInstancePool();
            GuaranteePeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs a DELETE on the database, given a Guarantee or Criteria object OR a primary key value.
     *
     * @param      mixed $values Criteria or Guarantee object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param      PropelPDO $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *				if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
     public static function doForceDelete($values, PropelPDO $con = null)
     {
        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = clone $values;
        } elseif ($values instanceof Guarantee) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(GuaranteePeer::DATABASE_NAME);
            $criteria->add(GuaranteePeer::ID, (array) $values, Criteria::IN);
        }

        // Set the correct dbName
        $criteria->setDbName(GuaranteePeer::DATABASE_NAME);

        $affectedRows = 0; // initialize var to track total num of affected rows

        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();

            // cloning the Criteria in case it's modified by doSelect() or doSelectStmt()
            $c = clone $criteria;
            $affectedRows += GuaranteePeer::doOnDeleteCascade($c, $con);

            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            if ($values instanceof Criteria) {
                GuaranteePeer::clearInstancePool();
            } elseif ($values instanceof Guarantee) { // it's a model object
                GuaranteePeer::removeInstanceFromPool($values);
            } else { // it's a primary key, or an array of pks
                foreach ((array) $values as $singleval) {
                    GuaranteePeer::removeInstanceFromPool($singleval);
                }
            }

            $affectedRows += BasePeer::doDelete($criteria, $con);
            GuaranteePeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * This is a method for emulating ON DELETE CASCADE for DBs that don't support this
     * feature (like MySQL or SQLite).
     *
     * This method is not very speedy because it must perform a query first to get
     * the implicated records and then perform the deletes by calling those Peer classes.
     *
     * This method should be used within a transaction if possible.
     *
     * @param      Criteria $criteria
     * @param      PropelPDO $con
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    protected static function doOnDeleteCascade(Criteria $criteria, PropelPDO $con)
    {
        // initialize var to track total num of affected rows
        $affectedRows = 0;

        // first find the objects that are implicated by the $criteria
        $objects = GuaranteePeer::doSelect($criteria, $con);
        foreach ($objects as $obj) {


            // delete related GuaranteeDocument objects
            $criteria = new Criteria(GuaranteeDocumentPeer::DATABASE_NAME);

            $criteria->add(GuaranteeDocumentPeer::GUARANTEEID, $obj->getId());
            $affectedRows += GuaranteeDocumentPeer::doDelete($criteria, $con);
        }

        return $affectedRows;
    }

    /**
     * Validates all modified columns of given Guarantee object.
     * If parameter $columns is either a single column name or an array of column names
     * than only those columns are validated.
     *
     * NOTICE: This does not apply to primary or foreign keys for now.
     *
     * @param      Guarantee $obj The object to validate.
     * @param      mixed $cols Column name or array of column names.
     *
     * @return mixed TRUE if all columns are valid or the error message of the first invalid column.
     */
    public static function doValidate($obj, $cols = null)
    {
        $columns = array();

        if ($cols) {
            $dbMap = Propel::getDatabaseMap(GuaranteePeer::DATABASE_NAME);
            $tableMap = $dbMap->getTable(GuaranteePeer::TABLE_NAME);

            if (! is_array($cols)) {
                $cols = array($cols);
            }

            foreach ($cols as $colName) {
                if ($tableMap->hasColumn($colName)) {
                    $get = 'get' . $tableMap->getColumn($colName)->getPhpName();
                    $columns[$colName] = $obj->$get();
                }
            }
        } else {

        }

        return BasePeer::doValidate(GuaranteePeer::DATABASE_NAME, GuaranteePeer::TABLE_NAME, $columns);
    }

    /**
     * Retrieve a single object by pkey.
     *
     * @param      int $pk the primary key.
     * @param      PropelPDO $con the connection to use
     * @return Guarantee
     */
    public static function retrieveByPK($pk, PropelPDO $con = null)
    {

        if (null !== ($obj = GuaranteePeer::getInstanceFromPool((string) $pk))) {
            return $obj;
        }

        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria = new Criteria(GuaranteePeer::DATABASE_NAME);
        $criteria->add(GuaranteePeer::ID, $pk);

        $v = GuaranteePeer::doSelect($criteria, $con);

        return !empty($v) > 0 ? $v[0] : null;
    }

    /**
     * Retrieve multiple objects by pkey.
     *
     * @param      array $pks List of primary keys
     * @param      PropelPDO $con the connection to use
     * @return Guarantee[]
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function retrieveByPKs($pks, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $objs = null;
        if (empty($pks)) {
            $objs = array();
        } else {
            $criteria = new Criteria(GuaranteePeer::DATABASE_NAME);
            $criteria->add(GuaranteePeer::ID, $pks, Criteria::IN);
            $objs = GuaranteePeer::doSelect($criteria, $con);
        }

        return $objs;
    }

    // soft_delete behavior

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        GuaranteeQuery::enableSoftDelete();
        // some soft_deleted objects may be in the instance pool
        GuaranteePeer::clearInstancePool();
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        GuaranteeQuery::disableSoftDelete();
    }

    /**
     * Check the soft_delete behavior for this model
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return GuaranteeQuery::isSoftDeleteEnabled();
    }

    /**
     * Soft delete records, given a Guarantee or Criteria object OR a primary key value.
     *
     * @param			 mixed $values Criteria or Guarantee object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDelete($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        if ($values instanceof Criteria) {
            // rename for clarity
            $selectCriteria = clone $values;
         } elseif ($values instanceof Guarantee) {
            // create criteria based on pk values
            $selectCriteria = $values->buildPkeyCriteria();
        } else {
            // it must be the primary key
            $selectCriteria = new Criteria(self::DATABASE_NAME);
             $selectCriteria->add(GuaranteePeer::ID, (array) $values, Criteria::IN);
        }
        // Set the correct dbName
        $selectCriteria->setDbName(GuaranteePeer::DATABASE_NAME);
        $updateCriteria = new Criteria(self::DATABASE_NAME);
        $updateCriteria->add(GuaranteePeer::DELETED_AT, time());

         return BasePeer::doUpdate($selectCriteria, $updateCriteria, $con);
    }

    /**
     * Delete or soft delete records, depending on GuaranteePeer::$softDelete
     *
     * @param			 mixed $values Criteria or Guarantee object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDelete($values, PropelPDO $con = null)
    {
        if (GuaranteePeer::isSoftDeleteEnabled()) {
            return GuaranteePeer::doSoftDelete($values, $con);
        } else {
            return GuaranteePeer::doForceDelete($values, $con);
        }
    }
    /**
     * Method to soft delete all rows from the panel_guarantee table.
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $selectCriteria = new Criteria();
        $selectCriteria->add(GuaranteePeer::DELETED_AT, null, Criteria::ISNULL);
        $selectCriteria->setDbName(GuaranteePeer::DATABASE_NAME);
        $modifyCriteria = new Criteria();
        $modifyCriteria->add(GuaranteePeer::DELETED_AT, time());

        return BasePeer::doUpdate($selectCriteria, $modifyCriteria, $con);
    }

    /**
     * Delete or soft delete all records, depending on GuaranteePeer::$softDelete
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDeleteAll(PropelPDO $con = null)
    {
        if (GuaranteePeer::isSoftDeleteEnabled()) {
            return GuaranteePeer::doSoftDeleteAll($con);
        } else {
            return GuaranteePeer::doForceDeleteAll($con);
        }
    }

} // BaseGuaranteePeer

// This is the static code needed to register the TableMap for this table with the main Propel class.
//
BaseGuaranteePeer::buildTableMap();

