<?php


/**
 * Base class that represents a row from the 'panel_contractor' table.
 *
 * Base de Contratistas
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseContractor extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'ContractorPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        ContractorPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the cuit field.
     * @var        string
     */
    protected $cuit;

    /**
     * The value for the address field.
     * @var        string
     */
    protected $address;

    /**
     * The value for the phone field.
     * @var        string
     */
    protected $phone;

    /**
     * The value for the contact field.
     * @var        string
     */
    protected $contact;

    /**
     * The value for the deleted_at field.
     * @var        string
     */
    protected $deleted_at;

    /**
     * @var        PropelObjectCollection|Guarantee[] Collection to store aggregation of Guarantee objects.
     */
    protected $collGuarantees;
    protected $collGuaranteesPartial;

    /**
     * @var        PropelObjectCollection|ContractorCategoryRelation[] Collection to store aggregation of ContractorCategoryRelation objects.
     */
    protected $collContractorCategoryRelations;
    protected $collContractorCategoryRelationsPartial;

    /**
     * @var        PropelObjectCollection|ProjectContractor[] Collection to store aggregation of ProjectContractor objects.
     */
    protected $collProjectContractors;
    protected $collProjectContractorsPartial;

    /**
     * @var        PropelObjectCollection|ContractorCategory[] Collection to store aggregation of ContractorCategory objects.
     */
    protected $collContractorCategorys;

    /**
     * @var        PropelObjectCollection|Project[] Collection to store aggregation of Project objects.
     */
    protected $collProjects;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $contractorCategorysScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $guaranteesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $contractorCategoryRelationsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectContractorsScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     * Identificacion del Contratista
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Nombre
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [cuit] column value.
     * Nombre
     * @return string
     */
    public function getCuit()
    {
        return $this->cuit;
    }

    /**
     * Get the [address] column value.
     * Direccion
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * Get the [phone] column value.
     * Direccion
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Get the [contact] column value.
     * Persona Contacto
     * @return string
     */
    public function getContact()
    {
        return $this->contact;
    }

    /**
     * Get the [optionally formatted] temporal [deleted_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDeletedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->deleted_at === null) {
            return null;
        }

        if ($this->deleted_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->deleted_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->deleted_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     * Identificacion del Contratista
     * @param int $v new value
     * @return Contractor The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = ContractorPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Nombre
     * @param string $v new value
     * @return Contractor The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = ContractorPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [cuit] column.
     * Nombre
     * @param string $v new value
     * @return Contractor The current object (for fluent API support)
     */
    public function setCuit($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->cuit !== $v) {
            $this->cuit = $v;
            $this->modifiedColumns[] = ContractorPeer::CUIT;
        }


        return $this;
    } // setCuit()

    /**
     * Set the value of [address] column.
     * Direccion
     * @param string $v new value
     * @return Contractor The current object (for fluent API support)
     */
    public function setAddress($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->address !== $v) {
            $this->address = $v;
            $this->modifiedColumns[] = ContractorPeer::ADDRESS;
        }


        return $this;
    } // setAddress()

    /**
     * Set the value of [phone] column.
     * Direccion
     * @param string $v new value
     * @return Contractor The current object (for fluent API support)
     */
    public function setPhone($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->phone !== $v) {
            $this->phone = $v;
            $this->modifiedColumns[] = ContractorPeer::PHONE;
        }


        return $this;
    } // setPhone()

    /**
     * Set the value of [contact] column.
     * Persona Contacto
     * @param string $v new value
     * @return Contractor The current object (for fluent API support)
     */
    public function setContact($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->contact !== $v) {
            $this->contact = $v;
            $this->modifiedColumns[] = ContractorPeer::CONTACT;
        }


        return $this;
    } // setContact()

    /**
     * Sets the value of [deleted_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Contractor The current object (for fluent API support)
     */
    public function setDeletedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->deleted_at !== null || $dt !== null) {
            $currentDateAsString = ($this->deleted_at !== null && $tmpDt = new DateTime($this->deleted_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->deleted_at = $newDateAsString;
                $this->modifiedColumns[] = ContractorPeer::DELETED_AT;
            }
        } // if either are not null


        return $this;
    } // setDeletedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->cuit = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->address = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->phone = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->contact = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->deleted_at = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 7; // 7 = ContractorPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Contractor object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ContractorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = ContractorPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->collGuarantees = null;

            $this->collContractorCategoryRelations = null;

            $this->collProjectContractors = null;

            $this->collContractorCategorys = null;
            $this->collProjects = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ContractorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = ContractorQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // soft_delete behavior
            if (!empty($ret) && ContractorQuery::isSoftDeleteEnabled()) {
                $this->setDeletedAt(time());
                $this->save($con);
                $this->postDelete($con);
                $con->commit();
                ContractorPeer::removeInstanceFromPool($this);

                return;
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ContractorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ContractorPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->contractorCategorysScheduledForDeletion !== null) {
                if (!$this->contractorCategorysScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->contractorCategorysScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    ContractorCategoryRelationQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->contractorCategorysScheduledForDeletion = null;
                }

                foreach ($this->getContractorCategorys() as $contractorCategory) {
                    if ($contractorCategory->isModified()) {
                        $contractorCategory->save($con);
                    }
                }
            }

            if ($this->projectsScheduledForDeletion !== null) {
                if (!$this->projectsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->projectsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    ProjectContractorQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->projectsScheduledForDeletion = null;
                }

                foreach ($this->getProjects() as $project) {
                    if ($project->isModified()) {
                        $project->save($con);
                    }
                }
            }

            if ($this->guaranteesScheduledForDeletion !== null) {
                if (!$this->guaranteesScheduledForDeletion->isEmpty()) {
                    foreach ($this->guaranteesScheduledForDeletion as $guarantee) {
                        // need to save related object because we set the relation to null
                        $guarantee->save($con);
                    }
                    $this->guaranteesScheduledForDeletion = null;
                }
            }

            if ($this->collGuarantees !== null) {
                foreach ($this->collGuarantees as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->contractorCategoryRelationsScheduledForDeletion !== null) {
                if (!$this->contractorCategoryRelationsScheduledForDeletion->isEmpty()) {
                    ContractorCategoryRelationQuery::create()
                        ->filterByPrimaryKeys($this->contractorCategoryRelationsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->contractorCategoryRelationsScheduledForDeletion = null;
                }
            }

            if ($this->collContractorCategoryRelations !== null) {
                foreach ($this->collContractorCategoryRelations as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectContractorsScheduledForDeletion !== null) {
                if (!$this->projectContractorsScheduledForDeletion->isEmpty()) {
                    foreach ($this->projectContractorsScheduledForDeletion as $projectContractor) {
                        // need to save related object because we set the relation to null
                        $projectContractor->save($con);
                    }
                    $this->projectContractorsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectContractors !== null) {
                foreach ($this->collProjectContractors as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = ContractorPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . ContractorPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ContractorPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(ContractorPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(ContractorPeer::CUIT)) {
            $modifiedColumns[':p' . $index++]  = '`CUIT`';
        }
        if ($this->isColumnModified(ContractorPeer::ADDRESS)) {
            $modifiedColumns[':p' . $index++]  = '`ADDRESS`';
        }
        if ($this->isColumnModified(ContractorPeer::PHONE)) {
            $modifiedColumns[':p' . $index++]  = '`PHONE`';
        }
        if ($this->isColumnModified(ContractorPeer::CONTACT)) {
            $modifiedColumns[':p' . $index++]  = '`CONTACT`';
        }
        if ($this->isColumnModified(ContractorPeer::DELETED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`DELETED_AT`';
        }

        $sql = sprintf(
            'INSERT INTO `panel_contractor` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`CUIT`':
                        $stmt->bindValue($identifier, $this->cuit, PDO::PARAM_STR);
                        break;
                    case '`ADDRESS`':
                        $stmt->bindValue($identifier, $this->address, PDO::PARAM_STR);
                        break;
                    case '`PHONE`':
                        $stmt->bindValue($identifier, $this->phone, PDO::PARAM_STR);
                        break;
                    case '`CONTACT`':
                        $stmt->bindValue($identifier, $this->contact, PDO::PARAM_STR);
                        break;
                    case '`DELETED_AT`':
                        $stmt->bindValue($identifier, $this->deleted_at, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            if (($retval = ContractorPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collGuarantees !== null) {
                    foreach ($this->collGuarantees as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collContractorCategoryRelations !== null) {
                    foreach ($this->collContractorCategoryRelations as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectContractors !== null) {
                    foreach ($this->collProjectContractors as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ContractorPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getCuit();
                break;
            case 3:
                return $this->getAddress();
                break;
            case 4:
                return $this->getPhone();
                break;
            case 5:
                return $this->getContact();
                break;
            case 6:
                return $this->getDeletedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Contractor'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Contractor'][$this->getPrimaryKey()] = true;
        $keys = ContractorPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getCuit(),
            $keys[3] => $this->getAddress(),
            $keys[4] => $this->getPhone(),
            $keys[5] => $this->getContact(),
            $keys[6] => $this->getDeletedAt(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->collGuarantees) {
                $result['Guarantees'] = $this->collGuarantees->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collContractorCategoryRelations) {
                $result['ContractorCategoryRelations'] = $this->collContractorCategoryRelations->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectContractors) {
                $result['ProjectContractors'] = $this->collProjectContractors->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ContractorPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setCuit($value);
                break;
            case 3:
                $this->setAddress($value);
                break;
            case 4:
                $this->setPhone($value);
                break;
            case 5:
                $this->setContact($value);
                break;
            case 6:
                $this->setDeletedAt($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = ContractorPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setCuit($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setAddress($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setPhone($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setContact($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setDeletedAt($arr[$keys[6]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(ContractorPeer::DATABASE_NAME);

        if ($this->isColumnModified(ContractorPeer::ID)) $criteria->add(ContractorPeer::ID, $this->id);
        if ($this->isColumnModified(ContractorPeer::NAME)) $criteria->add(ContractorPeer::NAME, $this->name);
        if ($this->isColumnModified(ContractorPeer::CUIT)) $criteria->add(ContractorPeer::CUIT, $this->cuit);
        if ($this->isColumnModified(ContractorPeer::ADDRESS)) $criteria->add(ContractorPeer::ADDRESS, $this->address);
        if ($this->isColumnModified(ContractorPeer::PHONE)) $criteria->add(ContractorPeer::PHONE, $this->phone);
        if ($this->isColumnModified(ContractorPeer::CONTACT)) $criteria->add(ContractorPeer::CONTACT, $this->contact);
        if ($this->isColumnModified(ContractorPeer::DELETED_AT)) $criteria->add(ContractorPeer::DELETED_AT, $this->deleted_at);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(ContractorPeer::DATABASE_NAME);
        $criteria->add(ContractorPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Contractor (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setCuit($this->getCuit());
        $copyObj->setAddress($this->getAddress());
        $copyObj->setPhone($this->getPhone());
        $copyObj->setContact($this->getContact());
        $copyObj->setDeletedAt($this->getDeletedAt());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getGuarantees() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addGuarantee($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getContractorCategoryRelations() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addContractorCategoryRelation($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectContractors() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectContractor($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Contractor Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return ContractorPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new ContractorPeer();
        }

        return self::$peer;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('Guarantee' == $relationName) {
            $this->initGuarantees();
        }
        if ('ContractorCategoryRelation' == $relationName) {
            $this->initContractorCategoryRelations();
        }
        if ('ProjectContractor' == $relationName) {
            $this->initProjectContractors();
        }
    }

    /**
     * Clears out the collGuarantees collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addGuarantees()
     */
    public function clearGuarantees()
    {
        $this->collGuarantees = null; // important to set this to null since that means it is uninitialized
        $this->collGuaranteesPartial = null;
    }

    /**
     * reset is the collGuarantees collection loaded partially
     *
     * @return void
     */
    public function resetPartialGuarantees($v = true)
    {
        $this->collGuaranteesPartial = $v;
    }

    /**
     * Initializes the collGuarantees collection.
     *
     * By default this just sets the collGuarantees collection to an empty array (like clearcollGuarantees());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initGuarantees($overrideExisting = true)
    {
        if (null !== $this->collGuarantees && !$overrideExisting) {
            return;
        }
        $this->collGuarantees = new PropelObjectCollection();
        $this->collGuarantees->setModel('Guarantee');
    }

    /**
     * Gets an array of Guarantee objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Contractor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Guarantee[] List of Guarantee objects
     * @throws PropelException
     */
    public function getGuarantees($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collGuaranteesPartial && !$this->isNew();
        if (null === $this->collGuarantees || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collGuarantees) {
                // return empty collection
                $this->initGuarantees();
            } else {
                $collGuarantees = GuaranteeQuery::create(null, $criteria)
                    ->filterByContractor($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collGuaranteesPartial && count($collGuarantees)) {
                      $this->initGuarantees(false);

                      foreach($collGuarantees as $obj) {
                        if (false == $this->collGuarantees->contains($obj)) {
                          $this->collGuarantees->append($obj);
                        }
                      }

                      $this->collGuaranteesPartial = true;
                    }

                    return $collGuarantees;
                }

                if($partial && $this->collGuarantees) {
                    foreach($this->collGuarantees as $obj) {
                        if($obj->isNew()) {
                            $collGuarantees[] = $obj;
                        }
                    }
                }

                $this->collGuarantees = $collGuarantees;
                $this->collGuaranteesPartial = false;
            }
        }

        return $this->collGuarantees;
    }

    /**
     * Sets a collection of Guarantee objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $guarantees A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setGuarantees(PropelCollection $guarantees, PropelPDO $con = null)
    {
        $this->guaranteesScheduledForDeletion = $this->getGuarantees(new Criteria(), $con)->diff($guarantees);

        foreach ($this->guaranteesScheduledForDeletion as $guaranteeRemoved) {
            $guaranteeRemoved->setContractor(null);
        }

        $this->collGuarantees = null;
        foreach ($guarantees as $guarantee) {
            $this->addGuarantee($guarantee);
        }

        $this->collGuarantees = $guarantees;
        $this->collGuaranteesPartial = false;
    }

    /**
     * Returns the number of related Guarantee objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Guarantee objects.
     * @throws PropelException
     */
    public function countGuarantees(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collGuaranteesPartial && !$this->isNew();
        if (null === $this->collGuarantees || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collGuarantees) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getGuarantees());
                }
                $query = GuaranteeQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByContractor($this)
                    ->count($con);
            }
        } else {
            return count($this->collGuarantees);
        }
    }

    /**
     * Method called to associate a Guarantee object to this object
     * through the Guarantee foreign key attribute.
     *
     * @param    Guarantee $l Guarantee
     * @return Contractor The current object (for fluent API support)
     */
    public function addGuarantee(Guarantee $l)
    {
        if ($this->collGuarantees === null) {
            $this->initGuarantees();
            $this->collGuaranteesPartial = true;
        }
        if (!$this->collGuarantees->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddGuarantee($l);
        }

        return $this;
    }

    /**
     * @param	Guarantee $guarantee The guarantee object to add.
     */
    protected function doAddGuarantee($guarantee)
    {
        $this->collGuarantees[]= $guarantee;
        $guarantee->setContractor($this);
    }

    /**
     * @param	Guarantee $guarantee The guarantee object to remove.
     */
    public function removeGuarantee($guarantee)
    {
        if ($this->getGuarantees()->contains($guarantee)) {
            $this->collGuarantees->remove($this->collGuarantees->search($guarantee));
            if (null === $this->guaranteesScheduledForDeletion) {
                $this->guaranteesScheduledForDeletion = clone $this->collGuarantees;
                $this->guaranteesScheduledForDeletion->clear();
            }
            $this->guaranteesScheduledForDeletion[]= $guarantee;
            $guarantee->setContractor(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Contractor is new, it will return
     * an empty collection; or if this Contractor has previously
     * been saved, it will retrieve related Guarantees from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Contractor.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Guarantee[] List of Guarantee objects
     */
    public function getGuaranteesJoinProject($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = GuaranteeQuery::create(null, $criteria);
        $query->joinWith('Project', $join_behavior);

        return $this->getGuarantees($query, $con);
    }

    /**
     * Clears out the collContractorCategoryRelations collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addContractorCategoryRelations()
     */
    public function clearContractorCategoryRelations()
    {
        $this->collContractorCategoryRelations = null; // important to set this to null since that means it is uninitialized
        $this->collContractorCategoryRelationsPartial = null;
    }

    /**
     * reset is the collContractorCategoryRelations collection loaded partially
     *
     * @return void
     */
    public function resetPartialContractorCategoryRelations($v = true)
    {
        $this->collContractorCategoryRelationsPartial = $v;
    }

    /**
     * Initializes the collContractorCategoryRelations collection.
     *
     * By default this just sets the collContractorCategoryRelations collection to an empty array (like clearcollContractorCategoryRelations());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initContractorCategoryRelations($overrideExisting = true)
    {
        if (null !== $this->collContractorCategoryRelations && !$overrideExisting) {
            return;
        }
        $this->collContractorCategoryRelations = new PropelObjectCollection();
        $this->collContractorCategoryRelations->setModel('ContractorCategoryRelation');
    }

    /**
     * Gets an array of ContractorCategoryRelation objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Contractor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ContractorCategoryRelation[] List of ContractorCategoryRelation objects
     * @throws PropelException
     */
    public function getContractorCategoryRelations($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collContractorCategoryRelationsPartial && !$this->isNew();
        if (null === $this->collContractorCategoryRelations || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collContractorCategoryRelations) {
                // return empty collection
                $this->initContractorCategoryRelations();
            } else {
                $collContractorCategoryRelations = ContractorCategoryRelationQuery::create(null, $criteria)
                    ->filterByContractor($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collContractorCategoryRelationsPartial && count($collContractorCategoryRelations)) {
                      $this->initContractorCategoryRelations(false);

                      foreach($collContractorCategoryRelations as $obj) {
                        if (false == $this->collContractorCategoryRelations->contains($obj)) {
                          $this->collContractorCategoryRelations->append($obj);
                        }
                      }

                      $this->collContractorCategoryRelationsPartial = true;
                    }

                    return $collContractorCategoryRelations;
                }

                if($partial && $this->collContractorCategoryRelations) {
                    foreach($this->collContractorCategoryRelations as $obj) {
                        if($obj->isNew()) {
                            $collContractorCategoryRelations[] = $obj;
                        }
                    }
                }

                $this->collContractorCategoryRelations = $collContractorCategoryRelations;
                $this->collContractorCategoryRelationsPartial = false;
            }
        }

        return $this->collContractorCategoryRelations;
    }

    /**
     * Sets a collection of ContractorCategoryRelation objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $contractorCategoryRelations A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setContractorCategoryRelations(PropelCollection $contractorCategoryRelations, PropelPDO $con = null)
    {
        $this->contractorCategoryRelationsScheduledForDeletion = $this->getContractorCategoryRelations(new Criteria(), $con)->diff($contractorCategoryRelations);

        foreach ($this->contractorCategoryRelationsScheduledForDeletion as $contractorCategoryRelationRemoved) {
            $contractorCategoryRelationRemoved->setContractor(null);
        }

        $this->collContractorCategoryRelations = null;
        foreach ($contractorCategoryRelations as $contractorCategoryRelation) {
            $this->addContractorCategoryRelation($contractorCategoryRelation);
        }

        $this->collContractorCategoryRelations = $contractorCategoryRelations;
        $this->collContractorCategoryRelationsPartial = false;
    }

    /**
     * Returns the number of related ContractorCategoryRelation objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ContractorCategoryRelation objects.
     * @throws PropelException
     */
    public function countContractorCategoryRelations(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collContractorCategoryRelationsPartial && !$this->isNew();
        if (null === $this->collContractorCategoryRelations || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collContractorCategoryRelations) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getContractorCategoryRelations());
                }
                $query = ContractorCategoryRelationQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByContractor($this)
                    ->count($con);
            }
        } else {
            return count($this->collContractorCategoryRelations);
        }
    }

    /**
     * Method called to associate a ContractorCategoryRelation object to this object
     * through the ContractorCategoryRelation foreign key attribute.
     *
     * @param    ContractorCategoryRelation $l ContractorCategoryRelation
     * @return Contractor The current object (for fluent API support)
     */
    public function addContractorCategoryRelation(ContractorCategoryRelation $l)
    {
        if ($this->collContractorCategoryRelations === null) {
            $this->initContractorCategoryRelations();
            $this->collContractorCategoryRelationsPartial = true;
        }
        if (!$this->collContractorCategoryRelations->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddContractorCategoryRelation($l);
        }

        return $this;
    }

    /**
     * @param	ContractorCategoryRelation $contractorCategoryRelation The contractorCategoryRelation object to add.
     */
    protected function doAddContractorCategoryRelation($contractorCategoryRelation)
    {
        $this->collContractorCategoryRelations[]= $contractorCategoryRelation;
        $contractorCategoryRelation->setContractor($this);
    }

    /**
     * @param	ContractorCategoryRelation $contractorCategoryRelation The contractorCategoryRelation object to remove.
     */
    public function removeContractorCategoryRelation($contractorCategoryRelation)
    {
        if ($this->getContractorCategoryRelations()->contains($contractorCategoryRelation)) {
            $this->collContractorCategoryRelations->remove($this->collContractorCategoryRelations->search($contractorCategoryRelation));
            if (null === $this->contractorCategoryRelationsScheduledForDeletion) {
                $this->contractorCategoryRelationsScheduledForDeletion = clone $this->collContractorCategoryRelations;
                $this->contractorCategoryRelationsScheduledForDeletion->clear();
            }
            $this->contractorCategoryRelationsScheduledForDeletion[]= $contractorCategoryRelation;
            $contractorCategoryRelation->setContractor(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Contractor is new, it will return
     * an empty collection; or if this Contractor has previously
     * been saved, it will retrieve related ContractorCategoryRelations from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Contractor.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ContractorCategoryRelation[] List of ContractorCategoryRelation objects
     */
    public function getContractorCategoryRelationsJoinContractorCategory($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ContractorCategoryRelationQuery::create(null, $criteria);
        $query->joinWith('ContractorCategory', $join_behavior);

        return $this->getContractorCategoryRelations($query, $con);
    }

    /**
     * Clears out the collProjectContractors collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectContractors()
     */
    public function clearProjectContractors()
    {
        $this->collProjectContractors = null; // important to set this to null since that means it is uninitialized
        $this->collProjectContractorsPartial = null;
    }

    /**
     * reset is the collProjectContractors collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectContractors($v = true)
    {
        $this->collProjectContractorsPartial = $v;
    }

    /**
     * Initializes the collProjectContractors collection.
     *
     * By default this just sets the collProjectContractors collection to an empty array (like clearcollProjectContractors());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectContractors($overrideExisting = true)
    {
        if (null !== $this->collProjectContractors && !$overrideExisting) {
            return;
        }
        $this->collProjectContractors = new PropelObjectCollection();
        $this->collProjectContractors->setModel('ProjectContractor');
    }

    /**
     * Gets an array of ProjectContractor objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Contractor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectContractor[] List of ProjectContractor objects
     * @throws PropelException
     */
    public function getProjectContractors($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectContractorsPartial && !$this->isNew();
        if (null === $this->collProjectContractors || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectContractors) {
                // return empty collection
                $this->initProjectContractors();
            } else {
                $collProjectContractors = ProjectContractorQuery::create(null, $criteria)
                    ->filterByContractor($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectContractorsPartial && count($collProjectContractors)) {
                      $this->initProjectContractors(false);

                      foreach($collProjectContractors as $obj) {
                        if (false == $this->collProjectContractors->contains($obj)) {
                          $this->collProjectContractors->append($obj);
                        }
                      }

                      $this->collProjectContractorsPartial = true;
                    }

                    return $collProjectContractors;
                }

                if($partial && $this->collProjectContractors) {
                    foreach($this->collProjectContractors as $obj) {
                        if($obj->isNew()) {
                            $collProjectContractors[] = $obj;
                        }
                    }
                }

                $this->collProjectContractors = $collProjectContractors;
                $this->collProjectContractorsPartial = false;
            }
        }

        return $this->collProjectContractors;
    }

    /**
     * Sets a collection of ProjectContractor objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectContractors A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectContractors(PropelCollection $projectContractors, PropelPDO $con = null)
    {
        $this->projectContractorsScheduledForDeletion = $this->getProjectContractors(new Criteria(), $con)->diff($projectContractors);

        foreach ($this->projectContractorsScheduledForDeletion as $projectContractorRemoved) {
            $projectContractorRemoved->setContractor(null);
        }

        $this->collProjectContractors = null;
        foreach ($projectContractors as $projectContractor) {
            $this->addProjectContractor($projectContractor);
        }

        $this->collProjectContractors = $projectContractors;
        $this->collProjectContractorsPartial = false;
    }

    /**
     * Returns the number of related ProjectContractor objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectContractor objects.
     * @throws PropelException
     */
    public function countProjectContractors(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectContractorsPartial && !$this->isNew();
        if (null === $this->collProjectContractors || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectContractors) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectContractors());
                }
                $query = ProjectContractorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByContractor($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectContractors);
        }
    }

    /**
     * Method called to associate a ProjectContractor object to this object
     * through the ProjectContractor foreign key attribute.
     *
     * @param    ProjectContractor $l ProjectContractor
     * @return Contractor The current object (for fluent API support)
     */
    public function addProjectContractor(ProjectContractor $l)
    {
        if ($this->collProjectContractors === null) {
            $this->initProjectContractors();
            $this->collProjectContractorsPartial = true;
        }
        if (!$this->collProjectContractors->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectContractor($l);
        }

        return $this;
    }

    /**
     * @param	ProjectContractor $projectContractor The projectContractor object to add.
     */
    protected function doAddProjectContractor($projectContractor)
    {
        $this->collProjectContractors[]= $projectContractor;
        $projectContractor->setContractor($this);
    }

    /**
     * @param	ProjectContractor $projectContractor The projectContractor object to remove.
     */
    public function removeProjectContractor($projectContractor)
    {
        if ($this->getProjectContractors()->contains($projectContractor)) {
            $this->collProjectContractors->remove($this->collProjectContractors->search($projectContractor));
            if (null === $this->projectContractorsScheduledForDeletion) {
                $this->projectContractorsScheduledForDeletion = clone $this->collProjectContractors;
                $this->projectContractorsScheduledForDeletion->clear();
            }
            $this->projectContractorsScheduledForDeletion[]= $projectContractor;
            $projectContractor->setContractor(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Contractor is new, it will return
     * an empty collection; or if this Contractor has previously
     * been saved, it will retrieve related ProjectContractors from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Contractor.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectContractor[] List of ProjectContractor objects
     */
    public function getProjectContractorsJoinProject($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectContractorQuery::create(null, $criteria);
        $query->joinWith('Project', $join_behavior);

        return $this->getProjectContractors($query, $con);
    }

    /**
     * Clears out the collContractorCategorys collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addContractorCategorys()
     */
    public function clearContractorCategorys()
    {
        $this->collContractorCategorys = null; // important to set this to null since that means it is uninitialized
        $this->collContractorCategorysPartial = null;
    }

    /**
     * Initializes the collContractorCategorys collection.
     *
     * By default this just sets the collContractorCategorys collection to an empty collection (like clearContractorCategorys());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initContractorCategorys()
    {
        $this->collContractorCategorys = new PropelObjectCollection();
        $this->collContractorCategorys->setModel('ContractorCategory');
    }

    /**
     * Gets a collection of ContractorCategory objects related by a many-to-many relationship
     * to the current object by way of the panel_contractorCategoryRelation cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Contractor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|ContractorCategory[] List of ContractorCategory objects
     */
    public function getContractorCategorys($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collContractorCategorys || null !== $criteria) {
            if ($this->isNew() && null === $this->collContractorCategorys) {
                // return empty collection
                $this->initContractorCategorys();
            } else {
                $collContractorCategorys = ContractorCategoryQuery::create(null, $criteria)
                    ->filterByContractor($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collContractorCategorys;
                }
                $this->collContractorCategorys = $collContractorCategorys;
            }
        }

        return $this->collContractorCategorys;
    }

    /**
     * Sets a collection of ContractorCategory objects related by a many-to-many relationship
     * to the current object by way of the panel_contractorCategoryRelation cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $contractorCategorys A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setContractorCategorys(PropelCollection $contractorCategorys, PropelPDO $con = null)
    {
        $this->clearContractorCategorys();
        $currentContractorCategorys = $this->getContractorCategorys();

        $this->contractorCategorysScheduledForDeletion = $currentContractorCategorys->diff($contractorCategorys);

        foreach ($contractorCategorys as $contractorCategory) {
            if (!$currentContractorCategorys->contains($contractorCategory)) {
                $this->doAddContractorCategory($contractorCategory);
            }
        }

        $this->collContractorCategorys = $contractorCategorys;
    }

    /**
     * Gets the number of ContractorCategory objects related by a many-to-many relationship
     * to the current object by way of the panel_contractorCategoryRelation cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related ContractorCategory objects
     */
    public function countContractorCategorys($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collContractorCategorys || null !== $criteria) {
            if ($this->isNew() && null === $this->collContractorCategorys) {
                return 0;
            } else {
                $query = ContractorCategoryQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByContractor($this)
                    ->count($con);
            }
        } else {
            return count($this->collContractorCategorys);
        }
    }

    /**
     * Associate a ContractorCategory object to this object
     * through the panel_contractorCategoryRelation cross reference table.
     *
     * @param  ContractorCategory $contractorCategory The ContractorCategoryRelation object to relate
     * @return void
     */
    public function addContractorCategory(ContractorCategory $contractorCategory)
    {
        if ($this->collContractorCategorys === null) {
            $this->initContractorCategorys();
        }
        if (!$this->collContractorCategorys->contains($contractorCategory)) { // only add it if the **same** object is not already associated
            $this->doAddContractorCategory($contractorCategory);

            $this->collContractorCategorys[]= $contractorCategory;
        }
    }

    /**
     * @param	ContractorCategory $contractorCategory The contractorCategory object to add.
     */
    protected function doAddContractorCategory($contractorCategory)
    {
        $contractorCategoryRelation = new ContractorCategoryRelation();
        $contractorCategoryRelation->setContractorCategory($contractorCategory);
        $this->addContractorCategoryRelation($contractorCategoryRelation);
    }

    /**
     * Remove a ContractorCategory object to this object
     * through the panel_contractorCategoryRelation cross reference table.
     *
     * @param ContractorCategory $contractorCategory The ContractorCategoryRelation object to relate
     * @return void
     */
    public function removeContractorCategory(ContractorCategory $contractorCategory)
    {
        if ($this->getContractorCategorys()->contains($contractorCategory)) {
            $this->collContractorCategorys->remove($this->collContractorCategorys->search($contractorCategory));
            if (null === $this->contractorCategorysScheduledForDeletion) {
                $this->contractorCategorysScheduledForDeletion = clone $this->collContractorCategorys;
                $this->contractorCategorysScheduledForDeletion->clear();
            }
            $this->contractorCategorysScheduledForDeletion[]= $contractorCategory;
        }
    }

    /**
     * Clears out the collProjects collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjects()
     */
    public function clearProjects()
    {
        $this->collProjects = null; // important to set this to null since that means it is uninitialized
        $this->collProjectsPartial = null;
    }

    /**
     * Initializes the collProjects collection.
     *
     * By default this just sets the collProjects collection to an empty collection (like clearProjects());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initProjects()
    {
        $this->collProjects = new PropelObjectCollection();
        $this->collProjects->setModel('Project');
    }

    /**
     * Gets a collection of Project objects related by a many-to-many relationship
     * to the current object by way of the projects_contractor cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Contractor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Project[] List of Project objects
     */
    public function getProjects($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collProjects || null !== $criteria) {
            if ($this->isNew() && null === $this->collProjects) {
                // return empty collection
                $this->initProjects();
            } else {
                $collProjects = ProjectQuery::create(null, $criteria)
                    ->filterByContractor($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collProjects;
                }
                $this->collProjects = $collProjects;
            }
        }

        return $this->collProjects;
    }

    /**
     * Sets a collection of Project objects related by a many-to-many relationship
     * to the current object by way of the projects_contractor cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projects A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjects(PropelCollection $projects, PropelPDO $con = null)
    {
        $this->clearProjects();
        $currentProjects = $this->getProjects();

        $this->projectsScheduledForDeletion = $currentProjects->diff($projects);

        foreach ($projects as $project) {
            if (!$currentProjects->contains($project)) {
                $this->doAddProject($project);
            }
        }

        $this->collProjects = $projects;
    }

    /**
     * Gets the number of Project objects related by a many-to-many relationship
     * to the current object by way of the projects_contractor cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Project objects
     */
    public function countProjects($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collProjects || null !== $criteria) {
            if ($this->isNew() && null === $this->collProjects) {
                return 0;
            } else {
                $query = ProjectQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByContractor($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjects);
        }
    }

    /**
     * Associate a Project object to this object
     * through the projects_contractor cross reference table.
     *
     * @param  Project $project The ProjectContractor object to relate
     * @return void
     */
    public function addProject(Project $project)
    {
        if ($this->collProjects === null) {
            $this->initProjects();
        }
        if (!$this->collProjects->contains($project)) { // only add it if the **same** object is not already associated
            $this->doAddProject($project);

            $this->collProjects[]= $project;
        }
    }

    /**
     * @param	Project $project The project object to add.
     */
    protected function doAddProject($project)
    {
        $projectContractor = new ProjectContractor();
        $projectContractor->setProject($project);
        $this->addProjectContractor($projectContractor);
    }

    /**
     * Remove a Project object to this object
     * through the projects_contractor cross reference table.
     *
     * @param Project $project The ProjectContractor object to relate
     * @return void
     */
    public function removeProject(Project $project)
    {
        if ($this->getProjects()->contains($project)) {
            $this->collProjects->remove($this->collProjects->search($project));
            if (null === $this->projectsScheduledForDeletion) {
                $this->projectsScheduledForDeletion = clone $this->collProjects;
                $this->projectsScheduledForDeletion->clear();
            }
            $this->projectsScheduledForDeletion[]= $project;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->cuit = null;
        $this->address = null;
        $this->phone = null;
        $this->contact = null;
        $this->deleted_at = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collGuarantees) {
                foreach ($this->collGuarantees as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collContractorCategoryRelations) {
                foreach ($this->collContractorCategoryRelations as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectContractors) {
                foreach ($this->collProjectContractors as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collContractorCategorys) {
                foreach ($this->collContractorCategorys as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjects) {
                foreach ($this->collProjects as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collGuarantees instanceof PropelCollection) {
            $this->collGuarantees->clearIterator();
        }
        $this->collGuarantees = null;
        if ($this->collContractorCategoryRelations instanceof PropelCollection) {
            $this->collContractorCategoryRelations->clearIterator();
        }
        $this->collContractorCategoryRelations = null;
        if ($this->collProjectContractors instanceof PropelCollection) {
            $this->collProjectContractors->clearIterator();
        }
        $this->collProjectContractors = null;
        if ($this->collContractorCategorys instanceof PropelCollection) {
            $this->collContractorCategorys->clearIterator();
        }
        $this->collContractorCategorys = null;
        if ($this->collProjects instanceof PropelCollection) {
            $this->collProjects->clearIterator();
        }
        $this->collProjects = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(ContractorPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // soft_delete behavior

    /**
     * Bypass the soft_delete behavior and force a hard delete of the current object
     */
    public function forceDelete(PropelPDO $con = null)
    {
        if ($isSoftDeleteEnabled = ContractorPeer::isSoftDeleteEnabled()) {
            ContractorPeer::disableSoftDelete();
        }
        $this->delete($con);
        if ($isSoftDeleteEnabled) {
            ContractorPeer::enableSoftDelete();
        }
    }

    /**
     * Undelete a row that was soft_deleted
     *
     * @return		 int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        $this->setDeletedAt(null);

        return $this->save($con);
    }

}
