<?php


/**
 * Base class that represents a query for the 'panel_administrativeActDocument' table.
 *
 *
 *
 * @method AdministrativeActDocumentQuery orderByAdministrativeactid($order = Criteria::ASC) Order by the administrativeActId column
 * @method AdministrativeActDocumentQuery orderByDocumentid($order = Criteria::ASC) Order by the documentId column
 *
 * @method AdministrativeActDocumentQuery groupByAdministrativeactid() Group by the administrativeActId column
 * @method AdministrativeActDocumentQuery groupByDocumentid() Group by the documentId column
 *
 * @method AdministrativeActDocumentQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method AdministrativeActDocumentQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method AdministrativeActDocumentQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method AdministrativeActDocumentQuery leftJoinAdministrativeAct($relationAlias = null) Adds a LEFT JOIN clause to the query using the AdministrativeAct relation
 * @method AdministrativeActDocumentQuery rightJoinAdministrativeAct($relationAlias = null) Adds a RIGHT JOIN clause to the query using the AdministrativeAct relation
 * @method AdministrativeActDocumentQuery innerJoinAdministrativeAct($relationAlias = null) Adds a INNER JOIN clause to the query using the AdministrativeAct relation
 *
 * @method AdministrativeActDocumentQuery leftJoinDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the Document relation
 * @method AdministrativeActDocumentQuery rightJoinDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Document relation
 * @method AdministrativeActDocumentQuery innerJoinDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the Document relation
 *
 * @method AdministrativeActDocument findOne(PropelPDO $con = null) Return the first AdministrativeActDocument matching the query
 * @method AdministrativeActDocument findOneOrCreate(PropelPDO $con = null) Return the first AdministrativeActDocument matching the query, or a new AdministrativeActDocument object populated from the query conditions when no match is found
 *
 * @method AdministrativeActDocument findOneByAdministrativeactid(int $administrativeActId) Return the first AdministrativeActDocument filtered by the administrativeActId column
 * @method AdministrativeActDocument findOneByDocumentid(int $documentId) Return the first AdministrativeActDocument filtered by the documentId column
 *
 * @method array findByAdministrativeactid(int $administrativeActId) Return AdministrativeActDocument objects filtered by the administrativeActId column
 * @method array findByDocumentid(int $documentId) Return AdministrativeActDocument objects filtered by the documentId column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseAdministrativeActDocumentQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseAdministrativeActDocumentQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'AdministrativeActDocument', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new AdministrativeActDocumentQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     AdministrativeActDocumentQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return AdministrativeActDocumentQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof AdministrativeActDocumentQuery) {
            return $criteria;
        }
        $query = new AdministrativeActDocumentQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$administrativeActId, $documentId]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   AdministrativeActDocument|AdministrativeActDocument[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = AdministrativeActDocumentPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(AdministrativeActDocumentPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   AdministrativeActDocument A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ADMINISTRATIVEACTID`, `DOCUMENTID` FROM `panel_administrativeActDocument` WHERE `ADMINISTRATIVEACTID` = :p0 AND `DOCUMENTID` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new AdministrativeActDocument();
            $obj->hydrate($row);
            AdministrativeActDocumentPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return AdministrativeActDocument|AdministrativeActDocument[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|AdministrativeActDocument[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return AdministrativeActDocumentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(AdministrativeActDocumentPeer::ADMINISTRATIVEACTID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(AdministrativeActDocumentPeer::DOCUMENTID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return AdministrativeActDocumentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(AdministrativeActDocumentPeer::ADMINISTRATIVEACTID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(AdministrativeActDocumentPeer::DOCUMENTID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the administrativeActId column
     *
     * Example usage:
     * <code>
     * $query->filterByAdministrativeactid(1234); // WHERE administrativeActId = 1234
     * $query->filterByAdministrativeactid(array(12, 34)); // WHERE administrativeActId IN (12, 34)
     * $query->filterByAdministrativeactid(array('min' => 12)); // WHERE administrativeActId > 12
     * </code>
     *
     * @see       filterByAdministrativeAct()
     *
     * @param     mixed $administrativeactid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AdministrativeActDocumentQuery The current query, for fluid interface
     */
    public function filterByAdministrativeactid($administrativeactid = null, $comparison = null)
    {
        if (is_array($administrativeactid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(AdministrativeActDocumentPeer::ADMINISTRATIVEACTID, $administrativeactid, $comparison);
    }

    /**
     * Filter the query on the documentId column
     *
     * Example usage:
     * <code>
     * $query->filterByDocumentid(1234); // WHERE documentId = 1234
     * $query->filterByDocumentid(array(12, 34)); // WHERE documentId IN (12, 34)
     * $query->filterByDocumentid(array('min' => 12)); // WHERE documentId > 12
     * </code>
     *
     * @see       filterByDocument()
     *
     * @param     mixed $documentid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AdministrativeActDocumentQuery The current query, for fluid interface
     */
    public function filterByDocumentid($documentid = null, $comparison = null)
    {
        if (is_array($documentid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(AdministrativeActDocumentPeer::DOCUMENTID, $documentid, $comparison);
    }

    /**
     * Filter the query by a related AdministrativeAct object
     *
     * @param   AdministrativeAct|PropelObjectCollection $administrativeAct The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   AdministrativeActDocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByAdministrativeAct($administrativeAct, $comparison = null)
    {
        if ($administrativeAct instanceof AdministrativeAct) {
            return $this
                ->addUsingAlias(AdministrativeActDocumentPeer::ADMINISTRATIVEACTID, $administrativeAct->getId(), $comparison);
        } elseif ($administrativeAct instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(AdministrativeActDocumentPeer::ADMINISTRATIVEACTID, $administrativeAct->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByAdministrativeAct() only accepts arguments of type AdministrativeAct or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the AdministrativeAct relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return AdministrativeActDocumentQuery The current query, for fluid interface
     */
    public function joinAdministrativeAct($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('AdministrativeAct');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'AdministrativeAct');
        }

        return $this;
    }

    /**
     * Use the AdministrativeAct relation AdministrativeAct object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   AdministrativeActQuery A secondary query class using the current class as primary query
     */
    public function useAdministrativeActQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinAdministrativeAct($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'AdministrativeAct', 'AdministrativeActQuery');
    }

    /**
     * Filter the query by a related Document object
     *
     * @param   Document|PropelObjectCollection $document The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   AdministrativeActDocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByDocument($document, $comparison = null)
    {
        if ($document instanceof Document) {
            return $this
                ->addUsingAlias(AdministrativeActDocumentPeer::DOCUMENTID, $document->getId(), $comparison);
        } elseif ($document instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(AdministrativeActDocumentPeer::DOCUMENTID, $document->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByDocument() only accepts arguments of type Document or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Document relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return AdministrativeActDocumentQuery The current query, for fluid interface
     */
    public function joinDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Document');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Document');
        }

        return $this;
    }

    /**
     * Use the Document relation Document object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   DocumentQuery A secondary query class using the current class as primary query
     */
    public function useDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Document', 'DocumentQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   AdministrativeActDocument $administrativeActDocument Object to remove from the list of results
     *
     * @return AdministrativeActDocumentQuery The current query, for fluid interface
     */
    public function prune($administrativeActDocument = null)
    {
        if ($administrativeActDocument) {
            $this->addCond('pruneCond0', $this->getAliasedColName(AdministrativeActDocumentPeer::ADMINISTRATIVEACTID), $administrativeActDocument->getAdministrativeactid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(AdministrativeActDocumentPeer::DOCUMENTID), $administrativeActDocument->getDocumentid(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
