<?php


/**
 * Base class that represents a query for the 'objectives_region' table.
 *
 * Asociacion entre Regiones y Objetivos
 *
 * @method ObjectiveRegionQuery orderByRegionid($order = Criteria::ASC) Order by the regionId column
 * @method ObjectiveRegionQuery orderByObjectiveid($order = Criteria::ASC) Order by the objectiveId column
 *
 * @method ObjectiveRegionQuery groupByRegionid() Group by the regionId column
 * @method ObjectiveRegionQuery groupByObjectiveid() Group by the objectiveId column
 *
 * @method ObjectiveRegionQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ObjectiveRegionQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ObjectiveRegionQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ObjectiveRegionQuery leftJoinRegion($relationAlias = null) Adds a LEFT JOIN clause to the query using the Region relation
 * @method ObjectiveRegionQuery rightJoinRegion($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Region relation
 * @method ObjectiveRegionQuery innerJoinRegion($relationAlias = null) Adds a INNER JOIN clause to the query using the Region relation
 *
 * @method ObjectiveRegionQuery leftJoinObjective($relationAlias = null) Adds a LEFT JOIN clause to the query using the Objective relation
 * @method ObjectiveRegionQuery rightJoinObjective($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Objective relation
 * @method ObjectiveRegionQuery innerJoinObjective($relationAlias = null) Adds a INNER JOIN clause to the query using the Objective relation
 *
 * @method ObjectiveRegion findOne(PropelPDO $con = null) Return the first ObjectiveRegion matching the query
 * @method ObjectiveRegion findOneOrCreate(PropelPDO $con = null) Return the first ObjectiveRegion matching the query, or a new ObjectiveRegion object populated from the query conditions when no match is found
 *
 * @method ObjectiveRegion findOneByRegionid(int $regionId) Return the first ObjectiveRegion filtered by the regionId column
 * @method ObjectiveRegion findOneByObjectiveid(int $objectiveId) Return the first ObjectiveRegion filtered by the objectiveId column
 *
 * @method array findByRegionid(int $regionId) Return ObjectiveRegion objects filtered by the regionId column
 * @method array findByObjectiveid(int $objectiveId) Return ObjectiveRegion objects filtered by the objectiveId column
 *
 * @package    propel.generator.objectives.classes.om
 */
abstract class BaseObjectiveRegionQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseObjectiveRegionQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ObjectiveRegion', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ObjectiveRegionQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ObjectiveRegionQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ObjectiveRegionQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ObjectiveRegionQuery) {
            return $criteria;
        }
        $query = new ObjectiveRegionQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$regionId, $objectiveId]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ObjectiveRegion|ObjectiveRegion[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ObjectiveRegionPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ObjectiveRegionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ObjectiveRegion A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `REGIONID`, `OBJECTIVEID` FROM `objectives_region` WHERE `REGIONID` = :p0 AND `OBJECTIVEID` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ObjectiveRegion();
            $obj->hydrate($row);
            ObjectiveRegionPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ObjectiveRegion|ObjectiveRegion[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ObjectiveRegion[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ObjectiveRegionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(ObjectiveRegionPeer::REGIONID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(ObjectiveRegionPeer::OBJECTIVEID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ObjectiveRegionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(ObjectiveRegionPeer::REGIONID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(ObjectiveRegionPeer::OBJECTIVEID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the regionId column
     *
     * Example usage:
     * <code>
     * $query->filterByRegionid(1234); // WHERE regionId = 1234
     * $query->filterByRegionid(array(12, 34)); // WHERE regionId IN (12, 34)
     * $query->filterByRegionid(array('min' => 12)); // WHERE regionId > 12
     * </code>
     *
     * @see       filterByRegion()
     *
     * @param     mixed $regionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveRegionQuery The current query, for fluid interface
     */
    public function filterByRegionid($regionid = null, $comparison = null)
    {
        if (is_array($regionid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ObjectiveRegionPeer::REGIONID, $regionid, $comparison);
    }

    /**
     * Filter the query on the objectiveId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectiveid(1234); // WHERE objectiveId = 1234
     * $query->filterByObjectiveid(array(12, 34)); // WHERE objectiveId IN (12, 34)
     * $query->filterByObjectiveid(array('min' => 12)); // WHERE objectiveId > 12
     * </code>
     *
     * @see       filterByObjective()
     *
     * @param     mixed $objectiveid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveRegionQuery The current query, for fluid interface
     */
    public function filterByObjectiveid($objectiveid = null, $comparison = null)
    {
        if (is_array($objectiveid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ObjectiveRegionPeer::OBJECTIVEID, $objectiveid, $comparison);
    }

    /**
     * Filter the query by a related Region object
     *
     * @param   Region|PropelObjectCollection $region The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveRegionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByRegion($region, $comparison = null)
    {
        if ($region instanceof Region) {
            return $this
                ->addUsingAlias(ObjectiveRegionPeer::REGIONID, $region->getId(), $comparison);
        } elseif ($region instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ObjectiveRegionPeer::REGIONID, $region->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByRegion() only accepts arguments of type Region or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Region relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveRegionQuery The current query, for fluid interface
     */
    public function joinRegion($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Region');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Region');
        }

        return $this;
    }

    /**
     * Use the Region relation Region object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   RegionQuery A secondary query class using the current class as primary query
     */
    public function useRegionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinRegion($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Region', 'RegionQuery');
    }

    /**
     * Filter the query by a related Objective object
     *
     * @param   Objective|PropelObjectCollection $objective The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveRegionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByObjective($objective, $comparison = null)
    {
        if ($objective instanceof Objective) {
            return $this
                ->addUsingAlias(ObjectiveRegionPeer::OBJECTIVEID, $objective->getId(), $comparison);
        } elseif ($objective instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ObjectiveRegionPeer::OBJECTIVEID, $objective->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByObjective() only accepts arguments of type Objective or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Objective relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveRegionQuery The current query, for fluid interface
     */
    public function joinObjective($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Objective');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Objective');
        }

        return $this;
    }

    /**
     * Use the Objective relation Objective object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ObjectiveQuery A secondary query class using the current class as primary query
     */
    public function useObjectiveQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinObjective($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Objective', 'ObjectiveQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ObjectiveRegion $objectiveRegion Object to remove from the list of results
     *
     * @return ObjectiveRegionQuery The current query, for fluid interface
     */
    public function prune($objectiveRegion = null)
    {
        if ($objectiveRegion) {
            $this->addCond('pruneCond0', $this->getAliasedColName(ObjectiveRegionPeer::REGIONID), $objectiveRegion->getRegionid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(ObjectiveRegionPeer::OBJECTIVEID), $objectiveRegion->getObjectiveid(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
