<?php

require_once 'ObjectiveYearsUnfilteredQuery.php';

use Egytca\Planning\YearsFilteredSelectAction;


class ObjectivesEditAction extends BaseSelectAction {

	use YearsFilteredSelectAction;


	/**
	* 
	* @param type $entityClassName
	* Constructor
	*/
	function __construct($entityClassName = 'Objective') {
		parent::__construct($entityClassName);
	}
	
	/**
	* 
	* Asignacion de variables a Smarty
	*/
	protected function postSelect() {
		parent::postSelect();

		$this->smarty->assign('includeJQuery', true);

		if ($this->entity->isNew()) {
			$this->entity->setStartingYear($_SESSION['planning']['startingYear']);
			$this->entity->setEndingYear($_SESSION['planning']['endingYear']);

			// si el redirect viene desde un Objetivo Estrategico, lo completo en el form.
			if ($_GET['filters']['fromStrategicObjectives'])
				$this->entity->setStrategicobjectiveid($_GET['filters']['strategicObjectiveId']);
		}else{
			//$this->smarty->assign('relatedPositions', ObjectivePositionQuery::create()->findByObjectiveid($this->entity->getId()));
			$this->smarty->assign('relatedPositions', $this->entity->getRelatedPositions());
		}
		
		/*$version = PositionPeer::getLatestVersion();
		$types = array_keys(ConfigModule::get('objectives','positionsTypes'));
		$positions = PositionPeer::getAllResponsiblesByPositionType($types,$version); */

		$this->smarty->assign('positions', PositionQuery::create()->find());
		
	}

	protected function createYearsUnfilteredQuery() {
		return ObjectiveYearsUnfilteredQuery::create();
	}
}
