<?php
/**
* ModulesVerifyListAction
*
* Listado para verificar la integridad de los archivos del sistema
*
* @package modules
*/

class ModulesVerifyListAction extends BaseAction {

	function execute($mapping, $form, &$request, &$response) {

		BaseAction::execute($mapping, $form, $request, $response);
		$plugInKey = 'SMARTY_PLUGIN';
		$smarty =& $this->actionServer->getPlugIn($plugInKey);
		if($smarty == NULL)
			echo 'No PlugIn found matching key: '.$plugInKey."<br>\n";

		$module = "Modules";
		$smarty->assign("module",$module);

		// archivo donde guardar fingerprints debe tener permisos de escritura
		$writable = true;
		$fingerprintsDir = "./WEB-INF/fingerprints/";
		if (!file_exists($fingerprintsDir)) {
			$created = mkdir($fingerprintsDir, 0755, true);
			if (!$created)
				$writable = false;
			else
				if (!Common::isWritable($fingerprintsDir))
					$writable = false;
		}
		$smarty->assign("writable",$writable);

		$smarty->assign("moduleColl", Egytca\ModuleVerify::getDirs());
		$smarty->assign("systemHash", Egytca\ModuleVerify::lookFingerprintsDir());

		return $mapping->findForwardConfig('success');
	}

}
