<?php
/**
* ModulesDoVerifyXAction
*
* Verifica el hash del directorio de los archivos del sistema
*
* @package modules
*/

class ModulesDoVerifyXAction extends BaseAction {

	function execute($mapping, $form, &$request, &$response) {

		BaseAction::execute($mapping, $form, $request, $response);
		$plugInKey = 'SMARTY_PLUGIN';
		$smarty =& $this->actionServer->getPlugIn($plugInKey);
		if($smarty == NULL)
			echo 'No PlugIn found matching key: '.$plugInKey."<br>\n";

		$verify = new Egytca\ModuleVerify($_POST['moduleName']);
		if (!$verify->lookDir($verify->dir['dir']))
			$smarty->assign('error','abrir el directorio');
		else {
			if (!file_exists($verify->fileDir)) {
				mkdir($verify->fileDir, 0777, true);
			}
			// si es un modulo nuevo guardo el fingerprint
			if (!file_exists($verify->file)) {
				if (!file_put_contents($verify->file, serialize($verify->hashes), LOCK_EX))
					$smarty->assign('error','intentar guardar los fingerprints');
			}
			else
				$smarty->assign('updateModule',true);

			$smarty->assign('directoryHash', $verify->getNewHash());
			$smarty->assign('oldHash', $verify->getDirectoryHash());
			$smarty->assign('newFiles', $verify->newFiles);
			$smarty->assign('changedFiles', $verify->changedFiles);
			$smarty->assign('allHashes', serialize($verify->hashes));
		}

		$smarty->assign('verifiedModule',$_POST['moduleName']);
		return $mapping->findForwardConfig('success');
	}

}
