<?php


/**
 * Base class that represents a query for the 'headlines_tag' table.
 *
 * Etiquetas de titulares
 *
 * @method HeadlineTagQuery orderById($order = Criteria::ASC) Order by the id column
 * @method HeadlineTagQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method HeadlineTagQuery orderByCreatedAt($order = Criteria::ASC) Order by the created_at column
 * @method HeadlineTagQuery orderByUpdatedAt($order = Criteria::ASC) Order by the updated_at column
 *
 * @method HeadlineTagQuery groupById() Group by the id column
 * @method HeadlineTagQuery groupByName() Group by the name column
 * @method HeadlineTagQuery groupByCreatedAt() Group by the created_at column
 * @method HeadlineTagQuery groupByUpdatedAt() Group by the updated_at column
 *
 * @method HeadlineTagQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method HeadlineTagQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method HeadlineTagQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method HeadlineTagQuery leftJoinHeadlineTagRelation($relationAlias = null) Adds a LEFT JOIN clause to the query using the HeadlineTagRelation relation
 * @method HeadlineTagQuery rightJoinHeadlineTagRelation($relationAlias = null) Adds a RIGHT JOIN clause to the query using the HeadlineTagRelation relation
 * @method HeadlineTagQuery innerJoinHeadlineTagRelation($relationAlias = null) Adds a INNER JOIN clause to the query using the HeadlineTagRelation relation
 *
 * @method HeadlineTag findOne(PropelPDO $con = null) Return the first HeadlineTag matching the query
 * @method HeadlineTag findOneOrCreate(PropelPDO $con = null) Return the first HeadlineTag matching the query, or a new HeadlineTag object populated from the query conditions when no match is found
 *
 * @method HeadlineTag findOneById(int $id) Return the first HeadlineTag filtered by the id column
 * @method HeadlineTag findOneByName(string $name) Return the first HeadlineTag filtered by the name column
 * @method HeadlineTag findOneByCreatedAt(string $created_at) Return the first HeadlineTag filtered by the created_at column
 * @method HeadlineTag findOneByUpdatedAt(string $updated_at) Return the first HeadlineTag filtered by the updated_at column
 *
 * @method array findById(int $id) Return HeadlineTag objects filtered by the id column
 * @method array findByName(string $name) Return HeadlineTag objects filtered by the name column
 * @method array findByCreatedAt(string $created_at) Return HeadlineTag objects filtered by the created_at column
 * @method array findByUpdatedAt(string $updated_at) Return HeadlineTag objects filtered by the updated_at column
 *
 * @package    propel.generator.headlines.classes.om
 */
abstract class BaseHeadlineTagQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseHeadlineTagQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'HeadlineTag', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new HeadlineTagQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     HeadlineTagQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return HeadlineTagQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof HeadlineTagQuery) {
            return $criteria;
        }
        $query = new HeadlineTagQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   HeadlineTag|HeadlineTag[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = HeadlineTagPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(HeadlineTagPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   HeadlineTag A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `CREATED_AT`, `UPDATED_AT` FROM `headlines_tag` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new HeadlineTag();
            $obj->hydrate($row);
            HeadlineTagPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return HeadlineTag|HeadlineTag[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|HeadlineTag[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return HeadlineTagQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(HeadlineTagPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return HeadlineTagQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(HeadlineTagPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineTagQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(HeadlineTagPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineTagQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(HeadlineTagPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the created_at column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatedAt('2011-03-14'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt('now'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt(array('max' => 'yesterday')); // WHERE created_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $createdAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineTagQuery The current query, for fluid interface
     */
    public function filterByCreatedAt($createdAt = null, $comparison = null)
    {
        if (is_array($createdAt)) {
            $useMinMax = false;
            if (isset($createdAt['min'])) {
                $this->addUsingAlias(HeadlineTagPeer::CREATED_AT, $createdAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($createdAt['max'])) {
                $this->addUsingAlias(HeadlineTagPeer::CREATED_AT, $createdAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlineTagPeer::CREATED_AT, $createdAt, $comparison);
    }

    /**
     * Filter the query on the updated_at column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdatedAt('2011-03-14'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt('now'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt(array('max' => 'yesterday')); // WHERE updated_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $updatedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineTagQuery The current query, for fluid interface
     */
    public function filterByUpdatedAt($updatedAt = null, $comparison = null)
    {
        if (is_array($updatedAt)) {
            $useMinMax = false;
            if (isset($updatedAt['min'])) {
                $this->addUsingAlias(HeadlineTagPeer::UPDATED_AT, $updatedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updatedAt['max'])) {
                $this->addUsingAlias(HeadlineTagPeer::UPDATED_AT, $updatedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlineTagPeer::UPDATED_AT, $updatedAt, $comparison);
    }

    /**
     * Filter the query by a related HeadlineTagRelation object
     *
     * @param   HeadlineTagRelation|PropelObjectCollection $headlineTagRelation  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   HeadlineTagQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByHeadlineTagRelation($headlineTagRelation, $comparison = null)
    {
        if ($headlineTagRelation instanceof HeadlineTagRelation) {
            return $this
                ->addUsingAlias(HeadlineTagPeer::ID, $headlineTagRelation->getTagid(), $comparison);
        } elseif ($headlineTagRelation instanceof PropelObjectCollection) {
            return $this
                ->useHeadlineTagRelationQuery()
                ->filterByPrimaryKeys($headlineTagRelation->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByHeadlineTagRelation() only accepts arguments of type HeadlineTagRelation or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the HeadlineTagRelation relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return HeadlineTagQuery The current query, for fluid interface
     */
    public function joinHeadlineTagRelation($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('HeadlineTagRelation');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'HeadlineTagRelation');
        }

        return $this;
    }

    /**
     * Use the HeadlineTagRelation relation HeadlineTagRelation object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   HeadlineTagRelationQuery A secondary query class using the current class as primary query
     */
    public function useHeadlineTagRelationQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinHeadlineTagRelation($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'HeadlineTagRelation', 'HeadlineTagRelationQuery');
    }

    /**
     * Filter the query by a related Headline object
     * using the headlines_headlineTags table as cross reference
     *
     * @param   Headline $headline the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   HeadlineTagQuery The current query, for fluid interface
     */
    public function filterByHeadline($headline, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useHeadlineTagRelationQuery()
            ->filterByHeadline($headline, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   HeadlineTag $headlineTag Object to remove from the list of results
     *
     * @return HeadlineTagQuery The current query, for fluid interface
     */
    public function prune($headlineTag = null)
    {
        if ($headlineTag) {
            $this->addUsingAlias(HeadlineTagPeer::ID, $headlineTag->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    // timestampable behavior

    /**
     * Filter by the latest updated
     *
     * @param      int $nbDays Maximum age of the latest update in days
     *
     * @return     HeadlineTagQuery The current query, for fluid interface
     */
    public function recentlyUpdated($nbDays = 7)
    {
        return $this->addUsingAlias(HeadlineTagPeer::UPDATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by update date desc
     *
     * @return     HeadlineTagQuery The current query, for fluid interface
     */
    public function lastUpdatedFirst()
    {
        return $this->addDescendingOrderByColumn(HeadlineTagPeer::UPDATED_AT);
    }

    /**
     * Order by update date asc
     *
     * @return     HeadlineTagQuery The current query, for fluid interface
     */
    public function firstUpdatedFirst()
    {
        return $this->addAscendingOrderByColumn(HeadlineTagPeer::UPDATED_AT);
    }

    /**
     * Filter by the latest created
     *
     * @param      int $nbDays Maximum age of in days
     *
     * @return     HeadlineTagQuery The current query, for fluid interface
     */
    public function recentlyCreated($nbDays = 7)
    {
        return $this->addUsingAlias(HeadlineTagPeer::CREATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by create date desc
     *
     * @return     HeadlineTagQuery The current query, for fluid interface
     */
    public function lastCreatedFirst()
    {
        return $this->addDescendingOrderByColumn(HeadlineTagPeer::CREATED_AT);
    }

    /**
     * Order by create date asc
     *
     * @return     HeadlineTagQuery The current query, for fluid interface
     */
    public function firstCreatedFirst()
    {
        return $this->addAscendingOrderByColumn(HeadlineTagPeer::CREATED_AT);
    }
}
