<?php


/**
 * Base static class for performing query and update operations on the 'headlines_headline' table.
 *
 * Headline
 *
 * @package propel.generator.headlines.classes.om
 */
abstract class BaseHeadlinePeer
{

    /** the default database name for this class */
    const DATABASE_NAME = 'application';

    /** the table name for this class */
    const TABLE_NAME = 'headlines_headline';

    /** the related Propel class for this table */
    const OM_CLASS = 'Headline';

    /** the related TableMap class for this table */
    const TM_CLASS = 'HeadlineTableMap';

    /** The total number of columns. */
    const NUM_COLUMNS = 32;

    /** The number of lazy-loaded columns. */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /** The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS) */
    const NUM_HYDRATE_COLUMNS = 32;

    /** the column name for the ID field */
    const ID = 'headlines_headline.ID';

    /** the column name for the NAME field */
    const NAME = 'headlines_headline.NAME';

    /** the column name for the CONTENT field */
    const CONTENT = 'headlines_headline.CONTENT';

    /** the column name for the DATEPUBLISHED field */
    const DATEPUBLISHED = 'headlines_headline.DATEPUBLISHED';

    /** the column name for the HEADLINEDATE field */
    const HEADLINEDATE = 'headlines_headline.HEADLINEDATE';

    /** the column name for the URL field */
    const URL = 'headlines_headline.URL';

    /** the column name for the TWITTS field */
    const TWITTS = 'headlines_headline.TWITTS';

    /** the column name for the FCB field */
    const FCB = 'headlines_headline.FCB';

    /** the column name for the GPLUS field */
    const GPLUS = 'headlines_headline.GPLUS';

    /** the column name for the COMMENT field */
    const COMMENT = 'headlines_headline.COMMENT';

    /** the column name for the PICTURE field */
    const PICTURE = 'headlines_headline.PICTURE';

    /** the column name for the CAMPAIGNID field */
    const CAMPAIGNID = 'headlines_headline.CAMPAIGNID';

    /** the column name for the MEDIAID field */
    const MEDIAID = 'headlines_headline.MEDIAID';

    /** the column name for the VALUE field */
    const VALUE = 'headlines_headline.VALUE';

    /** the column name for the RELEVANCE field */
    const RELEVANCE = 'headlines_headline.RELEVANCE';

    /** the column name for the INTERNALID field */
    const INTERNALID = 'headlines_headline.INTERNALID';

    /** the column name for the PAGE field */
    const PAGE = 'headlines_headline.PAGE';

    /** the column name for the SECTION field */
    const SECTION = 'headlines_headline.SECTION';

    /** the column name for the AUTHOR field */
    const AUTHOR = 'headlines_headline.AUTHOR';

    /** the column name for the SOURCE field */
    const SOURCE = 'headlines_headline.SOURCE';

    /** the column name for the SUMMARY field */
    const SUMMARY = 'headlines_headline.SUMMARY';

    /** the column name for the CAPTION field */
    const CAPTION = 'headlines_headline.CAPTION';

    /** the column name for the PROGRAM field */
    const PROGRAM = 'headlines_headline.PROGRAM';

    /** the column name for the STRATEGY field */
    const STRATEGY = 'headlines_headline.STRATEGY';

    /** the column name for the LENGTH field */
    const LENGTH = 'headlines_headline.LENGTH';

    /** the column name for the AGENDA field */
    const AGENDA = 'headlines_headline.AGENDA';

    /** the column name for the HEADLINESCOPE field */
    const HEADLINESCOPE = 'headlines_headline.HEADLINESCOPE';

    /** the column name for the PROCESSED field */
    const PROCESSED = 'headlines_headline.PROCESSED';

    /** the column name for the CLASS_KEY field */
    const CLASS_KEY = 'headlines_headline.CLASS_KEY';

    /** the column name for the CREATED_AT field */
    const CREATED_AT = 'headlines_headline.CREATED_AT';

    /** the column name for the UPDATED_AT field */
    const UPDATED_AT = 'headlines_headline.UPDATED_AT';

    /** the column name for the ISSUESCOUNT field */
    const ISSUESCOUNT = 'headlines_headline.ISSUESCOUNT';

    /** A key representing a particular subclass */
    const CLASSKEY_1 = '1';

    /** A key representing a particular subclass */
    const CLASSKEY_HEADLINE = '1';

    /** A class that can be returned by this peer. */
    const CLASSNAME_1 = 'Headline';

    /** A key representing a particular subclass */
    const CLASSKEY_2 = '2';

    /** A key representing a particular subclass */
    const CLASSKEY_PRESSHEADLINE = '2';

    /** A class that can be returned by this peer. */
    const CLASSNAME_2 = 'PressHeadline';

    /** A key representing a particular subclass */
    const CLASSKEY_3 = '3';

    /** A key representing a particular subclass */
    const CLASSKEY_MULTIMEDIAHEADLINE = '3';

    /** A class that can be returned by this peer. */
    const CLASSNAME_3 = 'MultimediaHeadline';

    /** A key representing a particular subclass */
    const CLASSKEY_4 = '4';

    /** A key representing a particular subclass */
    const CLASSKEY_WEBHEADLINE = '4';

    /** A class that can be returned by this peer. */
    const CLASSNAME_4 = 'WebHeadline';

    /** The default string format for model objects of the related table **/
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * An identiy map to hold any loaded instances of Headline objects.
     * This must be public so that other peer classes can access this when hydrating from JOIN
     * queries.
     * @var        array Headline[]
     */
    public static $instances = array();


    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. HeadlinePeer::$fieldNames[HeadlinePeer::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        BasePeer::TYPE_PHPNAME => array ('Id', 'Name', 'Content', 'Datepublished', 'Headlinedate', 'Url', 'Twitts', 'Fcb', 'Gplus', 'Comment', 'Picture', 'Campaignid', 'Mediaid', 'Value', 'Relevance', 'Internalid', 'Page', 'Section', 'Author', 'Source', 'Summary', 'Caption', 'Program', 'Strategy', 'Length', 'Agenda', 'Headlinescope', 'Processed', 'ClassKey', 'CreatedAt', 'UpdatedAt', 'Issuescount', ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id', 'name', 'content', 'datepublished', 'headlinedate', 'url', 'twitts', 'fcb', 'gplus', 'comment', 'picture', 'campaignid', 'mediaid', 'value', 'relevance', 'internalid', 'page', 'section', 'author', 'source', 'summary', 'caption', 'program', 'strategy', 'length', 'agenda', 'headlinescope', 'processed', 'classKey', 'createdAt', 'updatedAt', 'issuescount', ),
        BasePeer::TYPE_COLNAME => array (HeadlinePeer::ID, HeadlinePeer::NAME, HeadlinePeer::CONTENT, HeadlinePeer::DATEPUBLISHED, HeadlinePeer::HEADLINEDATE, HeadlinePeer::URL, HeadlinePeer::TWITTS, HeadlinePeer::FCB, HeadlinePeer::GPLUS, HeadlinePeer::COMMENT, HeadlinePeer::PICTURE, HeadlinePeer::CAMPAIGNID, HeadlinePeer::MEDIAID, HeadlinePeer::VALUE, HeadlinePeer::RELEVANCE, HeadlinePeer::INTERNALID, HeadlinePeer::PAGE, HeadlinePeer::SECTION, HeadlinePeer::AUTHOR, HeadlinePeer::SOURCE, HeadlinePeer::SUMMARY, HeadlinePeer::CAPTION, HeadlinePeer::PROGRAM, HeadlinePeer::STRATEGY, HeadlinePeer::LENGTH, HeadlinePeer::AGENDA, HeadlinePeer::HEADLINESCOPE, HeadlinePeer::PROCESSED, HeadlinePeer::CLASS_KEY, HeadlinePeer::CREATED_AT, HeadlinePeer::UPDATED_AT, HeadlinePeer::ISSUESCOUNT, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID', 'NAME', 'CONTENT', 'DATEPUBLISHED', 'HEADLINEDATE', 'URL', 'TWITTS', 'FCB', 'GPLUS', 'COMMENT', 'PICTURE', 'CAMPAIGNID', 'MEDIAID', 'VALUE', 'RELEVANCE', 'INTERNALID', 'PAGE', 'SECTION', 'AUTHOR', 'SOURCE', 'SUMMARY', 'CAPTION', 'PROGRAM', 'STRATEGY', 'LENGTH', 'AGENDA', 'HEADLINESCOPE', 'PROCESSED', 'CLASS_KEY', 'CREATED_AT', 'UPDATED_AT', 'ISSUESCOUNT', ),
        BasePeer::TYPE_FIELDNAME => array ('id', 'name', 'content', 'datePublished', 'headlineDate', 'url', 'twitts', 'fcb', 'gplus', 'comment', 'picture', 'campaignId', 'mediaId', 'value', 'relevance', 'internalId', 'page', 'section', 'author', 'source', 'summary', 'caption', 'program', 'strategy', 'length', 'agenda', 'headlineScope', 'processed', 'class_key', 'created_at', 'updated_at', 'issuesCount', ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. HeadlinePeer::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Name' => 1, 'Content' => 2, 'Datepublished' => 3, 'Headlinedate' => 4, 'Url' => 5, 'Twitts' => 6, 'Fcb' => 7, 'Gplus' => 8, 'Comment' => 9, 'Picture' => 10, 'Campaignid' => 11, 'Mediaid' => 12, 'Value' => 13, 'Relevance' => 14, 'Internalid' => 15, 'Page' => 16, 'Section' => 17, 'Author' => 18, 'Source' => 19, 'Summary' => 20, 'Caption' => 21, 'Program' => 22, 'Strategy' => 23, 'Length' => 24, 'Agenda' => 25, 'Headlinescope' => 26, 'Processed' => 27, 'ClassKey' => 28, 'CreatedAt' => 29, 'UpdatedAt' => 30, 'Issuescount' => 31, ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id' => 0, 'name' => 1, 'content' => 2, 'datepublished' => 3, 'headlinedate' => 4, 'url' => 5, 'twitts' => 6, 'fcb' => 7, 'gplus' => 8, 'comment' => 9, 'picture' => 10, 'campaignid' => 11, 'mediaid' => 12, 'value' => 13, 'relevance' => 14, 'internalid' => 15, 'page' => 16, 'section' => 17, 'author' => 18, 'source' => 19, 'summary' => 20, 'caption' => 21, 'program' => 22, 'strategy' => 23, 'length' => 24, 'agenda' => 25, 'headlinescope' => 26, 'processed' => 27, 'classKey' => 28, 'createdAt' => 29, 'updatedAt' => 30, 'issuescount' => 31, ),
        BasePeer::TYPE_COLNAME => array (HeadlinePeer::ID => 0, HeadlinePeer::NAME => 1, HeadlinePeer::CONTENT => 2, HeadlinePeer::DATEPUBLISHED => 3, HeadlinePeer::HEADLINEDATE => 4, HeadlinePeer::URL => 5, HeadlinePeer::TWITTS => 6, HeadlinePeer::FCB => 7, HeadlinePeer::GPLUS => 8, HeadlinePeer::COMMENT => 9, HeadlinePeer::PICTURE => 10, HeadlinePeer::CAMPAIGNID => 11, HeadlinePeer::MEDIAID => 12, HeadlinePeer::VALUE => 13, HeadlinePeer::RELEVANCE => 14, HeadlinePeer::INTERNALID => 15, HeadlinePeer::PAGE => 16, HeadlinePeer::SECTION => 17, HeadlinePeer::AUTHOR => 18, HeadlinePeer::SOURCE => 19, HeadlinePeer::SUMMARY => 20, HeadlinePeer::CAPTION => 21, HeadlinePeer::PROGRAM => 22, HeadlinePeer::STRATEGY => 23, HeadlinePeer::LENGTH => 24, HeadlinePeer::AGENDA => 25, HeadlinePeer::HEADLINESCOPE => 26, HeadlinePeer::PROCESSED => 27, HeadlinePeer::CLASS_KEY => 28, HeadlinePeer::CREATED_AT => 29, HeadlinePeer::UPDATED_AT => 30, HeadlinePeer::ISSUESCOUNT => 31, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID' => 0, 'NAME' => 1, 'CONTENT' => 2, 'DATEPUBLISHED' => 3, 'HEADLINEDATE' => 4, 'URL' => 5, 'TWITTS' => 6, 'FCB' => 7, 'GPLUS' => 8, 'COMMENT' => 9, 'PICTURE' => 10, 'CAMPAIGNID' => 11, 'MEDIAID' => 12, 'VALUE' => 13, 'RELEVANCE' => 14, 'INTERNALID' => 15, 'PAGE' => 16, 'SECTION' => 17, 'AUTHOR' => 18, 'SOURCE' => 19, 'SUMMARY' => 20, 'CAPTION' => 21, 'PROGRAM' => 22, 'STRATEGY' => 23, 'LENGTH' => 24, 'AGENDA' => 25, 'HEADLINESCOPE' => 26, 'PROCESSED' => 27, 'CLASS_KEY' => 28, 'CREATED_AT' => 29, 'UPDATED_AT' => 30, 'ISSUESCOUNT' => 31, ),
        BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'name' => 1, 'content' => 2, 'datePublished' => 3, 'headlineDate' => 4, 'url' => 5, 'twitts' => 6, 'fcb' => 7, 'gplus' => 8, 'comment' => 9, 'picture' => 10, 'campaignId' => 11, 'mediaId' => 12, 'value' => 13, 'relevance' => 14, 'internalId' => 15, 'page' => 16, 'section' => 17, 'author' => 18, 'source' => 19, 'summary' => 20, 'caption' => 21, 'program' => 22, 'strategy' => 23, 'length' => 24, 'agenda' => 25, 'headlineScope' => 26, 'processed' => 27, 'class_key' => 28, 'created_at' => 29, 'updated_at' => 30, 'issuesCount' => 31, ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, )
    );

    /**
     * Translates a fieldname to another type
     *
     * @param      string $name field name
     * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @param      string $toType   One of the class type constants
     * @return string          translated name of the field.
     * @throws PropelException - if the specified name could not be found in the fieldname mappings.
     */
    public static function translateFieldName($name, $fromType, $toType)
    {
        $toNames = HeadlinePeer::getFieldNames($toType);
        $key = isset(HeadlinePeer::$fieldKeys[$fromType][$name]) ? HeadlinePeer::$fieldKeys[$fromType][$name] : null;
        if ($key === null) {
            throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(HeadlinePeer::$fieldKeys[$fromType], true));
        }

        return $toNames[$key];
    }

    /**
     * Returns an array of field names.
     *
     * @param      string $type The type of fieldnames to return:
     *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @return array           A list of field names
     * @throws PropelException - if the type is not valid.
     */
    public static function getFieldNames($type = BasePeer::TYPE_PHPNAME)
    {
        if (!array_key_exists($type, HeadlinePeer::$fieldNames)) {
            throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
        }

        return HeadlinePeer::$fieldNames[$type];
    }

    /**
     * Convenience method which changes table.column to alias.column.
     *
     * Using this method you can maintain SQL abstraction while using column aliases.
     * <code>
     *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
     *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
     * </code>
     * @param      string $alias The alias for the current table.
     * @param      string $column The column name for current table. (i.e. HeadlinePeer::COLUMN_NAME).
     * @return string
     */
    public static function alias($alias, $column)
    {
        return str_replace(HeadlinePeer::TABLE_NAME.'.', $alias.'.', $column);
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param      Criteria $criteria object containing the columns to add.
     * @param      string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(HeadlinePeer::ID);
            $criteria->addSelectColumn(HeadlinePeer::NAME);
            $criteria->addSelectColumn(HeadlinePeer::CONTENT);
            $criteria->addSelectColumn(HeadlinePeer::DATEPUBLISHED);
            $criteria->addSelectColumn(HeadlinePeer::HEADLINEDATE);
            $criteria->addSelectColumn(HeadlinePeer::URL);
            $criteria->addSelectColumn(HeadlinePeer::TWITTS);
            $criteria->addSelectColumn(HeadlinePeer::FCB);
            $criteria->addSelectColumn(HeadlinePeer::GPLUS);
            $criteria->addSelectColumn(HeadlinePeer::COMMENT);
            $criteria->addSelectColumn(HeadlinePeer::PICTURE);
            $criteria->addSelectColumn(HeadlinePeer::CAMPAIGNID);
            $criteria->addSelectColumn(HeadlinePeer::MEDIAID);
            $criteria->addSelectColumn(HeadlinePeer::VALUE);
            $criteria->addSelectColumn(HeadlinePeer::RELEVANCE);
            $criteria->addSelectColumn(HeadlinePeer::INTERNALID);
            $criteria->addSelectColumn(HeadlinePeer::PAGE);
            $criteria->addSelectColumn(HeadlinePeer::SECTION);
            $criteria->addSelectColumn(HeadlinePeer::AUTHOR);
            $criteria->addSelectColumn(HeadlinePeer::SOURCE);
            $criteria->addSelectColumn(HeadlinePeer::SUMMARY);
            $criteria->addSelectColumn(HeadlinePeer::CAPTION);
            $criteria->addSelectColumn(HeadlinePeer::PROGRAM);
            $criteria->addSelectColumn(HeadlinePeer::STRATEGY);
            $criteria->addSelectColumn(HeadlinePeer::LENGTH);
            $criteria->addSelectColumn(HeadlinePeer::AGENDA);
            $criteria->addSelectColumn(HeadlinePeer::HEADLINESCOPE);
            $criteria->addSelectColumn(HeadlinePeer::PROCESSED);
            $criteria->addSelectColumn(HeadlinePeer::CLASS_KEY);
            $criteria->addSelectColumn(HeadlinePeer::CREATED_AT);
            $criteria->addSelectColumn(HeadlinePeer::UPDATED_AT);
            $criteria->addSelectColumn(HeadlinePeer::ISSUESCOUNT);
        } else {
            $criteria->addSelectColumn($alias . '.ID');
            $criteria->addSelectColumn($alias . '.NAME');
            $criteria->addSelectColumn($alias . '.CONTENT');
            $criteria->addSelectColumn($alias . '.DATEPUBLISHED');
            $criteria->addSelectColumn($alias . '.HEADLINEDATE');
            $criteria->addSelectColumn($alias . '.URL');
            $criteria->addSelectColumn($alias . '.TWITTS');
            $criteria->addSelectColumn($alias . '.FCB');
            $criteria->addSelectColumn($alias . '.GPLUS');
            $criteria->addSelectColumn($alias . '.COMMENT');
            $criteria->addSelectColumn($alias . '.PICTURE');
            $criteria->addSelectColumn($alias . '.CAMPAIGNID');
            $criteria->addSelectColumn($alias . '.MEDIAID');
            $criteria->addSelectColumn($alias . '.VALUE');
            $criteria->addSelectColumn($alias . '.RELEVANCE');
            $criteria->addSelectColumn($alias . '.INTERNALID');
            $criteria->addSelectColumn($alias . '.PAGE');
            $criteria->addSelectColumn($alias . '.SECTION');
            $criteria->addSelectColumn($alias . '.AUTHOR');
            $criteria->addSelectColumn($alias . '.SOURCE');
            $criteria->addSelectColumn($alias . '.SUMMARY');
            $criteria->addSelectColumn($alias . '.CAPTION');
            $criteria->addSelectColumn($alias . '.PROGRAM');
            $criteria->addSelectColumn($alias . '.STRATEGY');
            $criteria->addSelectColumn($alias . '.LENGTH');
            $criteria->addSelectColumn($alias . '.AGENDA');
            $criteria->addSelectColumn($alias . '.HEADLINESCOPE');
            $criteria->addSelectColumn($alias . '.PROCESSED');
            $criteria->addSelectColumn($alias . '.CLASS_KEY');
            $criteria->addSelectColumn($alias . '.CREATED_AT');
            $criteria->addSelectColumn($alias . '.UPDATED_AT');
            $criteria->addSelectColumn($alias . '.ISSUESCOUNT');
        }
    }

    /**
     * Returns the number of rows matching criteria.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @return int Number of matching rows.
     */
    public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
    {
        // we may modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(HeadlinePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            HeadlinePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
        $criteria->setDbName(HeadlinePeer::DATABASE_NAME); // Set the correct dbName

        if ($con === null) {
            $con = Propel::getConnection(HeadlinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        // BasePeer returns a PDOStatement
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }
    /**
     * Selects one object from the DB.
     *
     * @param      Criteria $criteria object used to create the SELECT statement.
     * @param      PropelPDO $con
     * @return                 Headline
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
    {
        $critcopy = clone $criteria;
        $critcopy->setLimit(1);
        $objects = HeadlinePeer::doSelect($critcopy, $con);
        if ($objects) {
            return $objects[0];
        }

        return null;
    }
    /**
     * Selects several row from the DB.
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con
     * @return array           Array of selected Objects
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        return HeadlinePeer::populateObjects(HeadlinePeer::doSelectStmt($criteria, $con));
    }
    /**
     * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
     *
     * Use this method directly if you want to work with an executed statement durirectly (for example
     * to perform your own object hydration).
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con The connection to use
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return PDOStatement The executed PDOStatement object.
     * @see        BasePeer::doSelect()
     */
    public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(HeadlinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        if (!$criteria->hasSelectClause()) {
            $criteria = clone $criteria;
            HeadlinePeer::addSelectColumns($criteria);
        }

        // Set the correct dbName
        $criteria->setDbName(HeadlinePeer::DATABASE_NAME);

        // BasePeer returns a PDOStatement
        return BasePeer::doSelect($criteria, $con);
    }
    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doSelect*()
     * methods in your stub classes -- you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by doSelect*()
     * and retrieveByPK*() calls.
     *
     * @param      Headline $obj A Headline object.
     * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if ($key === null) {
                $key = (string) $obj->getId();
            } // if key === null
            HeadlinePeer::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param      mixed $value A Headline object or a primary key value.
     *
     * @return void
     * @throws PropelException - if the value is invalid.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && $value !== null) {
            if (is_object($value) && $value instanceof Headline) {
                $key = (string) $value->getId();
            } elseif (is_scalar($value)) {
                // assume we've been passed a primary key
                $key = (string) $value;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or Headline object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
                throw $e;
            }

            unset(HeadlinePeer::$instances[$key]);
        }
    } // removeInstanceFromPool()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
     * @return   Headline Found object or null if 1) no instance exists for specified key or 2) instance pooling has been disabled.
     * @see        getPrimaryKeyHash()
     */
    public static function getInstanceFromPool($key)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (isset(HeadlinePeer::$instances[$key])) {
                return HeadlinePeer::$instances[$key];
            }
        }

        return null; // just to be explicit
    }

    /**
     * Clear the instance pool.
     *
     * @return void
     */
    public static function clearInstancePool()
    {
        HeadlinePeer::$instances = array();
    }

    /**
     * Method to invalidate the instance pool of all tables related to headlines_headline
     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
        // Invalidate objects in HeadlineActorPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        HeadlineActorPeer::clearInstancePool();
        // Invalidate objects in HeadlineIssuePeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        HeadlineIssuePeer::clearInstancePool();
        // Invalidate objects in HeadlineDocumentPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        HeadlineDocumentPeer::clearInstancePool();
        // Invalidate objects in HeadlineTagRelationPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        HeadlineTagRelationPeer::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return string A string version of PK or null if the components of primary key in result array are all null.
     */
    public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
    {
        // If the PK cannot be derived from the row, return null.
        if ($row[$startcol] === null) {
            return null;
        }

        return (string) $row[$startcol];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $startcol = 0)
    {

        return (int) $row[$startcol];
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function populateObjects(PDOStatement $stmt)
    {
        $results = array();

        // populate the object(s)
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key = HeadlinePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj = HeadlinePeer::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                // class must be set each time from the record row
                $cls = HeadlinePeer::getOMClass($row, 0);
                $cls = substr('.'.$cls, strrpos('.'.$cls, '.') + 1);
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                HeadlinePeer::addInstanceToPool($obj, $key);
            } // if key exists
        }
        $stmt->closeCursor();

        return $results;
    }
    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return array (Headline object, last column rank)
     */
    public static function populateObject($row, $startcol = 0)
    {
        $key = HeadlinePeer::getPrimaryKeyHashFromRow($row, $startcol);
        if (null !== ($obj = HeadlinePeer::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $startcol, true); // rehydrate
            $col = $startcol + HeadlinePeer::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = HeadlinePeer::getOMClass($row, $startcol);
            $obj = new $cls();
            $col = $obj->hydrate($row, $startcol);
            HeadlinePeer::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }


    /**
     * Returns the number of rows matching criteria, joining the related Media table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinMedia(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(HeadlinePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            HeadlinePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(HeadlinePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(HeadlinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(HeadlinePeer::MEDIAID, MediaPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of Headline objects pre-filled with their Media objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Headline objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinMedia(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(HeadlinePeer::DATABASE_NAME);
        }

        HeadlinePeer::addSelectColumns($criteria);
        $startcol = HeadlinePeer::NUM_HYDRATE_COLUMNS;
        MediaPeer::addSelectColumns($criteria);

        $criteria->addJoin(HeadlinePeer::MEDIAID, MediaPeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = HeadlinePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = HeadlinePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $omClass = HeadlinePeer::getOMClass($row, 0);
                $cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);

                $obj1 = new $cls();
                $obj1->hydrate($row);
                HeadlinePeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = MediaPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = MediaPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = MediaPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    MediaPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (Headline) to $obj2 (Media)
                $obj2->addHeadline($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining all related tables
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAll(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(HeadlinePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            HeadlinePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(HeadlinePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(HeadlinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(HeadlinePeer::MEDIAID, MediaPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }

    /**
     * Selects a collection of Headline objects pre-filled with all related objects.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Headline objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAll(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(HeadlinePeer::DATABASE_NAME);
        }

        HeadlinePeer::addSelectColumns($criteria);
        $startcol2 = HeadlinePeer::NUM_HYDRATE_COLUMNS;

        MediaPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + MediaPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(HeadlinePeer::MEDIAID, MediaPeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = HeadlinePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = HeadlinePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $omClass = HeadlinePeer::getOMClass($row, 0);
        $cls = substr('.'.$omClass, strrpos('.'.$omClass, '.') + 1);

                $obj1 = new $cls();
                $obj1->hydrate($row);
                HeadlinePeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

            // Add objects for joined Media rows

            $key2 = MediaPeer::getPrimaryKeyHashFromRow($row, $startcol2);
            if ($key2 !== null) {
                $obj2 = MediaPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = MediaPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    MediaPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 loaded

                // Add the $obj1 (Headline) to the collection in $obj2 (Media)
                $obj2->addHeadline($obj1);
            } // if joined row not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }

    /**
     * Returns the TableMap related to this peer.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getDatabaseMap(HeadlinePeer::DATABASE_NAME)->getTable(HeadlinePeer::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this peer class.
     */
    public static function buildTableMap()
    {
      $dbMap = Propel::getDatabaseMap(BaseHeadlinePeer::DATABASE_NAME);
      if (!$dbMap->hasTable(BaseHeadlinePeer::TABLE_NAME)) {
        $dbMap->addTableObject(new HeadlineTableMap());
      }
    }

    /**
     * The returned Class will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param      array $row PropelPDO result row.
     * @param      int $colnum Column to examine for OM class information (first is 0).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getOMClass($row, $colnum)
    {
        try {

            $omClass = null;
            $classKey = $row[$colnum + 28];

            switch ($classKey) {

                case HeadlinePeer::CLASSKEY_1:
                    $omClass = HeadlinePeer::CLASSNAME_1;
                    break;

                case HeadlinePeer::CLASSKEY_2:
                    $omClass = HeadlinePeer::CLASSNAME_2;
                    break;

                case HeadlinePeer::CLASSKEY_3:
                    $omClass = HeadlinePeer::CLASSNAME_3;
                    break;

                case HeadlinePeer::CLASSKEY_4:
                    $omClass = HeadlinePeer::CLASSNAME_4;
                    break;

                default:
                    $omClass = HeadlinePeer::OM_CLASS;

            } // switch

        } catch (Exception $e) {
            throw new PropelException('Unable to get OM class.', $e);
        }

        return $omClass;
    }

    /**
     * Performs an INSERT on the database, given a Headline or Criteria object.
     *
     * @param      mixed $values Criteria or Headline object containing data that is used to create the INSERT statement.
     * @param      PropelPDO $con the PropelPDO connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doInsert($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(HeadlinePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity
        } else {
            $criteria = $values->buildCriteria(); // build Criteria from Headline object
        }

        if ($criteria->containsKey(HeadlinePeer::ID) && $criteria->keyContainsValue(HeadlinePeer::ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.HeadlinePeer::ID.')');
        }


        // Set the correct dbName
        $criteria->setDbName(HeadlinePeer::DATABASE_NAME);

        try {
            // use transaction because $criteria could contain info
            // for more than one table (I guess, conceivably)
            $con->beginTransaction();
            $pk = BasePeer::doInsert($criteria, $con);
            $con->commit();
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }

        return $pk;
    }

    /**
     * Performs an UPDATE on the database, given a Headline or Criteria object.
     *
     * @param      mixed $values Criteria or Headline object containing data that is used to create the UPDATE statement.
     * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doUpdate($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(HeadlinePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $selectCriteria = new Criteria(HeadlinePeer::DATABASE_NAME);

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity

            $comparison = $criteria->getComparison(HeadlinePeer::ID);
            $value = $criteria->remove(HeadlinePeer::ID);
            if ($value) {
                $selectCriteria->add(HeadlinePeer::ID, $value, $comparison);
            } else {
                $selectCriteria->setPrimaryTableName(HeadlinePeer::TABLE_NAME);
            }

        } else { // $values is Headline object
            $criteria = $values->buildCriteria(); // gets full criteria
            $selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
        }

        // set the correct dbName
        $criteria->setDbName(HeadlinePeer::DATABASE_NAME);

        return BasePeer::doUpdate($selectCriteria, $criteria, $con);
    }

    /**
     * Deletes all rows from the headlines_headline table.
     *
     * @param      PropelPDO $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException
     */
    public static function doDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(HeadlinePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $affectedRows = 0; // initialize var to track total num of affected rows
        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();
            $affectedRows += HeadlinePeer::doOnDeleteCascade(new Criteria(HeadlinePeer::DATABASE_NAME), $con);
            $affectedRows += BasePeer::doDeleteAll(HeadlinePeer::TABLE_NAME, $con, HeadlinePeer::DATABASE_NAME);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            HeadlinePeer::clearInstancePool();
            HeadlinePeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs a DELETE on the database, given a Headline or Criteria object OR a primary key value.
     *
     * @param      mixed $values Criteria or Headline object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param      PropelPDO $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *				if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, PropelPDO $con = null)
     {
        if ($con === null) {
            $con = Propel::getConnection(HeadlinePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = clone $values;
        } elseif ($values instanceof Headline) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(HeadlinePeer::DATABASE_NAME);
            $criteria->add(HeadlinePeer::ID, (array) $values, Criteria::IN);
        }

        // Set the correct dbName
        $criteria->setDbName(HeadlinePeer::DATABASE_NAME);

        $affectedRows = 0; // initialize var to track total num of affected rows

        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();

            // cloning the Criteria in case it's modified by doSelect() or doSelectStmt()
            $c = clone $criteria;
            $affectedRows += HeadlinePeer::doOnDeleteCascade($c, $con);

            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            if ($values instanceof Criteria) {
                HeadlinePeer::clearInstancePool();
            } elseif ($values instanceof Headline) { // it's a model object
                HeadlinePeer::removeInstanceFromPool($values);
            } else { // it's a primary key, or an array of pks
                foreach ((array) $values as $singleval) {
                    HeadlinePeer::removeInstanceFromPool($singleval);
                }
            }

            $affectedRows += BasePeer::doDelete($criteria, $con);
            HeadlinePeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * This is a method for emulating ON DELETE CASCADE for DBs that don't support this
     * feature (like MySQL or SQLite).
     *
     * This method is not very speedy because it must perform a query first to get
     * the implicated records and then perform the deletes by calling those Peer classes.
     *
     * This method should be used within a transaction if possible.
     *
     * @param      Criteria $criteria
     * @param      PropelPDO $con
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    protected static function doOnDeleteCascade(Criteria $criteria, PropelPDO $con)
    {
        // initialize var to track total num of affected rows
        $affectedRows = 0;

        // first find the objects that are implicated by the $criteria
        $objects = HeadlinePeer::doSelect($criteria, $con);
        foreach ($objects as $obj) {


            // delete related HeadlineActor objects
            $criteria = new Criteria(HeadlineActorPeer::DATABASE_NAME);

            $criteria->add(HeadlineActorPeer::HEADLINEID, $obj->getId());
            $affectedRows += HeadlineActorPeer::doDelete($criteria, $con);

            // delete related HeadlineIssue objects
            $criteria = new Criteria(HeadlineIssuePeer::DATABASE_NAME);

            $criteria->add(HeadlineIssuePeer::HEADLINEID, $obj->getId());
            $affectedRows += HeadlineIssuePeer::doDelete($criteria, $con);

            // delete related HeadlineDocument objects
            $criteria = new Criteria(HeadlineDocumentPeer::DATABASE_NAME);

            $criteria->add(HeadlineDocumentPeer::HEADLINEID, $obj->getId());
            $affectedRows += HeadlineDocumentPeer::doDelete($criteria, $con);

            // delete related HeadlineTagRelation objects
            $criteria = new Criteria(HeadlineTagRelationPeer::DATABASE_NAME);

            $criteria->add(HeadlineTagRelationPeer::HEADLINEID, $obj->getId());
            $affectedRows += HeadlineTagRelationPeer::doDelete($criteria, $con);
        }

        return $affectedRows;
    }

    /**
     * Validates all modified columns of given Headline object.
     * If parameter $columns is either a single column name or an array of column names
     * than only those columns are validated.
     *
     * NOTICE: This does not apply to primary or foreign keys for now.
     *
     * @param      Headline $obj The object to validate.
     * @param      mixed $cols Column name or array of column names.
     *
     * @return mixed TRUE if all columns are valid or the error message of the first invalid column.
     */
    public static function doValidate($obj, $cols = null)
    {
        $columns = array();

        if ($cols) {
            $dbMap = Propel::getDatabaseMap(HeadlinePeer::DATABASE_NAME);
            $tableMap = $dbMap->getTable(HeadlinePeer::TABLE_NAME);

            if (! is_array($cols)) {
                $cols = array($cols);
            }

            foreach ($cols as $colName) {
                if ($tableMap->hasColumn($colName)) {
                    $get = 'get' . $tableMap->getColumn($colName)->getPhpName();
                    $columns[$colName] = $obj->$get();
                }
            }
        } else {

        }

        return BasePeer::doValidate(HeadlinePeer::DATABASE_NAME, HeadlinePeer::TABLE_NAME, $columns);
    }

    /**
     * Retrieve a single object by pkey.
     *
     * @param      int $pk the primary key.
     * @param      PropelPDO $con the connection to use
     * @return Headline
     */
    public static function retrieveByPK($pk, PropelPDO $con = null)
    {

        if (null !== ($obj = HeadlinePeer::getInstanceFromPool((string) $pk))) {
            return $obj;
        }

        if ($con === null) {
            $con = Propel::getConnection(HeadlinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria = new Criteria(HeadlinePeer::DATABASE_NAME);
        $criteria->add(HeadlinePeer::ID, $pk);

        $v = HeadlinePeer::doSelect($criteria, $con);

        return !empty($v) > 0 ? $v[0] : null;
    }

    /**
     * Retrieve multiple objects by pkey.
     *
     * @param      array $pks List of primary keys
     * @param      PropelPDO $con the connection to use
     * @return Headline[]
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function retrieveByPKs($pks, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(HeadlinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $objs = null;
        if (empty($pks)) {
            $objs = array();
        } else {
            $criteria = new Criteria(HeadlinePeer::DATABASE_NAME);
            $criteria->add(HeadlinePeer::ID, $pks, Criteria::IN);
            $objs = HeadlinePeer::doSelect($criteria, $con);
        }

        return $objs;
    }

} // BaseHeadlinePeer

// This is the static code needed to register the TableMap for this table with the main Propel class.
//
BaseHeadlinePeer::buildTableMap();

