<?php

class HeadlinesUpdateTagsXAction extends BaseAction {

	function HeadlinesUpdateTagsXAction() {
		;
	}
	
	function arrayHasTag($array, $tag) {
		foreach ($array as $e) {
			if ($e->getId() == $tag->getId())
				return true;
		}
		return false;
	}
	
	function removeTag($headline, $tag) {
		
		$headline = HeadlineQuery::create()->findOneById($_POST["headlineId"]);
		$relation = HeadlineTagRelationQuery::create()->filterByHeadline($headline)->filterByHeadlineTag($tag)->findOne();
		
		if (!empty($relation))
			try {
				$relation->delete();
			}
			catch (PropelException $exp) {
				if (ConfigModule::get("global","showPropelExceptions"))
					print_r($exp->getMessage());
			}
	}

	function execute($mapping, $form, &$request, &$response) {

		BaseAction::execute($mapping, $form, $request, $response);

		$plugInKey = 'SMARTY_PLUGIN';
		$smarty =& $this->actionServer->getPlugIn($plugInKey);
		if($smarty == NULL) {
			echo 'No PlugIn found matching key: '.$plugInKey."<br>\n";
		}

		$module = "Headlines";

		if (!empty($_POST["headlineId"])) {
		
			$headline = HeadlineQuery::create()->findOneById($_POST["headlineId"]);
			$tagId = $_POST["tagId"];

			$tag = HeadlineTagQuery::create()->findOneById($tagId);
			$associatedTags = $headline->getHeadlineTags();

			if($_POST["toDo"] == 'add'){
				if (!$this->arrayHasTag($associatedTags, $tag)){
					$headline->addHeadlineTag($tag);
					if (!$headline->save()) {
						$smarty->assign('message', 'failure');
					}
				}
			}elseif($_POST["toDo"] == 'remove'){

				$relation = HeadlineTagRelationQuery::create()->filterByHeadline($headline)->filterByHeadlineTag($tag)->findOne();

				if (!empty($relation))
					try {
						$relation->delete();
					}
					catch (PropelException $exp) {
						if (ConfigModule::get("global","showPropelExceptions"))
							$smarty->assign('errorDelete', $exp->getMessage());
					}
			}

			$smarty->assign('headline',$headline);
			$smarty->assign('tag',$tag);
			$smarty->assign('toDo',$_POST['toDo']);
			
		}
		return $mapping->findForwardConfig('success');
	}

}