<?php



/**
 * Skeleton subclass for representing a row from the 'constructions_construction' table.
 *
 * Seguimiento de obras
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.constructions.classes
 */
class Construction extends BaseConstruction {

	function postDelete($con =null) {

		parent::postDelete();

		$project = $this->getProject();
		if ($project && !$project->isDeleted()) {
			$project->delete();
		}
	}
	
	static function createFromProject($project) {
		$construction = new Construction();
		return $construction->setProject($project)
			->updateFromProject();
	}
	
	function updateFromProject() {
		$project = $this->getProject();

		$this->setName($project->getName());

		// si el proyecto tien lat y long se lo asigno a la obra
		if (!empty($project->getLatitude()))
			$this->setLatitude($project->getLatitude());

		if (!empty($project->getLongitude()))
			$this->setLongitude($project->getLongitude());

		return $this;
			
	}

	/**
	 * Devuelve la ultima inspeccion cargada en el sistema relacionada con la obra.
	 * En caso de no existir devuelve un Inspection nuevo al usar findOneOrCreate
	 * @return object Inspection
	 */
	public function getLastInspection() {
		return InspectionQuery::create()
	      ->filterByConstruction($this)
	      ->orderByVisitdate(Criteria::DESC)
	      ->findOneOrCreate();
	}

	function getStatusColor() {
		return Common::getConfiguration('tablero')
			['colors'][$this->getStatus()];
	}

	function getName() {
		return $this->tryGetProject()->getName();
	}

	function isDeletable() {
		$project = $this->getProject();
		return !$project || $project->isDeletable();
	}

} // Construction
