<?php


/**
 * Base class that represents a query for the 'actors_profileFormQuestionOption' table.
 *
 * Options for select questions
 *
 * @method QuestionOptionQuery orderById($order = Criteria::ASC) Order by the id column
 * @method QuestionOptionQuery orderByFormid($order = Criteria::ASC) Order by the formId column
 * @method QuestionOptionQuery orderByOrder($order = Criteria::ASC) Order by the order column
 * @method QuestionOptionQuery orderByValue($order = Criteria::ASC) Order by the value column
 * @method QuestionOptionQuery orderByText($order = Criteria::ASC) Order by the text column
 * @method QuestionOptionQuery orderByDefaultopc($order = Criteria::ASC) Order by the defaultOpc column
 *
 * @method QuestionOptionQuery groupById() Group by the id column
 * @method QuestionOptionQuery groupByFormid() Group by the formId column
 * @method QuestionOptionQuery groupByOrder() Group by the order column
 * @method QuestionOptionQuery groupByValue() Group by the value column
 * @method QuestionOptionQuery groupByText() Group by the text column
 * @method QuestionOptionQuery groupByDefaultopc() Group by the defaultOpc column
 *
 * @method QuestionOptionQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method QuestionOptionQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method QuestionOptionQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method QuestionOptionQuery leftJoinProfileForm($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProfileForm relation
 * @method QuestionOptionQuery rightJoinProfileForm($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProfileForm relation
 * @method QuestionOptionQuery innerJoinProfileForm($relationAlias = null) Adds a INNER JOIN clause to the query using the ProfileForm relation
 *
 * @method QuestionOption findOne(PropelPDO $con = null) Return the first QuestionOption matching the query
 * @method QuestionOption findOneOrCreate(PropelPDO $con = null) Return the first QuestionOption matching the query, or a new QuestionOption object populated from the query conditions when no match is found
 *
 * @method QuestionOption findOneById(int $id) Return the first QuestionOption filtered by the id column
 * @method QuestionOption findOneByFormid(int $formId) Return the first QuestionOption filtered by the formId column
 * @method QuestionOption findOneByOrder(int $order) Return the first QuestionOption filtered by the order column
 * @method QuestionOption findOneByValue(string $value) Return the first QuestionOption filtered by the value column
 * @method QuestionOption findOneByText(string $text) Return the first QuestionOption filtered by the text column
 * @method QuestionOption findOneByDefaultopc(boolean $defaultOpc) Return the first QuestionOption filtered by the defaultOpc column
 *
 * @method array findById(int $id) Return QuestionOption objects filtered by the id column
 * @method array findByFormid(int $formId) Return QuestionOption objects filtered by the formId column
 * @method array findByOrder(int $order) Return QuestionOption objects filtered by the order column
 * @method array findByValue(string $value) Return QuestionOption objects filtered by the value column
 * @method array findByText(string $text) Return QuestionOption objects filtered by the text column
 * @method array findByDefaultopc(boolean $defaultOpc) Return QuestionOption objects filtered by the defaultOpc column
 *
 * @package    propel.generator.actors.classes.om
 */
abstract class BaseQuestionOptionQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseQuestionOptionQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'QuestionOption', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new QuestionOptionQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     QuestionOptionQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return QuestionOptionQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof QuestionOptionQuery) {
            return $criteria;
        }
        $query = new QuestionOptionQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$id, $order]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   QuestionOption|QuestionOption[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = QuestionOptionPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(QuestionOptionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   QuestionOption A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `FORMID`, `ORDER`, `VALUE`, `TEXT`, `DEFAULTOPC` FROM `actors_profileFormQuestionOption` WHERE `ID` = :p0 AND `ORDER` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new QuestionOption();
            $obj->hydrate($row);
            QuestionOptionPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return QuestionOption|QuestionOption[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|QuestionOption[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return QuestionOptionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(QuestionOptionPeer::ID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(QuestionOptionPeer::ORDER, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return QuestionOptionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(QuestionOptionPeer::ID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(QuestionOptionPeer::ORDER, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return QuestionOptionQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(QuestionOptionPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the formId column
     *
     * Example usage:
     * <code>
     * $query->filterByFormid(1234); // WHERE formId = 1234
     * $query->filterByFormid(array(12, 34)); // WHERE formId IN (12, 34)
     * $query->filterByFormid(array('min' => 12)); // WHERE formId > 12
     * </code>
     *
     * @see       filterByProfileForm()
     *
     * @param     mixed $formid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return QuestionOptionQuery The current query, for fluid interface
     */
    public function filterByFormid($formid = null, $comparison = null)
    {
        if (is_array($formid)) {
            $useMinMax = false;
            if (isset($formid['min'])) {
                $this->addUsingAlias(QuestionOptionPeer::FORMID, $formid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($formid['max'])) {
                $this->addUsingAlias(QuestionOptionPeer::FORMID, $formid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(QuestionOptionPeer::FORMID, $formid, $comparison);
    }

    /**
     * Filter the query on the order column
     *
     * Example usage:
     * <code>
     * $query->filterByOrder(1234); // WHERE order = 1234
     * $query->filterByOrder(array(12, 34)); // WHERE order IN (12, 34)
     * $query->filterByOrder(array('min' => 12)); // WHERE order > 12
     * </code>
     *
     * @param     mixed $order The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return QuestionOptionQuery The current query, for fluid interface
     */
    public function filterByOrder($order = null, $comparison = null)
    {
        if (is_array($order) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(QuestionOptionPeer::ORDER, $order, $comparison);
    }

    /**
     * Filter the query on the value column
     *
     * Example usage:
     * <code>
     * $query->filterByValue('fooValue');   // WHERE value = 'fooValue'
     * $query->filterByValue('%fooValue%'); // WHERE value LIKE '%fooValue%'
     * </code>
     *
     * @param     string $value The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return QuestionOptionQuery The current query, for fluid interface
     */
    public function filterByValue($value = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($value)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $value)) {
                $value = str_replace('*', '%', $value);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(QuestionOptionPeer::VALUE, $value, $comparison);
    }

    /**
     * Filter the query on the text column
     *
     * Example usage:
     * <code>
     * $query->filterByText('fooValue');   // WHERE text = 'fooValue'
     * $query->filterByText('%fooValue%'); // WHERE text LIKE '%fooValue%'
     * </code>
     *
     * @param     string $text The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return QuestionOptionQuery The current query, for fluid interface
     */
    public function filterByText($text = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($text)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $text)) {
                $text = str_replace('*', '%', $text);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(QuestionOptionPeer::TEXT, $text, $comparison);
    }

    /**
     * Filter the query on the defaultOpc column
     *
     * Example usage:
     * <code>
     * $query->filterByDefaultopc(true); // WHERE defaultOpc = true
     * $query->filterByDefaultopc('yes'); // WHERE defaultOpc = true
     * </code>
     *
     * @param     boolean|string $defaultopc The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return QuestionOptionQuery The current query, for fluid interface
     */
    public function filterByDefaultopc($defaultopc = null, $comparison = null)
    {
        if (is_string($defaultopc)) {
            $defaultOpc = in_array(strtolower($defaultopc), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(QuestionOptionPeer::DEFAULTOPC, $defaultopc, $comparison);
    }

    /**
     * Filter the query by a related ProfileForm object
     *
     * @param   ProfileForm|PropelObjectCollection $profileForm The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   QuestionOptionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProfileForm($profileForm, $comparison = null)
    {
        if ($profileForm instanceof ProfileForm) {
            return $this
                ->addUsingAlias(QuestionOptionPeer::FORMID, $profileForm->getId(), $comparison);
        } elseif ($profileForm instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(QuestionOptionPeer::FORMID, $profileForm->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProfileForm() only accepts arguments of type ProfileForm or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProfileForm relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return QuestionOptionQuery The current query, for fluid interface
     */
    public function joinProfileForm($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProfileForm');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProfileForm');
        }

        return $this;
    }

    /**
     * Use the ProfileForm relation ProfileForm object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProfileFormQuery A secondary query class using the current class as primary query
     */
    public function useProfileFormQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProfileForm($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProfileForm', 'ProfileFormQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   QuestionOption $questionOption Object to remove from the list of results
     *
     * @return QuestionOptionQuery The current query, for fluid interface
     */
    public function prune($questionOption = null)
    {
        if ($questionOption) {
            $this->addCond('pruneCond0', $this->getAliasedColName(QuestionOptionPeer::ID), $questionOption->getId(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(QuestionOptionPeer::ORDER), $questionOption->getOrder(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
