<?php


/**
 * Base class that represents a row from the 'actors_actor' table.
 *
 * Base de Actores
 *
 * @package    propel.generator.actors.classes.om
 */
abstract class BaseActor extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'ActorPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        ActorPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the title field.
     * @var        string
     */
    protected $title;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the surname field.
     * @var        string
     */
    protected $surname;

    /**
     * The value for the institution field.
     * @var        string
     */
    protected $institution;

    /**
     * The value for the mailaddress field.
     * @var        string
     */
    protected $mailaddress;

    /**
     * The value for the deleted_at field.
     * @var        string
     */
    protected $deleted_at;

    /**
     * @var        PropelObjectCollection|ActorCategoryRelation[] Collection to store aggregation of ActorCategoryRelation objects.
     */
    protected $collActorCategoryRelations;
    protected $collActorCategoryRelationsPartial;

    /**
     * @var        PropelObjectCollection|ActorRelation[] Collection to store aggregation of ActorRelation objects.
     */
    protected $collActorRelations;
    protected $collActorRelationsPartial;

    /**
     * @var        PropelObjectCollection|ActorActiveQuestion[] Collection to store aggregation of ActorActiveQuestion objects.
     */
    protected $collActorActiveQuestions;
    protected $collActorActiveQuestionsPartial;

    /**
     * @var        PropelObjectCollection|ActorActiveRelationQuestion[] Collection to store aggregation of ActorActiveRelationQuestion objects.
     */
    protected $collActorActiveRelationQuestions;
    protected $collActorActiveRelationQuestionsPartial;

    /**
     * @var        PropelObjectCollection|ActorFormAnswer[] Collection to store aggregation of ActorFormAnswer objects.
     */
    protected $collActorFormAnswers;
    protected $collActorFormAnswersPartial;

    /**
     * @var        PropelObjectCollection|HeadlineActor[] Collection to store aggregation of HeadlineActor objects.
     */
    protected $collHeadlineActors;
    protected $collHeadlineActorsPartial;

    /**
     * @var        PropelObjectCollection|IssueActor[] Collection to store aggregation of IssueActor objects.
     */
    protected $collIssueActors;
    protected $collIssueActorsPartial;

    /**
     * @var        PropelObjectCollection|ActorCategory[] Collection to store aggregation of ActorCategory objects.
     */
    protected $collActorCategorys;

    /**
     * @var        PropelObjectCollection|ProfileForm[] Collection to store aggregation of ProfileForm objects.
     */
    protected $collProfileForms;

    /**
     * @var        PropelObjectCollection|Headline[] Collection to store aggregation of Headline objects.
     */
    protected $collHeadlines;

    /**
     * @var        PropelObjectCollection|Issue[] Collection to store aggregation of Issue objects.
     */
    protected $collIssues;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $actorCategorysScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $profileFormsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $headlinesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $issuesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $actorCategoryRelationsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $actorRelationsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $actorActiveQuestionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $actorActiveRelationQuestionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $actorFormAnswersScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $headlineActorsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $issueActorsScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     * Identificacion del actor
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [title] column value.
     * Titulo
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Get the [name] column value.
     * Nombre
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [surname] column value.
     * Apellido
     * @return string
     */
    public function getSurname()
    {
        return $this->surname;
    }

    /**
     * Get the [institution] column value.
     * Institucion
     * @return string
     */
    public function getInstitution()
    {
        return $this->institution;
    }

    /**
     * Get the [mailaddress] column value.
     * Direccion electronica
     * @return string
     */
    public function getMailaddress()
    {
        return $this->mailaddress;
    }

    /**
     * Get the [optionally formatted] temporal [deleted_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDeletedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->deleted_at === null) {
            return null;
        }

        if ($this->deleted_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->deleted_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->deleted_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     * Identificacion del actor
     * @param int $v new value
     * @return Actor The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = ActorPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [title] column.
     * Titulo
     * @param string $v new value
     * @return Actor The current object (for fluent API support)
     */
    public function setTitle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->title !== $v) {
            $this->title = $v;
            $this->modifiedColumns[] = ActorPeer::TITLE;
        }


        return $this;
    } // setTitle()

    /**
     * Set the value of [name] column.
     * Nombre
     * @param string $v new value
     * @return Actor The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = ActorPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [surname] column.
     * Apellido
     * @param string $v new value
     * @return Actor The current object (for fluent API support)
     */
    public function setSurname($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->surname !== $v) {
            $this->surname = $v;
            $this->modifiedColumns[] = ActorPeer::SURNAME;
        }


        return $this;
    } // setSurname()

    /**
     * Set the value of [institution] column.
     * Institucion
     * @param string $v new value
     * @return Actor The current object (for fluent API support)
     */
    public function setInstitution($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->institution !== $v) {
            $this->institution = $v;
            $this->modifiedColumns[] = ActorPeer::INSTITUTION;
        }


        return $this;
    } // setInstitution()

    /**
     * Set the value of [mailaddress] column.
     * Direccion electronica
     * @param string $v new value
     * @return Actor The current object (for fluent API support)
     */
    public function setMailaddress($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mailaddress !== $v) {
            $this->mailaddress = $v;
            $this->modifiedColumns[] = ActorPeer::MAILADDRESS;
        }


        return $this;
    } // setMailaddress()

    /**
     * Sets the value of [deleted_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Actor The current object (for fluent API support)
     */
    public function setDeletedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->deleted_at !== null || $dt !== null) {
            $currentDateAsString = ($this->deleted_at !== null && $tmpDt = new DateTime($this->deleted_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->deleted_at = $newDateAsString;
                $this->modifiedColumns[] = ActorPeer::DELETED_AT;
            }
        } // if either are not null


        return $this;
    } // setDeletedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->title = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->name = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->surname = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->institution = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->mailaddress = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->deleted_at = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 7; // 7 = ActorPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Actor object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ActorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = ActorPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->collActorCategoryRelations = null;

            $this->collActorRelations = null;

            $this->collActorActiveQuestions = null;

            $this->collActorActiveRelationQuestions = null;

            $this->collActorFormAnswers = null;

            $this->collHeadlineActors = null;

            $this->collIssueActors = null;

            $this->collActorCategorys = null;
            $this->collProfileForms = null;
            $this->collHeadlines = null;
            $this->collIssues = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ActorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = ActorQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // soft_delete behavior
            if (!empty($ret) && ActorQuery::isSoftDeleteEnabled()) {
                $this->setDeletedAt(time());
                $this->save($con);
                $this->postDelete($con);
                $con->commit();
                ActorPeer::removeInstanceFromPool($this);

                return;
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ActorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ActorPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->actorCategorysScheduledForDeletion !== null) {
                if (!$this->actorCategorysScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->actorCategorysScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    ActorCategoryRelationQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->actorCategorysScheduledForDeletion = null;
                }

                foreach ($this->getActorCategorys() as $actorCategory) {
                    if ($actorCategory->isModified()) {
                        $actorCategory->save($con);
                    }
                }
            }

            if ($this->profileFormsScheduledForDeletion !== null) {
                if (!$this->profileFormsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->profileFormsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    ActorActiveRelationQuestionQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->profileFormsScheduledForDeletion = null;
                }

                foreach ($this->getProfileForms() as $profileForm) {
                    if ($profileForm->isModified()) {
                        $profileForm->save($con);
                    }
                }
            }

            if ($this->headlinesScheduledForDeletion !== null) {
                if (!$this->headlinesScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->headlinesScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    HeadlineActorQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->headlinesScheduledForDeletion = null;
                }

                foreach ($this->getHeadlines() as $headline) {
                    if ($headline->isModified()) {
                        $headline->save($con);
                    }
                }
            }

            if ($this->issuesScheduledForDeletion !== null) {
                if (!$this->issuesScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->issuesScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    IssueActorQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->issuesScheduledForDeletion = null;
                }

                foreach ($this->getIssues() as $issue) {
                    if ($issue->isModified()) {
                        $issue->save($con);
                    }
                }
            }

            if ($this->actorCategoryRelationsScheduledForDeletion !== null) {
                if (!$this->actorCategoryRelationsScheduledForDeletion->isEmpty()) {
                    ActorCategoryRelationQuery::create()
                        ->filterByPrimaryKeys($this->actorCategoryRelationsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->actorCategoryRelationsScheduledForDeletion = null;
                }
            }

            if ($this->collActorCategoryRelations !== null) {
                foreach ($this->collActorCategoryRelations as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->actorRelationsScheduledForDeletion !== null) {
                if (!$this->actorRelationsScheduledForDeletion->isEmpty()) {
                    ActorRelationQuery::create()
                        ->filterByPrimaryKeys($this->actorRelationsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->actorRelationsScheduledForDeletion = null;
                }
            }

            if ($this->collActorRelations !== null) {
                foreach ($this->collActorRelations as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->actorActiveQuestionsScheduledForDeletion !== null) {
                if (!$this->actorActiveQuestionsScheduledForDeletion->isEmpty()) {
                    ActorActiveQuestionQuery::create()
                        ->filterByPrimaryKeys($this->actorActiveQuestionsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->actorActiveQuestionsScheduledForDeletion = null;
                }
            }

            if ($this->collActorActiveQuestions !== null) {
                foreach ($this->collActorActiveQuestions as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->actorActiveRelationQuestionsScheduledForDeletion !== null) {
                if (!$this->actorActiveRelationQuestionsScheduledForDeletion->isEmpty()) {
                    ActorActiveRelationQuestionQuery::create()
                        ->filterByPrimaryKeys($this->actorActiveRelationQuestionsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->actorActiveRelationQuestionsScheduledForDeletion = null;
                }
            }

            if ($this->collActorActiveRelationQuestions !== null) {
                foreach ($this->collActorActiveRelationQuestions as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->actorFormAnswersScheduledForDeletion !== null) {
                if (!$this->actorFormAnswersScheduledForDeletion->isEmpty()) {
                    ActorFormAnswerQuery::create()
                        ->filterByPrimaryKeys($this->actorFormAnswersScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->actorFormAnswersScheduledForDeletion = null;
                }
            }

            if ($this->collActorFormAnswers !== null) {
                foreach ($this->collActorFormAnswers as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->headlineActorsScheduledForDeletion !== null) {
                if (!$this->headlineActorsScheduledForDeletion->isEmpty()) {
                    HeadlineActorQuery::create()
                        ->filterByPrimaryKeys($this->headlineActorsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->headlineActorsScheduledForDeletion = null;
                }
            }

            if ($this->collHeadlineActors !== null) {
                foreach ($this->collHeadlineActors as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->issueActorsScheduledForDeletion !== null) {
                if (!$this->issueActorsScheduledForDeletion->isEmpty()) {
                    IssueActorQuery::create()
                        ->filterByPrimaryKeys($this->issueActorsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->issueActorsScheduledForDeletion = null;
                }
            }

            if ($this->collIssueActors !== null) {
                foreach ($this->collIssueActors as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = ActorPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . ActorPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ActorPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(ActorPeer::TITLE)) {
            $modifiedColumns[':p' . $index++]  = '`TITLE`';
        }
        if ($this->isColumnModified(ActorPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(ActorPeer::SURNAME)) {
            $modifiedColumns[':p' . $index++]  = '`SURNAME`';
        }
        if ($this->isColumnModified(ActorPeer::INSTITUTION)) {
            $modifiedColumns[':p' . $index++]  = '`INSTITUTION`';
        }
        if ($this->isColumnModified(ActorPeer::MAILADDRESS)) {
            $modifiedColumns[':p' . $index++]  = '`MAILADDRESS`';
        }
        if ($this->isColumnModified(ActorPeer::DELETED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`DELETED_AT`';
        }

        $sql = sprintf(
            'INSERT INTO `actors_actor` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`TITLE`':
                        $stmt->bindValue($identifier, $this->title, PDO::PARAM_STR);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`SURNAME`':
                        $stmt->bindValue($identifier, $this->surname, PDO::PARAM_STR);
                        break;
                    case '`INSTITUTION`':
                        $stmt->bindValue($identifier, $this->institution, PDO::PARAM_STR);
                        break;
                    case '`MAILADDRESS`':
                        $stmt->bindValue($identifier, $this->mailaddress, PDO::PARAM_STR);
                        break;
                    case '`DELETED_AT`':
                        $stmt->bindValue($identifier, $this->deleted_at, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            if (($retval = ActorPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collActorCategoryRelations !== null) {
                    foreach ($this->collActorCategoryRelations as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collActorRelations !== null) {
                    foreach ($this->collActorRelations as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collActorActiveQuestions !== null) {
                    foreach ($this->collActorActiveQuestions as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collActorActiveRelationQuestions !== null) {
                    foreach ($this->collActorActiveRelationQuestions as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collActorFormAnswers !== null) {
                    foreach ($this->collActorFormAnswers as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collHeadlineActors !== null) {
                    foreach ($this->collHeadlineActors as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collIssueActors !== null) {
                    foreach ($this->collIssueActors as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ActorPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getTitle();
                break;
            case 2:
                return $this->getName();
                break;
            case 3:
                return $this->getSurname();
                break;
            case 4:
                return $this->getInstitution();
                break;
            case 5:
                return $this->getMailaddress();
                break;
            case 6:
                return $this->getDeletedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Actor'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Actor'][$this->getPrimaryKey()] = true;
        $keys = ActorPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getTitle(),
            $keys[2] => $this->getName(),
            $keys[3] => $this->getSurname(),
            $keys[4] => $this->getInstitution(),
            $keys[5] => $this->getMailaddress(),
            $keys[6] => $this->getDeletedAt(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->collActorCategoryRelations) {
                $result['ActorCategoryRelations'] = $this->collActorCategoryRelations->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collActorRelations) {
                $result['ActorRelations'] = $this->collActorRelations->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collActorActiveQuestions) {
                $result['ActorActiveQuestions'] = $this->collActorActiveQuestions->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collActorActiveRelationQuestions) {
                $result['ActorActiveRelationQuestions'] = $this->collActorActiveRelationQuestions->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collActorFormAnswers) {
                $result['ActorFormAnswers'] = $this->collActorFormAnswers->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collHeadlineActors) {
                $result['HeadlineActors'] = $this->collHeadlineActors->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collIssueActors) {
                $result['IssueActors'] = $this->collIssueActors->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ActorPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setTitle($value);
                break;
            case 2:
                $this->setName($value);
                break;
            case 3:
                $this->setSurname($value);
                break;
            case 4:
                $this->setInstitution($value);
                break;
            case 5:
                $this->setMailaddress($value);
                break;
            case 6:
                $this->setDeletedAt($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = ActorPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setTitle($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setName($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setSurname($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setInstitution($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setMailaddress($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setDeletedAt($arr[$keys[6]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(ActorPeer::DATABASE_NAME);

        if ($this->isColumnModified(ActorPeer::ID)) $criteria->add(ActorPeer::ID, $this->id);
        if ($this->isColumnModified(ActorPeer::TITLE)) $criteria->add(ActorPeer::TITLE, $this->title);
        if ($this->isColumnModified(ActorPeer::NAME)) $criteria->add(ActorPeer::NAME, $this->name);
        if ($this->isColumnModified(ActorPeer::SURNAME)) $criteria->add(ActorPeer::SURNAME, $this->surname);
        if ($this->isColumnModified(ActorPeer::INSTITUTION)) $criteria->add(ActorPeer::INSTITUTION, $this->institution);
        if ($this->isColumnModified(ActorPeer::MAILADDRESS)) $criteria->add(ActorPeer::MAILADDRESS, $this->mailaddress);
        if ($this->isColumnModified(ActorPeer::DELETED_AT)) $criteria->add(ActorPeer::DELETED_AT, $this->deleted_at);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(ActorPeer::DATABASE_NAME);
        $criteria->add(ActorPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Actor (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setTitle($this->getTitle());
        $copyObj->setName($this->getName());
        $copyObj->setSurname($this->getSurname());
        $copyObj->setInstitution($this->getInstitution());
        $copyObj->setMailaddress($this->getMailaddress());
        $copyObj->setDeletedAt($this->getDeletedAt());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getActorCategoryRelations() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addActorCategoryRelation($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getActorRelations() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addActorRelation($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getActorActiveQuestions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addActorActiveQuestion($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getActorActiveRelationQuestions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addActorActiveRelationQuestion($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getActorFormAnswers() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addActorFormAnswer($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getHeadlineActors() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addHeadlineActor($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getIssueActors() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addIssueActor($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Actor Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return ActorPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new ActorPeer();
        }

        return self::$peer;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('ActorCategoryRelation' == $relationName) {
            $this->initActorCategoryRelations();
        }
        if ('ActorRelation' == $relationName) {
            $this->initActorRelations();
        }
        if ('ActorActiveQuestion' == $relationName) {
            $this->initActorActiveQuestions();
        }
        if ('ActorActiveRelationQuestion' == $relationName) {
            $this->initActorActiveRelationQuestions();
        }
        if ('ActorFormAnswer' == $relationName) {
            $this->initActorFormAnswers();
        }
        if ('HeadlineActor' == $relationName) {
            $this->initHeadlineActors();
        }
        if ('IssueActor' == $relationName) {
            $this->initIssueActors();
        }
    }

    /**
     * Clears out the collActorCategoryRelations collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addActorCategoryRelations()
     */
    public function clearActorCategoryRelations()
    {
        $this->collActorCategoryRelations = null; // important to set this to null since that means it is uninitialized
        $this->collActorCategoryRelationsPartial = null;
    }

    /**
     * reset is the collActorCategoryRelations collection loaded partially
     *
     * @return void
     */
    public function resetPartialActorCategoryRelations($v = true)
    {
        $this->collActorCategoryRelationsPartial = $v;
    }

    /**
     * Initializes the collActorCategoryRelations collection.
     *
     * By default this just sets the collActorCategoryRelations collection to an empty array (like clearcollActorCategoryRelations());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initActorCategoryRelations($overrideExisting = true)
    {
        if (null !== $this->collActorCategoryRelations && !$overrideExisting) {
            return;
        }
        $this->collActorCategoryRelations = new PropelObjectCollection();
        $this->collActorCategoryRelations->setModel('ActorCategoryRelation');
    }

    /**
     * Gets an array of ActorCategoryRelation objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Actor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ActorCategoryRelation[] List of ActorCategoryRelation objects
     * @throws PropelException
     */
    public function getActorCategoryRelations($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collActorCategoryRelationsPartial && !$this->isNew();
        if (null === $this->collActorCategoryRelations || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collActorCategoryRelations) {
                // return empty collection
                $this->initActorCategoryRelations();
            } else {
                $collActorCategoryRelations = ActorCategoryRelationQuery::create(null, $criteria)
                    ->filterByActor($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collActorCategoryRelationsPartial && count($collActorCategoryRelations)) {
                      $this->initActorCategoryRelations(false);

                      foreach($collActorCategoryRelations as $obj) {
                        if (false == $this->collActorCategoryRelations->contains($obj)) {
                          $this->collActorCategoryRelations->append($obj);
                        }
                      }

                      $this->collActorCategoryRelationsPartial = true;
                    }

                    return $collActorCategoryRelations;
                }

                if($partial && $this->collActorCategoryRelations) {
                    foreach($this->collActorCategoryRelations as $obj) {
                        if($obj->isNew()) {
                            $collActorCategoryRelations[] = $obj;
                        }
                    }
                }

                $this->collActorCategoryRelations = $collActorCategoryRelations;
                $this->collActorCategoryRelationsPartial = false;
            }
        }

        return $this->collActorCategoryRelations;
    }

    /**
     * Sets a collection of ActorCategoryRelation objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $actorCategoryRelations A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setActorCategoryRelations(PropelCollection $actorCategoryRelations, PropelPDO $con = null)
    {
        $this->actorCategoryRelationsScheduledForDeletion = $this->getActorCategoryRelations(new Criteria(), $con)->diff($actorCategoryRelations);

        foreach ($this->actorCategoryRelationsScheduledForDeletion as $actorCategoryRelationRemoved) {
            $actorCategoryRelationRemoved->setActor(null);
        }

        $this->collActorCategoryRelations = null;
        foreach ($actorCategoryRelations as $actorCategoryRelation) {
            $this->addActorCategoryRelation($actorCategoryRelation);
        }

        $this->collActorCategoryRelations = $actorCategoryRelations;
        $this->collActorCategoryRelationsPartial = false;
    }

    /**
     * Returns the number of related ActorCategoryRelation objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ActorCategoryRelation objects.
     * @throws PropelException
     */
    public function countActorCategoryRelations(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collActorCategoryRelationsPartial && !$this->isNew();
        if (null === $this->collActorCategoryRelations || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collActorCategoryRelations) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getActorCategoryRelations());
                }
                $query = ActorCategoryRelationQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByActor($this)
                    ->count($con);
            }
        } else {
            return count($this->collActorCategoryRelations);
        }
    }

    /**
     * Method called to associate a ActorCategoryRelation object to this object
     * through the ActorCategoryRelation foreign key attribute.
     *
     * @param    ActorCategoryRelation $l ActorCategoryRelation
     * @return Actor The current object (for fluent API support)
     */
    public function addActorCategoryRelation(ActorCategoryRelation $l)
    {
        if ($this->collActorCategoryRelations === null) {
            $this->initActorCategoryRelations();
            $this->collActorCategoryRelationsPartial = true;
        }
        if (!$this->collActorCategoryRelations->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddActorCategoryRelation($l);
        }

        return $this;
    }

    /**
     * @param	ActorCategoryRelation $actorCategoryRelation The actorCategoryRelation object to add.
     */
    protected function doAddActorCategoryRelation($actorCategoryRelation)
    {
        $this->collActorCategoryRelations[]= $actorCategoryRelation;
        $actorCategoryRelation->setActor($this);
    }

    /**
     * @param	ActorCategoryRelation $actorCategoryRelation The actorCategoryRelation object to remove.
     */
    public function removeActorCategoryRelation($actorCategoryRelation)
    {
        if ($this->getActorCategoryRelations()->contains($actorCategoryRelation)) {
            $this->collActorCategoryRelations->remove($this->collActorCategoryRelations->search($actorCategoryRelation));
            if (null === $this->actorCategoryRelationsScheduledForDeletion) {
                $this->actorCategoryRelationsScheduledForDeletion = clone $this->collActorCategoryRelations;
                $this->actorCategoryRelationsScheduledForDeletion->clear();
            }
            $this->actorCategoryRelationsScheduledForDeletion[]= $actorCategoryRelation;
            $actorCategoryRelation->setActor(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Actor is new, it will return
     * an empty collection; or if this Actor has previously
     * been saved, it will retrieve related ActorCategoryRelations from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Actor.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ActorCategoryRelation[] List of ActorCategoryRelation objects
     */
    public function getActorCategoryRelationsJoinActorCategory($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ActorCategoryRelationQuery::create(null, $criteria);
        $query->joinWith('ActorCategory', $join_behavior);

        return $this->getActorCategoryRelations($query, $con);
    }

    /**
     * Clears out the collActorRelations collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addActorRelations()
     */
    public function clearActorRelations()
    {
        $this->collActorRelations = null; // important to set this to null since that means it is uninitialized
        $this->collActorRelationsPartial = null;
    }

    /**
     * reset is the collActorRelations collection loaded partially
     *
     * @return void
     */
    public function resetPartialActorRelations($v = true)
    {
        $this->collActorRelationsPartial = $v;
    }

    /**
     * Initializes the collActorRelations collection.
     *
     * By default this just sets the collActorRelations collection to an empty array (like clearcollActorRelations());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initActorRelations($overrideExisting = true)
    {
        if (null !== $this->collActorRelations && !$overrideExisting) {
            return;
        }
        $this->collActorRelations = new PropelObjectCollection();
        $this->collActorRelations->setModel('ActorRelation');
    }

    /**
     * Gets an array of ActorRelation objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Actor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ActorRelation[] List of ActorRelation objects
     * @throws PropelException
     */
    public function getActorRelations($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collActorRelationsPartial && !$this->isNew();
        if (null === $this->collActorRelations || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collActorRelations) {
                // return empty collection
                $this->initActorRelations();
            } else {
                $collActorRelations = ActorRelationQuery::create(null, $criteria)
                    ->filterByActor($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collActorRelationsPartial && count($collActorRelations)) {
                      $this->initActorRelations(false);

                      foreach($collActorRelations as $obj) {
                        if (false == $this->collActorRelations->contains($obj)) {
                          $this->collActorRelations->append($obj);
                        }
                      }

                      $this->collActorRelationsPartial = true;
                    }

                    return $collActorRelations;
                }

                if($partial && $this->collActorRelations) {
                    foreach($this->collActorRelations as $obj) {
                        if($obj->isNew()) {
                            $collActorRelations[] = $obj;
                        }
                    }
                }

                $this->collActorRelations = $collActorRelations;
                $this->collActorRelationsPartial = false;
            }
        }

        return $this->collActorRelations;
    }

    /**
     * Sets a collection of ActorRelation objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $actorRelations A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setActorRelations(PropelCollection $actorRelations, PropelPDO $con = null)
    {
        $this->actorRelationsScheduledForDeletion = $this->getActorRelations(new Criteria(), $con)->diff($actorRelations);

        foreach ($this->actorRelationsScheduledForDeletion as $actorRelationRemoved) {
            $actorRelationRemoved->setActor(null);
        }

        $this->collActorRelations = null;
        foreach ($actorRelations as $actorRelation) {
            $this->addActorRelation($actorRelation);
        }

        $this->collActorRelations = $actorRelations;
        $this->collActorRelationsPartial = false;
    }

    /**
     * Returns the number of related ActorRelation objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ActorRelation objects.
     * @throws PropelException
     */
    public function countActorRelations(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collActorRelationsPartial && !$this->isNew();
        if (null === $this->collActorRelations || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collActorRelations) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getActorRelations());
                }
                $query = ActorRelationQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByActor($this)
                    ->count($con);
            }
        } else {
            return count($this->collActorRelations);
        }
    }

    /**
     * Method called to associate a ActorRelation object to this object
     * through the ActorRelation foreign key attribute.
     *
     * @param    ActorRelation $l ActorRelation
     * @return Actor The current object (for fluent API support)
     */
    public function addActorRelation(ActorRelation $l)
    {
        if ($this->collActorRelations === null) {
            $this->initActorRelations();
            $this->collActorRelationsPartial = true;
        }
        if (!$this->collActorRelations->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddActorRelation($l);
        }

        return $this;
    }

    /**
     * @param	ActorRelation $actorRelation The actorRelation object to add.
     */
    protected function doAddActorRelation($actorRelation)
    {
        $this->collActorRelations[]= $actorRelation;
        $actorRelation->setActor($this);
    }

    /**
     * @param	ActorRelation $actorRelation The actorRelation object to remove.
     */
    public function removeActorRelation($actorRelation)
    {
        if ($this->getActorRelations()->contains($actorRelation)) {
            $this->collActorRelations->remove($this->collActorRelations->search($actorRelation));
            if (null === $this->actorRelationsScheduledForDeletion) {
                $this->actorRelationsScheduledForDeletion = clone $this->collActorRelations;
                $this->actorRelationsScheduledForDeletion->clear();
            }
            $this->actorRelationsScheduledForDeletion[]= $actorRelation;
            $actorRelation->setActor(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Actor is new, it will return
     * an empty collection; or if this Actor has previously
     * been saved, it will retrieve related ActorRelations from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Actor.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ActorRelation[] List of ActorRelation objects
     */
    public function getActorRelationsJoinProfileForm($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ActorRelationQuery::create(null, $criteria);
        $query->joinWith('ProfileForm', $join_behavior);

        return $this->getActorRelations($query, $con);
    }

    /**
     * Clears out the collActorActiveQuestions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addActorActiveQuestions()
     */
    public function clearActorActiveQuestions()
    {
        $this->collActorActiveQuestions = null; // important to set this to null since that means it is uninitialized
        $this->collActorActiveQuestionsPartial = null;
    }

    /**
     * reset is the collActorActiveQuestions collection loaded partially
     *
     * @return void
     */
    public function resetPartialActorActiveQuestions($v = true)
    {
        $this->collActorActiveQuestionsPartial = $v;
    }

    /**
     * Initializes the collActorActiveQuestions collection.
     *
     * By default this just sets the collActorActiveQuestions collection to an empty array (like clearcollActorActiveQuestions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initActorActiveQuestions($overrideExisting = true)
    {
        if (null !== $this->collActorActiveQuestions && !$overrideExisting) {
            return;
        }
        $this->collActorActiveQuestions = new PropelObjectCollection();
        $this->collActorActiveQuestions->setModel('ActorActiveQuestion');
    }

    /**
     * Gets an array of ActorActiveQuestion objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Actor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ActorActiveQuestion[] List of ActorActiveQuestion objects
     * @throws PropelException
     */
    public function getActorActiveQuestions($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collActorActiveQuestionsPartial && !$this->isNew();
        if (null === $this->collActorActiveQuestions || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collActorActiveQuestions) {
                // return empty collection
                $this->initActorActiveQuestions();
            } else {
                $collActorActiveQuestions = ActorActiveQuestionQuery::create(null, $criteria)
                    ->filterByActor($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collActorActiveQuestionsPartial && count($collActorActiveQuestions)) {
                      $this->initActorActiveQuestions(false);

                      foreach($collActorActiveQuestions as $obj) {
                        if (false == $this->collActorActiveQuestions->contains($obj)) {
                          $this->collActorActiveQuestions->append($obj);
                        }
                      }

                      $this->collActorActiveQuestionsPartial = true;
                    }

                    return $collActorActiveQuestions;
                }

                if($partial && $this->collActorActiveQuestions) {
                    foreach($this->collActorActiveQuestions as $obj) {
                        if($obj->isNew()) {
                            $collActorActiveQuestions[] = $obj;
                        }
                    }
                }

                $this->collActorActiveQuestions = $collActorActiveQuestions;
                $this->collActorActiveQuestionsPartial = false;
            }
        }

        return $this->collActorActiveQuestions;
    }

    /**
     * Sets a collection of ActorActiveQuestion objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $actorActiveQuestions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setActorActiveQuestions(PropelCollection $actorActiveQuestions, PropelPDO $con = null)
    {
        $this->actorActiveQuestionsScheduledForDeletion = $this->getActorActiveQuestions(new Criteria(), $con)->diff($actorActiveQuestions);

        foreach ($this->actorActiveQuestionsScheduledForDeletion as $actorActiveQuestionRemoved) {
            $actorActiveQuestionRemoved->setActor(null);
        }

        $this->collActorActiveQuestions = null;
        foreach ($actorActiveQuestions as $actorActiveQuestion) {
            $this->addActorActiveQuestion($actorActiveQuestion);
        }

        $this->collActorActiveQuestions = $actorActiveQuestions;
        $this->collActorActiveQuestionsPartial = false;
    }

    /**
     * Returns the number of related ActorActiveQuestion objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ActorActiveQuestion objects.
     * @throws PropelException
     */
    public function countActorActiveQuestions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collActorActiveQuestionsPartial && !$this->isNew();
        if (null === $this->collActorActiveQuestions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collActorActiveQuestions) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getActorActiveQuestions());
                }
                $query = ActorActiveQuestionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByActor($this)
                    ->count($con);
            }
        } else {
            return count($this->collActorActiveQuestions);
        }
    }

    /**
     * Method called to associate a ActorActiveQuestion object to this object
     * through the ActorActiveQuestion foreign key attribute.
     *
     * @param    ActorActiveQuestion $l ActorActiveQuestion
     * @return Actor The current object (for fluent API support)
     */
    public function addActorActiveQuestion(ActorActiveQuestion $l)
    {
        if ($this->collActorActiveQuestions === null) {
            $this->initActorActiveQuestions();
            $this->collActorActiveQuestionsPartial = true;
        }
        if (!$this->collActorActiveQuestions->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddActorActiveQuestion($l);
        }

        return $this;
    }

    /**
     * @param	ActorActiveQuestion $actorActiveQuestion The actorActiveQuestion object to add.
     */
    protected function doAddActorActiveQuestion($actorActiveQuestion)
    {
        $this->collActorActiveQuestions[]= $actorActiveQuestion;
        $actorActiveQuestion->setActor($this);
    }

    /**
     * @param	ActorActiveQuestion $actorActiveQuestion The actorActiveQuestion object to remove.
     */
    public function removeActorActiveQuestion($actorActiveQuestion)
    {
        if ($this->getActorActiveQuestions()->contains($actorActiveQuestion)) {
            $this->collActorActiveQuestions->remove($this->collActorActiveQuestions->search($actorActiveQuestion));
            if (null === $this->actorActiveQuestionsScheduledForDeletion) {
                $this->actorActiveQuestionsScheduledForDeletion = clone $this->collActorActiveQuestions;
                $this->actorActiveQuestionsScheduledForDeletion->clear();
            }
            $this->actorActiveQuestionsScheduledForDeletion[]= $actorActiveQuestion;
            $actorActiveQuestion->setActor(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Actor is new, it will return
     * an empty collection; or if this Actor has previously
     * been saved, it will retrieve related ActorActiveQuestions from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Actor.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ActorActiveQuestion[] List of ActorActiveQuestion objects
     */
    public function getActorActiveQuestionsJoinProfileForm($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ActorActiveQuestionQuery::create(null, $criteria);
        $query->joinWith('ProfileForm', $join_behavior);

        return $this->getActorActiveQuestions($query, $con);
    }

    /**
     * Clears out the collActorActiveRelationQuestions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addActorActiveRelationQuestions()
     */
    public function clearActorActiveRelationQuestions()
    {
        $this->collActorActiveRelationQuestions = null; // important to set this to null since that means it is uninitialized
        $this->collActorActiveRelationQuestionsPartial = null;
    }

    /**
     * reset is the collActorActiveRelationQuestions collection loaded partially
     *
     * @return void
     */
    public function resetPartialActorActiveRelationQuestions($v = true)
    {
        $this->collActorActiveRelationQuestionsPartial = $v;
    }

    /**
     * Initializes the collActorActiveRelationQuestions collection.
     *
     * By default this just sets the collActorActiveRelationQuestions collection to an empty array (like clearcollActorActiveRelationQuestions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initActorActiveRelationQuestions($overrideExisting = true)
    {
        if (null !== $this->collActorActiveRelationQuestions && !$overrideExisting) {
            return;
        }
        $this->collActorActiveRelationQuestions = new PropelObjectCollection();
        $this->collActorActiveRelationQuestions->setModel('ActorActiveRelationQuestion');
    }

    /**
     * Gets an array of ActorActiveRelationQuestion objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Actor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ActorActiveRelationQuestion[] List of ActorActiveRelationQuestion objects
     * @throws PropelException
     */
    public function getActorActiveRelationQuestions($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collActorActiveRelationQuestionsPartial && !$this->isNew();
        if (null === $this->collActorActiveRelationQuestions || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collActorActiveRelationQuestions) {
                // return empty collection
                $this->initActorActiveRelationQuestions();
            } else {
                $collActorActiveRelationQuestions = ActorActiveRelationQuestionQuery::create(null, $criteria)
                    ->filterByActor($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collActorActiveRelationQuestionsPartial && count($collActorActiveRelationQuestions)) {
                      $this->initActorActiveRelationQuestions(false);

                      foreach($collActorActiveRelationQuestions as $obj) {
                        if (false == $this->collActorActiveRelationQuestions->contains($obj)) {
                          $this->collActorActiveRelationQuestions->append($obj);
                        }
                      }

                      $this->collActorActiveRelationQuestionsPartial = true;
                    }

                    return $collActorActiveRelationQuestions;
                }

                if($partial && $this->collActorActiveRelationQuestions) {
                    foreach($this->collActorActiveRelationQuestions as $obj) {
                        if($obj->isNew()) {
                            $collActorActiveRelationQuestions[] = $obj;
                        }
                    }
                }

                $this->collActorActiveRelationQuestions = $collActorActiveRelationQuestions;
                $this->collActorActiveRelationQuestionsPartial = false;
            }
        }

        return $this->collActorActiveRelationQuestions;
    }

    /**
     * Sets a collection of ActorActiveRelationQuestion objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $actorActiveRelationQuestions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setActorActiveRelationQuestions(PropelCollection $actorActiveRelationQuestions, PropelPDO $con = null)
    {
        $this->actorActiveRelationQuestionsScheduledForDeletion = $this->getActorActiveRelationQuestions(new Criteria(), $con)->diff($actorActiveRelationQuestions);

        foreach ($this->actorActiveRelationQuestionsScheduledForDeletion as $actorActiveRelationQuestionRemoved) {
            $actorActiveRelationQuestionRemoved->setActor(null);
        }

        $this->collActorActiveRelationQuestions = null;
        foreach ($actorActiveRelationQuestions as $actorActiveRelationQuestion) {
            $this->addActorActiveRelationQuestion($actorActiveRelationQuestion);
        }

        $this->collActorActiveRelationQuestions = $actorActiveRelationQuestions;
        $this->collActorActiveRelationQuestionsPartial = false;
    }

    /**
     * Returns the number of related ActorActiveRelationQuestion objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ActorActiveRelationQuestion objects.
     * @throws PropelException
     */
    public function countActorActiveRelationQuestions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collActorActiveRelationQuestionsPartial && !$this->isNew();
        if (null === $this->collActorActiveRelationQuestions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collActorActiveRelationQuestions) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getActorActiveRelationQuestions());
                }
                $query = ActorActiveRelationQuestionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByActor($this)
                    ->count($con);
            }
        } else {
            return count($this->collActorActiveRelationQuestions);
        }
    }

    /**
     * Method called to associate a ActorActiveRelationQuestion object to this object
     * through the ActorActiveRelationQuestion foreign key attribute.
     *
     * @param    ActorActiveRelationQuestion $l ActorActiveRelationQuestion
     * @return Actor The current object (for fluent API support)
     */
    public function addActorActiveRelationQuestion(ActorActiveRelationQuestion $l)
    {
        if ($this->collActorActiveRelationQuestions === null) {
            $this->initActorActiveRelationQuestions();
            $this->collActorActiveRelationQuestionsPartial = true;
        }
        if (!$this->collActorActiveRelationQuestions->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddActorActiveRelationQuestion($l);
        }

        return $this;
    }

    /**
     * @param	ActorActiveRelationQuestion $actorActiveRelationQuestion The actorActiveRelationQuestion object to add.
     */
    protected function doAddActorActiveRelationQuestion($actorActiveRelationQuestion)
    {
        $this->collActorActiveRelationQuestions[]= $actorActiveRelationQuestion;
        $actorActiveRelationQuestion->setActor($this);
    }

    /**
     * @param	ActorActiveRelationQuestion $actorActiveRelationQuestion The actorActiveRelationQuestion object to remove.
     */
    public function removeActorActiveRelationQuestion($actorActiveRelationQuestion)
    {
        if ($this->getActorActiveRelationQuestions()->contains($actorActiveRelationQuestion)) {
            $this->collActorActiveRelationQuestions->remove($this->collActorActiveRelationQuestions->search($actorActiveRelationQuestion));
            if (null === $this->actorActiveRelationQuestionsScheduledForDeletion) {
                $this->actorActiveRelationQuestionsScheduledForDeletion = clone $this->collActorActiveRelationQuestions;
                $this->actorActiveRelationQuestionsScheduledForDeletion->clear();
            }
            $this->actorActiveRelationQuestionsScheduledForDeletion[]= $actorActiveRelationQuestion;
            $actorActiveRelationQuestion->setActor(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Actor is new, it will return
     * an empty collection; or if this Actor has previously
     * been saved, it will retrieve related ActorActiveRelationQuestions from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Actor.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ActorActiveRelationQuestion[] List of ActorActiveRelationQuestion objects
     */
    public function getActorActiveRelationQuestionsJoinProfileForm($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ActorActiveRelationQuestionQuery::create(null, $criteria);
        $query->joinWith('ProfileForm', $join_behavior);

        return $this->getActorActiveRelationQuestions($query, $con);
    }

    /**
     * Clears out the collActorFormAnswers collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addActorFormAnswers()
     */
    public function clearActorFormAnswers()
    {
        $this->collActorFormAnswers = null; // important to set this to null since that means it is uninitialized
        $this->collActorFormAnswersPartial = null;
    }

    /**
     * reset is the collActorFormAnswers collection loaded partially
     *
     * @return void
     */
    public function resetPartialActorFormAnswers($v = true)
    {
        $this->collActorFormAnswersPartial = $v;
    }

    /**
     * Initializes the collActorFormAnswers collection.
     *
     * By default this just sets the collActorFormAnswers collection to an empty array (like clearcollActorFormAnswers());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initActorFormAnswers($overrideExisting = true)
    {
        if (null !== $this->collActorFormAnswers && !$overrideExisting) {
            return;
        }
        $this->collActorFormAnswers = new PropelObjectCollection();
        $this->collActorFormAnswers->setModel('ActorFormAnswer');
    }

    /**
     * Gets an array of ActorFormAnswer objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Actor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ActorFormAnswer[] List of ActorFormAnswer objects
     * @throws PropelException
     */
    public function getActorFormAnswers($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collActorFormAnswersPartial && !$this->isNew();
        if (null === $this->collActorFormAnswers || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collActorFormAnswers) {
                // return empty collection
                $this->initActorFormAnswers();
            } else {
                $collActorFormAnswers = ActorFormAnswerQuery::create(null, $criteria)
                    ->filterByActor($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collActorFormAnswersPartial && count($collActorFormAnswers)) {
                      $this->initActorFormAnswers(false);

                      foreach($collActorFormAnswers as $obj) {
                        if (false == $this->collActorFormAnswers->contains($obj)) {
                          $this->collActorFormAnswers->append($obj);
                        }
                      }

                      $this->collActorFormAnswersPartial = true;
                    }

                    return $collActorFormAnswers;
                }

                if($partial && $this->collActorFormAnswers) {
                    foreach($this->collActorFormAnswers as $obj) {
                        if($obj->isNew()) {
                            $collActorFormAnswers[] = $obj;
                        }
                    }
                }

                $this->collActorFormAnswers = $collActorFormAnswers;
                $this->collActorFormAnswersPartial = false;
            }
        }

        return $this->collActorFormAnswers;
    }

    /**
     * Sets a collection of ActorFormAnswer objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $actorFormAnswers A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setActorFormAnswers(PropelCollection $actorFormAnswers, PropelPDO $con = null)
    {
        $this->actorFormAnswersScheduledForDeletion = $this->getActorFormAnswers(new Criteria(), $con)->diff($actorFormAnswers);

        foreach ($this->actorFormAnswersScheduledForDeletion as $actorFormAnswerRemoved) {
            $actorFormAnswerRemoved->setActor(null);
        }

        $this->collActorFormAnswers = null;
        foreach ($actorFormAnswers as $actorFormAnswer) {
            $this->addActorFormAnswer($actorFormAnswer);
        }

        $this->collActorFormAnswers = $actorFormAnswers;
        $this->collActorFormAnswersPartial = false;
    }

    /**
     * Returns the number of related ActorFormAnswer objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ActorFormAnswer objects.
     * @throws PropelException
     */
    public function countActorFormAnswers(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collActorFormAnswersPartial && !$this->isNew();
        if (null === $this->collActorFormAnswers || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collActorFormAnswers) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getActorFormAnswers());
                }
                $query = ActorFormAnswerQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByActor($this)
                    ->count($con);
            }
        } else {
            return count($this->collActorFormAnswers);
        }
    }

    /**
     * Method called to associate a ActorFormAnswer object to this object
     * through the ActorFormAnswer foreign key attribute.
     *
     * @param    ActorFormAnswer $l ActorFormAnswer
     * @return Actor The current object (for fluent API support)
     */
    public function addActorFormAnswer(ActorFormAnswer $l)
    {
        if ($this->collActorFormAnswers === null) {
            $this->initActorFormAnswers();
            $this->collActorFormAnswersPartial = true;
        }
        if (!$this->collActorFormAnswers->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddActorFormAnswer($l);
        }

        return $this;
    }

    /**
     * @param	ActorFormAnswer $actorFormAnswer The actorFormAnswer object to add.
     */
    protected function doAddActorFormAnswer($actorFormAnswer)
    {
        $this->collActorFormAnswers[]= $actorFormAnswer;
        $actorFormAnswer->setActor($this);
    }

    /**
     * @param	ActorFormAnswer $actorFormAnswer The actorFormAnswer object to remove.
     */
    public function removeActorFormAnswer($actorFormAnswer)
    {
        if ($this->getActorFormAnswers()->contains($actorFormAnswer)) {
            $this->collActorFormAnswers->remove($this->collActorFormAnswers->search($actorFormAnswer));
            if (null === $this->actorFormAnswersScheduledForDeletion) {
                $this->actorFormAnswersScheduledForDeletion = clone $this->collActorFormAnswers;
                $this->actorFormAnswersScheduledForDeletion->clear();
            }
            $this->actorFormAnswersScheduledForDeletion[]= $actorFormAnswer;
            $actorFormAnswer->setActor(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Actor is new, it will return
     * an empty collection; or if this Actor has previously
     * been saved, it will retrieve related ActorFormAnswers from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Actor.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ActorFormAnswer[] List of ActorFormAnswer objects
     */
    public function getActorFormAnswersJoinProfileForm($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ActorFormAnswerQuery::create(null, $criteria);
        $query->joinWith('ProfileForm', $join_behavior);

        return $this->getActorFormAnswers($query, $con);
    }

    /**
     * Clears out the collHeadlineActors collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addHeadlineActors()
     */
    public function clearHeadlineActors()
    {
        $this->collHeadlineActors = null; // important to set this to null since that means it is uninitialized
        $this->collHeadlineActorsPartial = null;
    }

    /**
     * reset is the collHeadlineActors collection loaded partially
     *
     * @return void
     */
    public function resetPartialHeadlineActors($v = true)
    {
        $this->collHeadlineActorsPartial = $v;
    }

    /**
     * Initializes the collHeadlineActors collection.
     *
     * By default this just sets the collHeadlineActors collection to an empty array (like clearcollHeadlineActors());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initHeadlineActors($overrideExisting = true)
    {
        if (null !== $this->collHeadlineActors && !$overrideExisting) {
            return;
        }
        $this->collHeadlineActors = new PropelObjectCollection();
        $this->collHeadlineActors->setModel('HeadlineActor');
    }

    /**
     * Gets an array of HeadlineActor objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Actor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|HeadlineActor[] List of HeadlineActor objects
     * @throws PropelException
     */
    public function getHeadlineActors($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineActorsPartial && !$this->isNew();
        if (null === $this->collHeadlineActors || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collHeadlineActors) {
                // return empty collection
                $this->initHeadlineActors();
            } else {
                $collHeadlineActors = HeadlineActorQuery::create(null, $criteria)
                    ->filterByActor($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collHeadlineActorsPartial && count($collHeadlineActors)) {
                      $this->initHeadlineActors(false);

                      foreach($collHeadlineActors as $obj) {
                        if (false == $this->collHeadlineActors->contains($obj)) {
                          $this->collHeadlineActors->append($obj);
                        }
                      }

                      $this->collHeadlineActorsPartial = true;
                    }

                    return $collHeadlineActors;
                }

                if($partial && $this->collHeadlineActors) {
                    foreach($this->collHeadlineActors as $obj) {
                        if($obj->isNew()) {
                            $collHeadlineActors[] = $obj;
                        }
                    }
                }

                $this->collHeadlineActors = $collHeadlineActors;
                $this->collHeadlineActorsPartial = false;
            }
        }

        return $this->collHeadlineActors;
    }

    /**
     * Sets a collection of HeadlineActor objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $headlineActors A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setHeadlineActors(PropelCollection $headlineActors, PropelPDO $con = null)
    {
        $this->headlineActorsScheduledForDeletion = $this->getHeadlineActors(new Criteria(), $con)->diff($headlineActors);

        foreach ($this->headlineActorsScheduledForDeletion as $headlineActorRemoved) {
            $headlineActorRemoved->setActor(null);
        }

        $this->collHeadlineActors = null;
        foreach ($headlineActors as $headlineActor) {
            $this->addHeadlineActor($headlineActor);
        }

        $this->collHeadlineActors = $headlineActors;
        $this->collHeadlineActorsPartial = false;
    }

    /**
     * Returns the number of related HeadlineActor objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related HeadlineActor objects.
     * @throws PropelException
     */
    public function countHeadlineActors(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineActorsPartial && !$this->isNew();
        if (null === $this->collHeadlineActors || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collHeadlineActors) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getHeadlineActors());
                }
                $query = HeadlineActorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByActor($this)
                    ->count($con);
            }
        } else {
            return count($this->collHeadlineActors);
        }
    }

    /**
     * Method called to associate a HeadlineActor object to this object
     * through the HeadlineActor foreign key attribute.
     *
     * @param    HeadlineActor $l HeadlineActor
     * @return Actor The current object (for fluent API support)
     */
    public function addHeadlineActor(HeadlineActor $l)
    {
        if ($this->collHeadlineActors === null) {
            $this->initHeadlineActors();
            $this->collHeadlineActorsPartial = true;
        }
        if (!$this->collHeadlineActors->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddHeadlineActor($l);
        }

        return $this;
    }

    /**
     * @param	HeadlineActor $headlineActor The headlineActor object to add.
     */
    protected function doAddHeadlineActor($headlineActor)
    {
        $this->collHeadlineActors[]= $headlineActor;
        $headlineActor->setActor($this);
    }

    /**
     * @param	HeadlineActor $headlineActor The headlineActor object to remove.
     */
    public function removeHeadlineActor($headlineActor)
    {
        if ($this->getHeadlineActors()->contains($headlineActor)) {
            $this->collHeadlineActors->remove($this->collHeadlineActors->search($headlineActor));
            if (null === $this->headlineActorsScheduledForDeletion) {
                $this->headlineActorsScheduledForDeletion = clone $this->collHeadlineActors;
                $this->headlineActorsScheduledForDeletion->clear();
            }
            $this->headlineActorsScheduledForDeletion[]= $headlineActor;
            $headlineActor->setActor(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Actor is new, it will return
     * an empty collection; or if this Actor has previously
     * been saved, it will retrieve related HeadlineActors from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Actor.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|HeadlineActor[] List of HeadlineActor objects
     */
    public function getHeadlineActorsJoinHeadline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = HeadlineActorQuery::create(null, $criteria);
        $query->joinWith('Headline', $join_behavior);

        return $this->getHeadlineActors($query, $con);
    }

    /**
     * Clears out the collIssueActors collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIssueActors()
     */
    public function clearIssueActors()
    {
        $this->collIssueActors = null; // important to set this to null since that means it is uninitialized
        $this->collIssueActorsPartial = null;
    }

    /**
     * reset is the collIssueActors collection loaded partially
     *
     * @return void
     */
    public function resetPartialIssueActors($v = true)
    {
        $this->collIssueActorsPartial = $v;
    }

    /**
     * Initializes the collIssueActors collection.
     *
     * By default this just sets the collIssueActors collection to an empty array (like clearcollIssueActors());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initIssueActors($overrideExisting = true)
    {
        if (null !== $this->collIssueActors && !$overrideExisting) {
            return;
        }
        $this->collIssueActors = new PropelObjectCollection();
        $this->collIssueActors->setModel('IssueActor');
    }

    /**
     * Gets an array of IssueActor objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Actor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|IssueActor[] List of IssueActor objects
     * @throws PropelException
     */
    public function getIssueActors($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collIssueActorsPartial && !$this->isNew();
        if (null === $this->collIssueActors || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collIssueActors) {
                // return empty collection
                $this->initIssueActors();
            } else {
                $collIssueActors = IssueActorQuery::create(null, $criteria)
                    ->filterByActor($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collIssueActorsPartial && count($collIssueActors)) {
                      $this->initIssueActors(false);

                      foreach($collIssueActors as $obj) {
                        if (false == $this->collIssueActors->contains($obj)) {
                          $this->collIssueActors->append($obj);
                        }
                      }

                      $this->collIssueActorsPartial = true;
                    }

                    return $collIssueActors;
                }

                if($partial && $this->collIssueActors) {
                    foreach($this->collIssueActors as $obj) {
                        if($obj->isNew()) {
                            $collIssueActors[] = $obj;
                        }
                    }
                }

                $this->collIssueActors = $collIssueActors;
                $this->collIssueActorsPartial = false;
            }
        }

        return $this->collIssueActors;
    }

    /**
     * Sets a collection of IssueActor objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $issueActors A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIssueActors(PropelCollection $issueActors, PropelPDO $con = null)
    {
        $this->issueActorsScheduledForDeletion = $this->getIssueActors(new Criteria(), $con)->diff($issueActors);

        foreach ($this->issueActorsScheduledForDeletion as $issueActorRemoved) {
            $issueActorRemoved->setActor(null);
        }

        $this->collIssueActors = null;
        foreach ($issueActors as $issueActor) {
            $this->addIssueActor($issueActor);
        }

        $this->collIssueActors = $issueActors;
        $this->collIssueActorsPartial = false;
    }

    /**
     * Returns the number of related IssueActor objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related IssueActor objects.
     * @throws PropelException
     */
    public function countIssueActors(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collIssueActorsPartial && !$this->isNew();
        if (null === $this->collIssueActors || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collIssueActors) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getIssueActors());
                }
                $query = IssueActorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByActor($this)
                    ->count($con);
            }
        } else {
            return count($this->collIssueActors);
        }
    }

    /**
     * Method called to associate a IssueActor object to this object
     * through the IssueActor foreign key attribute.
     *
     * @param    IssueActor $l IssueActor
     * @return Actor The current object (for fluent API support)
     */
    public function addIssueActor(IssueActor $l)
    {
        if ($this->collIssueActors === null) {
            $this->initIssueActors();
            $this->collIssueActorsPartial = true;
        }
        if (!$this->collIssueActors->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddIssueActor($l);
        }

        return $this;
    }

    /**
     * @param	IssueActor $issueActor The issueActor object to add.
     */
    protected function doAddIssueActor($issueActor)
    {
        $this->collIssueActors[]= $issueActor;
        $issueActor->setActor($this);
    }

    /**
     * @param	IssueActor $issueActor The issueActor object to remove.
     */
    public function removeIssueActor($issueActor)
    {
        if ($this->getIssueActors()->contains($issueActor)) {
            $this->collIssueActors->remove($this->collIssueActors->search($issueActor));
            if (null === $this->issueActorsScheduledForDeletion) {
                $this->issueActorsScheduledForDeletion = clone $this->collIssueActors;
                $this->issueActorsScheduledForDeletion->clear();
            }
            $this->issueActorsScheduledForDeletion[]= $issueActor;
            $issueActor->setActor(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Actor is new, it will return
     * an empty collection; or if this Actor has previously
     * been saved, it will retrieve related IssueActors from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Actor.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|IssueActor[] List of IssueActor objects
     */
    public function getIssueActorsJoinIssue($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = IssueActorQuery::create(null, $criteria);
        $query->joinWith('Issue', $join_behavior);

        return $this->getIssueActors($query, $con);
    }

    /**
     * Clears out the collActorCategorys collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addActorCategorys()
     */
    public function clearActorCategorys()
    {
        $this->collActorCategorys = null; // important to set this to null since that means it is uninitialized
        $this->collActorCategorysPartial = null;
    }

    /**
     * Initializes the collActorCategorys collection.
     *
     * By default this just sets the collActorCategorys collection to an empty collection (like clearActorCategorys());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initActorCategorys()
    {
        $this->collActorCategorys = new PropelObjectCollection();
        $this->collActorCategorys->setModel('ActorCategory');
    }

    /**
     * Gets a collection of ActorCategory objects related by a many-to-many relationship
     * to the current object by way of the actors_actorsCategory cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Actor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|ActorCategory[] List of ActorCategory objects
     */
    public function getActorCategorys($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collActorCategorys || null !== $criteria) {
            if ($this->isNew() && null === $this->collActorCategorys) {
                // return empty collection
                $this->initActorCategorys();
            } else {
                $collActorCategorys = ActorCategoryQuery::create(null, $criteria)
                    ->filterByActor($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collActorCategorys;
                }
                $this->collActorCategorys = $collActorCategorys;
            }
        }

        return $this->collActorCategorys;
    }

    /**
     * Sets a collection of ActorCategory objects related by a many-to-many relationship
     * to the current object by way of the actors_actorsCategory cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $actorCategorys A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setActorCategorys(PropelCollection $actorCategorys, PropelPDO $con = null)
    {
        $this->clearActorCategorys();
        $currentActorCategorys = $this->getActorCategorys();

        $this->actorCategorysScheduledForDeletion = $currentActorCategorys->diff($actorCategorys);

        foreach ($actorCategorys as $actorCategory) {
            if (!$currentActorCategorys->contains($actorCategory)) {
                $this->doAddActorCategory($actorCategory);
            }
        }

        $this->collActorCategorys = $actorCategorys;
    }

    /**
     * Gets the number of ActorCategory objects related by a many-to-many relationship
     * to the current object by way of the actors_actorsCategory cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related ActorCategory objects
     */
    public function countActorCategorys($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collActorCategorys || null !== $criteria) {
            if ($this->isNew() && null === $this->collActorCategorys) {
                return 0;
            } else {
                $query = ActorCategoryQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByActor($this)
                    ->count($con);
            }
        } else {
            return count($this->collActorCategorys);
        }
    }

    /**
     * Associate a ActorCategory object to this object
     * through the actors_actorsCategory cross reference table.
     *
     * @param  ActorCategory $actorCategory The ActorCategoryRelation object to relate
     * @return void
     */
    public function addActorCategory(ActorCategory $actorCategory)
    {
        if ($this->collActorCategorys === null) {
            $this->initActorCategorys();
        }
        if (!$this->collActorCategorys->contains($actorCategory)) { // only add it if the **same** object is not already associated
            $this->doAddActorCategory($actorCategory);

            $this->collActorCategorys[]= $actorCategory;
        }
    }

    /**
     * @param	ActorCategory $actorCategory The actorCategory object to add.
     */
    protected function doAddActorCategory($actorCategory)
    {
        $actorCategoryRelation = new ActorCategoryRelation();
        $actorCategoryRelation->setActorCategory($actorCategory);
        $this->addActorCategoryRelation($actorCategoryRelation);
    }

    /**
     * Remove a ActorCategory object to this object
     * through the actors_actorsCategory cross reference table.
     *
     * @param ActorCategory $actorCategory The ActorCategoryRelation object to relate
     * @return void
     */
    public function removeActorCategory(ActorCategory $actorCategory)
    {
        if ($this->getActorCategorys()->contains($actorCategory)) {
            $this->collActorCategorys->remove($this->collActorCategorys->search($actorCategory));
            if (null === $this->actorCategorysScheduledForDeletion) {
                $this->actorCategorysScheduledForDeletion = clone $this->collActorCategorys;
                $this->actorCategorysScheduledForDeletion->clear();
            }
            $this->actorCategorysScheduledForDeletion[]= $actorCategory;
        }
    }

    /**
     * Clears out the collProfileForms collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProfileForms()
     */
    public function clearProfileForms()
    {
        $this->collProfileForms = null; // important to set this to null since that means it is uninitialized
        $this->collProfileFormsPartial = null;
    }

    /**
     * Initializes the collProfileForms collection.
     *
     * By default this just sets the collProfileForms collection to an empty collection (like clearProfileForms());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initProfileForms()
    {
        $this->collProfileForms = new PropelObjectCollection();
        $this->collProfileForms->setModel('ProfileForm');
    }

    /**
     * Gets a collection of ProfileForm objects related by a many-to-many relationship
     * to the current object by way of the actors_activeRelationQuestions cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Actor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|ProfileForm[] List of ProfileForm objects
     */
    public function getProfileForms($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collProfileForms || null !== $criteria) {
            if ($this->isNew() && null === $this->collProfileForms) {
                // return empty collection
                $this->initProfileForms();
            } else {
                $collProfileForms = ProfileFormQuery::create(null, $criteria)
                    ->filterByActor($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collProfileForms;
                }
                $this->collProfileForms = $collProfileForms;
            }
        }

        return $this->collProfileForms;
    }

    /**
     * Sets a collection of ProfileForm objects related by a many-to-many relationship
     * to the current object by way of the actors_activeRelationQuestions cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $profileForms A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProfileForms(PropelCollection $profileForms, PropelPDO $con = null)
    {
        $this->clearProfileForms();
        $currentProfileForms = $this->getProfileForms();

        $this->profileFormsScheduledForDeletion = $currentProfileForms->diff($profileForms);

        foreach ($profileForms as $profileForm) {
            if (!$currentProfileForms->contains($profileForm)) {
                $this->doAddProfileForm($profileForm);
            }
        }

        $this->collProfileForms = $profileForms;
    }

    /**
     * Gets the number of ProfileForm objects related by a many-to-many relationship
     * to the current object by way of the actors_activeRelationQuestions cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related ProfileForm objects
     */
    public function countProfileForms($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collProfileForms || null !== $criteria) {
            if ($this->isNew() && null === $this->collProfileForms) {
                return 0;
            } else {
                $query = ProfileFormQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByActor($this)
                    ->count($con);
            }
        } else {
            return count($this->collProfileForms);
        }
    }

    /**
     * Associate a ProfileForm object to this object
     * through the actors_activeRelationQuestions cross reference table.
     *
     * @param  ProfileForm $profileForm The ActorActiveRelationQuestion object to relate
     * @return void
     */
    public function addProfileForm(ProfileForm $profileForm)
    {
        if ($this->collProfileForms === null) {
            $this->initProfileForms();
        }
        if (!$this->collProfileForms->contains($profileForm)) { // only add it if the **same** object is not already associated
            $this->doAddProfileForm($profileForm);

            $this->collProfileForms[]= $profileForm;
        }
    }

    /**
     * @param	ProfileForm $profileForm The profileForm object to add.
     */
    protected function doAddProfileForm($profileForm)
    {
        $actorActiveRelationQuestion = new ActorActiveRelationQuestion();
        $actorActiveRelationQuestion->setProfileForm($profileForm);
        $this->addActorActiveRelationQuestion($actorActiveRelationQuestion);
    }

    /**
     * Remove a ProfileForm object to this object
     * through the actors_activeRelationQuestions cross reference table.
     *
     * @param ProfileForm $profileForm The ActorActiveRelationQuestion object to relate
     * @return void
     */
    public function removeProfileForm(ProfileForm $profileForm)
    {
        if ($this->getProfileForms()->contains($profileForm)) {
            $this->collProfileForms->remove($this->collProfileForms->search($profileForm));
            if (null === $this->profileFormsScheduledForDeletion) {
                $this->profileFormsScheduledForDeletion = clone $this->collProfileForms;
                $this->profileFormsScheduledForDeletion->clear();
            }
            $this->profileFormsScheduledForDeletion[]= $profileForm;
        }
    }

    /**
     * Clears out the collHeadlines collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addHeadlines()
     */
    public function clearHeadlines()
    {
        $this->collHeadlines = null; // important to set this to null since that means it is uninitialized
        $this->collHeadlinesPartial = null;
    }

    /**
     * Initializes the collHeadlines collection.
     *
     * By default this just sets the collHeadlines collection to an empty collection (like clearHeadlines());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initHeadlines()
    {
        $this->collHeadlines = new PropelObjectCollection();
        $this->collHeadlines->setModel('Headline');
    }

    /**
     * Gets a collection of Headline objects related by a many-to-many relationship
     * to the current object by way of the headlines_actor cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Actor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Headline[] List of Headline objects
     */
    public function getHeadlines($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collHeadlines || null !== $criteria) {
            if ($this->isNew() && null === $this->collHeadlines) {
                // return empty collection
                $this->initHeadlines();
            } else {
                $collHeadlines = HeadlineQuery::create(null, $criteria)
                    ->filterByActor($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collHeadlines;
                }
                $this->collHeadlines = $collHeadlines;
            }
        }

        return $this->collHeadlines;
    }

    /**
     * Sets a collection of Headline objects related by a many-to-many relationship
     * to the current object by way of the headlines_actor cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $headlines A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setHeadlines(PropelCollection $headlines, PropelPDO $con = null)
    {
        $this->clearHeadlines();
        $currentHeadlines = $this->getHeadlines();

        $this->headlinesScheduledForDeletion = $currentHeadlines->diff($headlines);

        foreach ($headlines as $headline) {
            if (!$currentHeadlines->contains($headline)) {
                $this->doAddHeadline($headline);
            }
        }

        $this->collHeadlines = $headlines;
    }

    /**
     * Gets the number of Headline objects related by a many-to-many relationship
     * to the current object by way of the headlines_actor cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Headline objects
     */
    public function countHeadlines($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collHeadlines || null !== $criteria) {
            if ($this->isNew() && null === $this->collHeadlines) {
                return 0;
            } else {
                $query = HeadlineQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByActor($this)
                    ->count($con);
            }
        } else {
            return count($this->collHeadlines);
        }
    }

    /**
     * Associate a Headline object to this object
     * through the headlines_actor cross reference table.
     *
     * @param  Headline $headline The HeadlineActor object to relate
     * @return void
     */
    public function addHeadline(Headline $headline)
    {
        if ($this->collHeadlines === null) {
            $this->initHeadlines();
        }
        if (!$this->collHeadlines->contains($headline)) { // only add it if the **same** object is not already associated
            $this->doAddHeadline($headline);

            $this->collHeadlines[]= $headline;
        }
    }

    /**
     * @param	Headline $headline The headline object to add.
     */
    protected function doAddHeadline($headline)
    {
        $headlineActor = new HeadlineActor();
        $headlineActor->setHeadline($headline);
        $this->addHeadlineActor($headlineActor);
    }

    /**
     * Remove a Headline object to this object
     * through the headlines_actor cross reference table.
     *
     * @param Headline $headline The HeadlineActor object to relate
     * @return void
     */
    public function removeHeadline(Headline $headline)
    {
        if ($this->getHeadlines()->contains($headline)) {
            $this->collHeadlines->remove($this->collHeadlines->search($headline));
            if (null === $this->headlinesScheduledForDeletion) {
                $this->headlinesScheduledForDeletion = clone $this->collHeadlines;
                $this->headlinesScheduledForDeletion->clear();
            }
            $this->headlinesScheduledForDeletion[]= $headline;
        }
    }

    /**
     * Clears out the collIssues collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIssues()
     */
    public function clearIssues()
    {
        $this->collIssues = null; // important to set this to null since that means it is uninitialized
        $this->collIssuesPartial = null;
    }

    /**
     * Initializes the collIssues collection.
     *
     * By default this just sets the collIssues collection to an empty collection (like clearIssues());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initIssues()
    {
        $this->collIssues = new PropelObjectCollection();
        $this->collIssues->setModel('Issue');
    }

    /**
     * Gets a collection of Issue objects related by a many-to-many relationship
     * to the current object by way of the issues_actors cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Actor is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Issue[] List of Issue objects
     */
    public function getIssues($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collIssues || null !== $criteria) {
            if ($this->isNew() && null === $this->collIssues) {
                // return empty collection
                $this->initIssues();
            } else {
                $collIssues = IssueQuery::create(null, $criteria)
                    ->filterByActor($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collIssues;
                }
                $this->collIssues = $collIssues;
            }
        }

        return $this->collIssues;
    }

    /**
     * Sets a collection of Issue objects related by a many-to-many relationship
     * to the current object by way of the issues_actors cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $issues A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIssues(PropelCollection $issues, PropelPDO $con = null)
    {
        $this->clearIssues();
        $currentIssues = $this->getIssues();

        $this->issuesScheduledForDeletion = $currentIssues->diff($issues);

        foreach ($issues as $issue) {
            if (!$currentIssues->contains($issue)) {
                $this->doAddIssue($issue);
            }
        }

        $this->collIssues = $issues;
    }

    /**
     * Gets the number of Issue objects related by a many-to-many relationship
     * to the current object by way of the issues_actors cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Issue objects
     */
    public function countIssues($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collIssues || null !== $criteria) {
            if ($this->isNew() && null === $this->collIssues) {
                return 0;
            } else {
                $query = IssueQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByActor($this)
                    ->count($con);
            }
        } else {
            return count($this->collIssues);
        }
    }

    /**
     * Associate a Issue object to this object
     * through the issues_actors cross reference table.
     *
     * @param  Issue $issue The IssueActor object to relate
     * @return void
     */
    public function addIssue(Issue $issue)
    {
        if ($this->collIssues === null) {
            $this->initIssues();
        }
        if (!$this->collIssues->contains($issue)) { // only add it if the **same** object is not already associated
            $this->doAddIssue($issue);

            $this->collIssues[]= $issue;
        }
    }

    /**
     * @param	Issue $issue The issue object to add.
     */
    protected function doAddIssue($issue)
    {
        $issueActor = new IssueActor();
        $issueActor->setIssue($issue);
        $this->addIssueActor($issueActor);
    }

    /**
     * Remove a Issue object to this object
     * through the issues_actors cross reference table.
     *
     * @param Issue $issue The IssueActor object to relate
     * @return void
     */
    public function removeIssue(Issue $issue)
    {
        if ($this->getIssues()->contains($issue)) {
            $this->collIssues->remove($this->collIssues->search($issue));
            if (null === $this->issuesScheduledForDeletion) {
                $this->issuesScheduledForDeletion = clone $this->collIssues;
                $this->issuesScheduledForDeletion->clear();
            }
            $this->issuesScheduledForDeletion[]= $issue;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->title = null;
        $this->name = null;
        $this->surname = null;
        $this->institution = null;
        $this->mailaddress = null;
        $this->deleted_at = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collActorCategoryRelations) {
                foreach ($this->collActorCategoryRelations as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collActorRelations) {
                foreach ($this->collActorRelations as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collActorActiveQuestions) {
                foreach ($this->collActorActiveQuestions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collActorActiveRelationQuestions) {
                foreach ($this->collActorActiveRelationQuestions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collActorFormAnswers) {
                foreach ($this->collActorFormAnswers as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collHeadlineActors) {
                foreach ($this->collHeadlineActors as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collIssueActors) {
                foreach ($this->collIssueActors as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collActorCategorys) {
                foreach ($this->collActorCategorys as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProfileForms) {
                foreach ($this->collProfileForms as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collHeadlines) {
                foreach ($this->collHeadlines as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collIssues) {
                foreach ($this->collIssues as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collActorCategoryRelations instanceof PropelCollection) {
            $this->collActorCategoryRelations->clearIterator();
        }
        $this->collActorCategoryRelations = null;
        if ($this->collActorRelations instanceof PropelCollection) {
            $this->collActorRelations->clearIterator();
        }
        $this->collActorRelations = null;
        if ($this->collActorActiveQuestions instanceof PropelCollection) {
            $this->collActorActiveQuestions->clearIterator();
        }
        $this->collActorActiveQuestions = null;
        if ($this->collActorActiveRelationQuestions instanceof PropelCollection) {
            $this->collActorActiveRelationQuestions->clearIterator();
        }
        $this->collActorActiveRelationQuestions = null;
        if ($this->collActorFormAnswers instanceof PropelCollection) {
            $this->collActorFormAnswers->clearIterator();
        }
        $this->collActorFormAnswers = null;
        if ($this->collHeadlineActors instanceof PropelCollection) {
            $this->collHeadlineActors->clearIterator();
        }
        $this->collHeadlineActors = null;
        if ($this->collIssueActors instanceof PropelCollection) {
            $this->collIssueActors->clearIterator();
        }
        $this->collIssueActors = null;
        if ($this->collActorCategorys instanceof PropelCollection) {
            $this->collActorCategorys->clearIterator();
        }
        $this->collActorCategorys = null;
        if ($this->collProfileForms instanceof PropelCollection) {
            $this->collProfileForms->clearIterator();
        }
        $this->collProfileForms = null;
        if ($this->collHeadlines instanceof PropelCollection) {
            $this->collHeadlines->clearIterator();
        }
        $this->collHeadlines = null;
        if ($this->collIssues instanceof PropelCollection) {
            $this->collIssues->clearIterator();
        }
        $this->collIssues = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(ActorPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // soft_delete behavior

    /**
     * Bypass the soft_delete behavior and force a hard delete of the current object
     */
    public function forceDelete(PropelPDO $con = null)
    {
        if ($isSoftDeleteEnabled = ActorPeer::isSoftDeleteEnabled()) {
            ActorPeer::disableSoftDelete();
        }
        $this->delete($con);
        if ($isSoftDeleteEnabled) {
            ActorPeer::enableSoftDelete();
        }
    }

    /**
     * Undelete a row that was soft_deleted
     *
     * @return		 int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        $this->setDeletedAt(null);

        return $this->save($con);
    }

}
