<?php

namespace Egytca\Status\OnTheFly\Query;

use Criteria;
use Egytca\PropelRelationsConfig;
use Egytca\Statements\Factory as StmntFactory;
use Egytca\Statements\Statement;
use Egytca\Statements\StringStatement as StmntString;

trait PropagatedStatusQuery {

	use StatusQuery;

	private function configPropagatedStatusQuery(PropelRelationsConfig $propelRelationsConfig) {
		$this->propelRelationsConfig = $propelRelationsConfig;
	}

	private function statementForDescendantsWithStatusByType($status, $type) {
		$useDescendantQuery = $this->propelRelationsConfig->getUseDescendantQueryFn($type);
		$statementForChosenStatus = 'statementForStatus'.ucfirst($status);
		return $this->$useDescendantQuery()->$statementForChosenStatus();
	}

	private function statementForDescendantsExistanceByType(Statement $condition, $type) {
		$descendantTable = $this->propelRelationsConfig->getDescendantTable($type);
		$descendantRelationColumn = $this->propelRelationsConfig->getDescendantColumn($type);
		$localRelationColumn = $this->propelRelationsConfig->getLocalColumn($type);
		$where = "($localRelationColumn=$descendantRelationColumn) AND "
			. $condition->toString();
		$select = new StmntString("(SELECT * FROM $descendantTable WHERE $where)");
		return StmntFactory::create($select, 'EXISTS');
	}

	private function statementForDescendantsExistance(Statement $condition) {
		$statement = null;
		foreach ($this->propelRelationsConfig->getNames() as $relationName) {
			if ($statement === null) {
				$statement = $this->statementForDescendantsExistanceByType($condition, $relationName);
			} else {
				$statement = $statement->orWith(
					$this->statementForDescendantsExistanceByType($condition, $relationName)
				);
			}
		}
		return $statement;
	}

	private function statementForDescendantsExistanceWithStatus($status) {

		$statement = null;
		foreach ($this->propelRelationsConfig->getNames() as $relationName) {
			$condition = $this->statementForDescendantsWithStatusByType($status, $relationName);
			if ($statement === null) {
				$statement = $this->statementForDescendantsExistanceByType($condition, $relationName);
			} else {
				$statement = $statement->orWith(
					$this->statementForDescendantsExistanceByType($condition, $relationName)
				);
			}
		}
		return $statement;
	}

	/* ******************** status late ******************** */
	private function statusLateOnlyPart() {
		return $this->statementForDescendantsExistanceWithStatus('late');
	}

	function statementForStatusLate($comparison = Criteria::EQUAL) {
		$statement = $this->statusLateOnlyPart();
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusLate($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusLate($comparison)->toString())
			->groupBy('Id');
	}
	/* ****************** end status late ****************** */

	/* ******************** status delayed ******************** */
	private function statusDelayedOnlyPart() {
		return $this->statementForDescendantsExistanceWithStatus('delayed');
	}

	function statementForStatusDelayed($comparison = Criteria::EQUAL) {
		$statement = $this->statusDelayedOnlyPart()
			->andWith($this->statusLateOnlyPart()->invert());
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusDelayed($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusDelayed($comparison)->toString())
			->groupBy('Id');
	}
	/* ****************** end status delayed ****************** */

	/* ******************** status undefined ******************** */
	private function statusUndefinedOnlyPart() {
		return $this->statementForDescendantsExistanceWithStatus('undefined');
	}

	function statementForStatusUndefined($comparison = Criteria::EQUAL) {
		$statement = $this->statusUndefinedOnlyPart()
			->andWith($this->statusDelayedOnlyPart()->invert())
			->andWith($this->statusLateOnlyPart()->invert());
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusUndefined($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusUndefined($comparison)->toString())
			->groupBy('Id');
	}
	/* ****************** end status undefined ****************** */

	/* ******************** status ontime ******************** */
	private function statusOntimeOnlyPart() {
		return $this->statementForDescendantsExistanceWithStatus('ontime');
	}

	function statementForStatusOntime($comparison = Criteria::EQUAL) {
		$statement = $this->statusOntimeOnlyPart()
			->andWith($this->statusUndefinedOnlyPart()->invert())
			->andWith($this->statusDelayedOnlyPart()->invert())
			->andWith($this->statusLateOnlyPart()->invert());
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusOntime($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusOntime($comparison)->toString())
			->groupBy('Id');
	}
	/* ****************** end status ontime ****************** */

	/* ******************** status planned ******************** */
	private function statusPlannedOnlyPart() {
		return $this->statementForDescendantsExistanceWithStatus('planned');
	}

	function statementForStatusPlanned($comparison = Criteria::EQUAL) {
		$statement = $this->statusPlannedOnlyPart()
			->andWith($this->statusOntimeOnlyPart()->invert())
			->andWith($this->statusUndefinedOnlyPart()->invert())
			->andWith($this->statusDelayedOnlyPart()->invert())
			->andWith($this->statusLateOnlyPart()->invert());
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusPlanned($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusPlanned($comparison)->toString())
			->groupBy('Id');
	}
	/* ****************** end status planned ****************** */

	/* ******************** status finished ******************** */
	private function statusFinishedOnlyPart() {
		$finishedDescendants = $this->statementForDescendantsExistanceWithStatus('finished');
		$any = new StmntString('1');
		$noDescendantsExist = $this->statementForDescendantsExistance($any)->invert();
		return $this->statementForDescendantsExistance($finishedDescendants)
			->orWith($noDescendantsExist);
	}

	function statementForStatusFinished($comparison = Criteria::EQUAL) {
		$statement = $this->statusFinishedOnlyPart()
			->andWith($this->statusPlannedOnlyPart()->invert())
			->andWith($this->statusOntimeOnlyPart()->invert())
			->andWith($this->statusUndefinedOnlyPart()->invert())
			->andWith($this->statusDelayedOnlyPart()->invert())
			->andWith($this->statusLateOnlyPart()->invert());
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusFinished($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusFinished($comparison)->toString())
			->groupBy('Id');
	}
	/* ****************** end status finished ****************** */
}
