<?php

namespace Egytca\Planning;

use Criteria;

trait YearFilter {

	function filterByPlanningYears() {

		$minYear = isset($_SESSION['planning']['startingYear']) ?
			$_SESSION['planning']['startingYear'] : ConfigModule::get('planning', 'startingYear');
		$maxYear = isset($_SESSION['planning']['endingYear']) ?
			$_SESSION['planning']['endingYear'] : ConfigModule::get('planning', 'endingYear');

		return $this->filterByStartingYear($maxYear, Criteria::LESS_EQUAL)
			->filterByEndingYear($minYear, Criteria::GREATER_EQUAL);
	}
}
